//-
// ==========================================================================
// Copyright 1995,2006,2008 Autodesk, Inc. All rights reserved.
//
// Use of this software is subject to the terms of the Autodesk
// license agreement provided at the time of installation or download,
// or which otherwise accompanies this software in either electronic
// or hard copy form.
// ==========================================================================
//+

// MayaCmdCOM.cpp : Implementation of DLL Exports.

#include "stdafx.h"
#include "resource.h"
#include "MayaCmdCOM.h"

class CMayaCmdCOMModule : public CAtlDllModuleT< CMayaCmdCOMModule >
{
public :
	DECLARE_LIBID(LIBID_MayaCommandEngine)
	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_MAYACMDCOM, "{4186C674-158C-416C-9D83-B9593134EB30}")
};

CMayaCmdCOMModule _AtlModule;


// DLL Entry Point
extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	hInstance;
    return _AtlModule.DllMain(dwReason, lpReserved); 
}


// Used to determine whether the DLL can be unloaded by OLE
STDAPI DllCanUnloadNow(void)
{
    return _AtlModule.DllCanUnloadNow();
}


// Returns a class factory to create an object of the requested type
STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _AtlModule.DllGetClassObject(rclsid, riid, ppv);
}


// DllRegisterServer - Adds entries to the system registry
STDAPI DllRegisterServer(void)
{
    // registers object, typelib and all interfaces in typelib
    HRESULT hr = _AtlModule.DllRegisterServer();
	if (SUCCEEDED(hr))
		// registers URL protocol handler
		hr = _AtlModule.UpdateRegistryFromResourceS(IDR_MELPROTOCOL, TRUE);
	return hr;
}


// DllUnregisterServer - Removes entries from the system registry
STDAPI DllUnregisterServer(void)
{
	HRESULT hr = _AtlModule.DllUnregisterServer();
	if (SUCCEEDED(hr))
		hr = _AtlModule.UpdateRegistryFromResourceS(IDR_MELPROTOCOL, FALSE);
	return hr;
}
