"""
Check that the scheduling graph generated by the automated process is
equivalent to the graph generated by the dbpeek command.
"""

from maya.analytics.decorators import makeAnalytic
from maya.analytics.decorators import addMethodDocs
from maya.debug.emModeManager import emModeManager
from maya.analytics.BaseAnalytic import BaseAnalytic
from maya.debug.playbackModeManager import playbackModeManager
from maya.analytics.decorators import addHelp

class analyticScheduling(BaseAnalytic):
    """
    The normal output the output is a dictionary whose keys are the error types
    the values are the details of that error. There are only four:
    
        "scheduling" : {
            "nodeMissing" : "transform1",
            "nodeAdded"   : "transform2",
            "edgeMissing" : ["transform1", "transform2"],
            "edgeAdded"   : ["transform2", "group1"]
        }
    
    "Missing" means it existed in the original dump but not in the new one.
    "Added" means it did not exist in the original dump but does in the new one.
    """
    
    
    
    def __init__(self):
        """
        Initialize the persistent class members
        """
    
        pass
    
    
    def read_scheduling_file(self, file_name):
        """
        Read the scheduling .dot file and extract the relevant information
        from it.
        
        :param file_name: Name of file containing JSON scheduling data
        :return: (nodes, edges) where:
            nodes: list of node names in the file
            edges: list of node pairs corresponding to edges in the file
        """
    
        pass
    
    
    def run(self):
        """
        Run the analytic on the current scene.
        Runs the EMP animation to generate the old scheduling graph dump,
        run the commands needed to generate the new dump, then compare
        the two to generate the results
        :result: JSON data as described in the class doc
        """
    
        pass
    
    
    def help():
        """
        Call this method to print the class documentation, including all methods.
        """
    
        pass
    
    
    ANALYTIC_DESCRIPTION_DETAILED = 'The normal output the output is a dictionary whose keys are the error types\nthe values are the details of that error. There are only four:\n\n    "scheduling" : {\n        "nodeMissing" : "transform1",\n        "nodeAdded"   : "transform2",\n        "edgeMissing" : ["transform1", "transform2"],\n        "edgeAdded"   : ["transform2", "group1"]\n    }\n\n"Missing" means it existed in the original dump but not in the new one.\n"Added" means it did not exist in the original dump but does in the new one.'
    
    
    ANALYTIC_DESCRIPTION_SHORT = []
    
    
    ANALYTIC_LABEL = []
    
    
    ANALYTIC_NAME = 'Scheduling'
    
    
    __fulldocs__ = 'The normal output the output is a dictionary whose keys are the error types\nthe values are the details of that error. There are only four:\n\n    "scheduling" : {\n        "nodeMissing" : "transform1",\n        "nodeAdded"   : "transform2",\n        "edgeMissing" : ["transform1", "transform2"],\n        "edgeAdded"   : ["transform2", "group1"]\n    }\n\n"Missing" means it existed in the original dump but not in the new one.\n"Added" means it did not exist in the original dump but does in the new one.\nBase class for output for analytics.\n\nThe default location for the anlaytic output is in a subdirectory\ncalled \'MayaAnalytics\' in your temp directory. You can change that\nat any time by calling set_output_directory().\n\nClass static member:\n     ANALYTIC_NAME : Name of the analytic\n\nClass members:\n     directory     : Directory the output will go to\n     is_static     : True means this analytic doesn\'t require a file to run\n     logger        : Logging object for errors, warnings, and messages\n     plug_namer    : Object creating plug names, possibly anonymous\n     node_namer    : Object creating node names, possibly anonymous\n     csv_output    : Location to store legacy CSV output\n     plug_namer    : Set by option \'anonymous\' - if True then make plug names anonymous\n     node_namer    : Set by option \'anonymous\' - if True then make node names anonymous\n     __options     : Dictionary of per-analytic options\n\n\tMethods\n\t-------\n\tdebug : Utility to standardize debug messages coming from analytics.\n\n\terror : Utility to standardize errors coming from analytics.\n\n\testablish_baseline : This is run on an empty scene, to give the analytic a chance to\n\t                     establish any baseline data it might need (e.g. the nodes in an\n\t                     empty scene could all be ignored by the analytic)\n\t                     \n\t                     Base implementation does nothing. Derived classes should call\n\t                     their super() method though, in case something does get added.\n\n\thelp : Call this method to print the class documentation, including all methods.\n\n\tjson_file : Although an analytic is free to create any set of output files it\n\t            wishes there will always be one master JSON file containing the\n\n\tlog : Utility to standardize logging messages coming from analytics.\n\n\tmarker_file : Returns the name of the marker file used to indicate that the\n\t              computation of an analytic is in progress. If this file remains\n\t              in a directory after the analytic has run that means it was\n\t              interrupted and the data is not up to date.\n\t              \n\t              This file provides a safety measure against machines going down\n\t              or analytics crashing.\n\n\tname : Get the name of this type of analytic\n\n\toption : Return TRUE if the option specified has been set on this analytic.\n\t         option: Name of option to check\n\n\toutput_files : This is used to get the list of files the analytic will generate.\n\t               There will always be a JSON file generated which contains at minimum\n\t               the timing information. An analytic should override this method only\n\t               if they are adding more output files (e.g. a .jpg file).\n\t               \n\t               This should only be called after the final directory has been set.\n\n\tread_scheduling_file : Read the scheduling .dot file and extract the relevant information\n\t                       from it.\n\t                       \n\t                       :param file_name: Name of file containing JSON scheduling data\n\t                       :return: (nodes, edges) where:\n\t                           nodes: list of node names in the file\n\t                           edges: list of node pairs corresponding to edges in the file\n\n\trun : Run the analytic on the current scene.\n\t      Runs the EMP animation to generate the old scheduling graph dump,\n\t      run the commands needed to generate the new dump, then compare\n\t      the two to generate the results\n\t      :result: JSON data as described in the class doc\n\n\tset_options : Modify the settings controlling the run operation of the analytic.\n\t              Override this method if your analytic has some different options\n\t              available to it, but be sure to call this parent version after since\n\t              it sets common options.\n\n\tset_output_directory : Call this method to set a specific directory as the output location.\n\t                       The special names \'stdout\' and \'stderr\' are recognized as the\n\t                       output and error streams respectively rather than a directory.\n\n\twarning : Utility to standardize warnings coming from analytics.\n'
    
    
    is_static = False



NEW_ROOT = '__SCHEDULING_ROOT__'

kAnalyticDescriptionShort = []

OLD_ROOT = 'RootTask'

BUILD = None

kAnalyticLabel = []

RE_NODE = None

RE_EDGE = None


