"""
This module provides a context manager to have a convenient 
profiler guard mechanism.  It ensures that the profiler is started 
and stopped at expected time.
"""

class ProfilerMgr:
    """
    Safe way to manage profiler guard
    
    Example:
        with ProfilerMgr('Profile Cube Creation'):
            cmds.polyCube()
            cmds.polyCube()
    """
    
    
    
    def __enter__(self):
        pass
    
    
    def __exit__(self, type, value, traceback):
        pass
    
    
    def __init__(self, name):
        pass



def profile(decoratedFunc):
    """
    Profile decorator to manage the profiling scope
    """

    pass



_profilerCategory = 9

_profilerColor = 13


