"""
It is meant to be used by tests validating the correctness of evaluation, for
instance validating the correctness of evaluation under evaluation manager or
background evaluation.

Its main utility function is run_correctness_test().

If resultsPath is set then the graph output and differences are dumped to
files using that path as the base name.  For example:

    resultsPath             = MyDirectory/emCorrecteness_animCone
    reference results dump  = MyDirectory/emCorrecteness_animCone.ref.txt
    reference results image = MyDirectory/emCorrecteness_animCone.ref.png
    ${mode} results dump    = MyDirectory/emCorrecteness_animCone.${mode}.txt
    ${mode} results image   = MyDirectory/emCorrecteness_animCone.${mode}.png

If resultsPath is not set then no output is stored, everything is live.

The return value is a list of value pairs indicating number of differences
between the reference evaluation and the tested mode. e.g. if you requested 'ems'
mode then you would get back {'ems' : (0, 0, 0)} from a successful comparison.

If fileName is not set then the current scene is analyzed.
"""

from maya.debug.TODO import TODO
from maya.debug.DGState import DGState
from maya.debug.emModeManager import emModeManager
from maya.debug.playbackModeManager import playbackModeManager

class EmptyContext(object):
    """
    Empty context class that performs no action on entry or exit.
    """
    
    
    
    def __enter__(self):
        pass
    
    
    def __exit__(self, type, value, traceback):
        pass
    
    
    __dict__ = None
    
    __weakref__ = None



def run_correctness_test(referenceMode, modes, fileName='None', resultsPath='None', verbose='False', maxFrames='20', dataTypes="['matrix', 'vertex', 'screen']", emSetup='0'):
    """
    Evaluate the file in multiple modes and compare the results.
    
    referenceMode: Mode to which other modes will be compared for correctness.
                   It's a string that can be passed to emModeManager.setMode()
                   function.
    modes:         List of modes to run the tests in.  They must be have the following methods:
                   getTitle   : returns a string describing the mode
                   getEmMode  : returns a string to be passed to emModeManager.setMode()
                                before running the test.
                   getContext : returns a context object that can set extra state on enter
                                and reset it on exit (or None if not needed).
    fileName:      Name of file to load for comparison. None means use the current scene
    resultsPath:   Where to store the results. None means don't store anything
    verbose:       If True then dump the differing values when they are encountered
    maxFrames:     Maximum number of frames in the playback, to avoid long tests.
    dataTypes:     List of data types to include in the analysis. These are the possibilities:
                   matrix: Any attribute that returns a matrix
                   vector: Any attribute with type 3Double
                   vertex: Attributes on the mesh shape that hold vertex positions
                   number: Any attribute that returns a number
                   screen: Screenshot after the animation runs
    emSetup:       What to do before running an EM mode test, in bitfield combinations
                   CORRECTNESS_NO_SETUP        Do nothing, just run playback
                   CORRECTNESS_DOUBLE_PLAYBACK Run playback twice to ensure graph is valid
                   CORRECTNESS_INVALIDATE      Invalidate the graph to force rebuild
                   CORRECTNESS_LOAD            Load the file between every mode's run
                                               (Default is to just load once at the beginning.)
    
    Returns a list of value tuples indicating the run mode and the number of
    changes encountered in that mode. e.g. ['ems', 0]
    
    If verbose is true then instead of counts return a list of actual changes.
    e.g. ['ems', ["plug1,oldValue,newValue"]]
    
    Changed values are a CSV 3-tuple with "plug name", "value in reference mode", "value in the named test mode"
    in most cases.
    
    In the special case of an image difference the plug name will be one
    of the special ones below and the values will be those generated by the
    comparison method used:
        DGState.SCREENSHOT_PLUG_MD5 : md5 values when the image compare could not be done
        DGState.SCREENSHOT_PLUG_MAG : md5 and image difference values from ImageMagick
        DGState.SCREENSHOT_PLUG_IMF : md5 and image difference values from imf_diff
    """

    pass


def model_panel_visible():
    """
    Return true if any model panel is currently visible. This includes
    checking for GUI model and looking at the currently visible panels
    to see if any of them are model panels.
    """

    pass


def __is_maya_file(path):
    """
    Check to see if the given path is a Maya file. Only looks for native Maya
    files ".ma" and ".mb", not other importable formats such as ".obj" or ".dxf"
    """

    pass


def __has_evaluation_cache(type):
    """
    Returns true if the given node type has an active evaluation caching point
    """

    pass


def __get_all_descendents(root):
    """
    Return the list of all DAG nodes below root, empty if it is a leaf.
    """

    pass


def __find_em_plugs(ignored_nodes, results_filename):
    """
    Find all of the root level plugs that the EM will be marking
    dirty. The passed-in dictionary will be populated by a list of
    dictionaries.
    
    :param ignored_nodes:  Array of [NODES_TO_SKIP]
    
    :return: Dictionary of NODE -> [DIRTY_PLUG_IN_NODE]
    """

    pass


def __no_caching_nodes():
    """
    When nodes are controlled by th cache evaluator, not every one of them
    will have its data updated in the datablock. This method will return a
    list of nodes that do not have a caching point.
    
    The empty array will be returned when cache evaluation is disabled.
    """

    pass


def __invisible_nodes():
    """
    When nodes are invisible their calculation may or may not be ignored,
    depending on the way the DG does its calculation on what the
    invisibility evaluator captures. There's no way to exactly predict
    which attributes will be computed in these cases so it's safer to
    just ignore any nodes that are invisible, either directly, through
    a display layer, or by virtue of being an intermediate object.
    
    On the other hand, if the invisible object is driving a visible
    object then the visible object comparison should give a good idea
    of whether the invisible object was correctly computed, so those
    cases will be handled.
    """

    pass


def __multi_chain_nodes():
    """
    The IK multi-chain solver is known to create inconsistent results so remove
    any joints that are being controlled by it from the list being compared.
    Even though we have an evaluator that disables the EM when these are found even
    the DG results are not consistent so these always must be ignored.
    """

    pass



CORRECTNESS_NO_SETUP = 0

CACHE_EVALUATOR = 'cache'

CORRECTNESS_MAX_FRAMECOUNT = 20

CORRECTNESS_INVALIDATE = 2

CORRECTNESS_LOAD = 4

CORRECTNESS_DOUBLE_PLAYBACK = 1


