class PyUI(unicode):
    def __repr__(self):
        pass
    
    
    def asQtObject(mayaName):
        """
        Given the name of a May UI control, return the corresponding QWidget.
        If the object does not exist, returns None
        
        .. note:: Requires PySide
        """
    
        pass
    
    
    def delete(*args, **kwargs):
        """
        This command deletes UI objects such as windows and controls.  Deleting a layout or window will also delete all of its
        children.  If a flag is used then all objects being deleted must be of the specified type. This command may not be
        edited or queried. NOTE: it is recommended that the type flags be used to disambiguate different kinds of objects with
        the same name.
        
        Flags:
          - collection : cl                (bool)          [create]
              Object names for deletion are all radio or tool collections.
        
          - control : ctl                  (bool)          [create]
              Object names for deletion are all controls.
        
          - editor : ed                    (bool)          [create]
              Object names for deletion are all editors.
        
          - layout : lay                   (bool)          [create]
              Object names for deletion are all layouts.
        
          - menu : m                       (bool)          [create]
              Object names for deletion are all menus.
        
          - menuItem : mi                  (bool)          [create]
              Object names for deletion are all menu items.
        
          - panel : pnl                    (bool)          [create]
              Object names for deletion are all panels.
        
          - panelConfig : pc               (bool)          [create]
              Object names for deletion are panel configurations.
        
          - radioMenuItemCollection : ric  (bool)          [create]
              Object names for deletion are all radio menu item collections.
        
          - toolContext : tc               (bool)          [create]
              Object names for deletion are all tool contexts.
        
          - uiTemplate : uit               (bool)          [create]
              Object names for deletion are all UI templates.
        
          - window : wnd                   (bool)          [create]
              Object names for deletion are all windows.                  Flag can have multiple arguments, passed either as a tuple
              or a list.
        
        
        Derived from mel command `maya.cmds.deleteUI`
        """
    
        pass
    
    
    def getParent(self):
        pass
    
    
    def name(self):
        pass
    
    
    def parent(self):
        pass
    
    
    def rename(*args, **kwargs):
        """
        This command renames the UI object passed as first arument to the new name specified as second argument. If the new name
        is a duplicate, or not valid, then re-naming fails and the old name is returned.
        
        
        Derived from mel command `maya.cmds.renameUI`
        """
    
        pass
    
    
    def shortName(self):
        pass
    
    
    def type(name, **kwargs):
        """
        This command returns the type of UI element such as button, sliders, etc.
        
        Flags:
          - isType : i                     (unicode)       [create]
              Returns true|false if the object is of the specified type.
        
          - listAll : la                   (bool)          [create]
              Returns a list of all known UI commands and their respective types. Each entry contains three strings which are the
              command name, ui type and class name. Note that the class name is internal and is subject to change.
        
          - superClasses : sc              (bool)          [create]
              Returns a list of the names of all super classes for the given object. Note that all class names are internal and are
              subject to change.                  Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.objectTypeUI`
        """
    
        pass
    
    
    def window(self):
        pass
    
    
    def exists(cls, name):
        pass
    
    
    def __new__(cls, name='None', create='False', **kwargs):
        """
        Provides the ability to create the PyUI Element when creating a class::
        
            import pymel.core as pm
            n = pm.Window("myWindow",create=True)
            n.__repr__()
            # Result: Window('myWindow')
        """
    
        pass
    
    
    __dict__ = None
    
    __weakref__ = None


class AETemplate(object):
    """
    To create an Attribute Editor template using python, do the following:
         1. create a subclass of `uitypes.AETemplate`
        2. set its ``_nodeType`` class attribute to the name of the desired node type, or name the class using the
    convention ``AE<nodeType>Template``
        3. import the module
    
    AETemplates which do not meet one of the two requirements listed in step 2 will be ignored.  To ensure that your
    Template's node type is being detected correctly, use the ``AETemplate.nodeType()`` class method::
    
        import AETemplates
        AETemplates.AEmib_amb_occlusionTemplate.nodeType()
    
    As a convenience, when pymel is imported it will automatically import the module ``AETemplates``, if it exists,
    thereby causing any AETemplates within it or its sub-modules to be registered. Be sure to import pymel
    or modules containing your ``AETemplate`` classes before opening the Atrribute Editor for the node types in question.
    
    To check which python templates are loaded::
    
        from pymel.core.uitypes import AELoader
        print AELoader.loadedTemplates()
    """
    
    
    
    def __init__(self, nodeName):
        pass
    
    
    def addComponents(self):
        pass
    
    
    def addControl(self, control, label='None', changeCommand='None', annotation='None', preventOverride='False', dynamic='False'):
        pass
    
    
    def addExtraControls(self, label='None'):
        pass
    
    
    def addSeparator(self):
        pass
    
    
    def beginLayout(self, name, collapse='True'):
        pass
    
    
    def beginNoOptimize(self):
        pass
    
    
    def beginScrollLayout(self):
        pass
    
    
    def callCustom(self, newFunc, replaceFunc, *attrs):
        pass
    
    
    def dimControl(self, nodeName, control, state):
        pass
    
    
    def endLayout(self):
        pass
    
    
    def endNoOptimize(self):
        pass
    
    
    def endScrollLayout(self):
        pass
    
    
    def interruptOptimize(self):
        pass
    
    
    def suppress(self, control):
        pass
    
    
    def controlLabel(cls, nodeName, control):
        pass
    
    
    def controlValue(cls, nodeName, control):
        pass
    
    
    def nodeType(cls):
        pass
    
    
    def reload(cls):
        """
        Reload the template. Beware, this reloads the module in which the template exists!
        """
    
        pass
    
    
    __dict__ = None
    
    __weakref__ = None
    
    nodeName = None


class AELoader(type):
    """
    Metaclass used by `AETemplate` class to create wrapping and loading mechanisms when an AETemplate instance is created
    """
    
    
    
    def loadedTemplates(cls):
        """
        Return the names of the loaded templates
        """
    
        pass
    
    
    def __new__(cls, classname, bases, classdict):
        pass
    
    
    def load(modname, classname, nodename):
        pass
    
    
    def makeAEProc(modname, classname, procname):
        pass


class UITemplate(object):
    """
    from pymel.core import *
    
    # force deletes the template if it already exists
    template = ui.UITemplate( 'ExampleTemplate', force=True )
    
    template.define( button, width=100, height=40, align='left' )
    template.define( frameLayout, borderVisible=True, labelVisible=False )
    
    #    Create a window and apply the template.
    #
    with window():
        with template:
            with columnLayout( rowSpacing=5 ):
                with frameLayout():
                    with columnLayout():
                        button( label='One' )
                        button( label='Two' )
                        button( label='Three' )
    
                with frameLayout():
                    with columnLayout():
                        button( label='Red' )
                        button( label='Green' )
                        button( label='Blue' )
    """
    
    
    
    def __enter__(self):
        pass
    
    
    def __exit__(self, type, value, traceback):
        pass
    
    
    def __init__(self, name='None', force='False'):
        pass
    
    
    def __repr__(self):
        pass
    
    
    def define(self, uiType, **kwargs):
        """
        uiType can be:
            - a ui function or class
            - the name of a ui function or class
            - a list or tuple of the above
        """
    
        pass
    
    
    def name(self):
        pass
    
    
    def pop(self):
        pass
    
    
    def push(self):
        pass
    
    
    def exists(name):
        pass
    
    
    __dict__ = None
    
    __weakref__ = None


class TextScrollList(PyUI):
    """
    class counterpart of mel function `textScrollList`
    
    This command creates/edits/queries a text scrolling list. The list can be in single select mode where only one item at at time is selected, or in multi-select mode where many items may be selected. Note: The -dgc/dragCallback flag works only on Windows.
    """
    
    
    
    def append(self, val='True', **kwargs):
        """
        Add an item to the end of the list.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def appendPosition(self, val='True', **kwargs):
        """
        Append an item at the specified position. The position is a 1-based index.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def deleteKeyCommand(self, val='True', **kwargs):
        """
        Specify the command to be executed when the delete or backspace key is pressed.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def deselectAll(self, val='True', **kwargs):
        """
        Deselect all items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def deselectIndexedItem(self, val='True', **kwargs):
        """
        Deselect the indexed item.  Indices are 1-based.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def deselectItem(self, val='True', **kwargs):
        """
        Deselect the item that contains the specified text.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def doubleClickCommand(self, val='True', **kwargs):
        """
        Specify the command to be executed when an item is double clicked.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def extend(self, appendList):
        """
        append a list of strings
        """
    
        pass
    
    
    def getAllItems(self, **kwargs):
        """
        All the items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getAllowAutomaticSelection(self, **kwargs):
        """
        Specify automatic selection mode.  When automaticSelection is on each item that the mouse is over (during dragging once an item has been selected) will be selected.  Thus, if -sc/selectCommand someCommandis set, someCommandwill be called for each selected item. If -aas/allowAutomaticSelectionis off, then only the item selected when the mouse button is up will be the selected item, so -sc/selectCommand someCommandis only called once if it is set.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getAllowMultiSelection(self, **kwargs):
        """
        Specify multi or single selection mode.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getFont(self, **kwargs):
        """
        The font for the list items.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getNumberOfItems(self, **kwargs):
        """
        Number of items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getNumberOfRows(self, **kwargs):
        """
        Number of visible rows.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getNumberOfSelectedItems(self, **kwargs):
        """
        Number of selected items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getSelectIndexedItem(self, **kwargs):
        """
        Select the indexed item. Indices are 1-based.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getSelectItem(self, **kwargs):
        """
        Select the item that contains the specified text.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getSelectUniqueTagItem(self, **kwargs):
        """
        Allow item selections based on the unique tag. In query mode, it will return the unique tag of the selected items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def lineFont(self, val='True', **kwargs):
        """
        Specify the font for a specific line of the list. The indices are 1-based. Valid font values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def removeAll(self, val='True', **kwargs):
        """
        Remove all items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def removeIndexedItem(self, val='True', **kwargs):
        """
        Remove the indexed item. Indices are 1-based.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def removeIndexedItems(self, removeList):
        """
        remove a list of indices
        """
    
        pass
    
    
    def removeItem(self, val='True', **kwargs):
        """
        Remove the item with the specified text.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def selectAll(self):
        """
        select all items
        """
    
        pass
    
    
    def selectCommand(self, val='True', **kwargs):
        """
        Specify the command to be executed when an item is selected.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def selectIndexedItems(self, selectList):
        """
        select a list of indices
        """
    
        pass
    
    
    def setAllowAutomaticSelection(self, val='True', **kwargs):
        """
        Specify automatic selection mode.  When automaticSelection is on each item that the mouse is over (during dragging once an item has been selected) will be selected.  Thus, if -sc/selectCommand someCommandis set, someCommandwill be called for each selected item. If -aas/allowAutomaticSelectionis off, then only the item selected when the mouse button is up will be the selected item, so -sc/selectCommand someCommandis only called once if it is set.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setAllowMultiSelection(self, val='True', **kwargs):
        """
        Specify multi or single selection mode.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setFont(self, val='True', **kwargs):
        """
        The font for the list items.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setNumberOfRows(self, val='True', **kwargs):
        """
        Number of visible rows.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setSelectIndexedItem(self, val='True', **kwargs):
        """
        Select the indexed item. Indices are 1-based.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setSelectItem(self, val='True', **kwargs):
        """
        Select the item that contains the specified text.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setSelectUniqueTagItem(self, val='True', **kwargs):
        """
        Allow item selections based on the unique tag. In query mode, it will return the unique tag of the selected items.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def showIndexedItem(self, val='True', **kwargs):
        """
        Show the indexed item.  Scroll the list as necessary so that the indexed item is visible.  Indices are 1-based.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def uniqueTag(self, val='True', **kwargs):
        """
        This flag can only be used in conjunction with the append or the appendPosition flag. The string specifies a unique tag for the appended item; the tag can then be used to query an item. This tag provides an alternate way to uniquely identify a list item using a string instead of by index. Tags are case insensitive.                  
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates/edits/queries a text scrolling list. The list can be in single select mode where only one item at
        at time is selected, or in multi-select mode where many items may be selected. Note: The -dgc/dragCallback flag works
        only on Windows.
        
        Modifications:
          - returns an empty list when the result is None for flags: (query and (selectIndexedItem or allItems or selectItem))
        
        Flags:
          - allItems : ai                  (bool)          [query]
              All the items.
        
          - allowAutomaticSelection : aas  (bool)          [create,query,edit]
              Specify automatic selection mode.  When automaticSelection is on each item that the mouse is over (during dragging once
              an item has been selected) will be selected.  Thus, if -sc/selectCommand someCommandis set, someCommandwill be called
              for each selected item. If -aas/allowAutomaticSelectionis off, then only the item selected when the mouse button is up
              will be the selected item, so -sc/selectCommand someCommandis only called once if it is set.
        
          - allowMultiSelection : ams      (bool)          [create,query,edit]
              Specify multi or single selection mode.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - append : a                     (unicode)       [create,edit]
              Add an item to the end of the list.
        
          - appendPosition : ap            (int, unicode)  [create,edit]
              Append an item at the specified position. The position is a 1-based index.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - deleteKeyCommand : dkc         (script)        [create,edit]
              Specify the command to be executed when the delete or backspace key is pressed.
        
          - deselectAll : da               (bool)          [create,edit]
              Deselect all items.
        
          - deselectIndexedItem : dii      (int)           [create,edit]
              Deselect the indexed item.  Indices are 1-based.
        
          - deselectItem : di              (unicode)       [create,edit]
              Deselect the item that contains the specified text.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - doubleClickCommand : dcc       (script)        [create,edit]
              Specify the command to be executed when an item is double clicked.
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - font : fn                      (unicode)       [create,query,edit]
              The font for the list items.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
              smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - lineFont : lf                  (int, unicode)  [create,edit]
              Specify the font for a specific line of the list. The indices are 1-based. Valid font values are boldLabelFont,
              smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont,
              fixedWidthFontand smallFixedWidthFont.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfItems : ni             (bool)          [query]
              Number of items.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - numberOfRows : nr              (int)           [create,query,edit]
              Number of visible rows.
        
          - numberOfSelectedItems : nsi    (bool)          [query]
              Number of selected items.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - removeAll : ra                 (bool)          [create,edit]
              Remove all items.
        
          - removeIndexedItem : rii        (int)           [create,edit]
              Remove the indexed item. Indices are 1-based.
        
          - removeItem : ri                (unicode)       [create,edit]
              Remove the item with the specified text.
        
          - selectCommand : sc             (script)        [create,edit]
              Specify the command to be executed when an item is selected.
        
          - selectIndexedItem : sii        (int)           [create,query,edit]
              Select the indexed item. Indices are 1-based.
        
          - selectItem : si                (unicode)       [create,query,edit]
              Select the item that contains the specified text.
        
          - selectUniqueTagItem : sut      (unicode)       [create,query,edit]
              Allow item selections based on the unique tag. In query mode, it will return the unique tag of the selected items.
        
          - showIndexedItem : shi          (int)           [create,edit]
              Show the indexed item.  Scroll the list as necessary so that the indexed item is visible.  Indices are 1-based.
        
          - uniqueTag : utg                (unicode)       [create,edit]
              This flag can only be used in conjunction with the append or the appendPosition flag. The string specifies a unique tag
              for the appended item; the tag can then be used to query an item. This tag provides an alternate way to uniquely
              identify a list item using a string instead of by index. Tags are case insensitive.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.textScrollList`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'textScrollList'
    
    
    __melui__ = 'textScrollList'
    
    
    
    
    __readonly__ = {}


class Button(PyUI):
    """
    class counterpart of mel function `button`
    
    Create a button control capable of displaying a textual label and executing a command when selected by the user.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getActOnPress(self, **kwargs):
        """
        If true then the command specified by the command flag will be executed when a mouse button is pressed.  If false then that command will be executed after the mouse button is released. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getActionIsSubstitute(self, **kwargs):
        """
        This flag is obsolete and should no longer be used.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getAlign(self, **kwargs):
        """
        This flag is obsolete and should no longer be used. The button label will always be center-aligned.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getCommand(self, **kwargs):
        """
        Command executed when the control is pressed.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        The label text.  The default label is the name of the control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getRecomputeSize(self, **kwargs):
        """
        If true then the control will recompute it's size to just fit the size of the label.  If false then the control size will remain fixed as you change the size of the label.  The default value of this flag is true.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setActOnPress(self, val='True', **kwargs):
        """
        If true then the command specified by the command flag will be executed when a mouse button is pressed.  If false then that command will be executed after the mouse button is released. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setActionIsSubstitute(self, val='True', **kwargs):
        """
        This flag is obsolete and should no longer be used.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setAlign(self, val='True', **kwargs):
        """
        This flag is obsolete and should no longer be used. The button label will always be center-aligned.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setCommand(self, val='True', **kwargs):
        """
        Command executed when the control is pressed.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        The label text.  The default label is the name of the control.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setRecomputeSize(self, val='True', **kwargs):
        """
        If true then the control will recompute it's size to just fit the size of the label.  If false then the control size will remain fixed as you change the size of the label.  The default value of this flag is true.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a button control capable of displaying a textual label and executing a command when selected by the user.
        
        Flags:
          - actOnPress : aop               (bool)          [create,query,edit]
              If true then the command specified by the command flag will be executed when a mouse button is pressed.  If false then
              that command will be executed after the mouse button is released. The default value is false.
        
          - actionIsSubstitute : ais       (bool)          [create,query,edit]
              This flag is obsolete and should no longer be used.
        
          - align : al                     (unicode)       [create,query,edit]
              This flag is obsolete and should no longer be used. The button label will always be center-aligned.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - command : c                    (script)        [create,query,edit]
              Command executed when the control is pressed.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - label : l                      (unicode)       [create,query,edit]
              The label text.  The default label is the name of the control.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - recomputeSize : rs             (bool)          [create,query,edit]
              If true then the control will recompute it's size to just fit the size of the label.  If false then the control size
              will remain fixed as you change the size of the label.  The default value of this flag is true.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.button`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'button'
    
    
    __melui__ = 'button'
    
    
    __readonly__ = {}


class RadioMenuItemCollection(PyUI):
    """
    class counterpart of mel function `radioMenuItemCollection`
    
    This command creates a radioMenuItemCollection.  Attach radio menu items to radio menu item collection objects to get radio button behaviour.  Radio menu item collections will be parented to the current menu if no parent is specified with the -p/parentflag. As children of the menu they will be deleted when the menu is deleted. Collections may also span more than one menu if the -g/globalflag is used. In this case the collection has no parent menu and must be explicitly deleted with the deleteUIcommand when it is no longer wanted.
    """
    
    
    
    def getGl(self, **kwargs):
        """
        Set the collection to have no parent menu.  Global collections must be explicitly deleted.                  
        
        
        Derived from mel command `maya.cmds.radioMenuItemCollection`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a radioMenuItemCollection.  Attach radio menu items to radio menu item collection objects to get
        radio button behaviour.  Radio menu item collections will be parented to the current menu if no parent is specified with
        the -p/parentflag. As children of the menu they will be deleted when the menu is deleted. Collections may also span more
        than one menu if the -g/globalflag is used. In this case the collection has no parent menu and must be explicitly
        deleted with the deleteUIcommand when it is no longer wanted.
        
        Flags:
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - gl : gl                        (bool)          [create,query]
              Set the collection to have no parent menu.  Global collections must be explicitly deleted.
        
          - parent : p                     (unicode)       [create]
              The parent of the collection.  The collection will be deleted along with the parent.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.radioMenuItemCollection`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'radioMenuItemCollection'
    
    
    __melui__ = 'radioMenuItemCollection'
    
    
    __readonly__ = {}


class Image(PyUI):
    """
    class counterpart of mel function `image`
    
    This command creates a static image for non-xpm files. Any image file format supported by the file texture node is supported by this command.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getImage(self, **kwargs):
        """
        Sets the image given the file name.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setImage(self, val='True', **kwargs):
        """
        Sets the image given the file name.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a static image for non-xpm files. Any image file format supported by the file texture node is
        supported by this command.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - image : i                      (unicode)       [create,query,edit]
              Sets the image given the file name.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.image`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'image'
    
    
    __melui__ = 'image'
    
    
    __readonly__ = {}


class Canvas(PyUI):
    """
    class counterpart of mel function `canvas`
    
    Creates a control capable of displaying a color swatch. This control can also accept a command to be called when the colour swatch is pressed by the user. Note: The -dgc/dragCallback and -dpc/dropCallback are not available for this control.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getHsvValue(self, **kwargs):
        """
        Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0 to 360.0 and the saturation and value components range from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getRgbValue(self, **kwargs):
        """
        Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def pressCommand(self, val='True', **kwargs):
        """
        Command to be executed when there is a mouse press.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setHsvValue(self, val='True', **kwargs):
        """
        Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0 to 360.0 and the saturation and value components range from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setRgbValue(self, val='True', **kwargs):
        """
        Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Creates a control capable of displaying a color swatch. This control can also accept a command to be called when the
        colour swatch is pressed by the user. Note: The -dgc/dragCallback and -dpc/dropCallback are not available for this
        control.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - hsvValue : hsv                 (float, float, float) [create,query,edit]
              Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0
              to 360.0 and the saturation and value components range from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - pressCommand : pc              (script)        [create,edit]
              Command to be executed when there is a mouse press.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - rgbValue : rgb                 (float, float, float) [create,query,edit]
              Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.canvas`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'canvas'
    
    
    __melui__ = 'canvas'
    
    
    __readonly__ = {}


class PalettePort(PyUI):
    """
    class counterpart of mel function `palettePort`
    
    This command creates an array of color cells. It could be used to to store an retrieve some colors you want to manage during your working session.
    """
    
    
    
    def changeCommand(self, val='True', **kwargs):
        """
        This command string will be executed when a color in the palette is changed.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def colorEdited(self, val='True', **kwargs):
        """
        This command string will be executed when a color in the palette is edited.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getActualTotal(self, **kwargs):
        """
        Set the actual number of palette entries. This number must be greater than zero, but not be greater than maximum number of palette entries defined by the dimensionsflag.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getColorEditable(self, **kwargs):
        """
        If true then the user can modify the current index's color.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getDimensions(self, **kwargs):
        """
        Set the dimensions of the array.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getEditable(self, **kwargs):
        """
        If true then the user can change the current color.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getHsvValue(self, **kwargs):
        """
        Set a color for a given cell, using HSV format. On query return the color of the current cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getRgbValue(self, **kwargs):
        """
        Set a color for a given cell, using RGB format. On query return the color of the current cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getSetCurCell(self, **kwargs):
        """
        Set the current cell in the array to the given index. Returns the current cell when queried.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getTransparent(self, **kwargs):
        """
        Set a given cell to be the transparent color.  A cell value of -1 indicates that no cell is transparent.  On query returns the current transparent cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def redraw(self, val='True', **kwargs):
        """
        Forces a redraw of the array                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setColorEditable(self, val='True', **kwargs):
        """
        If true then the user can modify the current index's color.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setEditable(self, val='True', **kwargs):
        """
        If true then the user can change the current color.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setHsvValue(self, val='True', **kwargs):
        """
        Set a color for a given cell, using HSV format. On query return the color of the current cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setRgbValue(self, val='True', **kwargs):
        """
        Set a color for a given cell, using RGB format. On query return the color of the current cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setSetCurCell(self, val='True', **kwargs):
        """
        Set the current cell in the array to the given index. Returns the current cell when queried.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setTransparent(self, val='True', **kwargs):
        """
        Set a given cell to be the transparent color.  A cell value of -1 indicates that no cell is transparent.  On query returns the current transparent cell.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates an array of color cells. It could be used to to store an retrieve some colors you want to manage
        during your working session.
        
        Flags:
          - actualTotal : at               (int)           [create,query]
              Set the actual number of palette entries. This number must be greater than zero, but not be greater than maximum number
              of palette entries defined by the dimensionsflag.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand : cc             (script)        [create,edit]
              This command string will be executed when a color in the palette is changed.
        
          - colorEditable : ced            (bool)          [create,query,edit]
              If true then the user can modify the current index's color.
        
          - colorEdited : ce               (script)        [create,edit]
              This command string will be executed when a color in the palette is edited.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - dimensions : dim               (int, int)      [create,query]
              Set the dimensions of the array.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - editable : ed                  (bool)          [create,query,edit]
              If true then the user can change the current color.
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - hsvValue : hsv                 (int, int, float, float, float) [create,query,edit]
              Set a color for a given cell, using HSV format. On query return the color of the current cell.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - redraw : r                     (bool)          [create,edit]
              Forces a redraw of the array
        
          - rgbValue : rgb                 (int, float, float, float) [create,query,edit]
              Set a color for a given cell, using RGB format. On query return the color of the current cell.
        
          - setCurCell : scc               (int)           [create,query,edit]
              Set the current cell in the array to the given index. Returns the current cell when queried.
        
          - topDown : td                   (bool)          [create]
              If this flag is true, it indicates that first entry should appear in top left as opposed to the bottom left.
        
          - transparent : t                (int)           [create,query,edit]
              Set a given cell to be the transparent color.  A cell value of -1 indicates that no cell is transparent.  On query
              returns the current transparent cell.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.palettePort`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'palettePort'
    
    
    __melui__ = 'palettePort'
    
    
    __readonly__ = {}


class LayoutDialog(PyUI):
    """
    class counterpart of mel function `layoutDialog`
    
    The layoutDialog command creates a modal dialog containing a formLayout with 100 divisions. The formLayout can be populated with arbitrary UI elements through use of the '-ui/-uiScript' flag. NOTE:A layoutDialog is not a window and certain UI elements will not function properly within it. In particular menuBars and panels containing menuBars should not be used with the layoutDialog.
    """
    
    
    
    def __melcmd__(*args, **kwargs):
        """
        The layoutDialog command creates a modal dialog containing a formLayout with 100 divisions. The formLayout can be
        populated with arbitrary UI elements through use of the '-ui/-uiScript' flag. NOTE:A layoutDialog is not a window and
        certain UI elements will not function properly within it. In particular menuBars and panels containing menuBars should
        not be used with the layoutDialog.
        
        Flags:
          - backgroundColor : bgc          (float, float, float) [create]
              The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. (Windows only flag)
        
          - dismiss : dis                  (unicode)       [create]
              Dismiss the current layoutDialog. The specified string will be set as the result of the initial layoutDialog command.
        
          - parent : p                     (unicode)       [create]
              Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
              parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
        
          - title : t                      (unicode)       [create]
              The dialog title.
        
          - uiScript : ui                  (script)        [create]
              The specified MEL procedure name will be invoked to build the UI of the layoutDialog. This flag is required when
              creating a layoutDialog. The top-level control of a layoutDialog is a formLayout with 100 divisions. It can be accessed
              by calling 'setParent -q' at the beginning of the specified MEL procedure.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.layoutDialog`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'layoutDialog'
    
    
    __melui__ = 'layoutDialog'
    
    
    __readonly__ = {}


class IconTextButton(PyUI):
    """
    class counterpart of mel function `iconTextButton`
    
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best fits the current size of the control given its current style. This command creates an iconTextButton that can be displayed with different icons, with or without accompanying text label. When an argument is passed, it is used to give a name to the iconTextButton.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getAlign(self, **kwargs):
        """
        The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getCommand(self, **kwargs):
        """
        Command executed when the control is pressed.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getCommandRepeatable(self, **kwargs):
        """
        Set if the MEL command specified in the command flag should be repeatable or not.  The gkey, by default, is the shortcut to repeat the last executed command.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getDisabledImage(self, **kwargs):
        """
        Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getDoubleClickCommand(self, **kwargs):
        """
        Command executed when the control is double clicked.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getFlat(self, **kwargs):
        """
        Sets whether the control will be a flat button (0 false, 1 true).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getFlipX(self, **kwargs):
        """
        Is the image flipped horizontally?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getFlipY(self, **kwargs):
        """
        Is the image flipped vertically?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getFont(self, **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getHighlightImage(self, **kwargs):
        """
        Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with the -i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getImage(self, **kwargs):
        """
        If you are not providing images with different sizes then you may use this flag for the control's image. If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getImage1(self, **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getImage2(self, **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getImage3(self, **kwargs):
        """
        This control supports three icons. The icon that best fits the current size of the control will be displayed.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getImageOverlayLabel(self, **kwargs):
        """
        A short string, up to 6 characters, representing a label that will be displayed on top of the image.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        The text that appears in the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getLabelOffset(self, **kwargs):
        """
        The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getLtVersion(self, **kwargs):
        """
        This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getMarginHeight(self, **kwargs):
        """
        The number of pixels above and below the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getMarginWidth(self, **kwargs):
        """
        The number of pixels on either side of the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getOverlayLabelBackColor(self, **kwargs):
        """
        The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getOverlayLabelColor(self, **kwargs):
        """
        The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getRotation(self, **kwargs):
        """
        The rotation value of the image in radians.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getSelectionImage(self, **kwargs):
        """
        Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getSourceType(self, **kwargs):
        """
        Sets the language type for the command script. Can only be used in conjunction with the c/command or dcc/doubleClickCommand flags. Valid values are mel(enabled by default), and python.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getStyle(self, **kwargs):
        """
        The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getUseAlpha(self, **kwargs):
        """
        Is the image using alpha channel?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getVersion(self, **kwargs):
        """
        Specify the version that this control feature was introduced. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def handleNodeDropCallback(self, val='True', **kwargs):
        """
        Specify a script callback which is called when a node is dropped on the control.  The name of the node being dropped will be passed to the function  (python callable) or appended to the end (script) to form the command to be executed.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def labelEditingCallback(self, val='True', **kwargs):
        """
        Specify a callback which is called after the user double clicks the label of the control to give it a new label. The new label string will be passed to the callback.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def menuItem(self, val='True', **kwargs):
        """
        Creates menu items for this button by passing in arguments for the menu item label and command for each item.  These should be passed as strings: labelcommandfor each use of this flag in the command. May be used mutliple times                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def scaleIcon(self, val='True', **kwargs):
        """
        For textOnlyand iconOnlystyle, this flag has no effect. For other styles, if the flag is specified, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setAlign(self, val='True', **kwargs):
        """
        The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setCommand(self, val='True', **kwargs):
        """
        Command executed when the control is pressed.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setCommandRepeatable(self, val='True', **kwargs):
        """
        Set if the MEL command specified in the command flag should be repeatable or not.  The gkey, by default, is the shortcut to repeat the last executed command.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setDisabledImage(self, val='True', **kwargs):
        """
        Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setDoubleClickCommand(self, val='True', **kwargs):
        """
        Command executed when the control is double clicked.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setFlat(self, val='True', **kwargs):
        """
        Sets whether the control will be a flat button (0 false, 1 true).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setFlipX(self, val='True', **kwargs):
        """
        Is the image flipped horizontally?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setFlipY(self, val='True', **kwargs):
        """
        Is the image flipped vertically?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setFont(self, val='True', **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setHighlightImage(self, val='True', **kwargs):
        """
        Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with the -i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setImage(self, val='True', **kwargs):
        """
        If you are not providing images with different sizes then you may use this flag for the control's image. If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setImage1(self, val='True', **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setImage2(self, val='True', **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setImage3(self, val='True', **kwargs):
        """
        This control supports three icons. The icon that best fits the current size of the control will be displayed.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setImageOverlayLabel(self, val='True', **kwargs):
        """
        A short string, up to 6 characters, representing a label that will be displayed on top of the image.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        The text that appears in the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setLabelOffset(self, val='True', **kwargs):
        """
        The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setLtVersion(self, val='True', **kwargs):
        """
        This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setMarginHeight(self, val='True', **kwargs):
        """
        The number of pixels above and below the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setMarginWidth(self, val='True', **kwargs):
        """
        The number of pixels on either side of the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setOverlayLabelBackColor(self, val='True', **kwargs):
        """
        The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setOverlayLabelColor(self, val='True', **kwargs):
        """
        The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setRotation(self, val='True', **kwargs):
        """
        The rotation value of the image in radians.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setSelectionImage(self, val='True', **kwargs):
        """
        Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setSourceType(self, val='True', **kwargs):
        """
        Sets the language type for the command script. Can only be used in conjunction with the c/command or dcc/doubleClickCommand flags. Valid values are mel(enabled by default), and python.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setStyle(self, val='True', **kwargs):
        """
        The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setUseAlpha(self, val='True', **kwargs):
        """
        Is the image using alpha channel?                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setVersion(self, val='True', **kwargs):
        """
        Specify the version that this control feature was introduced. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
        fits the current size of the control given its current style. This command creates an iconTextButton that can be
        displayed with different icons, with or without accompanying text label. When an argument is passed, it is used to give
        a name to the iconTextButton.
        
        Flags:
          - actionIsSubstitute : ais       (bool)          []
        
          - align : al                     (unicode)       [create,query,edit]
              The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
              only available when -st/style is set to iconAndTextCentered.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - command : c                    (script)        [create,query,edit]
              Command executed when the control is pressed.
        
          - commandRepeatable : rpt        (bool)          [create,query,edit]
              Set if the MEL command specified in the command flag should be repeatable or not.  The gkey, by default, is the shortcut
              to repeat the last executed command.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - disabledImage : di             (unicode)       [create,query,edit]
              Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
              a Windows only flag.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - doubleClickCommand : dcc       (script)        [create,query,edit]
              Command executed when the control is double clicked.
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - flat : fla                     (bool)          [create,query,edit]
              Sets whether the control will be a flat button (0 false, 1 true).
        
          - flipX : fx                     (bool)          [create,query,edit]
              Is the image flipped horizontally?
        
          - flipY : fy                     (bool)          [create,query,edit]
              Is the image flipped vertically?
        
          - font : fn                      (unicode)       [create,query,edit]
              The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
              smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - handleNodeDropCallback : hnd   (script)        [create,edit]
              Specify a script callback which is called when a node is dropped on the control.  The name of the node being dropped
              will be passed to the function  (python callable) or appended to the end (script) to form the command to be executed.
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - highlightImage : hi            (unicode)       [create,query,edit]
              Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with
              the -i/imageflag. This is a Windows only flag.
        
          - image : i                      (unicode)       [create,query,edit]
              If you are not providing images with different sizes then you may use this flag for the control's image. If the
              iconOnlystyle is set, the icon will be scaled to the size of the control.
        
          - image1 : i1                    (unicode)       [create,query,edit]
        
          - image2 : i2                    (unicode)       [create,query,edit]
        
          - image3 : i3                    (unicode)       [create,query,edit]
              This control supports three icons. The icon that best fits the current size of the control will be displayed.
        
          - imageOverlayLabel : iol        (unicode)       [create,query,edit]
              A short string, up to 6 characters, representing a label that will be displayed on top of the image.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - label : l                      (unicode)       [create,query,edit]
              The text that appears in the control.
        
          - labelEditingCallback : lec     (script)        [create,edit]
              Specify a callback which is called after the user double clicks the label of the control to give it a new label. The new
              label string will be passed to the callback.
        
          - labelOffset : lo               (int)           [create,query,edit]
              The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
        
          - ltVersion : lt                 (unicode)       [create,query,edit]
              This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
              specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
              otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
              accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - marginHeight : mh              (int)           [create,query,edit]
              The number of pixels above and below the control content. The default value is 1 pixel.
        
          - marginWidth : mw               (int)           [create,query,edit]
              The number of pixels on either side of the control content. The default value is 1 pixel.
        
          - menuItem : mi                  (unicode, unicode) [create,edit]
              Creates menu items for this button by passing in arguments for the menu item label and command for each item.  These
              should be passed as strings: labelcommandfor each use of this flag in the command. May be used mutliple times
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
              The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
        
          - overlayLabelColor : olc        (float, float, float) [create,query,edit]
              The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - rotation : rot                 (float)         [create,query,edit]
              The rotation value of the image in radians.
        
          - scaleIcon : sic                (bool)          [create,edit]
              For textOnlyand iconOnlystyle, this flag has no effect. For other styles, if the flag is specified, the icon will be
              scaled to the size of the control.
        
          - selectionImage : si            (unicode)       [create,query,edit]
              Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag.
              This is a Windows only flag.
        
          - sourceType : stp               (unicode)       [create,query,edit]
              Sets the language type for the command script. Can only be used in conjunction with the c/command or
              dcc/doubleClickCommand flags. Valid values are mel(enabled by default), and python.
        
          - style : st                     (unicode)       [create,query,edit]
              The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
              iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
              be scaled to the size of the control.
        
          - useAlpha : ua                  (bool)          [create,query,edit]
              Is the image using alpha channel?
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - version : ver                  (unicode)       [create,query,edit]
              Specify the version that this control feature was introduced. The argument should be given as a string of the version
              number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
              2014).
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.iconTextButton`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'iconTextButton'
    
    
    __melui__ = 'iconTextButton'
    
    
    __readonly__ = {}


class FloatSlider2(PyUI):
    """
    class counterpart of mel function `floatSlider2`
    
    This command creates a float slider containing two handles. The two handles are arranged such that they cannot pass one another, thus handle 1 will always have a value less than or or equal to handle 2 when you adjust the values. Each handle may have a MEL command associated with it which is issued when the handle moves and thus can be used to update the values of plugs such as via a setAttr command. Each handle can also be associated with a float textfield to display the current value of the handle. Note: the floatSlider2 widget currently only supports vertical (columnLayout) orientation.
    """
    
    
    
    def changeCommand1(self, val='True', **kwargs):
        """
        Command to be associated with handle 1 and issued whenever the value of the handle is changed (except when values are changed via the -hv/handleValue flag). An example command might be setAttr nurbsSphere1.txand if handle 1 were to move to value 0.23 the slider would issue the command setAttr nurbsSphere1.tx 0.23;.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def changeCommand2(self, val='True', **kwargs):
        """
        Command to be associated with handle 2 and issued whenever the value of the handle is changed (except when values are changed via the -hv/handleValue flag). An example command might be setAttr nurbsSphere1.txand if handle 2 were to move to value 0.23 the slider would issue the command setAttr nurbsSphere1.tx 0.23;.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getMaximum(self, **kwargs):
        """
        Maximum limit of the slider. The default value is 10.0. The maximum value occurs at the top(right) end of the slider unless -polarity was specified. Note: you cannot set the maximum value greater than or equal to the current minimum.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getMinimum(self, **kwargs):
        """
        Minimum limit of the slider. The default value is 0.0. The minimum value occurs at the bottom end of the slider unless -polarity was specified. Note: you cannot set the minimum value greater than or equal to the current maximum.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getPolarity(self, **kwargs):
        """
        Specifies the polarity of the slider. If 0 (the default), the minimum value (specified by the -minimum flag) occurs at the bottom end of the slider and maximum at the top(right), with values increasing as the slider handles are moved towards the upper end of the slider. If the polarity is specified as 1, the reverse behaviour occurs, with the maximum occurring at the bottom end, the mimimum occuring at the top(right) end and values decreasing as the handles are moved towards the upper end.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getValue1(self, **kwargs):
        """
        Value of handle 1. To ensure that handle 1 stays at or below handle 2, an error will occur if the value specified is too large. If you wish to set both handles simultaneously, use the -values flag.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getValue2(self, **kwargs):
        """
        Value of handle 2. To ensure that handle 2 stays at or above handle 2, an error will occur if the value specified is too large. If you wish to set both handles simultaneously, use the -values flag.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def positionControl1(self, val='True', **kwargs):
        """
        Set the name of the control (if any) which is associated with handle 1 of this slider. The control must be a floatField. The control always displays the value of the handle, and is updated as the handle moves.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def positionControl2(self, val='True', **kwargs):
        """
        Set the name of the control (if any) which is associated with handle 2 of this slider. The control must be a floatField. The control always displays the value of the handle, and is updated as the handle moves.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setMaximum(self, val='True', **kwargs):
        """
        Maximum limit of the slider. The default value is 10.0. The maximum value occurs at the top(right) end of the slider unless -polarity was specified. Note: you cannot set the maximum value greater than or equal to the current minimum.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setMinimum(self, val='True', **kwargs):
        """
        Minimum limit of the slider. The default value is 0.0. The minimum value occurs at the bottom end of the slider unless -polarity was specified. Note: you cannot set the minimum value greater than or equal to the current maximum.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setPolarity(self, val='True', **kwargs):
        """
        Specifies the polarity of the slider. If 0 (the default), the minimum value (specified by the -minimum flag) occurs at the bottom end of the slider and maximum at the top(right), with values increasing as the slider handles are moved towards the upper end of the slider. If the polarity is specified as 1, the reverse behaviour occurs, with the maximum occurring at the bottom end, the mimimum occuring at the top(right) end and values decreasing as the handles are moved towards the upper end.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setValue1(self, val='True', **kwargs):
        """
        Value of handle 1. To ensure that handle 1 stays at or below handle 2, an error will occur if the value specified is too large. If you wish to set both handles simultaneously, use the -values flag.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setValue2(self, val='True', **kwargs):
        """
        Value of handle 2. To ensure that handle 2 stays at or above handle 2, an error will occur if the value specified is too large. If you wish to set both handles simultaneously, use the -values flag.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def values(self, val='True', **kwargs):
        """
        Sets the value for handles 1 and 2 simulteneously. The first argument is applied to handle 1 and must be less than or equal to the second (handle 2) argument or an error will be issued.                  
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a float slider containing two handles. The two handles are arranged such that they cannot pass one
        another, thus handle 1 will always have a value less than or or equal to handle 2 when you adjust the values. Each
        handle may have a MEL command associated with it which is issued when the handle moves and thus can be used to update
        the values of plugs such as via a setAttr command. Each handle can also be associated with a float textfield to display
        the current value of the handle. Note: the floatSlider2 widget currently only supports vertical (columnLayout)
        orientation.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand1 : cc1           (unicode)       [create,edit]
              Command to be associated with handle 1 and issued whenever the value of the handle is changed (except when values are
              changed via the -hv/handleValue flag). An example command might be setAttr nurbsSphere1.txand if handle 1 were to move
              to value 0.23 the slider would issue the command setAttr nurbsSphere1.tx 0.23;.
        
          - changeCommand2 : cc2           (unicode)       [create,edit]
              Command to be associated with handle 2 and issued whenever the value of the handle is changed (except when values are
              changed via the -hv/handleValue flag). An example command might be setAttr nurbsSphere1.txand if handle 2 were to move
              to value 0.23 the slider would issue the command setAttr nurbsSphere1.tx 0.23;.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - maximum : max                  (float)         [create,query,edit]
              Maximum limit of the slider. The default value is 10.0. The maximum value occurs at the top(right) end of the slider
              unless -polarity was specified. Note: you cannot set the maximum value greater than or equal to the current minimum.
        
          - minimum : min                  (float)         [create,query,edit]
              Minimum limit of the slider. The default value is 0.0. The minimum value occurs at the bottom end of the slider unless
              -polarity was specified. Note: you cannot set the minimum value greater than or equal to the current maximum.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - polarity : pol                 (int)           [create,query,edit]
              Specifies the polarity of the slider. If 0 (the default), the minimum value (specified by the -minimum flag) occurs at
              the bottom end of the slider and maximum at the top(right), with values increasing as the slider handles are moved
              towards the upper end of the slider. If the polarity is specified as 1, the reverse behaviour occurs, with the maximum
              occurring at the bottom end, the mimimum occuring at the top(right) end and values decreasing as the handles are moved
              towards the upper end.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - positionControl1 : pc1         (unicode)       [create,edit]
              Set the name of the control (if any) which is associated with handle 1 of this slider. The control must be a floatField.
              The control always displays the value of the handle, and is updated as the handle moves.
        
          - positionControl2 : pc2         (unicode)       [create,edit]
              Set the name of the control (if any) which is associated with handle 2 of this slider. The control must be a floatField.
              The control always displays the value of the handle, and is updated as the handle moves.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - value1 : v1                    (float)         [create,query,edit]
              Value of handle 1. To ensure that handle 1 stays at or below handle 2, an error will occur if the value specified is too
              large. If you wish to set both handles simultaneously, use the -values flag.
        
          - value2 : v2                    (float)         [create,query,edit]
              Value of handle 2. To ensure that handle 2 stays at or above handle 2, an error will occur if the value specified is too
              large. If you wish to set both handles simultaneously, use the -values flag.
        
          - values : vs                    (float, float)  [create,edit]
              Sets the value for handles 1 and 2 simulteneously. The first argument is applied to handle 1 and must be less than or
              equal to the second (handle 2) argument or an error will be issued.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.floatSlider2`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'floatSlider2'
    
    
    __melui__ = 'floatSlider2'
    
    
    __readonly__ = {}


class MenuSet(PyUI):
    """
    class counterpart of mel function `menuSet`
    
    Create a menu set which is used to logically order menus for display in the main menu bar.  Such menu sets can be edited and reordered dynamically.
    """
    
    
    
    def getAllMenuSets(self, **kwargs):
        """
        Returns an array of the all the menu set object names in use.  Query returns string array.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getCurrentMenuSet(self, **kwargs):
        """
        The currently active menu set under which all operations affect (append, insert, remove, etc.).  Query returns string.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getExists(self, **kwargs):
        """
        Returns whether the specified menu set exists.  This query flag supports string arguments. ie. menuSet -q -exists animationMenuSet;       
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getHotBoxVisible(self, **kwargs):
        """
        Whether this menu set should be displayed in the hotbox as well as in the main menubar.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        The label of the current menu set.  Query returns string.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getMenuArray(self, **kwargs):
        """
        An array of menu names (strings) in the current menu set.  Query returns string array.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getNumberOfMenuSets(self, **kwargs):
        """
        Number of menuSets in total.  Query returns int.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getNumberOfMenus(self, **kwargs):
        """
        The mumber of menus in the current menu set.  Query returns int.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def getPermanent(self, **kwargs):
        """
        Whether this menu set can be removed.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def setHotBoxVisible(self, val='True', **kwargs):
        """
        Whether this menu set should be displayed in the hotbox as well as in the main menubar.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def setPermanent(self, val='True', **kwargs):
        """
        Whether this menu set can be removed.                  
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a menu set which is used to logically order menus for display in the main menu bar.  Such menu sets can be edited
        and reordered dynamically.
        
        Flags:
          - addMenu : am                   (unicode)       [create]
              Appends a menu onto the end of the current menu set.
        
          - allMenuSets : ams              (bool)          [query]
              Returns an array of the all the menu set object names in use.  Query returns string array.
        
          - currentMenuSet : cms           (unicode)       [create,query]
              The currently active menu set under which all operations affect (append, insert, remove, etc.).  Query returns string.
        
          - exists : ex                    (unicode)       [query]
              Returns whether the specified menu set exists.  This query flag supports string arguments. ie. menuSet -q -exists
              animationMenuSet;
        
          - hotBoxVisible : hbv            (bool)          [create,query,edit]
              Whether this menu set should be displayed in the hotbox as well as in the main menubar.
        
          - insertMenu : im                (unicode, int)  [create]
              Inserts a menu into a specified index in the current menu set.
        
          - label : l                      (unicode)       [create,query]
              The label of the current menu set.  Query returns string.
        
          - menuArray : ma                 (<type 'unicode'>, ...) [create,query]
              An array of menu names (strings) in the current menu set.  Query returns string array.
        
          - moveMenu : mm                  (unicode, int)  [create]
              Moves a specified menu from the current menu set to a new position.
        
          - moveMenuSet : mms              (unicode, int)  [create]
              Moves a specified menu set to another index.
        
          - numberOfMenuSets : nms         (bool)          [query]
              Number of menuSets in total.  Query returns int.
        
          - numberOfMenus : nm             (bool)          [query]
              The mumber of menus in the current menu set.  Query returns int.
        
          - permanent : p                  (bool)          [create,query,edit]
              Whether this menu set can be removed.
        
          - removeMenu : rm                (unicode)       [create]
              Removes a specified menu from the current menu set.
        
          - removeMenuSet : rms            (unicode)       [create]
              Removes the specified menu set object from the list of all menu sets.                  Flag can have multiple arguments,
              passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.menuSet`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'menuSet'
    
    
    __melui__ = 'menuSet'
    
    
    __readonly__ = {}


class LayerButton(PyUI):
    """
    class counterpart of mel function `layerButton`
    
    Creates a layer bar button widget.  This widget contains both the name of the layer to which it refers and a color swatch indicating it's color assignment.  It is used primarily in the construction of the layerBar and layer Editor window, being the widget used for each layer in the respective lists.
    """
    
    
    
    def color(self, val='True', **kwargs):
        """
        Layer color, specified with normalized real numbers in R, G, B space.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def command(self, val='True', **kwargs):
        """
        Set the command to call on a single click.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def current(self, val='True', **kwargs):
        """
        Set this button to display as the current layer.  The current layer is the one which the user has the option of adding all newly created objects into.  NB: Setting the layer button to this state has no effect on the actual current layer.
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def doubleClickCommand(self, val='True', **kwargs):
        """
        Set the command to call on a double click.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getIdentification(self, **kwargs):
        """
        This is the integer identification number associated with the layer.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        Label text for the button.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getLabelWidth(self, **kwargs):
        """
        Query the width of the label part so as to determine if button clicks are in the label part or the colour swatch part.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getLayerHideOnPlayback(self, **kwargs):
        """
        Indicates whether the layer is visible or invisible during the playback.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getLayerState(self, **kwargs):
        """
        Describes the state of the layer.  This may be one of normal, template, or reference.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getLayerVisible(self, **kwargs):
        """
        Indicates whether the layer is visible or invisible.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getSelect(self, **kwargs):
        """
        Set this button to display as a selected layer.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getTransparent(self, **kwargs):
        """
        Indicate whether the layer color is visible or transparent.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def hideOnPlaybackCommand(self, val='True', **kwargs):
        """
        Command that is called when the hide on playback indicator of the layer button is pressed.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def renameCommand(self, val='True', **kwargs):
        """
        Set the command to call when the layer gets renamed. The string '#1' will be substituted with the control's name and '#2' will be replaced with the layer's new name.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setIdentification(self, val='True', **kwargs):
        """
        This is the integer identification number associated with the layer.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        Label text for the button.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setLayerHideOnPlayback(self, val='True', **kwargs):
        """
        Indicates whether the layer is visible or invisible during the playback.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setLayerState(self, val='True', **kwargs):
        """
        Describes the state of the layer.  This may be one of normal, template, or reference.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setLayerVisible(self, val='True', **kwargs):
        """
        Indicates whether the layer is visible or invisible.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setSelect(self, val='True', **kwargs):
        """
        Set this button to display as a selected layer.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setTransparent(self, val='True', **kwargs):
        """
        Indicate whether the layer color is visible or transparent.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def typeCommand(self, val='True', **kwargs):
        """
        Command that is called when the type indicator of the layer button is pressed.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def visibleCommand(self, val='True', **kwargs):
        """
        Command that is called when the visibility indicator of the layer button is pressed.                  
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Creates a layer bar button widget.  This widget contains both the name of the layer to which it refers and a color
        swatch indicating it's color assignment.  It is used primarily in the construction of the layerBar and layer Editor
        window, being the widget used for each layer in the respective lists.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand : cc             (callable)      []
        
          - color : cl                     (float, float, float) [create,edit]
              Layer color, specified with normalized real numbers in R, G, B space.
        
          - command : c                    (script)        [create,edit]
              Set the command to call on a single click.
        
          - current : cr                   (bool)          [create,edit]
              Set this button to display as the current layer.  The current layer is the one which the user has the option of adding
              all newly created objects into.  NB: Setting the layer button to this state has no effect on the actual current layer.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - doubleClickCommand : dcc       (script)        [create,edit]
              Set the command to call on a double click.
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - hideOnPlaybackCommand : hpc    (script)        [create,edit]
              Command that is called when the hide on playback indicator of the layer button is pressed.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - identification : id            (int)           [create,query,edit]
              This is the integer identification number associated with the layer.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - label : l                      (unicode)       [create,query,edit]
              Label text for the button.
        
          - labelWidth : lw                (bool)          [query]
              Query the width of the label part so as to determine if button clicks are in the label part or the colour swatch part.
        
          - layerHideOnPlayback : hp       (bool)          [create,query,edit]
              Indicates whether the layer is visible or invisible during the playback.
        
          - layerState : ls                (unicode)       [create,query,edit]
              Describes the state of the layer.  This may be one of normal, template, or reference.
        
          - layerVisible : lv              (bool)          [create,query,edit]
              Indicates whether the layer is visible or invisible.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - name : n                       (unicode)       [create,query]
              Name of the layer.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - renameCommand : rc             (unicode)       [create,edit]
              Set the command to call when the layer gets renamed. The string '#1' will be substituted with the control's name and
              '#2' will be replaced with the layer's new name.
        
          - select : s                     (bool)          [create,query,edit]
              Set this button to display as a selected layer.
        
          - transparent : t                (bool)          [create,query,edit]
              Indicate whether the layer color is visible or transparent.
        
          - typeCommand : tc               (script)        [create,edit]
              Command that is called when the type indicator of the layer button is pressed.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - visibleCommand : vc            (script)        [create,edit]
              Command that is called when the visibility indicator of the layer button is pressed.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.layerButton`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'layerButton'
    
    
    __melui__ = 'layerButton'
    
    
    __readonly__ = {}


class SymbolButton(PyUI):
    """
    class counterpart of mel function `symbolButton`
    
    This command creates a symbol button.  A symbol button behaves like a regular button, the only difference is a symbol button displays an image rather that a text label.  A command may be attached to the button which will be executed when the button is pressed.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getCommand(self, **kwargs):
        """
        Command executed when the symbol button is pressed.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getImage(self, **kwargs):
        """
        Image for the button.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setCommand(self, val='True', **kwargs):
        """
        Command executed when the symbol button is pressed.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setImage(self, val='True', **kwargs):
        """
        Image for the button.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a symbol button.  A symbol button behaves like a regular button, the only difference is a symbol
        button displays an image rather that a text label.  A command may be attached to the button which will be executed when
        the button is pressed.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - command : c                    (script)        [create,query,edit]
              Command executed when the symbol button is pressed.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - image : i                      (unicode)       [create,query,edit]
              Image for the button.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.symbolButton`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'symbolButton'
    
    
    __melui__ = 'symbolButton'
    
    
    __readonly__ = {}


class ScriptedPanelType(PyUI):
    """
    class counterpart of mel function `scriptedPanelType`
    
    This command defines the callbacks for a type of scripted panel.  The panel type created by this command is then used when creating a scripted panel.  See also the 'scriptedPanel' command.
    """
    
    
    
    def getAddCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for adding the panel to a particular control layout.  The parent layout is guaranteed to be the current default layout when the proc is called.  If its name is required then it can be queried with 'setParent -q'.  Any editors should be parented here. global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getCopyStateCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for copying the state of the panel when a tear-off copy of the panel is made.  The callback proc has the form: global proc procName (string $panelName, string $newPanelName) { .... } This procedure will be executed immediately after the addCallback procedure has finished executing. At that point, the copied panel will be fully created and accessible to facilitate copying of panel settings. Note: the addCallback procedure is called after the createCallback procedure has been called.                   
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getCreateCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for initially creating the panel object.  No UI should be created here.  Any editors owned by the panel should be created here unparented. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getCustomView(self, **kwargs):
        """
        This flag specifies if this view is a custom 3d view for MPx3dModelView types. This flag should only be used for MPx3dModelView types.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getDeleteCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for final deletion of the panel.  The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getInitCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for the initialize callback.  This will be called on file -new and file -open to give the panel an opportunity to re-initialize to a starting state, if required. The panel may be parented or unparented at this time. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        Label for the panel                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getObsolete(self, **kwargs):
        """
        This flag specifies that this type is no longer used in Maya.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getRemoveCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for removing the panel from its current control layout.  Any editors should be unparented here. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getRetainOnFileOpen(self, **kwargs):
        """
        This flag specifies if panels of this type should be retained after restoring panel cofiguration during file open. Default value is false.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getSaveStateCallback(self, **kwargs):
        """
        This flag specifies the callback procedure for saving the state of the panel.  The callback proc has the form: global proc string procName (string $panelName) { .... } Note that the proc returns a string.  This string will be executed after the createCallback has been called to facilitate restoring the panel state.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def getUnique(self, **kwargs):
        """
        This flag specifies if only one instance of this type of panel can exist at a given time.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setAddCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for adding the panel to a particular control layout.  The parent layout is guaranteed to be the current default layout when the proc is called.  If its name is required then it can be queried with 'setParent -q'.  Any editors should be parented here. global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setCopyStateCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for copying the state of the panel when a tear-off copy of the panel is made.  The callback proc has the form: global proc procName (string $panelName, string $newPanelName) { .... } This procedure will be executed immediately after the addCallback procedure has finished executing. At that point, the copied panel will be fully created and accessible to facilitate copying of panel settings. Note: the addCallback procedure is called after the createCallback procedure has been called.                   
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setCreateCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for initially creating the panel object.  No UI should be created here.  Any editors owned by the panel should be created here unparented. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setCustomView(self, val='True', **kwargs):
        """
        This flag specifies if this view is a custom 3d view for MPx3dModelView types. This flag should only be used for MPx3dModelView types.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setDeleteCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for final deletion of the panel.  The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setInitCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for the initialize callback.  This will be called on file -new and file -open to give the panel an opportunity to re-initialize to a starting state, if required. The panel may be parented or unparented at this time. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        Label for the panel                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setObsolete(self, val='True', **kwargs):
        """
        This flag specifies that this type is no longer used in Maya.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setRemoveCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for removing the panel from its current control layout.  Any editors should be unparented here. The callback proc has the form: global proc procName (string $panelName) { .... }                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setRetainOnFileOpen(self, val='True', **kwargs):
        """
        This flag specifies if panels of this type should be retained after restoring panel cofiguration during file open. Default value is false.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setSaveStateCallback(self, val='True', **kwargs):
        """
        This flag specifies the callback procedure for saving the state of the panel.  The callback proc has the form: global proc string procName (string $panelName) { .... } Note that the proc returns a string.  This string will be executed after the createCallback has been called to facilitate restoring the panel state.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def setUnique(self, val='True', **kwargs):
        """
        This flag specifies if only one instance of this type of panel can exist at a given time.                  
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command defines the callbacks for a type of scripted panel.  The panel type created by this command is then used
        when creating a scripted panel.  See also the 'scriptedPanel' command.
        
        Flags:
          - addCallback : acb              (unicode)       [create,query,edit]
              This flag specifies the callback procedure for adding the panel to a particular control layout.  The parent layout is
              guaranteed to be the current default layout when the proc is called.  If its name is required then it can be queried
              with 'setParent -q'.  Any editors should be parented here. global proc procName (string $panelName) { .... }
        
          - copyStateCallback : ocb        (unicode)       [create,query,edit]
              This flag specifies the callback procedure for copying the state of the panel when a tear-off copy of the panel is made.
              The callback proc has the form: global proc procName (string $panelName, string $newPanelName) { .... } This procedure
              will be executed immediately after the addCallback procedure has finished executing. At that point, the copied panel
              will be fully created and accessible to facilitate copying of panel settings. Note: the addCallback procedure is called
              after the createCallback procedure has been called.
        
          - createCallback : ccb           (unicode)       [create,query,edit]
              This flag specifies the callback procedure for initially creating the panel object.  No UI should be created here.  Any
              editors owned by the panel should be created here unparented. The callback proc has the form: global proc procName
              (string $panelName) { .... }
        
          - customView : cv                (bool)          [create,query,edit]
              This flag specifies if this view is a custom 3d view for MPx3dModelView types. This flag should only be used for
              MPx3dModelView types.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - deleteCallback : dcb           (unicode)       [create,query,edit]
              This flag specifies the callback procedure for final deletion of the panel.  The callback proc has the form: global proc
              procName (string $panelName) { .... }
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - initCallback : icb             (unicode)       [create,query,edit]
              This flag specifies the callback procedure for the initialize callback.  This will be called on file -new and file -open
              to give the panel an opportunity to re-initialize to a starting state, if required. The panel may be parented or
              unparented at this time. The callback proc has the form: global proc procName (string $panelName) { .... }
        
          - label : l                      (unicode)       [create,query,edit]
              Label for the panel
        
          - obsolete : o                   (bool)          [create,query,edit]
              This flag specifies that this type is no longer used in Maya.
        
          - removeCallback : rcb           (unicode)       [create,query,edit]
              This flag specifies the callback procedure for removing the panel from its current control layout.  Any editors should
              be unparented here. The callback proc has the form: global proc procName (string $panelName) { .... }
        
          - retainOnFileOpen : rfo         (bool)          [create,query,edit]
              This flag specifies if panels of this type should be retained after restoring panel cofiguration during file open.
              Default value is false.
        
          - saveStateCallback : scb        (unicode)       [create,query,edit]
              This flag specifies the callback procedure for saving the state of the panel.  The callback proc has the form: global
              proc string procName (string $panelName) { .... } Note that the proc returns a string.  This string will be executed
              after the createCallback has been called to facilitate restoring the panel state.
        
          - unique : u                     (bool)          [create,query,edit]
              This flag specifies if only one instance of this type of panel can exist at a given time.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.scriptedPanelType`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'scriptedPanelType'
    
    
    __melui__ = 'scriptedPanelType'
    
    
    __readonly__ = {}


class AttributeMenu(PyUI):
    """
    class counterpart of mel function `attributeMenu`
    
    Action to generate popup connection menus for Hypershade. This command is used internally by the Hypershade panel.
    """
    
    
    
    def __melcmd__(*args, **kwargs):
        """
        Action to generate popup connection menus for Hypershade. This command is used internally by the Hypershade panel.
        
        Flags:
          - beginMenu : beg                (bool)          [create]
              If true the menu will be used to start a connection edit so it will list all available attributes for either inputs or
              outputs.  If false the menu will be used to complete a connection so it will list only the attributes compatible with
              the attribute at the other end of the connection.  A plug must be supplied in this case.
        
          - editor : edt                   (unicode)       [create]
              Name of the Hypergraph, Hypershade or Visor editor for which this menu is being built.  This argument is no longer
              mandatory. If it is omitted, the inputs flag and the node must be used to specify the search targets. This allows
              attributeMenu to be used in the absence of a hypershade editor.
        
          - finishMenu : fsh               (bool)          [create]
              finishes the menu
        
          - inputs : inp                   (bool)          [create]
              If true only attributes which can be used as inputs will be listed.  If false only attributes which can be used as
              outputs will be listed
        
          - plug : p                       (PyNode)        [create]
              If inputs is false then we are completing a connection and the name of the plug at the other end of the connection must
              be supplied.
        
          - regPulldownMenuCommand : rpm   (unicode)       [create]
              This flag will register a callback that allows the user to define their own popup menu for a specific node type for use
              in the Hypershade and Hypergraph editor. The command signature should look like this: global proc int proc_name(string
              $editorName, string $nodeName, string $plug, string $mode, string $menuType) The method should return 0 if it does not
              recognize the node type and the default attributeMenu popup menu will be displayed. If the callback returns one then the
              menu is considered built and no other menuItems will be added to the popup. The return value from this flag will be the
              ID to use for the -unregPulldownMenuCommand flag.
        
          - unregPulldownMenuCommand : upm (int)           [create]
              This flag will unregister a callback procedure that was registered with the -regPulldownMenuCommand flag. The argument
              should be the integer identifier returned from the -regPulldownMenuCommand flag.                                    Flag
              can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.attributeMenu`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'attributeMenu'
    
    
    __melui__ = 'attributeMenu'
    
    
    __readonly__ = {}


class HelpLine(PyUI):
    """
    class counterpart of mel function `helpLine`
    
    This command creates a help line where tool help/hints are shown.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a help line where tool help/hints are shown.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.helpLine`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'helpLine'
    
    
    __melui__ = 'helpLine'
    
    
    __readonly__ = {}


class DynPaintEditor(PyUI):
    """
    class counterpart of mel function `dynPaintEditor`
    
    Create a editor window that can be painted into
    """
    
    
    
    def canvasUndo(self, val='True', **kwargs):
        """
        Does a fast undo in Canvas mode. This is a special undo because we are not using any history when we paint in Canvas mode so we provide a single level undo for the Canvas.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def clear(self, val='True', **kwargs):
        """
        Clears the buffer (if in Canvas mode) to the floating point values (R,G,B).                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getActiveOnly(self, **kwargs):
        """
        For Scene mode, this determines if only the active strokes will be refreshed.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getAutoSave(self, **kwargs):
        """
        For Canvas mode, this determines if the buffer will be saved to a disk file after every stroke. Good for painting textures and viewing the results in shaded display in the model view.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getCamera(self, **kwargs):
        """
        Sets the name of the camera which the Paint Effects panel looks through.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getCanvasMode(self, **kwargs):
        """
        Sets the Paint Effects panel into Canvas mode if true.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getChangeCommand(self, **kwargs):
        """
        Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the command when something changes in the editor The command should have this prototype :  command(string $editor, string $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2: buffer (single/double)3: axis 4: image displayed5: image saved in memory
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getCurrentCanvasSize(self, **kwargs):
        """
        In Query mode, this returns the (X,Y) resolution of the current canvas.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayAppearance(self, **kwargs):
        """
        Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded, flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and boundingBoxare valid for the interactive mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayFog(self, **kwargs):
        """
        For Scene mode, this determines if fog will be displayed in the Paint Effects panel when refreshing the scene. If fog is on, but this is off, fog will only be drawn on the strokes, not the rest of the scene.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayImage(self, **kwargs):
        """
        Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack using the si/saveImageflag.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayLights(self, **kwargs):
        """
        Sets the lighting for shaded mode.  Possible values are selected, active, all, default.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayStyle(self, **kwargs):
        """
        Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask channellumto display the luminance of the image
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDisplayTextures(self, **kwargs):
        """
        Turns on or off display of textures in shaded mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDoubleBuffer(self, **kwargs):
        """
        Set the display in double buffer mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDrawAxis(self, **kwargs):
        """
        Set or query whether the axis will be drawn.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getDrawContext(self, **kwargs):
        """
        Returns the name of the context.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getFileName(self, **kwargs):
        """
        This sets the file to which the canvas will be saved.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getNbImages(self, **kwargs):
        """
        returns the number of images                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getNewImage(self, **kwargs):
        """
        Starts a new image in edit mode, setting the resolution to the integer values (X,Y) and clearing the buffer to the floating point values (R,G,B). In Query mode, this returns the (X,Y) resolution of the current Image.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getRefreshMode(self, **kwargs):
        """
        Sets the refresh mode to the specified value. 0 - Do not draw strokes on refresh, 1 - Redraw strokes in wireframe mode, 2 - Redraw strokes in final rendered mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getSaveAlpha(self, **kwargs):
        """
        For Canvas mode, this determines if the alpha will be saved when storing the canvas to a disk file.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getSaveBumpmap(self, **kwargs):
        """
        Saves the current buffer as a bump map to the specified file.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getScaleBlue(self, **kwargs):
        """
        Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getScaleGreen(self, **kwargs):
        """
        Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getScaleRed(self, **kwargs):
        """
        Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getSingleBuffer(self, **kwargs):
        """
        Set the display in single buffer mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getWrap(self, **kwargs):
        """
        For Canvas mode, should the buffer wrap in U, and V (respectively) when painting.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def getZoom(self, **kwargs):
        """
        Zooms the Canvas image by the specified value.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def iconGrab(self, val='True', **kwargs):
        """
        This puts the Paint Effects panel into Grab Icon mode where the user is expected to drag out a section of the screen to be made into an icon.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def loadImage(self, val='True', **kwargs):
        """
        load an image from disk and set it as the current Editor Image                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def paintAll(self, val='True', **kwargs):
        """
        Redraws the buffer in current refresh mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def redrawLast(self, val='True', **kwargs):
        """
        Redraws the last stroke again. Useful when it's brush has just changed. This feature does a fast undo and redraws the stroke again.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def refresh(self, val='True', **kwargs):
        """
        requests a refresh of the current Editor Image.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def removeAllImages(self, val='True', **kwargs):
        """
        remove all the Editor Images from the Editor Image Stack                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def removeImage(self, val='True', **kwargs):
        """
        remove the current Editor Image from the Editor Image Stack                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def rollImage(self, val='True', **kwargs):
        """
        In Canvas mode, this rolls the image by the floating point values (X,Y). X and Y are between 0 (no roll) and 1 (full roll). A value of .5 rolls the image 50% (ie. the border moves to the center of the screen.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def saveImage(self, val='True', **kwargs):
        """
        save the current Editor Image to memory. Saved Editor Images are stored in an Editor Image Stack. The most recently saved image is stored in position 0, the second most recently saved image in position 1, and so on... To set the current Editor Image to a previously saved image use the di/displayImageflag.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setActiveOnly(self, val='True', **kwargs):
        """
        For Scene mode, this determines if only the active strokes will be refreshed.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setAutoSave(self, val='True', **kwargs):
        """
        For Canvas mode, this determines if the buffer will be saved to a disk file after every stroke. Good for painting textures and viewing the results in shaded display in the model view.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setCamera(self, val='True', **kwargs):
        """
        Sets the name of the camera which the Paint Effects panel looks through.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setCanvasMode(self, val='True', **kwargs):
        """
        Sets the Paint Effects panel into Canvas mode if true.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setChangeCommand(self, val='True', **kwargs):
        """
        Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the command when something changes in the editor The command should have this prototype :  command(string $editor, string $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2: buffer (single/double)3: axis 4: image displayed5: image saved in memory
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayAppearance(self, val='True', **kwargs):
        """
        Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded, flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and boundingBoxare valid for the interactive mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayFog(self, val='True', **kwargs):
        """
        For Scene mode, this determines if fog will be displayed in the Paint Effects panel when refreshing the scene. If fog is on, but this is off, fog will only be drawn on the strokes, not the rest of the scene.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayImage(self, val='True', **kwargs):
        """
        Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack using the si/saveImageflag.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayLights(self, val='True', **kwargs):
        """
        Sets the lighting for shaded mode.  Possible values are selected, active, all, default.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayStyle(self, val='True', **kwargs):
        """
        Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask channellumto display the luminance of the image
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDisplayTextures(self, val='True', **kwargs):
        """
        Turns on or off display of textures in shaded mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDoubleBuffer(self, val='True', **kwargs):
        """
        Set the display in double buffer mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setDrawAxis(self, val='True', **kwargs):
        """
        Set or query whether the axis will be drawn.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setFileName(self, val='True', **kwargs):
        """
        This sets the file to which the canvas will be saved.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setNewImage(self, val='True', **kwargs):
        """
        Starts a new image in edit mode, setting the resolution to the integer values (X,Y) and clearing the buffer to the floating point values (R,G,B). In Query mode, this returns the (X,Y) resolution of the current Image.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setRefreshMode(self, val='True', **kwargs):
        """
        Sets the refresh mode to the specified value. 0 - Do not draw strokes on refresh, 1 - Redraw strokes in wireframe mode, 2 - Redraw strokes in final rendered mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setSaveAlpha(self, val='True', **kwargs):
        """
        For Canvas mode, this determines if the alpha will be saved when storing the canvas to a disk file.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setSaveBumpmap(self, val='True', **kwargs):
        """
        Saves the current buffer as a bump map to the specified file.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setScaleBlue(self, val='True', **kwargs):
        """
        Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setScaleGreen(self, val='True', **kwargs):
        """
        Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setScaleRed(self, val='True', **kwargs):
        """
        Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setSingleBuffer(self, val='True', **kwargs):
        """
        Set the display in single buffer mode                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setWrap(self, val='True', **kwargs):
        """
        For Canvas mode, should the buffer wrap in U, and V (respectively) when painting.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def setZoom(self, val='True', **kwargs):
        """
        Zooms the Canvas image by the specified value.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def snapShot(self, val='True', **kwargs):
        """
        Takes a snapshot of the current camera view.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def tileSize(self, val='True', **kwargs):
        """
        Sets the size of the tile for the hardware texture redraw of the display buffer.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def undoCache(self, val='True', **kwargs):
        """
        By default the last image is cached for undo. If this is set false, then undoing will be disabled in canvas mode and undo in scene mode will force a full refresh. Less memory will be used if this is set false before the first clear or refresh of the current scene.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def writeImage(self, val='True', **kwargs):
        """
        write the current Editor Image to disk                  
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a editor window that can be painted into
        
        Flags:
          - activeOnly : ao                (bool)          [query,edit]
              For Scene mode, this determines if only the active strokes will be refreshed.
        
          - autoSave : autoSave            (bool)          [query,edit]
              For Canvas mode, this determines if the buffer will be saved to a disk file after every stroke. Good for painting
              textures and viewing the results in shaded display in the model view.
        
          - camera : cam                   (unicode)       [query,edit]
              Sets the name of the camera which the Paint Effects panel looks through.
        
          - canvasMode : cm                (bool)          [query,edit]
              Sets the Paint Effects panel into Canvas mode if true.
        
          - canvasUndo : cu                (bool)          [edit]
              Does a fast undo in Canvas mode. This is a special undo because we are not using any history when we paint in Canvas
              mode so we provide a single level undo for the Canvas.
        
          - changeCommand : cc             (unicode, unicode, unicode, unicode) [create,query,edit]
              Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the
              command when something changes in the editor The command should have this prototype :  command(string $editor, string
              $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2:
              buffer (single/double)3: axis 4: image displayed5: image saved in memory
        
          - clear : cl                     (float, float, float) [edit]
              Clears the buffer (if in Canvas mode) to the floating point values (R,G,B).
        
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - currentCanvasSize : ccs        (bool)          [query]
              In Query mode, this returns the (X,Y) resolution of the current canvas.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - displayAppearance : dsa        (unicode)       [query,edit]
              Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded,
              flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and
              boundingBoxare valid for the interactive mode.
        
          - displayFog : dfg               (bool)          [query,edit]
              For Scene mode, this determines if fog will be displayed in the Paint Effects panel when refreshing the scene. If fog is
              on, but this is off, fog will only be drawn on the strokes, not the rest of the scene.
        
          - displayImage : di              (int)           [query,edit]
              Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack
              using the si/saveImageflag.
        
          - displayLights : dsl            (unicode)       [query,edit]
              Sets the lighting for shaded mode.  Possible values are selected, active, all, default.
        
          - displayStyle : dst             (unicode)       [create,query,edit]
              Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask
              channellumto display the luminance of the image
        
          - displayTextures : dtx          (bool)          [query,edit]
              Turns on or off display of textures in shaded mode
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - doubleBuffer : dbf             (bool)          [create,query,edit]
              Set the display in double buffer mode
        
          - drawAxis : da                  (bool)          [create,query,edit]
              Set or query whether the axis will be drawn.
        
          - drawContext : drc              (bool)          [query]
              Returns the name of the context.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fastUpdate : fu                (int)           []
        
          - fileName : fil                 (unicode)       [query,edit]
              This sets the file to which the canvas will be saved.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - iconGrab : ig                  (bool)          [edit]
              This puts the Paint Effects panel into Grab Icon mode where the user is expected to drag out a section of the screen to
              be made into an icon.
        
          - loadImage : li                 (unicode)       [edit]
              load an image from disk and set it as the current Editor Image
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - menu : mn                      (unicode)       [create]
              Sets the name of the script used to build a menu in the editor. The script takes the editor name as an argument.
        
          - nbImages : nim                 (bool)          [query]
              returns the number of images
        
          - newImage : ni                  (int, int, float, float, float) [query,edit]
              Starts a new image in edit mode, setting the resolution to the integer values (X,Y) and clearing the buffer to the
              floating point values (R,G,B). In Query mode, this returns the (X,Y) resolution of the current Image.
        
          - paintAll : pa                  (float)         [edit]
              Redraws the buffer in current refresh mode.
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - redrawLast : rl                (bool)          [edit]
              Redraws the last stroke again. Useful when it's brush has just changed. This feature does a fast undo and redraws the
              stroke again.
        
          - refresh : ref                  (bool)          [edit]
              requests a refresh of the current Editor Image.
        
          - refreshMode : rmd              (int)           [query,edit]
              Sets the refresh mode to the specified value. 0 - Do not draw strokes on refresh, 1 - Redraw strokes in wireframe mode,
              2 - Redraw strokes in final rendered mode.
        
          - removeAllImages : ra           (bool)          [edit]
              remove all the Editor Images from the Editor Image Stack
        
          - removeImage : ri               (bool)          [edit]
              remove the current Editor Image from the Editor Image Stack
        
          - rollImage : rig                (float, float)  [edit]
              In Canvas mode, this rolls the image by the floating point values (X,Y). X and Y are between 0 (no roll) and 1 (full
              roll). A value of .5 rolls the image 50% (ie. the border moves to the center of the screen.
        
          - saveAlpha : sa                 (bool)          [query,edit]
              For Canvas mode, this determines if the alpha will be saved when storing the canvas to a disk file.
        
          - saveBumpmap : sbm              (unicode)       [query,edit]
              Saves the current buffer as a bump map to the specified file.
        
          - saveImage : si                 (bool)          [edit]
              save the current Editor Image to memory. Saved Editor Images are stored in an Editor Image Stack. The most recently
              saved image is stored in position 0, the second most recently saved image in position 1, and so on... To set the current
              Editor Image to a previously saved image use the di/displayImageflag.
        
          - scaleBlue : sb                 (float)         [create,query,edit]
              Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000
        
          - scaleGreen : sg                (float)         [create,query,edit]
              Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000
        
          - scaleRed : sr                  (float)         [create,query,edit]
              Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - singleBuffer : sbf             (bool)          [create,query,edit]
              Set the display in single buffer mode
        
          - snapShot : snp                 (bool)          [edit]
              Takes a snapshot of the current camera view.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - swap : swp                     (int)           []
        
          - tileSize : ts                  (int)           [edit]
              Sets the size of the tile for the hardware texture redraw of the display buffer.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - undoCache : uc                 (bool)          [edit]
              By default the last image is cached for undo. If this is set false, then undoing will be disabled in canvas mode and
              undo in scene mode will force a full refresh. Less memory will be used if this is set false before the first clear or
              refresh of the current scene.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - wrap : wr                      (bool, bool)    [query,edit]
              For Canvas mode, should the buffer wrap in U, and V (respectively) when painting.
        
          - writeImage : wi                (unicode)       [edit]
              write the current Editor Image to disk
        
          - zoom : zm                      (float)         [query,edit]
              Zooms the Canvas image by the specified value.                  Flag can have multiple arguments, passed either as a
              tuple or a list.
        
        
        Derived from mel command `maya.cmds.dynPaintEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'dynPaintEditor'
    
    
    __melui__ = 'dynPaintEditor'
    
    
    __readonly__ = {}


class IconTextRadioCollection(PyUI):
    """
    class counterpart of mel function `iconTextRadioCollection`
    
    This command creates a cluster for iconTextRadioButtons.  Clusters will be parented to the current default layout if no parent is specified with the -p/parent flag. As children of the layout they will be deleted when the layout is deleted. Clusters may also span more than one window if the -g/global flag is used. In this case the cluster has no parent so must be explicitly deleted with the 'deleteUI' command.
    """
    
    
    
    def disableCommands(self, val='True', **kwargs):
        """
        Allows a particular iconTextRadioButton in the collection to be selected without invoking the commands attached to the -cc/changeCommand, -onc/onCommand, or -ofc/offCommand flags. This flag is only meaningful when used in conjuction with the -edit and -select flags.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def getCollectionItemArray(self, **kwargs):
        """
        Returns a string list giving the long names of all the items in this collection.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def getGl(self, **kwargs):
        """
        Set the collection to have no parent layout.  If the collection has a parent layout then it will be deleted with that layout, otherwise if it is specified to be global it must be explicitly deleted.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def getNumberOfCollectionItems(self, **kwargs):
        """
        Returns the number of items that are in this collection.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def getSelect(self, **kwargs):
        """
        Select the specified collection item.  If queried will return the name of the currently selected collection item.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def setSelect(self, val='True', **kwargs):
        """
        Select the specified collection item.  If queried will return the name of the currently selected collection item.                  
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a cluster for iconTextRadioButtons.  Clusters will be parented to the current default layout if no
        parent is specified with the -p/parent flag. As children of the layout they will be deleted when the layout is deleted.
        Clusters may also span more than one window if the -g/global flag is used. In this case the cluster has no parent so
        must be explicitly deleted with the 'deleteUI' command.
        
        Flags:
          - collectionItemArray : cia      (bool)          [query]
              Returns a string list giving the long names of all the items in this collection.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - disableCommands : dcm          (bool)          [edit]
              Allows a particular iconTextRadioButton in the collection to be selected without invoking the commands attached to the
              -cc/changeCommand, -onc/onCommand, or -ofc/offCommand flags. This flag is only meaningful when used in conjuction with
              the -edit and -select flags.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - gl : gl                        (bool)          [create,query]
              Set the collection to have no parent layout.  If the collection has a parent layout then it will be deleted with that
              layout, otherwise if it is specified to be global it must be explicitly deleted.
        
          - numberOfCollectionItems : nci  (bool)          [query]
              Returns the number of items that are in this collection.
        
          - parent : p                     (unicode)       [create]
              Set the specified layout to be the parent layout of the cluster.
        
          - select : sl                    (unicode)       [create,query,edit]
              Select the specified collection item.  If queried will return the name of the currently selected collection item.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.iconTextRadioCollection`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'iconTextRadioCollection'
    
    
    __melui__ = 'iconTextRadioCollection'
    
    
    __readonly__ = {}


class ClipEditor(PyUI):
    """
    class counterpart of mel function `clipEditor`
    
    Create a clip editor with the given name.
    """
    
    
    
    def clipDropCmd(self, val='True', **kwargs):
        """
        Command executed when clip node is dropped on the TraX editor                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def deleteCmd(self, val='True', **kwargs):
        """
        Command executed when backspacekey is pressed                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def deselectAll(self, val='True', **kwargs):
        """
        Deselect all clips and blends in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayActiveKeyTangents(self, val='True', **kwargs):
        """
        on | off | tgl Display active key tangents in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayActiveKeys(self, val='True', **kwargs):
        """
        on | off | tgl Display active keys in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayInfinities(self, val='True', **kwargs):
        """
        on | off | tgl Display infinities in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayKeys(self, val='True', **kwargs):
        """
        on | off | tgl Display keyframes in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayTangents(self, val='True', **kwargs):
        """
        on | off | tgl Display tangents in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def displayValues(self, val='True', **kwargs):
        """
        on | off | tgl Display active keys and tangents values in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def frameAll(self, val='True', **kwargs):
        """
        Frame view around all clips in the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getAutoFit(self, **kwargs):
        """
        on | off | tgl Auto fit-to-view.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getClipStyle(self, **kwargs):
        """
        Set/return the clip track style in the specified editor. Default is 2. Valid values are 1-3.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getFrameRange(self, **kwargs):
        """
        The editor's current frame range.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getHighlightedBlend(self, **kwargs):
        """
        Returns the highlighted blend, listed as scheduler and index                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getHighlightedClip(self, **kwargs):
        """
        Returns the highlighted clip, listed as scheduler and index                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getInitialized(self, **kwargs):
        """
        Returns whether the clip editor is fully initialized, and has a port to draw through. If not, the -frameRange and -frameAll flags will fail.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getManageSequencer(self, **kwargs):
        """
        Sets/returns whether the clip editor should manage sequencer nodes.  If so, animation clips and characters are not represented.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getMenuContext(self, **kwargs):
        """
        Returns a string array denoting the type of data object the cursor is over.  Returned values are: timeSlider nothing track, track index, character node name, group name clip, clip node name                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getSelectBlend(self, **kwargs):
        """
        Select the blends specified by the scheduler name and the indicies of the two clips used in the blend. When queried, a string containing the scheduler name and the two clip indicies for all of the selected blends is returned.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getSelectClip(self, **kwargs):
        """
        Selects the clip specified by the scheduler name and the clip index. When queried, a string containing the scheduler and clip index of all of the selected clips is returned.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getSnapTime(self, **kwargs):
        """
        none | integer | keyframe Keyframe move snap in time.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getSnapValue(self, **kwargs):
        """
        none | integer | keyframe Keyframe move snap in values.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def listAllCharacters(self, val='True', **kwargs):
        """
        List all characters in the editor and outliner.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def listCurrentCharacters(self, val='True', **kwargs):
        """
        List only the characters in the editor and outliner.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def lookAt(self, val='True', **kwargs):
        """
        all | selected | currentTime FitView helpers.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setAutoFit(self, val='True', **kwargs):
        """
        on | off | tgl Auto fit-to-view.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setClipStyle(self, val='True', **kwargs):
        """
        Set/return the clip track style in the specified editor. Default is 2. Valid values are 1-3.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setFrameRange(self, val='True', **kwargs):
        """
        The editor's current frame range.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setManageSequencer(self, val='True', **kwargs):
        """
        Sets/returns whether the clip editor should manage sequencer nodes.  If so, animation clips and characters are not represented.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setSelectBlend(self, val='True', **kwargs):
        """
        Select the blends specified by the scheduler name and the indicies of the two clips used in the blend. When queried, a string containing the scheduler name and the two clip indicies for all of the selected blends is returned.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setSelectClip(self, val='True', **kwargs):
        """
        Selects the clip specified by the scheduler name and the clip index. When queried, a string containing the scheduler and clip index of all of the selected clips is returned.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setSnapTime(self, val='True', **kwargs):
        """
        none | integer | keyframe Keyframe move snap in time.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def setSnapValue(self, val='True', **kwargs):
        """
        none | integer | keyframe Keyframe move snap in values.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a clip editor with the given name.
        
        Flags:
          - allTrackHeights : th           (int)           []
              OBSOLETE flag. Use clipStyle instead.
        
          - autoFit : af                   (unicode)       [query,edit]
              on | off | tgl Auto fit-to-view.
        
          - characterOutline : co          (unicode)       []
        
          - clipDropCmd : cd               (unicode)       [edit]
              Command executed when clip node is dropped on the TraX editor
        
          - clipStyle : cs                 (int)           [query,edit]
              Set/return the clip track style in the specified editor. Default is 2. Valid values are 1-3.
        
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - deleteCmd : dc                 (unicode)       [edit]
              Command executed when backspacekey is pressed
        
          - deselectAll : da               (bool)          [edit]
              Deselect all clips and blends in the editor.
        
          - displayActiveKeyTangents : dat (unicode)       [edit]
              on | off | tgl Display active key tangents in the editor.
        
          - displayActiveKeys : dak        (unicode)       [edit]
              on | off | tgl Display active keys in the editor.
        
          - displayInfinities : di         (unicode)       [edit]
              on | off | tgl Display infinities in the editor.
        
          - displayKeys : dk               (unicode)       [edit]
              on | off | tgl Display keyframes in the editor.
        
          - displayTangents : dtn          (unicode)       [edit]
              on | off | tgl Display tangents in the editor.
        
          - displayValues : dv             (unicode)       [edit]
              on | off | tgl Display active keys and tangents values in the editor.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - frameAll : fa                  (bool)          [edit]
              Frame view around all clips in the editor.
        
          - frameRange : fr                (float, float)  [query,edit]
              The editor's current frame range.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - highlightedBlend : hb          (unicode, unicode) [query]
              Returns the highlighted blend, listed as scheduler and index
        
          - highlightedClip : hc           (unicode, unicode) [query]
              Returns the highlighted clip, listed as scheduler and index
        
          - initialized : it               (bool)          [query]
              Returns whether the clip editor is fully initialized, and has a port to draw through. If not, the -frameRange and
              -frameAll flags will fail.
        
          - listAllCharacters : lac        (bool)          [edit]
              List all characters in the editor and outliner.
        
          - listCurrentCharacters : lc     (bool)          [edit]
              List only the characters in the editor and outliner.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - lookAt : la                    (unicode)       [edit]
              all | selected | currentTime FitView helpers.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - manageSequencer : ms           (bool)          [create,query,edit]
              Sets/returns whether the clip editor should manage sequencer nodes.  If so, animation clips and characters are not
              represented.
        
          - menuContext : mc               (unicode)       [query]
              Returns a string array denoting the type of data object the cursor is over.  Returned values are: timeSlider nothing
              track, track index, character node name, group name clip, clip node name
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - selectBlend : sb               (unicode, unicode, unicode) [query,edit]
              Select the blends specified by the scheduler name and the indicies of the two clips used in the blend. When queried, a
              string containing the scheduler name and the two clip indicies for all of the selected blends is returned.
        
          - selectClip : sc                (unicode, unicode) [query,edit]
              Selects the clip specified by the scheduler name and the clip index. When queried, a string containing the scheduler and
              clip index of all of the selected clips is returned.
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - snapTime : st                  (unicode)       [query,edit]
              none | integer | keyframe Keyframe move snap in time.
        
          - snapValue : sv                 (unicode)       [query,edit]
              none | integer | keyframe Keyframe move snap in values.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.clipEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'clipEditor'
    
    
    __melui__ = 'clipEditor'
    
    
    __readonly__ = {}


class RadioCollection(PyUI):
    """
    class counterpart of mel function `radioCollection`
    
    This command creates a radio button collection. Collections are parented to the current default layout if no parent is specified with the -p/parentflag.  As children of the layout they will be deleted when the layout is deleted. Collections may also span more than one window if the -gl/globalflag is used. In this case the collection has no parent and must be explicitly deleted with the deleteUIcommand when it is no longer wanted.
    """
    
    
    
    def getCollectionItemArray(self, **kwargs):
        """
        Return a string list giving the long names of all the items in this collection.                  
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    def getGl(self, **kwargs):
        """
        Set the collection to have no parent layout.  Global collections must be explicitly deleted.                  
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    def getNumberOfCollectionItems(self, **kwargs):
        """
        Return the number of items in this collection.                  
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    def getSelect(self, **kwargs):
        """
        Select the specified collection item.  If queried will return the name of the currently selected collection item.                  
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    def setSelect(self, val='True', **kwargs):
        """
        Select the specified collection item.  If queried will return the name of the currently selected collection item.                  
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a radio button collection. Collections are parented to the current default layout if no parent is
        specified with the -p/parentflag.  As children of the layout they will be deleted when the layout is deleted.
        Collections may also span more than one window if the -gl/globalflag is used. In this case the collection has no parent
        and must be explicitly deleted with the deleteUIcommand when it is no longer wanted.
        
        Flags:
          - collectionItemArray : cia      (bool)          [query]
              Return a string list giving the long names of all the items in this collection.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - gl : gl                        (bool)          [create,query]
              Set the collection to have no parent layout.  Global collections must be explicitly deleted.
        
          - numberOfCollectionItems : nci  (bool)          [query]
              Return the number of items in this collection.
        
          - parent : p                     (unicode)       [create]
              The parent of the collection.  The collection will be deleted along with the parent.
        
          - select : sl                    (unicode)       [create,query,edit]
              Select the specified collection item.  If queried will return the name of the currently selected collection item.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.radioCollection`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'radioCollection'
    
    
    __melui__ = 'radioCollection'
    
    
    __readonly__ = {}


class TextCurves(PyUI):
    """
    class counterpart of mel function `textCurves`
    
    The textCurves command creates NURBS curves from a text string using the specified font. A single letter can be made up of more than one NURBS curve. The number of curves per letter varies with the font.
    """
    
    
    
    def __melcmd__(*args, **kwargs):
        """
        The textCurves command creates NURBS curves from a text string using the specified font. A single letter can be made up
        of more than one NURBS curve. The number of curves per letter varies with the font.
        
        Flags:
          - caching : cch                  (bool)          []
        
          - constructionHistory : ch       (bool)          []
        
          - deprecatedFontName : dfn       (bool)          []
        
          - font : f                       (unicode)       [create]
              The font to use.
        
          - frozen : fzn                   (bool)          []
        
          - name : n                       (unicode)       [create]
              Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified
              namespace; if the namespace does not exist, it will be created.
        
          - nodeState : nds                (int)           []
        
          - object : o                     (bool)          [create]
              Create the result, or just the dependency node.
        
          - text : t                       (unicode)       [create]
              The string to create the curves for.                  Flag can have multiple arguments, passed either as a tuple or a
              list.
        
        
        Derived from mel command `maya.cmds.textCurves`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'textCurves'
    
    
    __melui__ = 'textCurves'
    
    
    __readonly__ = {}


class OutlinerEditor(PyUI):
    """
    class counterpart of mel function `outlinerEditor`
    
    This command creates an outliner editor which can be used to display a list of objects.WARNING: some flag combinations may not behave as you expect.  The command is really intended for internal use for creating the outliner used by the various editors.
    """
    
    
    
    def allowMultiSelection(self, val='True', **kwargs):
        """
        If true then multiple selection will be allowed in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def alwaysToggleSelect(self, val='True', **kwargs):
        """
        If true, then clicking on an item in the outliner will select or deselect it without affecting the selection of other items (unless allowMultiSelection is false). If false, clicking on an item in the outliner will replace the current selection with the selected item.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def directSelect(self, val='True', **kwargs):
        """
        If true then clicking on an item in the outliner will add or remove just that item from the selection connection. If false then clicking on an item in the outliner causes the selection connection to be reloaded with the currently selected items in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def expandAllItems(self, val='True', **kwargs):
        """
        Expand or collapse all items in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def expandAllSelectedItems(self, val='True', **kwargs):
        """
        Expand or collapse all selected items in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def expandAttribute(self, val='True', **kwargs):
        """
        Force the outliner to fill the selection list with only attributes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAnimLayerFilterOptions(self, **kwargs):
        """
        Specifies whether a filter is to be applied when displaying animation layers. If so, the options can be allAffecting(no filter), active(only the active layers on the object will be displayed) and animLayerEditor(the settings will be taken from the animation layer editor).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAttrAlphaOrder(self, **kwargs):
        """
        Specify how attributes are to be sorted. Current recognised values are defaultfor no sorting and ascendto sort attributes from 'a' to ''z' and descendto sort from 'z' to 'a'. Notes: a) this only applies to top level attributes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAttrFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be placed on this editor. This filters the attributes displayed in the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAutoExpand(self, **kwargs):
        """
        This flag specifies whether or not objects that are loaded in should have their attributes automatically expanded.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAutoExpandLayers(self, **kwargs):
        """
        If true then when a node with animation layer is displayed, all the animation layers will show up in expanded form.                   
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getAutoSelectNewObjects(self, **kwargs):
        """
        This flag specifies whether or not new objects added to the outliner should be automatically selected.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getContainersIgnoreFilters(self, **kwargs):
        """
        This flag specifices whether or not filters should be ignored when displaying container contents.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getDisplayMode(self, **kwargs):
        """
        Affects how the outliner displays when a filter is applied. List mode is a non-indented flat list. DAG mode indents to represent the hierarchical structure of the model.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getDoNotSelectNewObjects(self, **kwargs):
        """
        If true this flag specifies that new objects added to the outliner will not be selected, even if they are active.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getDropIsParent(self, **kwargs):
        """
        This flag specifies the mode for drag and drop. If the flag is true, dropping items will do a reparent. If it is false, dropping will reorder items. By default, the flag is true (parent).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getEditAttrName(self, **kwargs):
        """
        This flag specifies whether or not attribute names can be edited. By default double-clicking on an attribute will open the expression editor for that attribute.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getExpandConnections(self, **kwargs):
        """
        This flag specifies whether or not attributes should be expanded to show their input connections. Note: currently the expansion will only show animCurves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getExpandObjects(self, **kwargs):
        """
        This flag specifies whether or not objects that are loaded in should be automatically expanded.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getFeedbackItemName(self, **kwargs):
        """
        Returns the outliner item name at the current mouse position, if any.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getFeedbackRowNumber(self, **kwargs):
        """
        Returns the outliner row number at the current mouse position, if any.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getGetCurrentSetOfItem(self, **kwargs):
        """
        Returns the current set of item at the given row. As an item can belong to number of sets, current set is the set to which the item belongs to currently.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getHighlightActive(self, **kwargs):
        """
        This flag specifies whether or not the outliner should highlight objects that are active. Note: if the outliner is driving the contents of another editor, setting highlightActive to true may produce unexpected behavior.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getHighlightSecondary(self, **kwargs):
        """
        This flag specifies whether or not the outliner should highlight objects that are contained in the highlightConnection.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIgnoreDagHierarchy(self, **kwargs):
        """
        This flag specifies whether or not DAG objects are displayed in their DAG hierarchy. Warning: using this flag without some other form of sensible filtering will lead to a very confusing outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIgnoreHiddenAttribute(self, **kwargs):
        """
        Sets whether or not the outliner ignores the 'hidden in outliner' flag on nodes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIgnoreOutlinerColor(self, **kwargs):
        """
        Sets whether or not the outliner ignores the 'use outliner color' flag on nodes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIsChildSelected(self, **kwargs):
        """
        This flag allows you to query if one or more of the children of the specified item is selected in the outliner. The item should be specified using a unique DAG path. Note that if the specified item appears multiple times in the outliner, the result will be true if one or more children of any occurrence of the specified item in the outliner is/are selected.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIsSet(self, **kwargs):
        """
        Returns true if the item present at the given row is a set.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getIsSetMember(self, **kwargs):
        """
        Returns true if the item present at the given row is a set member.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getLongNames(self, **kwargs):
        """
        Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the -niceNames flag is set.  Default is short names. Queried, returns a boolean.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getMapMotionTrails(self, **kwargs):
        """
        Sets whether or not we replace the motion trail in the outliner with the object it is trailing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getMasterOutliner(self, **kwargs):
        """
        This flag is the name of an outliner that this outliner will share the objects and state from. When an outliner is shared, all of its state information comes from, and is applied to, the master outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getNiceNames(self, **kwargs):
        """
        Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the longNames flag. Default is on. Queried, returns a boolean.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getObject(self, **kwargs):
        """
        This flags is used together with the parentObjectflag to get the name of the parent object for the specified object.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getOrganizeByLayer(self, **kwargs):
        """
        If true then when a node with animation layer is displayed, attributes will be displayed according to the layer(s) it belongs to. eg:  Layer1 Attr1 Attr2 Layer2 Attr1  If it is false then the outliner will be organized primarily by attributes. eg:  Attr1 Layer1 Layer2 Attr2 Layer1                   
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getParentObject(self, **kwargs):
        """
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getPinPlug(self, **kwargs):
        """
        Pins the named plug, so it always appears in the outliner, irrespective of the incoming selection connection. In query mode, returns a list of the pinned plugs.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getRenderFilterActive(self, **kwargs):
        """
        This is a query only flag which returns true if the render setup filter is Active, i.e one of the four render filters (Inside Selected, Outside Selected, Inside All Layers, Outside All Layers) is applied on the outliner currently, false otherwise.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getRenderFilterIndex(self, **kwargs):
        """
        Sets the Render Setup Filter to the index passed. This only works if the filter is visible in outliner and its selection is not locked. Valid indices are: 0 - Scene2 - Inside Selected3 - Outside Selected4 - Inside All Layers5 - Outside All LayersDefault: Scene 0 In query mode returns current index of the filter.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getRenderFilterVisible(self, **kwargs):
        """
        Show/Hide the Render Setup Filter in outliner. In query mode returns whether the Render Setup Filter is visible or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getSelectCommand(self, **kwargs):
        """
        A command to be executed when an item is selected.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getSetFilter(self, **kwargs):
        """
        Specifies the name of a filter which is used to filter which (if any) sets to display.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getSetsIgnoreFilters(self, **kwargs):
        """
        This flag specifies whether or not the filter should be ignored for expanding sets to show set members (default is true).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAnimCurvesOnly(self, **kwargs):
        """
        This flag modifies the showConnected flag.  If showConnected is set to true then this flag will cause display of only those attributes that are connected to an animCurve. If showConnected is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAnimLayerWeight(self, **kwargs):
        """
        If true then when a node with animation layer is displayed, the weight of the layer will be displayed if it is keyed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAssets(self, **kwargs):
        """
        This flags specifies whether assets should be shown in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAssignedMaterials(self, **kwargs):
        """
        Specifies whether to show assigned materials under shapes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAttrValues(self, **kwargs):
        """
        This flag specifies whether attribute values or attribute names should be displayed. Note: currently only string attributes can have their values displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowAttributes(self, **kwargs):
        """
        Specifies whether to show attributes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowCompounds(self, **kwargs):
        """
        This flag specifies whether or not compound attributes should be displayed, or just the leaf attributes. Note: if showConnected is true, and the compound attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowConnected(self, **kwargs):
        """
        This flag modifies the showAttributes flag.  If showAttributes is set to true then this flag will cause display of only those attributes that are connected in the dependency graph. If showAttributes is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowContainedOnly(self, **kwargs):
        """
        This flags specifies whether nodes belonging to containers should be show under the container node only. Otherwise, it will show up under the world as well.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowContainerContents(self, **kwargs):
        """
        This flags specifies whether the contents of the container should be shown under the container node in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowDagOnly(self, **kwargs):
        """
        This flag specifies whether all dependency graph objects will be displayed, or just DAG objects.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowLeafs(self, **kwargs):
        """
        This flag specifies whether or not leaf attributes should be displayed, or just the compound attributes. Note: if showConnected is true, and the leaf attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowNamespace(self, **kwargs):
        """
        This flag specifies whether all objects will have their namespace displayed, if namespace different than root.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowNumericAttrsOnly(self, **kwargs):
        """
        This flag specifies whether or not all attributes should be displayed, or just numeric attributes. Note: if showConnected is true, and the attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowPinIcons(self, **kwargs):
        """
        Sets whether pin icons are shown for unpinned plugs.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowPublishedAsConnected(self, **kwargs):
        """
        This flags enables attributes that are published to be displayed in italics. Otherwise, only attributes connected as a destination are shown in italics.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowReferenceMembers(self, **kwargs):
        """
        Specifies whether to show reference node members under the reference node in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowReferenceNodes(self, **kwargs):
        """
        Specifies whether to show reference nodes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowSetMembers(self, **kwargs):
        """
        If true then when a set is expanded, the set members will be displayed. If false, then only other sets will be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowShapes(self, **kwargs):
        """
        Specifies whether to show shapes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowTextureNodesOnly(self, **kwargs):
        """
        This flag modifies the showConnected flag. If showConnected is set to true then this flag will cause display of only those attributes that are connected to a texture node. If showConnected is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowTimeEditor(self, **kwargs):
        """
        If true, all nodes related to the Time Editor will be shown as a hierarchy.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowUVAttrsOnly(self, **kwargs):
        """
        This flag specifies whether or not all attributes should be displayed, or just uv attributes. Note: currently the only attribute which will be displayed is Shape.uvSet.uvSetName.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowUnitlessCurves(self, **kwargs):
        """
        This flag (in combination with -expandConnections) specifies whether or not connection expansion should show unitless animCurves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getShowUpstreamCurves(self, **kwargs):
        """
        Specifies exactly which attributes are displayed when showAttributes and expandConnections are both true. If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getSortOrder(self, **kwargs):
        """
        Specify how objects are to be sorted.  Current recognised values are nonefor no sorting and dagNameto sort DAG objects by name. Notes: a) non-DAG objects are always sorted by nodeType and name. b) when sortOrder is set to dagName, objects cannot be reordered using drag-and-drop, they can however be reparented.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def getTransmitFilters(self, **kwargs):
        """
        This flag specifies how the selectionConnection is populated when attribute filters are enabled.  If this flag is set to true, then all the attributes that pass the filter will be placed on the selectionConnection.  By default this flag is false.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def refresh(self, val='True', **kwargs):
        """
        Causes the outliner to refresh itself.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def removeFromCurrentSet(self, val='True', **kwargs):
        """
        Removes selected members of a set from their current set. Current set is the set to which item at the given row belongs to. If no selected items, the item at the given row is removed from its current set.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def renameItem(self, val='True', **kwargs):
        """
        Renames the item at the given row index in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def renameSelectedItem(self, val='True', **kwargs):
        """
        Rename the first selected item in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def selectionOrder(self, val='True', **kwargs):
        """
        Specify how objects are sorted in selection list. Current recognised values are selectionfor sorting in selection order and displayto sort objects in the same order that the outliner does.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAnimLayerFilterOptions(self, val='True', **kwargs):
        """
        Specifies whether a filter is to be applied when displaying animation layers. If so, the options can be allAffecting(no filter), active(only the active layers on the object will be displayed) and animLayerEditor(the settings will be taken from the animation layer editor).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAttrAlphaOrder(self, val='True', **kwargs):
        """
        Specify how attributes are to be sorted. Current recognised values are defaultfor no sorting and ascendto sort attributes from 'a' to ''z' and descendto sort from 'z' to 'a'. Notes: a) this only applies to top level attributes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAttrFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be placed on this editor. This filters the attributes displayed in the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAutoExpand(self, val='True', **kwargs):
        """
        This flag specifies whether or not objects that are loaded in should have their attributes automatically expanded.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAutoExpandLayers(self, val='True', **kwargs):
        """
        If true then when a node with animation layer is displayed, all the animation layers will show up in expanded form.                   
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setAutoSelectNewObjects(self, val='True', **kwargs):
        """
        This flag specifies whether or not new objects added to the outliner should be automatically selected.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setContainersIgnoreFilters(self, val='True', **kwargs):
        """
        This flag specifices whether or not filters should be ignored when displaying container contents.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setDisplayMode(self, val='True', **kwargs):
        """
        Affects how the outliner displays when a filter is applied. List mode is a non-indented flat list. DAG mode indents to represent the hierarchical structure of the model.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setDoNotSelectNewObjects(self, val='True', **kwargs):
        """
        If true this flag specifies that new objects added to the outliner will not be selected, even if they are active.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setDropIsParent(self, val='True', **kwargs):
        """
        This flag specifies the mode for drag and drop. If the flag is true, dropping items will do a reparent. If it is false, dropping will reorder items. By default, the flag is true (parent).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setEditAttrName(self, val='True', **kwargs):
        """
        This flag specifies whether or not attribute names can be edited. By default double-clicking on an attribute will open the expression editor for that attribute.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setExpandConnections(self, val='True', **kwargs):
        """
        This flag specifies whether or not attributes should be expanded to show their input connections. Note: currently the expansion will only show animCurves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setExpandObjects(self, val='True', **kwargs):
        """
        This flag specifies whether or not objects that are loaded in should be automatically expanded.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setHighlightActive(self, val='True', **kwargs):
        """
        This flag specifies whether or not the outliner should highlight objects that are active. Note: if the outliner is driving the contents of another editor, setting highlightActive to true may produce unexpected behavior.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setHighlightSecondary(self, val='True', **kwargs):
        """
        This flag specifies whether or not the outliner should highlight objects that are contained in the highlightConnection.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setIgnoreDagHierarchy(self, val='True', **kwargs):
        """
        This flag specifies whether or not DAG objects are displayed in their DAG hierarchy. Warning: using this flag without some other form of sensible filtering will lead to a very confusing outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setIgnoreHiddenAttribute(self, val='True', **kwargs):
        """
        Sets whether or not the outliner ignores the 'hidden in outliner' flag on nodes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setIgnoreOutlinerColor(self, val='True', **kwargs):
        """
        Sets whether or not the outliner ignores the 'use outliner color' flag on nodes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setLongNames(self, val='True', **kwargs):
        """
        Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the -niceNames flag is set.  Default is short names. Queried, returns a boolean.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setMapMotionTrails(self, val='True', **kwargs):
        """
        Sets whether or not we replace the motion trail in the outliner with the object it is trailing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setMasterOutliner(self, val='True', **kwargs):
        """
        This flag is the name of an outliner that this outliner will share the objects and state from. When an outliner is shared, all of its state information comes from, and is applied to, the master outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setNiceNames(self, val='True', **kwargs):
        """
        Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the longNames flag. Default is on. Queried, returns a boolean.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setOrganizeByLayer(self, val='True', **kwargs):
        """
        If true then when a node with animation layer is displayed, attributes will be displayed according to the layer(s) it belongs to. eg:  Layer1 Attr1 Attr2 Layer2 Attr1  If it is false then the outliner will be organized primarily by attributes. eg:  Attr1 Layer1 Layer2 Attr2 Layer1                   
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setPinPlug(self, val='True', **kwargs):
        """
        Pins the named plug, so it always appears in the outliner, irrespective of the incoming selection connection. In query mode, returns a list of the pinned plugs.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setRenderFilterIndex(self, val='True', **kwargs):
        """
        Sets the Render Setup Filter to the index passed. This only works if the filter is visible in outliner and its selection is not locked. Valid indices are: 0 - Scene2 - Inside Selected3 - Outside Selected4 - Inside All Layers5 - Outside All LayersDefault: Scene 0 In query mode returns current index of the filter.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setRenderFilterVisible(self, val='True', **kwargs):
        """
        Show/Hide the Render Setup Filter in outliner. In query mode returns whether the Render Setup Filter is visible or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setSelectCommand(self, val='True', **kwargs):
        """
        A command to be executed when an item is selected.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setSetFilter(self, val='True', **kwargs):
        """
        Specifies the name of a filter which is used to filter which (if any) sets to display.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setSetsIgnoreFilters(self, val='True', **kwargs):
        """
        This flag specifies whether or not the filter should be ignored for expanding sets to show set members (default is true).                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAnimCurvesOnly(self, val='True', **kwargs):
        """
        This flag modifies the showConnected flag.  If showConnected is set to true then this flag will cause display of only those attributes that are connected to an animCurve. If showConnected is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAnimLayerWeight(self, val='True', **kwargs):
        """
        If true then when a node with animation layer is displayed, the weight of the layer will be displayed if it is keyed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAssets(self, val='True', **kwargs):
        """
        This flags specifies whether assets should be shown in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAssignedMaterials(self, val='True', **kwargs):
        """
        Specifies whether to show assigned materials under shapes.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAttrValues(self, val='True', **kwargs):
        """
        This flag specifies whether attribute values or attribute names should be displayed. Note: currently only string attributes can have their values displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowAttributes(self, val='True', **kwargs):
        """
        Specifies whether to show attributes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowCompounds(self, val='True', **kwargs):
        """
        This flag specifies whether or not compound attributes should be displayed, or just the leaf attributes. Note: if showConnected is true, and the compound attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowConnected(self, val='True', **kwargs):
        """
        This flag modifies the showAttributes flag.  If showAttributes is set to true then this flag will cause display of only those attributes that are connected in the dependency graph. If showAttributes is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowContainedOnly(self, val='True', **kwargs):
        """
        This flags specifies whether nodes belonging to containers should be show under the container node only. Otherwise, it will show up under the world as well.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowContainerContents(self, val='True', **kwargs):
        """
        This flags specifies whether the contents of the container should be shown under the container node in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowDagOnly(self, val='True', **kwargs):
        """
        This flag specifies whether all dependency graph objects will be displayed, or just DAG objects.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowLeafs(self, val='True', **kwargs):
        """
        This flag specifies whether or not leaf attributes should be displayed, or just the compound attributes. Note: if showConnected is true, and the leaf attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowNamespace(self, val='True', **kwargs):
        """
        This flag specifies whether all objects will have their namespace displayed, if namespace different than root.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowNumericAttrsOnly(self, val='True', **kwargs):
        """
        This flag specifies whether or not all attributes should be displayed, or just numeric attributes. Note: if showConnected is true, and the attribute is connected, it will still be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowPinIcons(self, val='True', **kwargs):
        """
        Sets whether pin icons are shown for unpinned plugs.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowPublishedAsConnected(self, val='True', **kwargs):
        """
        This flags enables attributes that are published to be displayed in italics. Otherwise, only attributes connected as a destination are shown in italics.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowReferenceMembers(self, val='True', **kwargs):
        """
        Specifies whether to show reference node members under the reference node in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowReferenceNodes(self, val='True', **kwargs):
        """
        Specifies whether to show reference nodes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowSetMembers(self, val='True', **kwargs):
        """
        If true then when a set is expanded, the set members will be displayed. If false, then only other sets will be displayed.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowShapes(self, val='True', **kwargs):
        """
        Specifies whether to show shapes or not.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowTextureNodesOnly(self, val='True', **kwargs):
        """
        This flag modifies the showConnected flag. If showConnected is set to true then this flag will cause display of only those attributes that are connected to a texture node. If showConnected is set to false then this flag does nothing.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowTimeEditor(self, val='True', **kwargs):
        """
        If true, all nodes related to the Time Editor will be shown as a hierarchy.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowUVAttrsOnly(self, val='True', **kwargs):
        """
        This flag specifies whether or not all attributes should be displayed, or just uv attributes. Note: currently the only attribute which will be displayed is Shape.uvSet.uvSetName.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowUnitlessCurves(self, val='True', **kwargs):
        """
        This flag (in combination with -expandConnections) specifies whether or not connection expansion should show unitless animCurves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setShowUpstreamCurves(self, val='True', **kwargs):
        """
        Specifies exactly which attributes are displayed when showAttributes and expandConnections are both true. If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setSortOrder(self, val='True', **kwargs):
        """
        Specify how objects are to be sorted.  Current recognised values are nonefor no sorting and dagNameto sort DAG objects by name. Notes: a) non-DAG objects are always sorted by nodeType and name. b) when sortOrder is set to dagName, objects cannot be reordered using drag-and-drop, they can however be reparented.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def setTransmitFilters(self, val='True', **kwargs):
        """
        This flag specifies how the selectionConnection is populated when attribute filters are enabled.  If this flag is set to true, then all the attributes that pass the filter will be placed on the selectionConnection.  By default this flag is false.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def showSelected(self, val='True', **kwargs):
        """
        If true then the selected items are expanded in the outliner.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def unpinPlug(self, val='True', **kwargs):
        """
        Unpins the named plug.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates an outliner editor which can be used to display a list of objects.WARNING: some flag combinations
        may not behave as you expect.  The command is really intended for internal use for creating the outliner used by the
        various editors.
        
        Flags:
          - allowMultiSelection : ams      (bool)          [create,edit]
              If true then multiple selection will be allowed in the outliner.
        
          - alwaysToggleSelect : ats       (bool)          [create,edit]
              If true, then clicking on an item in the outliner will select or deselect it without affecting the selection of other
              items (unless allowMultiSelection is false). If false, clicking on an item in the outliner will replace the current
              selection with the selected item.
        
          - animLayerFilterOptions : alf   (unicode)       [create,query,edit]
              Specifies whether a filter is to be applied when displaying animation layers. If so, the options can be allAffecting(no
              filter), active(only the active layers on the object will be displayed) and animLayerEditor(the settings will be taken
              from the animation layer editor).
        
          - attrAlphaOrder : aao           (unicode)       [create,query,edit]
              Specify how attributes are to be sorted. Current recognised values are defaultfor no sorting and ascendto sort
              attributes from 'a' to ''z' and descendto sort from 'z' to 'a'. Notes: a) this only applies to top level attributes.
        
          - attrFilter : af                (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be placed on this editor. This filters the attributes displayed in the
              editor.
        
          - autoExpand : xpd               (bool)          [create,query,edit]
              This flag specifies whether or not objects that are loaded in should have their attributes automatically expanded.
        
          - autoExpandLayers : ael         (bool)          [create,query,edit]
              If true then when a node with animation layer is displayed, all the animation layers will show up in expanded form.
        
          - autoSelectNewObjects : autoSelectNewObjects (bool)          [create,query,edit]
              This flag specifies whether or not new objects added to the outliner should be automatically selected.
        
          - containersIgnoreFilters : cif  (bool)          [create,query,edit]
              This flag specifices whether or not filters should be ignored when displaying container contents.
        
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - directSelect : ds              (bool)          [create,edit]
              If true then clicking on an item in the outliner will add or remove just that item from the selection connection. If
              false then clicking on an item in the outliner causes the selection connection to be reloaded with the currently
              selected items in the outliner.
        
          - displayMode : dm               (unicode)       [create,query,edit]
              Affects how the outliner displays when a filter is applied. List mode is a non-indented flat list. DAG mode indents to
              represent the hierarchical structure of the model.
        
          - doNotSelectNewObjects : dns    (bool)          [create,query,edit]
              If true this flag specifies that new objects added to the outliner will not be selected, even if they are active.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - dropIsParent : dip             (bool)          [create,query,edit]
              This flag specifies the mode for drag and drop. If the flag is true, dropping items will do a reparent. If it is false,
              dropping will reorder items. By default, the flag is true (parent).
        
          - editAttrName : ean             (bool)          [create,query,edit]
              This flag specifies whether or not attribute names can be edited. By default double-clicking on an attribute will open
              the expression editor for that attribute.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - expandAllItems : eai           (bool)          [create,edit]
              Expand or collapse all items in the outliner.
        
          - expandAllSelectedItems : eas   (bool)          [create,edit]
              Expand or collapse all selected items in the outliner.
        
          - expandAttribute : att          (bool)          [edit]
              Force the outliner to fill the selection list with only attributes.
        
          - expandConnections : xc         (bool)          [create,query,edit]
              This flag specifies whether or not attributes should be expanded to show their input connections. Note: currently the
              expansion will only show animCurves.
        
          - expandObjects : eo             (bool)          [create,query,edit]
              This flag specifies whether or not objects that are loaded in should be automatically expanded.
        
          - feedbackItemName : fbn         (bool)          [query]
              Returns the outliner item name at the current mouse position, if any.
        
          - feedbackRowNumber : fbr        (bool)          [query]
              Returns the outliner row number at the current mouse position, if any.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - getCurrentSetOfItem : gcs      (int)           [query]
              Returns the current set of item at the given row. As an item can belong to number of sets, current set is the set to
              which the item belongs to currently.
        
          - highlightActive : ha           (bool)          [create,query,edit]
              This flag specifies whether or not the outliner should highlight objects that are active. Note: if the outliner is
              driving the contents of another editor, setting highlightActive to true may produce unexpected behavior.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - highlightSecondary : hs        (bool)          [create,query,edit]
              This flag specifies whether or not the outliner should highlight objects that are contained in the highlightConnection.
        
          - ignoreDagHierarchy : hir       (bool)          [create,query,edit]
              This flag specifies whether or not DAG objects are displayed in their DAG hierarchy. Warning: using this flag without
              some other form of sensible filtering will lead to a very confusing outliner.
        
          - ignoreHiddenAttribute : iha    (bool)          [create,query,edit]
              Sets whether or not the outliner ignores the 'hidden in outliner' flag on nodes.
        
          - ignoreOutlinerColor : ioc      (bool)          [create,query,edit]
              Sets whether or not the outliner ignores the 'use outliner color' flag on nodes.
        
          - isChildSelected : ics          (PyNode)        [query]
              This flag allows you to query if one or more of the children of the specified item is selected in the outliner. The item
              should be specified using a unique DAG path. Note that if the specified item appears multiple times in the outliner, the
              result will be true if one or more children of any occurrence of the specified item in the outliner is/are selected.
        
          - isSet : isSet                  (int)           [query]
              Returns true if the item present at the given row is a set.
        
          - isSetMember : ism              (int)           [query]
              Returns true if the item present at the given row is a set member.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - longNames : ln                 (bool)          [query,edit]
              Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the
              -niceNames flag is set.  Default is short names. Queried, returns a boolean.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - mapMotionTrails : mmt          (bool)          [create,query,edit]
              Sets whether or not we replace the motion trail in the outliner with the object it is trailing.
        
          - masterOutliner : mst           (unicode)       [create,query,edit]
              This flag is the name of an outliner that this outliner will share the objects and state from. When an outliner is
              shared, all of its state information comes from, and is applied to, the master outliner.
        
          - niceNames : nn                 (bool)          [query,edit]
              Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the
              longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the
              longNames flag. Default is on. Queried, returns a boolean.
        
          - object : obj                   (PyNode)        [query]
              This flags is used together with the parentObjectflag to get the name of the parent object for the specified object.
        
          - organizeByLayer : obl          (bool)          [create,query,edit]
              If true then when a node with animation layer is displayed, attributes will be displayed according to the layer(s) it
              belongs to. eg:  Layer1 Attr1 Attr2 Layer2 Attr1  If it is false then the outliner will be organized primarily by
              attributes. eg:  Attr1 Layer1 Layer2 Attr2 Layer1
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - parentObject : po              (bool)          [query]
        
          - pinPlug : pin                  (PyNode)        [create,query,edit]
              Pins the named plug, so it always appears in the outliner, irrespective of the incoming selection connection. In query
              mode, returns a list of the pinned plugs.
        
          - refresh : rfs                  (bool)          [edit]
              Causes the outliner to refresh itself.
        
          - removeFromCurrentSet : rcs     (int)           [edit]
              Removes selected members of a set from their current set. Current set is the set to which item at the given row belongs
              to. If no selected items, the item at the given row is removed from its current set.
        
          - renameItem : rni               (int)           [edit]
              Renames the item at the given row index in the outliner.
        
          - renameSelectedItem : rsi       (bool)          [edit]
              Rename the first selected item in the outliner.
        
          - renderFilterActive : rfa       (bool)          [query]
              This is a query only flag which returns true if the render setup filter is Active, i.e one of the four render filters
              (Inside Selected, Outside Selected, Inside All Layers, Outside All Layers) is applied on the outliner currently, false
              otherwise.
        
          - renderFilterIndex : rfi        (int)           [create,query,edit]
              Sets the Render Setup Filter to the index passed. This only works if the filter is visible in outliner and its selection
              is not locked. Valid indices are: 0 - Scene2 - Inside Selected3 - Outside Selected4 - Inside All Layers5 - Outside All
              LayersDefault: Scene 0 In query mode returns current index of the filter.
        
          - renderFilterVisible : rfv      (bool)          [create,query,edit]
              Show/Hide the Render Setup Filter in outliner. In query mode returns whether the Render Setup Filter is visible or not.
        
          - selectCommand : sec            (script)        [create,query,edit]
              A command to be executed when an item is selected.
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - selectionOrder : sod           (unicode)       [edit]
              Specify how objects are sorted in selection list. Current recognised values are selectionfor sorting in selection order
              and displayto sort objects in the same order that the outliner does.
        
          - setFilter : sf                 (unicode)       [create,query,edit]
              Specifies the name of a filter which is used to filter which (if any) sets to display.
        
          - setsIgnoreFilters : sif        (bool)          [create,query,edit]
              This flag specifies whether or not the filter should be ignored for expanding sets to show set members (default is
              true).
        
          - showAnimCurvesOnly : aco       (bool)          [create,query,edit]
              This flag modifies the showConnected flag.  If showConnected is set to true then this flag will cause display of only
              those attributes that are connected to an animCurve. If showConnected is set to false then this flag does nothing.
        
          - showAnimLayerWeight : saw      (bool)          [create,query,edit]
              If true then when a node with animation layer is displayed, the weight of the layer will be displayed if it is keyed.
        
          - showAssets : a                 (bool)          [create,query,edit]
              This flags specifies whether assets should be shown in the outliner.
        
          - showAssignedMaterials : sam    (bool)          [create,query,edit]
              Specifies whether to show assigned materials under shapes.
        
          - showAttrValues : av            (bool)          [create,query,edit]
              This flag specifies whether attribute values or attribute names should be displayed. Note: currently only string
              attributes can have their values displayed.
        
          - showAttributes : atr           (bool)          [create,query,edit]
              Specifies whether to show attributes or not.
        
          - showCompounds : cmp            (bool)          [create,query,edit]
              This flag specifies whether or not compound attributes should be displayed, or just the leaf attributes. Note: if
              showConnected is true, and the compound attribute is connected, it will still be displayed.
        
          - showConnected : con            (bool)          [create,query,edit]
              This flag modifies the showAttributes flag.  If showAttributes is set to true then this flag will cause display of only
              those attributes that are connected in the dependency graph. If showAttributes is set to false then this flag does
              nothing.
        
          - showContainedOnly : sco        (bool)          [create,query,edit]
              This flags specifies whether nodes belonging to containers should be show under the container node only. Otherwise, it
              will show up under the world as well.
        
          - showContainerContents : scc    (bool)          [create,query,edit]
              This flags specifies whether the contents of the container should be shown under the container node in the outliner.
        
          - showDagOnly : dag              (bool)          [create,query,edit]
              This flag specifies whether all dependency graph objects will be displayed, or just DAG objects.
        
          - showLeafs : laf                (bool)          [create,query,edit]
              This flag specifies whether or not leaf attributes should be displayed, or just the compound attributes. Note: if
              showConnected is true, and the leaf attribute is connected, it will still be displayed.
        
          - showMuteInfo : smi             (bool)          []
        
          - showNamespace : sn             (bool)          [create,query,edit]
              This flag specifies whether all objects will have their namespace displayed, if namespace different than root.
        
          - showNumericAttrsOnly : num     (bool)          [create,query,edit]
              This flag specifies whether or not all attributes should be displayed, or just numeric attributes. Note: if
              showConnected is true, and the attribute is connected, it will still be displayed.
        
          - showPinIcons : spi             (bool)          [create,query,edit]
              Sets whether pin icons are shown for unpinned plugs.
        
          - showPublishedAsConnected : spc (bool)          [create,query,edit]
              This flags enables attributes that are published to be displayed in italics. Otherwise, only attributes connected as a
              destination are shown in italics.
        
          - showReferenceMembers : rm      (bool)          [create,query,edit]
              Specifies whether to show reference node members under the reference node in the outliner.
        
          - showReferenceNodes : rn        (bool)          [create,query,edit]
              Specifies whether to show reference nodes or not.
        
          - showSelected : sc              (bool)          [create,edit]
              If true then the selected items are expanded in the outliner.
        
          - showSetMembers : ssm           (bool)          [create,query,edit]
              If true then when a set is expanded, the set members will be displayed. If false, then only other sets will be
              displayed.
        
          - showShapes : shp               (bool)          [create,query,edit]
              Specifies whether to show shapes or not.
        
          - showTextureNodesOnly : tno     (bool)          [create,query,edit]
              This flag modifies the showConnected flag. If showConnected is set to true then this flag will cause display of only
              those attributes that are connected to a texture node. If showConnected is set to false then this flag does nothing.
        
          - showTimeEditor : ste           (bool)          [create,query,edit]
              If true, all nodes related to the Time Editor will be shown as a hierarchy.
        
          - showUVAttrsOnly : uv           (bool)          [create,query,edit]
              This flag specifies whether or not all attributes should be displayed, or just uv attributes. Note: currently the only
              attribute which will be displayed is Shape.uvSet.uvSetName.
        
          - showUnitlessCurves : su        (bool)          [create,query,edit]
              This flag (in combination with -expandConnections) specifies whether or not connection expansion should show unitless
              animCurves.
        
          - showUpstreamCurves : suc       (bool)          [create,query,edit]
              Specifies exactly which attributes are displayed when showAttributes and expandConnections are both true. If true, the
              dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example
              in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve
              that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false,
              multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.
        
          - sortOrder : so                 (unicode)       [create,query,edit]
              Specify how objects are to be sorted.  Current recognised values are nonefor no sorting and dagNameto sort DAG objects
              by name. Notes: a) non-DAG objects are always sorted by nodeType and name. b) when sortOrder is set to dagName, objects
              cannot be reordered using drag-and-drop, they can however be reparented.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - transmitFilters : tf           (bool)          [create,query,edit]
              This flag specifies how the selectionConnection is populated when attribute filters are enabled.  If this flag is set to
              true, then all the attributes that pass the filter will be placed on the selectionConnection.  By default this flag is
              false.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - unpinPlug : unp                (PyNode)        [create,edit]
              Unpins the named plug.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.outlinerEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'outlinerEditor'
    
    
    __melui__ = 'outlinerEditor'
    
    
    __readonly__ = {}


class ScrollField(PyUI):
    """
    class counterpart of mel function `scrollField`
    
    This command creates a scrolling field that handles multiple lines of text.
    """
    
    
    
    def changeCommand(self, val='True', **kwargs):
        """
        Command executed when the value changes. This command is executed whenever the field loses focus.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def clear(self, val='True', **kwargs):
        """
        Removes all text in the field.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def enterCommand(self, val='True', **kwargs):
        """
        Command executed when the enter key is pressed. This applies to the enter key on the numeric keypad only.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getEditable(self, **kwargs):
        """
        The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it. If false then the field is 'read only' and can not be typed into. The text in the field can always be changed with the -tx/text flag regardless of the state of the -ed/editable flag.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getFont(self, **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getFontPointSize(self, **kwargs):
        """
        The font point size for the text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getInsertionPosition(self, **kwargs):
        """
        The insertion position for inserted text.  This is a 1 based value where position 1 specifies the beginning of the field.  Position 0 may be used to specify the end of the field.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getNumberOfLines(self, **kwargs):
        """
        Number of lines in the scroll field.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getQtFont(self, **kwargs):
        """
        The Qt font family for the text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getSelection(self, **kwargs):
        """
        The selected text in the field.  An empty string is returned if there is no selected text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getText(self, **kwargs):
        """
        The field text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def insertText(self, val='True', **kwargs):
        """
        Insert text into the field at the current insertion position (specified by the -ip/insertionPosition flag).                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def keyPressCommand(self, val='True', **kwargs):
        """
        Command executed when any key is pressed.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setEditable(self, val='True', **kwargs):
        """
        The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it. If false then the field is 'read only' and can not be typed into. The text in the field can always be changed with the -tx/text flag regardless of the state of the -ed/editable flag.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setFont(self, val='True', **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setFontPointSize(self, val='True', **kwargs):
        """
        The font point size for the text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setInsertionPosition(self, val='True', **kwargs):
        """
        The insertion position for inserted text.  This is a 1 based value where position 1 specifies the beginning of the field.  Position 0 may be used to specify the end of the field.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setQtFont(self, val='True', **kwargs):
        """
        The Qt font family for the text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setText(self, val='True', **kwargs):
        """
        The field text.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates a scrolling field that handles multiple lines of text.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand : cc             (script)        [create,edit]
              Command executed when the value changes. This command is executed whenever the field loses focus.
        
          - clear : cl                     (bool)          [create,edit]
              Removes all text in the field.
        
          - command : c                    (unicode)       []
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - editable : ed                  (bool)          [create,query,edit]
              The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
              If false then the field is 'read only' and can not be typed into. The text in the field can always be changed with the
              -tx/text flag regardless of the state of the -ed/editable flag.
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - enterCommand : ec              (script)        [create,edit]
              Command executed when the enter key is pressed. This applies to the enter key on the numeric keypad only.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - font : fn                      (unicode)       [create,query,edit]
              The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
              smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
        
          - fontPointSize : fns            (int)           [create,query,edit]
              The font point size for the text.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - insertText : it                (unicode)       [create,edit]
              Insert text into the field at the current insertion position (specified by the -ip/insertionPosition flag).
        
          - insertionPosition : ip         (int)           [create,query,edit]
              The insertion position for inserted text.  This is a 1 based value where position 1 specifies the beginning of the
              field.  Position 0 may be used to specify the end of the field.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - keyPressCommand : kpc          (script)        [create,edit]
              Command executed when any key is pressed.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfLines : nl             (int)           [query]
              Number of lines in the scroll field.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - qtFont : qfn                   (unicode)       [create,query,edit]
              The Qt font family for the text.
        
          - selection : sl                 (bool)          [query]
              The selected text in the field.  An empty string is returned if there is no selected text.
        
          - text : tx                      (unicode)       [create,query,edit]
              The field text.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - wordWrap : ww                  (bool)          [create]
              Specify true to break lines at spaces, tabs, or newlines.  Text will continue on the following line.  A value of false
              will not break text between words, in which case text may disappear beyond the edge of the field.  This flag must be set
              at create time. Lines do not word wrap by default.                  Flag can have multiple arguments, passed either as a
              tuple or a list.
        
        
        Derived from mel command `maya.cmds.scrollField`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'scrollField'
    
    
    __melui__ = 'scrollField'
    
    
    __readonly__ = {}


class ShellField(PyUI):
    __melui__ = 'shellField'
    
    
    __readonly__ = {}


class FloatSlider(PyUI):
    """
    class counterpart of mel function `floatSlider`
    
    Create a slider control that accepts only float values and is bound by a minimum and maximum value.  The slider displays a marker indicating the current value of the slider relative to it's minimum and maximum values.  Click and drag the marker or on the slider itself to change the current value.
    """
    
    
    
    def changeCommand(self, val='True', **kwargs):
        """
        Command executed when the value changes.  This command is not invoked when the value changes via the -v/value flag.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def dragCommand(self, val='True', **kwargs):
        """
        Command executed when the value changes by dragging the slider's value marker.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getHorizontal(self, **kwargs):
        """
        Orientation of the slider.  This flag is true by default which corresponds to a horizontally oriented slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getMaxValue(self, **kwargs):
        """
        Upper limit of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getMinValue(self, **kwargs):
        """
        Lower limit of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getStep(self, **kwargs):
        """
        The step value represents the amount the value will increase or decrease when you click either side of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getValue(self, **kwargs):
        """
        Value of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setMaxValue(self, val='True', **kwargs):
        """
        Upper limit of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setMinValue(self, val='True', **kwargs):
        """
        Lower limit of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setStep(self, val='True', **kwargs):
        """
        The step value represents the amount the value will increase or decrease when you click either side of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setValue(self, val='True', **kwargs):
        """
        Value of the slider.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a slider control that accepts only float values and is bound by a minimum and maximum value.  The slider displays
        a marker indicating the current value of the slider relative to it's minimum and maximum values.  Click and drag the
        marker or on the slider itself to change the current value.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand : cc             (script)        [create,edit]
              Command executed when the value changes.  This command is not invoked when the value changes via the -v/value flag.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dragCommand : dc               (script)        [create,edit]
              Command executed when the value changes by dragging the slider's value marker.
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - horizontal : hr                (bool)          [create,query]
              Orientation of the slider.  This flag is true by default which corresponds to a horizontally oriented slider.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - maxValue : max                 (float)         [create,query,edit]
              Upper limit of the slider.
        
          - minValue : min                 (float)         [create,query,edit]
              Lower limit of the slider.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - step : s                       (float)         [create,query,edit]
              The step value represents the amount the value will increase or decrease when you click either side of the slider.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - value : v                      (float)         [create,query,edit]
              Value of the slider.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.floatSlider`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'floatSlider'
    
    
    __melui__ = 'floatSlider'
    
    
    __readonly__ = {}


class Panel(PyUI):
    """
    class counterpart of mel function `panel`
    
    This command allows editing or querying properties of any panels. Not all of the common properites of panels can be used with this command. Flags such as -tearOff and -replacePanel require that you use the explicit panel command. The command 'getPanel -typeOf panelName' will return the explicit type of a panel. In query mode, return type is based on queried flag.
    """
    
    
    
    def copy(self, val='True', **kwargs):
        """
        Makes this panel a copy of the specified panel.  Both panels must be of the same type.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def createString(self, val='True', **kwargs):
        """
        Command string used to create a panel                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def editString(self, val='True', **kwargs):
        """
        Command string used to edit a panel                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels may not have controls at times.  This flag can return if no control is present.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the Maya panel.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getIsUnique(self, **kwargs):
        """
        Returns true if only one instance of this panel type is allowed.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        Specifies the user readable label for the panel.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getMenuBarVisible(self, **kwargs):
        """
        Controls whether the menu bar for the panel is displayed.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getNeedsInit(self, **kwargs):
        """
        (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for initialization.  Used during file -new and file -open.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getPopupMenuProcedure(self, **kwargs):
        """
        Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The procedure should take one string argument which is the panel's name.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def getTearOff(self, **kwargs):
        """
        Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag will return if the panel has been torn off into its own window.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def init(self, val='True', **kwargs):
        """
        Initializes the panel's default state.  This is usually done automatically on file -new and file -open.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def replacePanel(self, val='True', **kwargs):
        """
        Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the Maya panel.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        Specifies the user readable label for the panel.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setMenuBarVisible(self, val='True', **kwargs):
        """
        Controls whether the menu bar for the panel is displayed.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setNeedsInit(self, val='True', **kwargs):
        """
        (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for initialization.  Used during file -new and file -open.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setPopupMenuProcedure(self, val='True', **kwargs):
        """
        Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The procedure should take one string argument which is the panel's name.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def setTearOff(self, val='True', **kwargs):
        """
        Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag will return if the panel has been torn off into its own window.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.                  
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command allows editing or querying properties of any panels. Not all of the common properites of panels can be used
        with this command. Flags such as -tearOff and -replacePanel require that you use the explicit panel command. The command
        'getPanel -typeOf panelName' will return the explicit type of a panel. In query mode, return type is based on queried
        flag.
        
        Flags:
          - control : ctl                  (bool)          [query]
              Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels
              may not have controls at times.  This flag can return if no control is present.
        
          - copy : cp                      (unicode)       [edit]
              Makes this panel a copy of the specified panel.  Both panels must be of the same type.
        
          - createString : cs              (bool)          [edit]
              Command string used to create a panel
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the Maya panel.
        
          - editString : es                (bool)          [edit]
              Command string used to edit a panel
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - init : init                    (bool)          [create,edit]
              Initializes the panel's default state.  This is usually done automatically on file -new and file -open.
        
          - isUnique : iu                  (bool)          [query]
              Returns true if only one instance of this panel type is allowed.
        
          - label : l                      (unicode)       [query,edit]
              Specifies the user readable label for the panel.
        
          - menuBarVisible : mbv           (bool)          [create,query,edit]
              Controls whether the menu bar for the panel is displayed.
        
          - needsInit : ni                 (bool)          [query,edit]
              (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for
              initialization.  Used during file -new and file -open.
        
          - parent : p                     (unicode)       [create]
              Specifies the parent layout for this panel.
        
          - popupMenuProcedure : pmp       (script)        [query,edit]
              Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The
              procedure should take one string argument which is the panel's name.
        
          - replacePanel : rp              (unicode)       [edit]
              Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.
        
          - tearOff : to                   (bool)          [query,edit]
              Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag
              will return if the panel has been torn off into its own window.
        
          - tearOffCopy : toc              (unicode)       [create]
              Will create this panel as a torn of copy of the specified source panel.
        
          - unParent : up                  (bool)          [edit]
              Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.panel`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'panel'
    
    
    __melui__ = 'panel'
    
    
    
    
    __readonly__ = {}


class MenuEditor(PyUI):
    """
    class counterpart of mel function `menuEditor`
    
    A menuEditor displays the contents of a popup menu and allows the menu's items to be edited. Menu items are represented by labelled icons which can be dragged around within the editor to change the menu's layout.  Various objects can be dragged and dropped into the menuEditor to create new menu items: toolButtons from the shelf or toolbox, shelfButtons from the shelf, iconTextButtons with attached commands, and scripts from the command window. When editing a Marking Menu, the radial menu items correspond to 8 icons arranged in a circle within the menuEditor.  Overflow items in the Marking Menu (or linear items in a normal menu) are displayed in a column below the radial items. To edit a submenu of a popup menu, a new menuEditor instance must be created (typically within its own window) and attached to its parent menuEditor. Some flags require the position of a menu item to be passed in as an argument.  For these, positions are specified with a (string,int) pair, where the string corresponds to a radial position (possibily None) and the int corresponds to a linear position (possibly equal to 0 for none).  Radial positions are specified by one of (N,0), (NE,0), (E,0), (SE,0), (S,0), (SW,0), (W,0) or (NW,0).  Overflow, or linear positions, are specified with (None,i), where i is a 1-based index giving the position of the item within the overflow column.Note:This command is not meant to be called explicitly. It was created to support the Marking Menu editor. It is recommended that you use that editor to modify marking menus.
    """
    
    
    
    def cellWidthHeight(self, val='True', **kwargs):
        """
        The width and height of the icons in the menuEditor.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getCellHeight(self, **kwargs):
        """
        The height of the icons in the menuEditor.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getCellWidth(self, **kwargs):
        """
        The width of the icons in the menuEditor.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getCheckBoxPresent(self, **kwargs):
        """
        This controls whether a menu item has a check box or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getCheckBoxState(self, **kwargs):
        """
        The state of the check box associated with a menu item. The arguments are a flag indicating state, followed by the position of the menu item. This flag is ignored if the menu item does not have a check box. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getCommand(self, **kwargs):
        """
        The command or script executed by a menu item. The arguments are the command string or script name, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item or a separator item. If queried, an array of strings is returned containing all the commands. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getImage(self, **kwargs):
        """
        The filename of the icon associated with a menu item. This icon is displayed by the menuEditor to represent the menu item. The arguments are the icon filename, followed by the position of the menu item. If queried, an array of strings is returned containing all the icon filenames. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        The label of a menu item. The arguments are the label text, followed by the position of the menu item. If queried, an array of strings is returned containing all the labels. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getMenuItemTypes(self, **kwargs):
        """
        This is a query only flag.  Returns an array of strings indicating the type of contents in each cell of the menuEditor.  Cells can be vacant, or may contain a regular menu item, or a separator, or a submenuitem.  In each case, the corresponding string is returned. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getOptionBoxCommand(self, **kwargs):
        """
        The command or script executed by a menu item's associated option box item. The arguments are the command string or script name, followed by the position of the menu item. This flag is ignored if the menu item does not have an associated option box item. If queried, an array of strings is returned containing all the commands. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getOptionBoxPresent(self, **kwargs):
        """
        This controls whether a menu item has an associated option box item or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getRadioButtonPresent(self, **kwargs):
        """
        This controls whether a menu item has a radio button or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getRadioButtonState(self, **kwargs):
        """
        The state of the radio button associated with a menu item. The arguments are a flag indicating state, followed by the position of the menu item. This flag is ignored if the menu item does not have a radio button. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getSeparator(self, **kwargs):
        """
        In edit mode this adds a separator to the menuEditor at the specified position. The parameters are the radialPosition and the overflowRow. If queried, an array of booleans is returned indicating if the item is a separator item. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getStyle(self, **kwargs):
        """
        This is the style of icons within the menuEditor. Valid styles are iconOnly, textOnly, iconAndTextHorizontaland iconAndTextVertical.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getSubMenuEditorsOpen(self, **kwargs):
        """
        This is a query only flag.  Returns an array of booleans, each of which indicates if a sub-menuEditor is open and attached to the menu item in a particular cell.  One boolean is returned for each cell in the menuEditor, even if the cell is vacant or contains a non-submenu item (false will be returned in both these cases).  Only when a cell contains a submenu item can true possibily be returned. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getTopLevelMenu(self, **kwargs):
        """
        The popup menu to attach to the editor.  All editing operations performed in the editor (i.e. inserting/deleting/moving an item) will be immediately reflected in this menu. This flag is ignored if the editor is a sub-menuEditor.  The editor will update gracefully if the value of the flag is changed from its initial value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setCellHeight(self, val='True', **kwargs):
        """
        The height of the icons in the menuEditor.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setCellWidth(self, val='True', **kwargs):
        """
        The width of the icons in the menuEditor.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setCheckBoxPresent(self, val='True', **kwargs):
        """
        This controls whether a menu item has a check box or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setCheckBoxState(self, val='True', **kwargs):
        """
        The state of the check box associated with a menu item. The arguments are a flag indicating state, followed by the position of the menu item. This flag is ignored if the menu item does not have a check box. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setCommand(self, val='True', **kwargs):
        """
        The command or script executed by a menu item. The arguments are the command string or script name, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item or a separator item. If queried, an array of strings is returned containing all the commands. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setImage(self, val='True', **kwargs):
        """
        The filename of the icon associated with a menu item. This icon is displayed by the menuEditor to represent the menu item. The arguments are the icon filename, followed by the position of the menu item. If queried, an array of strings is returned containing all the icon filenames. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        The label of a menu item. The arguments are the label text, followed by the position of the menu item. If queried, an array of strings is returned containing all the labels. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setOptionBoxCommand(self, val='True', **kwargs):
        """
        The command or script executed by a menu item's associated option box item. The arguments are the command string or script name, followed by the position of the menu item. This flag is ignored if the menu item does not have an associated option box item. If queried, an array of strings is returned containing all the commands. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setOptionBoxPresent(self, val='True', **kwargs):
        """
        This controls whether a menu item has an associated option box item or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setRadioButtonPresent(self, val='True', **kwargs):
        """
        This controls whether a menu item has a radio button or not. The arguments are a flag indicating presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setRadioButtonState(self, val='True', **kwargs):
        """
        The state of the radio button associated with a menu item. The arguments are a flag indicating state, followed by the position of the menu item. This flag is ignored if the menu item does not have a radio button. If queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setSeparator(self, val='True', **kwargs):
        """
        In edit mode this adds a separator to the menuEditor at the specified position. The parameters are the radialPosition and the overflowRow. If queried, an array of booleans is returned indicating if the item is a separator item. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setStyle(self, val='True', **kwargs):
        """
        This is the style of icons within the menuEditor. Valid styles are iconOnly, textOnly, iconAndTextHorizontaland iconAndTextVertical.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setTopLevelMenu(self, val='True', **kwargs):
        """
        The popup menu to attach to the editor.  All editing operations performed in the editor (i.e. inserting/deleting/moving an item) will be immediately reflected in this menu. This flag is ignored if the editor is a sub-menuEditor.  The editor will update gracefully if the value of the flag is changed from its initial value.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def subMenuAt(self, val='True', **kwargs):
        """
        Creates a submenu item at the given position.  A submenu item created within the radial portion of a menu will overwrite whatever item (if any) is currently at the given position. A submenu item created within the overflow (linear) portion of a menu will be inserted before the item currently at the given position.                  
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        A menuEditor displays the contents of a popup menu and allows the menu's items to be edited. Menu items are represented
        by labelled icons which can be dragged around within the editor to change the menu's layout.  Various objects can be
        dragged and dropped into the menuEditor to create new menu items: toolButtons from the shelf or toolbox, shelfButtons
        from the shelf, iconTextButtons with attached commands, and scripts from the command window. When editing a Marking
        Menu, the radial menu items correspond to 8 icons arranged in a circle within the menuEditor.  Overflow items in the
        Marking Menu (or linear items in a normal menu) are displayed in a column below the radial items. To edit a submenu of a
        popup menu, a new menuEditor instance must be created (typically within its own window) and attached to its parent
        menuEditor. Some flags require the position of a menu item to be passed in as an argument.  For these, positions are
        specified with a (string,int) pair, where the string corresponds to a radial position (possibily None) and the int
        corresponds to a linear position (possibly equal to 0 for none).  Radial positions are specified by one of (N,0),
        (NE,0), (E,0), (SE,0), (S,0), (SW,0), (W,0) or (NW,0).  Overflow, or linear positions, are specified with (None,i),
        where i is a 1-based index giving the position of the item within the overflow column.Note:This command is not meant to
        be called explicitly. It was created to support the Marking Menu editor. It is recommended that you use that editor to
        modify marking menus.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - cellHeight : ch                (int)           [query,edit]
              The height of the icons in the menuEditor.
        
          - cellWidth : cw                 (int)           [query,edit]
              The width of the icons in the menuEditor.
        
          - cellWidthHeight : cwh          (int, int)      [edit]
              The width and height of the icons in the menuEditor.
        
          - checkBoxPresent : cbp          (bool, unicode, int) [query,edit]
              This controls whether a menu item has a check box or not. The arguments are a flag indicating presence, followed by the
              position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans is
              returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ...
              NW), and all later entries correspond to overflow (or linear) menu items.
        
          - checkBoxState : cbs            (bool, unicode, int) [query,edit]
              The state of the check box associated with a menu item. The arguments are a flag indicating state, followed by the
              position of the menu item. This flag is ignored if the menu item does not have a check box. If queried, an array of
              booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N,
              NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - command : c                    (unicode, unicode, int) [query,edit]
              The command or script executed by a menu item. The arguments are the command string or script name, followed by the
              position of the menu item. This flag is ignored if the menu item is a submenu item or a separator item. If queried, an
              array of strings is returned containing all the commands. The first 8 entries of the array correspond to radial items
              (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - delete : d                     (unicode, int)  [edit]
              Deletes the menu item at the given position, removing it from the menu.  If the menu item has a submenu, and a sub-
              menuEditor is open and attached to it, then the sub-menuEditor's window and all its child menuEditor windows will be
              closed recursively.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - iconMenuCallback : imc         (unicode)       [create]
              This is the name of a MEL callback procedure that is called to create the popup menus attached to icons in the
              menuEditor.  The callback is called once for each newly created icon, and once each time an icon is moved within the
              menuEditor.  Popup menus created by the callback should contain commands for editing the menu item associated with the
              icon.  Operations accessible through the menu should include deletion of the item, editing of the item's
              label/command/image/checkbox/optionbox, creation of a submenu, and popping up a sub-menuEditor. The arguments to the
              callback must match this form: callbackProc(string $menuEditorName, string $parentIconName, string $menuTitle, string
              $radialPosition, int $overflowRow); The popup menu's parent should be $parentIconName. Note that when a sub-menuEditor
              is created, this flag need not be re-specified as it adopts a default value equal to the value of its parent
              menuEditor's -imc/iconMenuCallback flag.
        
          - image : i                      (unicode, unicode, int) [query,edit]
              The filename of the icon associated with a menu item. This icon is displayed by the menuEditor to represent the menu
              item. The arguments are the icon filename, followed by the position of the menu item. If queried, an array of strings is
              returned containing all the icon filenames. The first 8 entries of the array correspond to radial items (in order, N,
              NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - label : l                      (unicode, unicode, int) [query,edit]
              The label of a menu item. The arguments are the label text, followed by the position of the menu item. If queried, an
              array of strings is returned containing all the labels. The first 8 entries of the array correspond to radial items (in
              order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - menuItemTypes : mit            (bool)          [query]
              This is a query only flag.  Returns an array of strings indicating the type of contents in each cell of the menuEditor.
              Cells can be vacant, or may contain a regular menu item, or a separator, or a submenuitem.  In each case, the
              corresponding string is returned. The first 8 entries of the array correspond to radial items (in order, N, NE, ... NW),
              and all later entries correspond to overflow (or linear) menu items.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - optionBoxCommand : obc         (unicode, unicode, int) [query,edit]
              The command or script executed by a menu item's associated option box item. The arguments are the command string or
              script name, followed by the position of the menu item. This flag is ignored if the menu item does not have an
              associated option box item. If queried, an array of strings is returned containing all the commands. The first 8 entries
              of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or
              linear) menu items.
        
          - optionBoxPresent : obp         (bool, unicode, int) [query,edit]
              This controls whether a menu item has an associated option box item or not. The arguments are a flag indicating
              presence, followed by the position of the menu item. This flag is ignored if the menu item is a submenu item. If
              queried, an array of booleans is returned containing all the flags. The first 8 entries of the array correspond to
              radial items (in order, N, NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - radioButtonPresent : rbp       (bool, unicode, int) [query,edit]
              This controls whether a menu item has a radio button or not. The arguments are a flag indicating presence, followed by
              the position of the menu item. This flag is ignored if the menu item is a submenu item. If queried, an array of booleans
              is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N, NE, ...
              NW), and all later entries correspond to overflow (or linear) menu items.
        
          - radioButtonState : rbs         (bool, unicode, int) [query,edit]
              The state of the radio button associated with a menu item. The arguments are a flag indicating state, followed by the
              position of the menu item. This flag is ignored if the menu item does not have a radio button. If queried, an array of
              booleans is returned containing all the flags. The first 8 entries of the array correspond to radial items (in order, N,
              NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - separator : sp                 (unicode, int)  [query,edit]
              In edit mode this adds a separator to the menuEditor at the specified position. The parameters are the radialPosition
              and the overflowRow. If queried, an array of booleans is returned indicating if the item is a separator item. The first
              8 entries of the array correspond to radial items (in order, N, NE, ... NW), and all later entries correspond to
              overflow (or linear) menu items.
        
          - style : st                     (unicode)       [query,edit]
              This is the style of icons within the menuEditor. Valid styles are iconOnly, textOnly, iconAndTextHorizontaland
              iconAndTextVertical.
        
          - subMenuAt : sma                (unicode, int)  [edit]
              Creates a submenu item at the given position.  A submenu item created within the radial portion of a menu will overwrite
              whatever item (if any) is currently at the given position. A submenu item created within the overflow (linear) portion
              of a menu will be inserted before the item currently at the given position.
        
          - subMenuEditorWindow : sew      (unicode)       [create]
              The name of the window which contains a sub-menuEditor.  Only use when creatitg a sub-menuEditor. This window will
              automatically be closed if a parent menuEditor is closed or if a parent menu item is deleted.
        
          - subMenuEditorsOpen : seo       (bool)          [query]
              This is a query only flag.  Returns an array of booleans, each of which indicates if a sub-menuEditor is open and
              attached to the menu item in a particular cell.  One boolean is returned for each cell in the menuEditor, even if the
              cell is vacant or contains a non-submenu item (false will be returned in both these cases).  Only when a cell contains a
              submenu item can true possibily be returned. The first 8 entries of the array correspond to radial items (in order, N,
              NE, ... NW), and all later entries correspond to overflow (or linear) menu items.
        
          - subMenuOf : smo                (unicode, unicode, int) [create]
              Attaches a sub-menuEditor to its parent menuEditor.  Only use when creatitg a sub-menuEditor. The arguments are the name
              of the parent menuEditor, followed by the position of a submenu item within the parent. A submenu item must already
              exist within the parent at the given position. A submenu item cannot have multiple sub-menuEditors attached to it.
        
          - topLevelMenu : tlm             (unicode)       [query,edit]
              The popup menu to attach to the editor.  All editing operations performed in the editor (i.e. inserting/deleting/moving
              an item) will be immediately reflected in this menu. This flag is ignored if the editor is a sub-menuEditor.  The editor
              will update gracefully if the value of the flag is changed from its initial value.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.menuEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'menuEditor'
    
    
    __melui__ = 'menuEditor'
    
    
    __readonly__ = {}


class ModelEditor(PyUI):
    """
    class counterpart of mel function `modelEditor`
    
    Create, edit or query a model editor. Note that some of the flags of this command may have different settings for normal mode and for interactive/playback mode.  For example, a modelEditor can be set to use shaded mode normally, but to use wireframe during playback for greater speed.  Some flags also support having defaults set so that new model editors will be created with those settings.
    """
    
    
    
    def activeCustomEnvironment(self, val='True', **kwargs):
        """
        Specifies a path to an image file to be used as environment map. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def addObjects(self, val='True', **kwargs):
        """
        This flag causes the objects contained within the selection connection to be added to the list of objects visible in the view (if viewSelected is true).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def addSelected(self, val='True', **kwargs):
        """
        This flag causes the currently active objects to be added to the list of objects visible in the view (if viewSelected is true).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def cameraName(self, val='True', **kwargs):
        """
        Set the name of the panel's camera transform and shape. The shape name is computed by appending the string Shapeto the transform name. This flag may not be queried.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveComponentsXray(self, **kwargs):
        """
        Turns on or off Xray mode for active components.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveCustomGeometry(self, **kwargs):
        """
        Specifies an identifier for custom geometry to override the geometry to display. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveCustomLighSet(self, **kwargs):
        """
        Specifies an identifier for the light set to use with a scene render filter. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveCustomOverrideGeometry(self, **kwargs):
        """
        Specifies an identifier for an override on the custom geometry for a scene render filter.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveCustomRenderer(self, **kwargs):
        """
        Specifies an identifier for custom renderer to use when a valid scene render filter is also specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveOnly(self, **kwargs):
        """
        Sets whether only active objects should appear shaded in shaded display.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveShadingGraph(self, **kwargs):
        """
        Specifies the shading graph to use to override material display. Only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getActiveView(self, **kwargs):
        """
        Sets this model editor to be the active view.  Returns true if successful.  On query this flag will return whether the view is the active view.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getAllObjects(self, **kwargs):
        """
        Turn on/off the display of all objects for the view of the model editor. This excludes NURBS, CVs, hulls, grids and manipulators.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getBackfaceCulling(self, **kwargs):
        """
        Turns on or off backface culling for the whole view.  This setting overrides the culling settings of individual objects.  All objects draw in the view will be backface culled.  When backface culling is turned on, surfaces becomes invisible in areas where the normal is pointing away from the camera.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getBufferMode(self, **kwargs):
        """
        Sets the graphic buffer mode.  Possible values are singleor double.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getBumpResolution(self, **kwargs):
        """
        Set the resolution for bakedbump map textures when using the hardware renderer. The default value is 512, 512 respectively.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCamera(self, **kwargs):
        """
        Change or query the name of the camera in model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCameraSetup(self, **kwargs):
        """
        Based on the model editor name passed in will returns a string list containing camera setups. A camera setup can contain one or more cameras which are associated with each other. Camera setups are defined as pairs of consecutive strings in the list. Each pair is comprised of: a string which identifies an active camera, and a string which defines a script to set up a given active camera. As many pairs of strings can be returned as the number of active cameras. If nothing is returned then it is assumed that no set up is required to activate a given camera.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCameras(self, **kwargs):
        """
        Turn on/off the display of cameras for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCapture(self, **kwargs):
        """
        Perform an one-time capture of the viewport to the named image file on disk.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCaptureSequenceNumber(self, **kwargs):
        """
        When a number greater or equal to 0 is specified each subsequent refresh will save an image file to disk if the capture flag has been enabled.  The naming of the file is:  {root name}.#.{extension}  if the name {root name}.{extension} is used for the capture flag argument.  The value of # starts at the number specified to for this argument and increments for each subsequent refresh.  Sequence capture can be disabled by specifying a number less than 0 or an empty file name for the capture flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCmEnabled(self, **kwargs):
        """
        Turn on or off applying color management in the editor.  If set, the color management configuration set in the current editor is used.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getColorMap(self, **kwargs):
        """
        Queries the color map style for the model panel. Possible values are colorIndexand rgb.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getColorResolution(self, **kwargs):
        """
        Set the resolution for bakedcolor textures when using the hardware renderer. The default value is 256, 256 respectively.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getControlVertices(self, **kwargs):
        """
        Turn on/off the display of NURBS CVs for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getCullingOverride(self, **kwargs):
        """
        Set whether to override the culling attributes on objects when using the hardware renderer. The options are: none: Use the culling object attributes per object.doubleSided: Force all objects to be double sided.singleSided: Force all objects to be single sided.The default value is none.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDefault(self, **kwargs):
        """
        Causes this command to modify the default value of this setting. Newly created model editors will inherit the values.  This flag may be used with the -interactive to set default interactive settings.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDeformers(self, **kwargs):
        """
        Turn on/off the display of deformer objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDimensions(self, **kwargs):
        """
        Turn on/off the display of dimension objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDisplayAppearance(self, **kwargs):
        """
        Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded, flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and boundingBoxare valid for the interactive mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDisplayLights(self, **kwargs):
        """
        Sets the lighting for shaded mode.  Possible values are selected, active, all, default, none.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDisplayTextures(self, **kwargs):
        """
        Turns on or off display of textures in shaded mode                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDynamicConstraints(self, **kwargs):
        """
        Turn on/off the display of dynamicConstraints for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getDynamics(self, **kwargs):
        """
        Turn on/off the display of dynamics objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getEditorChanged(self, **kwargs):
        """
        An optional script callback which is called when the editors options have changed.  This is useful in a situation where a scripted panel contains a modelEditor and wants to be notified when the contained editor changes its options.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getExposure(self, **kwargs):
        """
        The exposure value used by the color management of the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFilteredObjectList(self, **kwargs):
        """
        For model editors with filtering on (either using an object filter, or isolate select), this flag returns a string list of the objects which are displayed in this editor. Note that this list does not take into account visibility (based on camera frustum or flags), it purely captures the objects which are considered when rendering the view.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFluids(self, **kwargs):
        """
        Turn on/off the display of fluids for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogColor(self, **kwargs):
        """
        The color used for hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogDensity(self, **kwargs):
        """
        Determines the density of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogEnd(self, **kwargs):
        """
        The end location of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogMode(self, **kwargs):
        """
        This determines the drop-off mode for fog. The possibilities are: linear: linear drop-offexponent: exponential drop-offexponent2: squared exponential drop-off
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogSource(self, **kwargs):
        """
        Set the type of fog algorithm to use. If the argument is fragment(default) then fog is computed per pixel. If the argument is coordinatethen if the geometry has specified vertex fog coordinates, and the OpenGL extension for vertex fog is supported by the graphics system, then fog is computed per vertex.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogStart(self, **kwargs):
        """
        The start location of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFogging(self, **kwargs):
        """
        Set whether hardware fogging is enabled or not.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getFollicles(self, **kwargs):
        """
        Turn on/off the display of follicles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getGamma(self, **kwargs):
        """
        The gamma value used by the color management of the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getGrid(self, **kwargs):
        """
        Turn on/off the display of the grid for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHairSystems(self, **kwargs):
        """
        Turn on/off the display of hairSystems for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHandles(self, **kwargs):
        """
        Turn on/off the display of select handles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHeadsUpDisplay(self, **kwargs):
        """
        Sets whether the model panel will draw any enabled heads up display     elements in this window (if true).  Currently this requires the HUD elements to be globally enabled.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        Return the height of the associated viewport in pixels                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getHulls(self, **kwargs):
        """
        Turn on/off the display of NURBS hulls for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getIgnorePanZoom(self, **kwargs):
        """
        Sets whether the model panel will ignore the 2D pan/zoom value to give an overview of the scene.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getIkHandles(self, **kwargs):
        """
        Turn on/off the display of ik handles and end effectors for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getImagePlane(self, **kwargs):
        """
        Turn on/off the display of image plane for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getInteractive(self, **kwargs):
        """
        Causes this command to modify the interactive refresh settings of the view.  In this way it is possible to change the behavior of the model editor during playback for improved performance.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getIsFiltered(self, **kwargs):
        """
        Returns true for model editors with filtering applied to their view of the scene. This could either be an explicit object filter, or a display option such as isolate select which filters the objects that are displayed.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getJointXray(self, **kwargs):
        """
        Turns on or off Xray mode for joints.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getJoints(self, **kwargs):
        """
        Turn on/off the display of joints for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getLights(self, **kwargs):
        """
        Turn on/off the display of lights for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getLineWidth(self, **kwargs):
        """
        Set width of lines for display                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getLocators(self, **kwargs):
        """
        Turn on/off the display of locator objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getLowQualityLighting(self, **kwargs):
        """
        Set whether to use low quality lightingwhen using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getManipulators(self, **kwargs):
        """
        Turn on/off the display of manipulator objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getMaxConstantTransparency(self, **kwargs):
        """
        Sets the maximum constant transparency.  Setting this value remaps constant transparency values from the range [0.0, 1.0] to the range [0.0, maxConstantTransparency]. All transparency values are shifted linearly to the new range, so a fully transparency object (transparency 1.0) would appear with a transparency of maxConstantTransparency in the viewport, allowing highly transparent objects to be made visible.  This flag only affects constant (non-textured) transparent objects.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getMotionTrails(self, **kwargs):
        """
        Turn on/off the Motion Trail display in the Viewport.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getNCloths(self, **kwargs):
        """
        Turn on/off the display of nCloths for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getNParticles(self, **kwargs):
        """
        Turn on/off the display of nParticles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getNRigids(self, **kwargs):
        """
        Turn on/off the display of nRigids for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getNurbsCurves(self, **kwargs):
        """
        Turn on/off the display of nurbs curves for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getNurbsSurfaces(self, **kwargs):
        """
        Turn on/off the display of nurbs surfaces for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getObjectFilter(self, **kwargs):
        """
        Set or query the current object filter name. An object filter is required to have already been registered.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getObjectFilterList(self, **kwargs):
        """
        Return a list of names of registered filters.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getObjectFilterListUI(self, **kwargs):
        """
        Return a list of UI names of registered filters.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getObjectFilterShowInHUD(self, **kwargs):
        """
        Sets whether or not to display the object filter UI name in the heads up display when an object filter is active. This string is concatenated with the camera name.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getObjectFilterUI(self, **kwargs):
        """
        Query the current object filter UI name. The object filter is required to have already been registered.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getOcclusionCulling(self, **kwargs):
        """
        Set whether to enable occlusion culling testing when using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getPivots(self, **kwargs):
        """
        Turn on/off the display of transform pivots for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getPlanes(self, **kwargs):
        """
        Turn on/off the display of sketch planes for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getPolymeshes(self, **kwargs):
        """
        Turn on/off the display of polygon meshes for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getQueryPluginObjects(self, **kwargs):
        """
        Query the on/off state of plugin objects display for the view. To set the on/off state, use -pluginObjects instead.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererDeviceName(self, **kwargs):
        """
        Query for the name of the draw API used by the Viewport 2.0 renderer for a 3d modeling viewport. The possible return values are VirtualDeviceGLif Maya is set to use OpenGL for Viewport 2.0 or VirtualDeviceDx11if Maya is set to use DirectX for Viewport 2.0. If the renderer for the 3d modeling viewport is not Viewport 2.0, an empty string will be returned.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererList(self, **kwargs):
        """
        Query for a list of the internal names for renderers available for use with the 3d modeling viewport. The default list contains at least base_OpenGL_Renderer, and hwRender_OpenGL_Renderer, if supported. See rendererName for more details on these renderers. Any plugin viewport renderers will also appear in this list.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererListUI(self, **kwargs):
        """
        Query for a list of the UI names for renderers available for use with the 3d modeling viewport. The default list consists of the UI name for base_OpenGL_Renderer, and the UI name for hwRender_OpenGL_Renderer, if it is supported. Any plugin viewport renderer's UI names will also appear in this list. This list and the list returned from rendererList have a 1:1 correspondance.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererName(self, **kwargs):
        """
        Set or get the renderer used for a 3d modeling viewport. The name provided should an internal name of a renderer. The 'rendererList' flag can be used to query for a list of available names. The default renderers available are : base_OpenGL_Renderer: The default OpenGL based renderer, and hwRender_OpenGL_Renderer: The high quality hardware renderer. The default renderer is base_OpenGL_Renderer. The high quality renderer is only supported on certain hardware configurations. See the hardware qualification charts for more details.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererOverrideList(self, **kwargs):
        """
        Query for a list of the internal names for renderer overrides for a 3d viewport renderer. Currently only the Viewport 2renderer supports renderer overrides.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererOverrideListUI(self, **kwargs):
        """
        Query for a list of the UI names for renderer overrides for a 3d viewport renderer. Currently only the Viewport 2renderer supports renderer overrides.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getRendererOverrideName(self, **kwargs):
        """
        Set or get the override used for a 3d viewport renderer. The name provided should be the internal name for an override.  The 'rendererOverrideList' flag can be used to query for a list of available names. Currently only the Viewport 2renderer  supports renderer overrides. Setting an empty string will unset any currently active override.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSceneRenderFilter(self, **kwargs):
        """
        Specifies the name of a scene render filter                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSelectionHiliteDisplay(self, **kwargs):
        """
        Sets whether the model panel will draw any selection hiliting on the objects in this window.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getShadows(self, **kwargs):
        """
        Turn on/off the display of hardware shadows in shaded mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSmoothWireframe(self, **kwargs):
        """
        Turns on or off smoothing of wireframe lines and points                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSortTransparent(self, **kwargs):
        """
        This flag turns on/off sorting of transparent objects during shaded mode refresh. Normally, objects are sorted according to their origin in camera space but when this flag is turned off they will be drawn according to their (depth-first traversal) order in the scene graph. This is a global flag that affects all model editors.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getStrokes(self, **kwargs):
        """
        Turn on/off the display of Paint Effects strokes for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getSubdivSurfaces(self, **kwargs):
        """
        Turn on/off the display of subdivision surfaces for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureAnisotropic(self, **kwargs):
        """
        Set whether to perform anisotropic texture filtering. Will work only if the anisotropic texture filtering extension is supported in OpenGL on the graphics system.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureDisplay(self, **kwargs):
        """
        Set the type of blending to use for textures. The blend is performed between the destination fragment and the texture fragment. The source is usually the material color. Argument options are: modulate: multiply the destination and texture fragment decal: overwrite the destination with the texture fragment                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureHilight(self, **kwargs):
        """
        Set whether to show specular hilighting when the display is in shaded textured mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureMaxSize(self, **kwargs):
        """
        Set maximum texture size for hardware texturing.  The integer value must be a power of 2.  Recommended values are 128 or 256.  If the value specified is larger than the OpenGL maximim textures size for the graphics hardware it will be clamped to the OpenGL size.  If many large textures are used in a scene reducing this value improves performance.  On Impact texture memory is pinned in RAM so using large textures can cause reliability and performance problems. Again reducing this value will help. Software rendering does not use this value. This flag is obsolete as of Maya 6.5. The maxTextureResolution/mtr argument on the displayPref command should be used instead.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureMemoryUsed(self, **kwargs):
        """
        Returns the total number of bytes used by all texture maps.  This is typicly width\*height\*channels for all texture objects in the scene If the texture is mip mapped all mip map levels are included in the total though not never more than two level will be in use at one time                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextureSampling(self, **kwargs):
        """
        Set the type of sampling to be used for texture display. The argument can be either: 1 : means to perform point sample2 : means to perform bilinear interpolation (default)
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTextures(self, **kwargs):
        """
        Turn on/off the display of texture objects for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTranspInShadows(self, **kwargs):
        """
        Set whether to enable display of transparency in shadows when using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTransparencyAlgorithm(self, **kwargs):
        """
        Set the transparency algorithm. The options are: 1) frontAndBackCull: Two pass front and back culling technique.2) perPolygonSort: Draw transparent polygons in back-to-front order technique.transparency pptions 1) and 2) are supported by the hardware renderer. Options 1) is supported by the interactive modeling viewports. The default value is frontAndBackCull.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getTwoSidedLighting(self, **kwargs):
        """
        Turns on or off two sided lighting.  This may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUseBaseRenderer(self, **kwargs):
        """
        Set whether to use the baserenderer when using the hardware renderer and in interactive display mode(-useInteractiveMode) The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUseColorIndex(self, **kwargs):
        """
        Sets whether the model panel will attempt to use color index mode when possible.  Color index mode can provide a performance increase for point, bounding box, and wireframe display modes. This may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUseDefaultMaterial(self, **kwargs):
        """
        Sets whether the model panel will draw all the shaded surfaces using the default material as opposed to using the material(s) currently assigned to the surfaces.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUseInteractiveMode(self, **kwargs):
        """
        Turns on or off the use of the special interaction settings during playback.  This flag may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUseRGBImagePlane(self, **kwargs):
        """
        Sets whether the model panel will be forced into RGB mode when there is an image plane attached to the panel's camera.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getUserNode(self, **kwargs):
        """
        Allows the user to associate a node name with the modelEditor. The value is automatically updated in the event the node is deleted or renamed.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getViewObjects(self, **kwargs):
        """
        Returns the name (if any) of the objectSet which contains the list of objects visible in the view if viewSelected is true and the list of objects being displayed does notcome from the active list.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getViewSelected(self, **kwargs):
        """
        This flag turns on/off viewing of selected objects. When the flag is set to true, the currently active objects are captured and used as the list of objects to view.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getViewTransformName(self, **kwargs):
        """
        Sets the view pipeline to be applied if color management is enabled in the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getViewType(self, **kwargs):
        """
        Returns a string indicating the type of the model editor. For the default model editor, returns the empty string. For custom model editor types created via the API, returns the same string as is returned via the method MPx3dModelView::viewType().                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        Return the width of the associated viewport in pixels.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getWireframeBackingStore(self, **kwargs):
        """
        Sets whether a backing store is used to optimization the drawing of active objects. This mode can provide a performance increase in wireframe mode for certain scenes.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getWireframeOnShaded(self, **kwargs):
        """
        Sets whether the model panel will draw the wireframe on all shaded objects (if true) or only for active objects (if false).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def getXray(self, **kwargs):
        """
        Turns on or off Xray mode.  This may be used with the -default flag.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def noUndo(self, val='True', **kwargs):
        """
        This flag prevents some viewport operations (such as isolate select) from being added to the undo queue.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def pluginObjects(self, val='True', **kwargs):
        """
        Turn on/off the display of plugin objects for the view. It depends on the plugin implementation whether to respect this flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def pluginShapes(self, val='True', **kwargs):
        """
        Turn on/off the display of plugin shapes for the view. It depends on the plugin implementation whether to respect this flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def removeSelected(self, val='True', **kwargs):
        """
        This flag causes the currently active objects to be removed from the list of objects visible in the view (if viewSelected is true).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def resetCustomCamera(self, val='True', **kwargs):
        """
        When specified will reset the camera transform for the active custom camera used for a scene render filter. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveComponentsXray(self, val='True', **kwargs):
        """
        Turns on or off Xray mode for active components.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveCustomGeometry(self, val='True', **kwargs):
        """
        Specifies an identifier for custom geometry to override the geometry to display. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveCustomLighSet(self, val='True', **kwargs):
        """
        Specifies an identifier for the light set to use with a scene render filter. It is only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveCustomOverrideGeometry(self, val='True', **kwargs):
        """
        Specifies an identifier for an override on the custom geometry for a scene render filter.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveCustomRenderer(self, val='True', **kwargs):
        """
        Specifies an identifier for custom renderer to use when a valid scene render filter is also specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveOnly(self, val='True', **kwargs):
        """
        Sets whether only active objects should appear shaded in shaded display.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveShadingGraph(self, val='True', **kwargs):
        """
        Specifies the shading graph to use to override material display. Only enabled when a valid scene render filter is specified.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setActiveView(self, val='True', **kwargs):
        """
        Sets this model editor to be the active view.  Returns true if successful.  On query this flag will return whether the view is the active view.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setAllObjects(self, val='True', **kwargs):
        """
        Turn on/off the display of all objects for the view of the model editor. This excludes NURBS, CVs, hulls, grids and manipulators.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setBackfaceCulling(self, val='True', **kwargs):
        """
        Turns on or off backface culling for the whole view.  This setting overrides the culling settings of individual objects.  All objects draw in the view will be backface culled.  When backface culling is turned on, surfaces becomes invisible in areas where the normal is pointing away from the camera.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setBufferMode(self, val='True', **kwargs):
        """
        Sets the graphic buffer mode.  Possible values are singleor double.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setBumpResolution(self, val='True', **kwargs):
        """
        Set the resolution for bakedbump map textures when using the hardware renderer. The default value is 512, 512 respectively.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCamera(self, val='True', **kwargs):
        """
        Change or query the name of the camera in model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCameras(self, val='True', **kwargs):
        """
        Turn on/off the display of cameras for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCapture(self, val='True', **kwargs):
        """
        Perform an one-time capture of the viewport to the named image file on disk.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCaptureSequenceNumber(self, val='True', **kwargs):
        """
        When a number greater or equal to 0 is specified each subsequent refresh will save an image file to disk if the capture flag has been enabled.  The naming of the file is:  {root name}.#.{extension}  if the name {root name}.{extension} is used for the capture flag argument.  The value of # starts at the number specified to for this argument and increments for each subsequent refresh.  Sequence capture can be disabled by specifying a number less than 0 or an empty file name for the capture flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCmEnabled(self, val='True', **kwargs):
        """
        Turn on or off applying color management in the editor.  If set, the color management configuration set in the current editor is used.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setColorResolution(self, val='True', **kwargs):
        """
        Set the resolution for bakedcolor textures when using the hardware renderer. The default value is 256, 256 respectively.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setControlVertices(self, val='True', **kwargs):
        """
        Turn on/off the display of NURBS CVs for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setCullingOverride(self, val='True', **kwargs):
        """
        Set whether to override the culling attributes on objects when using the hardware renderer. The options are: none: Use the culling object attributes per object.doubleSided: Force all objects to be double sided.singleSided: Force all objects to be single sided.The default value is none.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDefault(self, val='True', **kwargs):
        """
        Causes this command to modify the default value of this setting. Newly created model editors will inherit the values.  This flag may be used with the -interactive to set default interactive settings.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDeformers(self, val='True', **kwargs):
        """
        Turn on/off the display of deformer objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDimensions(self, val='True', **kwargs):
        """
        Turn on/off the display of dimension objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDisplayAppearance(self, val='True', **kwargs):
        """
        Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded, flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and boundingBoxare valid for the interactive mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDisplayLights(self, val='True', **kwargs):
        """
        Sets the lighting for shaded mode.  Possible values are selected, active, all, default, none.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDisplayTextures(self, val='True', **kwargs):
        """
        Turns on or off display of textures in shaded mode                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDynamicConstraints(self, val='True', **kwargs):
        """
        Turn on/off the display of dynamicConstraints for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setDynamics(self, val='True', **kwargs):
        """
        Turn on/off the display of dynamics objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setEditorChanged(self, val='True', **kwargs):
        """
        An optional script callback which is called when the editors options have changed.  This is useful in a situation where a scripted panel contains a modelEditor and wants to be notified when the contained editor changes its options.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setExposure(self, val='True', **kwargs):
        """
        The exposure value used by the color management of the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFluids(self, val='True', **kwargs):
        """
        Turn on/off the display of fluids for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogColor(self, val='True', **kwargs):
        """
        The color used for hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogDensity(self, val='True', **kwargs):
        """
        Determines the density of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogEnd(self, val='True', **kwargs):
        """
        The end location of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogMode(self, val='True', **kwargs):
        """
        This determines the drop-off mode for fog. The possibilities are: linear: linear drop-offexponent: exponential drop-offexponent2: squared exponential drop-off
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogSource(self, val='True', **kwargs):
        """
        Set the type of fog algorithm to use. If the argument is fragment(default) then fog is computed per pixel. If the argument is coordinatethen if the geometry has specified vertex fog coordinates, and the OpenGL extension for vertex fog is supported by the graphics system, then fog is computed per vertex.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogStart(self, val='True', **kwargs):
        """
        The start location of hardware fogging.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFogging(self, val='True', **kwargs):
        """
        Set whether hardware fogging is enabled or not.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setFollicles(self, val='True', **kwargs):
        """
        Turn on/off the display of follicles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setGamma(self, val='True', **kwargs):
        """
        The gamma value used by the color management of the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setGrid(self, val='True', **kwargs):
        """
        Turn on/off the display of the grid for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setHairSystems(self, val='True', **kwargs):
        """
        Turn on/off the display of hairSystems for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setHandles(self, val='True', **kwargs):
        """
        Turn on/off the display of select handles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setHeadsUpDisplay(self, val='True', **kwargs):
        """
        Sets whether the model panel will draw any enabled heads up display     elements in this window (if true).  Currently this requires the HUD elements to be globally enabled.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setHulls(self, val='True', **kwargs):
        """
        Turn on/off the display of NURBS hulls for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setIgnorePanZoom(self, val='True', **kwargs):
        """
        Sets whether the model panel will ignore the 2D pan/zoom value to give an overview of the scene.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setIkHandles(self, val='True', **kwargs):
        """
        Turn on/off the display of ik handles and end effectors for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setImagePlane(self, val='True', **kwargs):
        """
        Turn on/off the display of image plane for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setInteractive(self, val='True', **kwargs):
        """
        Causes this command to modify the interactive refresh settings of the view.  In this way it is possible to change the behavior of the model editor during playback for improved performance.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setJointXray(self, val='True', **kwargs):
        """
        Turns on or off Xray mode for joints.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setJoints(self, val='True', **kwargs):
        """
        Turn on/off the display of joints for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setLights(self, val='True', **kwargs):
        """
        Turn on/off the display of lights for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setLineWidth(self, val='True', **kwargs):
        """
        Set width of lines for display                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setLocators(self, val='True', **kwargs):
        """
        Turn on/off the display of locator objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setLowQualityLighting(self, val='True', **kwargs):
        """
        Set whether to use low quality lightingwhen using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setManipulators(self, val='True', **kwargs):
        """
        Turn on/off the display of manipulator objects for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setMaxConstantTransparency(self, val='True', **kwargs):
        """
        Sets the maximum constant transparency.  Setting this value remaps constant transparency values from the range [0.0, 1.0] to the range [0.0, maxConstantTransparency]. All transparency values are shifted linearly to the new range, so a fully transparency object (transparency 1.0) would appear with a transparency of maxConstantTransparency in the viewport, allowing highly transparent objects to be made visible.  This flag only affects constant (non-textured) transparent objects.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setMotionTrails(self, val='True', **kwargs):
        """
        Turn on/off the Motion Trail display in the Viewport.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setNCloths(self, val='True', **kwargs):
        """
        Turn on/off the display of nCloths for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setNParticles(self, val='True', **kwargs):
        """
        Turn on/off the display of nParticles for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setNRigids(self, val='True', **kwargs):
        """
        Turn on/off the display of nRigids for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setNurbsCurves(self, val='True', **kwargs):
        """
        Turn on/off the display of nurbs curves for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setNurbsSurfaces(self, val='True', **kwargs):
        """
        Turn on/off the display of nurbs surfaces for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setObjectFilter(self, val='True', **kwargs):
        """
        Set or query the current object filter name. An object filter is required to have already been registered.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setObjectFilterShowInHUD(self, val='True', **kwargs):
        """
        Sets whether or not to display the object filter UI name in the heads up display when an object filter is active. This string is concatenated with the camera name.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setOcclusionCulling(self, val='True', **kwargs):
        """
        Set whether to enable occlusion culling testing when using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setPivots(self, val='True', **kwargs):
        """
        Turn on/off the display of transform pivots for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setPlanes(self, val='True', **kwargs):
        """
        Turn on/off the display of sketch planes for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setPolymeshes(self, val='True', **kwargs):
        """
        Turn on/off the display of polygon meshes for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setRendererName(self, val='True', **kwargs):
        """
        Set or get the renderer used for a 3d modeling viewport. The name provided should an internal name of a renderer. The 'rendererList' flag can be used to query for a list of available names. The default renderers available are : base_OpenGL_Renderer: The default OpenGL based renderer, and hwRender_OpenGL_Renderer: The high quality hardware renderer. The default renderer is base_OpenGL_Renderer. The high quality renderer is only supported on certain hardware configurations. See the hardware qualification charts for more details.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setRendererOverrideName(self, val='True', **kwargs):
        """
        Set or get the override used for a 3d viewport renderer. The name provided should be the internal name for an override.  The 'rendererOverrideList' flag can be used to query for a list of available names. Currently only the Viewport 2renderer  supports renderer overrides. Setting an empty string will unset any currently active override.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSceneRenderFilter(self, val='True', **kwargs):
        """
        Specifies the name of a scene render filter                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSelected(self, val='True', **kwargs):
        """
        This flag causes the currently active objects to be the only objects visible in the view (if viewSelected is true).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSelectionHiliteDisplay(self, val='True', **kwargs):
        """
        Sets whether the model panel will draw any selection hiliting on the objects in this window.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setShadows(self, val='True', **kwargs):
        """
        Turn on/off the display of hardware shadows in shaded mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSmoothWireframe(self, val='True', **kwargs):
        """
        Turns on or off smoothing of wireframe lines and points                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSortTransparent(self, val='True', **kwargs):
        """
        This flag turns on/off sorting of transparent objects during shaded mode refresh. Normally, objects are sorted according to their origin in camera space but when this flag is turned off they will be drawn according to their (depth-first traversal) order in the scene graph. This is a global flag that affects all model editors.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setStrokes(self, val='True', **kwargs):
        """
        Turn on/off the display of Paint Effects strokes for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setSubdivSurfaces(self, val='True', **kwargs):
        """
        Turn on/off the display of subdivision surfaces for the view of the model editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextureAnisotropic(self, val='True', **kwargs):
        """
        Set whether to perform anisotropic texture filtering. Will work only if the anisotropic texture filtering extension is supported in OpenGL on the graphics system.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextureDisplay(self, val='True', **kwargs):
        """
        Set the type of blending to use for textures. The blend is performed between the destination fragment and the texture fragment. The source is usually the material color. Argument options are: modulate: multiply the destination and texture fragment decal: overwrite the destination with the texture fragment                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextureHilight(self, val='True', **kwargs):
        """
        Set whether to show specular hilighting when the display is in shaded textured mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextureMaxSize(self, val='True', **kwargs):
        """
        Set maximum texture size for hardware texturing.  The integer value must be a power of 2.  Recommended values are 128 or 256.  If the value specified is larger than the OpenGL maximim textures size for the graphics hardware it will be clamped to the OpenGL size.  If many large textures are used in a scene reducing this value improves performance.  On Impact texture memory is pinned in RAM so using large textures can cause reliability and performance problems. Again reducing this value will help. Software rendering does not use this value. This flag is obsolete as of Maya 6.5. The maxTextureResolution/mtr argument on the displayPref command should be used instead.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextureSampling(self, val='True', **kwargs):
        """
        Set the type of sampling to be used for texture display. The argument can be either: 1 : means to perform point sample2 : means to perform bilinear interpolation (default)
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTextures(self, val='True', **kwargs):
        """
        Turn on/off the display of texture objects for the view                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTranspInShadows(self, val='True', **kwargs):
        """
        Set whether to enable display of transparency in shadows when using the hardware renderer. The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTransparencyAlgorithm(self, val='True', **kwargs):
        """
        Set the transparency algorithm. The options are: 1) frontAndBackCull: Two pass front and back culling technique.2) perPolygonSort: Draw transparent polygons in back-to-front order technique.transparency pptions 1) and 2) are supported by the hardware renderer. Options 1) is supported by the interactive modeling viewports. The default value is frontAndBackCull.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setTwoSidedLighting(self, val='True', **kwargs):
        """
        Turns on or off two sided lighting.  This may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUseBaseRenderer(self, val='True', **kwargs):
        """
        Set whether to use the baserenderer when using the hardware renderer and in interactive display mode(-useInteractiveMode) The default value is false.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUseColorIndex(self, val='True', **kwargs):
        """
        Sets whether the model panel will attempt to use color index mode when possible.  Color index mode can provide a performance increase for point, bounding box, and wireframe display modes. This may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUseDefaultMaterial(self, val='True', **kwargs):
        """
        Sets whether the model panel will draw all the shaded surfaces using the default material as opposed to using the material(s) currently assigned to the surfaces.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUseInteractiveMode(self, val='True', **kwargs):
        """
        Turns on or off the use of the special interaction settings during playback.  This flag may be used with the -default flag.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUseRGBImagePlane(self, val='True', **kwargs):
        """
        Sets whether the model panel will be forced into RGB mode when there is an image plane attached to the panel's camera.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setUserNode(self, val='True', **kwargs):
        """
        Allows the user to associate a node name with the modelEditor. The value is automatically updated in the event the node is deleted or renamed.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setViewSelected(self, val='True', **kwargs):
        """
        This flag turns on/off viewing of selected objects. When the flag is set to true, the currently active objects are captured and used as the list of objects to view.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setViewTransformName(self, val='True', **kwargs):
        """
        Sets the view pipeline to be applied if color management is enabled in the current editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setWireframeBackingStore(self, val='True', **kwargs):
        """
        Sets whether a backing store is used to optimization the drawing of active objects. This mode can provide a performance increase in wireframe mode for certain scenes.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setWireframeOnShaded(self, val='True', **kwargs):
        """
        Sets whether the model panel will draw the wireframe on all shaded objects (if true) or only for active objects (if false).                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def setXray(self, val='True', **kwargs):
        """
        Turns on or off Xray mode.  This may be used with the -default flag.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def toggleExposure(self, val='True', **kwargs):
        """
        Toggles between the current and the default exposure value of the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def toggleGamma(self, val='True', **kwargs):
        """
        Toggles between the current and the default gamma value of the editor.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def updateColorMode(self, val='True', **kwargs):
        """
        Using this flag tells the model panel to check which color mode it should be in, and to switch accordingly.  This flag may be used to update a model panel after a camera image plane has been added or removed.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create, edit or query a model editor. Note that some of the flags of this command may have different settings for normal
        mode and for interactive/playback mode.  For example, a modelEditor can be set to use shaded mode normally, but to use
        wireframe during playback for greater speed.  Some flags also support having defaults set so that new model editors will
        be created with those settings.
        
        Modifications:
          - returns a PyNode object for flags: (query and camera)
        
        Flags:
          - activeComponentsXray : acx     (bool)          [query,edit]
              Turns on or off Xray mode for active components.
        
          - activeCustomEnvironment : ace  (unicode)       [edit]
              Specifies a path to an image file to be used as environment map. It is only enabled when a valid scene render filter is
              specified.
        
          - activeCustomGeometry : acg     (unicode)       [query,edit]
              Specifies an identifier for custom geometry to override the geometry to display. It is only enabled when a valid scene
              render filter is specified.
        
          - activeCustomLighSet : acl      (unicode)       [query,edit]
              Specifies an identifier for the light set to use with a scene render filter. It is only enabled when a valid scene
              render filter is specified.
        
          - activeCustomOverrideGeometry : aog (unicode)       [query,edit]
              Specifies an identifier for an override on the custom geometry for a scene render filter.
        
          - activeCustomRenderer : acr     (unicode)       [query,edit]
              Specifies an identifier for custom renderer to use when a valid scene render filter is also specified.
        
          - activeOnly : ao                (bool)          [query,edit]
              Sets whether only active objects should appear shaded in shaded display.
        
          - activeShadingGraph : asg       (unicode)       [query,edit]
              Specifies the shading graph to use to override material display. Only enabled when a valid scene render filter is
              specified.
        
          - activeView : av                (bool)          [query,edit]
              Sets this model editor to be the active view.  Returns true if successful.  On query this flag will return whether the
              view is the active view.
        
          - addObjects : aob               (unicode)       [edit]
              This flag causes the objects contained within the selection connection to be added to the list of objects visible in the
              view (if viewSelected is true).
        
          - addSelected : addSelected      (bool)          [edit]
              This flag causes the currently active objects to be added to the list of objects visible in the view (if viewSelected is
              true).
        
          - addSelectedObjects : aso       (bool)          []
        
          - allObjects : alo               (bool)          [query,edit]
              Turn on/off the display of all objects for the view of the model editor. This excludes NURBS, CVs, hulls, grids and
              manipulators.
        
          - backfaceCulling : bfc          (bool)          [query,edit]
              Turns on or off backface culling for the whole view.  This setting overrides the culling settings of individual objects.
              All objects draw in the view will be backface culled.  When backface culling is turned on, surfaces becomes invisible in
              areas where the normal is pointing away from the camera.
        
          - bufferMode : bm                (unicode)       [query,edit]
              Sets the graphic buffer mode.  Possible values are singleor double.
        
          - bumpResolution : brz           (int, int)      [query,edit]
              Set the resolution for bakedbump map textures when using the hardware renderer. The default value is 512, 512
              respectively.
        
          - camera : cam                   (unicode)       [query,edit]
              Change or query the name of the camera in model editor.
        
          - cameraName : cn                (unicode)       [create,edit]
              Set the name of the panel's camera transform and shape. The shape name is computed by appending the string Shapeto the
              transform name. This flag may not be queried.
        
          - cameraSet : cst                (unicode)       []
        
          - cameraSetup : cs               (bool)          [query]
              Based on the model editor name passed in will returns a string list containing camera setups. A camera setup can contain
              one or more cameras which are associated with each other. Camera setups are defined as pairs of consecutive strings in
              the list. Each pair is comprised of: a string which identifies an active camera, and a string which defines a script to
              set up a given active camera. As many pairs of strings can be returned as the number of active cameras. If nothing is
              returned then it is assumed that no set up is required to activate a given camera.
        
          - cameras : ca                   (bool)          [query,edit]
              Turn on/off the display of cameras for the view of the model editor.
        
          - capture : cpt                  (unicode)       [query,edit]
              Perform an one-time capture of the viewport to the named image file on disk.
        
          - captureSequenceNumber : csn    (int)           [query,edit]
              When a number greater or equal to 0 is specified each subsequent refresh will save an image file to disk if the capture
              flag has been enabled.  The naming of the file is:  {root name}.#.{extension}  if the name {root name}.{extension} is
              used for the capture flag argument.  The value of # starts at the number specified to for this argument and increments
              for each subsequent refresh.  Sequence capture can be disabled by specifying a number less than 0 or an empty file name
              for the capture flag.
        
          - clipGhosts : cg                (bool)          []
        
          - cmEnabled : cme                (bool)          [query,edit]
              Turn on or off applying color management in the editor.  If set, the color management configuration set in the current
              editor is used.
        
          - colorMap : cm                  (bool)          [query]
              Queries the color map style for the model panel. Possible values are colorIndexand rgb.
        
          - colorResolution : crz          (int, int)      [query,edit]
              Set the resolution for bakedcolor textures when using the hardware renderer. The default value is 256, 256 respectively.
        
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - controlVertices : cv           (bool)          [query,edit]
              Turn on/off the display of NURBS CVs for the view of the model editor.
        
          - cullingOverride : cov          (unicode)       [query,edit]
              Set whether to override the culling attributes on objects when using the hardware renderer. The options are: none: Use
              the culling object attributes per object.doubleSided: Force all objects to be double sided.singleSided: Force all
              objects to be single sided.The default value is none.
        
          - default : d                    (bool)          [query,edit]
              Causes this command to modify the default value of this setting. Newly created model editors will inherit the values.
              This flag may be used with the -interactive to set default interactive settings.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - deformers : df                 (bool)          [query,edit]
              Turn on/off the display of deformer objects for the view of the model editor.
        
          - depthOfFieldPreview : dof      (bool)          []
        
          - dimensions : dim               (bool)          [query,edit]
              Turn on/off the display of dimension objects for the view of the model editor.
        
          - displayAppearance : da         (unicode)       [query,edit]
              Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded,
              flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and
              boundingBoxare valid for the interactive mode.
        
          - displayLights : dl             (unicode)       [query,edit]
              Sets the lighting for shaded mode.  Possible values are selected, active, all, default, none.
        
          - displayTextures : dtx          (bool)          [query,edit]
              Turns on or off display of textures in shaded mode
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - dynamicConstraints : dc        (bool)          [query,edit]
              Turn on/off the display of dynamicConstraints for the view of the model editor.
        
          - dynamics : dy                  (bool)          [query,edit]
              Turn on/off the display of dynamics objects for the view of the model editor.
        
          - editorChanged : ec             (script)        [create,query,edit]
              An optional script callback which is called when the editors options have changed.  This is useful in a situation where
              a scripted panel contains a modelEditor and wants to be notified when the contained editor changes its options.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - exposure : exp                 (float)         [query,edit]
              The exposure value used by the color management of the current editor.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - filteredObjectList : fol       (bool)          [query]
              For model editors with filtering on (either using an object filter, or isolate select), this flag returns a string list
              of the objects which are displayed in this editor. Note that this list does not take into account visibility (based on
              camera frustum or flags), it purely captures the objects which are considered when rendering the view.
        
          - fluids : fl                    (bool)          [query,edit]
              Turn on/off the display of fluids for the view of the model editor.
        
          - fogColor : fcl                 (float, float, float, float) [query,edit]
              The color used for hardware fogging.
        
          - fogDensity : fdn               (float)         [query,edit]
              Determines the density of hardware fogging.
        
          - fogEnd : fen                   (float)         [query,edit]
              The end location of hardware fogging.
        
          - fogMode : fmd                  (unicode)       [query,edit]
              This determines the drop-off mode for fog. The possibilities are: linear: linear drop-offexponent: exponential drop-
              offexponent2: squared exponential drop-off
        
          - fogSource : fsc                (unicode)       [query,edit]
              Set the type of fog algorithm to use. If the argument is fragment(default) then fog is computed per pixel. If the
              argument is coordinatethen if the geometry has specified vertex fog coordinates, and the OpenGL extension for vertex fog
              is supported by the graphics system, then fog is computed per vertex.
        
          - fogStart : fst                 (float)         [query,edit]
              The start location of hardware fogging.
        
          - fogging : fg                   (bool)          [query,edit]
              Set whether hardware fogging is enabled or not.
        
          - follicles : fo                 (bool)          [query,edit]
              Turn on/off the display of follicles for the view of the model editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - gamma : ga                     (float)         [query,edit]
              The gamma value used by the color management of the current editor.
        
          - greasePencils : gp             (bool)          []
        
          - grid : gr                      (bool)          [query,edit]
              Turn on/off the display of the grid for the view of the model editor.
        
          - hairSystems : hs               (bool)          [query,edit]
              Turn on/off the display of hairSystems for the view of the model editor.
        
          - handles : ha                   (bool)          [query,edit]
              Turn on/off the display of select handles for the view of the model editor.
        
          - headsUpDisplay : hud           (bool)          [query,edit]
              Sets whether the model panel will draw any enabled heads up display     elements in this window (if true).  Currently
              this requires the HUD elements to be globally enabled.
        
          - height : h                     (int)           [query]
              Return the height of the associated viewport in pixels
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - holdOuts : hos                 (bool)          []
        
          - hulls : hu                     (bool)          [query,edit]
              Turn on/off the display of NURBS hulls for the view of the model editor.
        
          - ignorePanZoom : ipz            (bool)          [query,edit]
              Sets whether the model panel will ignore the 2D pan/zoom value to give an overview of the scene.
        
          - ikHandles : ikh                (bool)          [query,edit]
              Turn on/off the display of ik handles and end effectors for the view of the model editor.
        
          - imagePlane : imp               (bool)          [query,edit]
              Turn on/off the display of image plane for the view
        
          - interactive : i                (bool)          [query,edit]
              Causes this command to modify the interactive refresh settings of the view.  In this way it is possible to change the
              behavior of the model editor during playback for improved performance.
        
          - interactiveBackFaceCull : ibc  (bool)          []
        
          - interactiveDisableShadows : dis (bool)          []
        
          - isFiltered : isFiltered        (bool)          [query]
              Returns true for model editors with filtering applied to their view of the scene. This could either be an explicit
              object filter, or a display option such as isolate select which filters the objects that are displayed.
        
          - jointXray : jx                 (bool)          [query,edit]
              Turns on or off Xray mode for joints.
        
          - joints : j                     (bool)          [query,edit]
              Turn on/off the display of joints for the view of the model editor.
        
          - lights : lt                    (bool)          [query,edit]
              Turn on/off the display of lights for the view of the model editor.
        
          - lineWidth : lw                 (float)         [query,edit]
              Set width of lines for display
        
          - locators : lc                  (bool)          [query,edit]
              Turn on/off the display of locator objects for the view of the model editor.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - lowQualityLighting : lql       (bool)          [query,edit]
              Set whether to use low quality lightingwhen using the hardware renderer. The default value is false.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - manipulators : m               (bool)          [query,edit]
              Turn on/off the display of manipulator objects for the view of the model editor.
        
          - maxConstantTransparency : mct  (float)         [query,edit]
              Sets the maximum constant transparency.  Setting this value remaps constant transparency values from the range [0.0,
              1.0] to the range [0.0, maxConstantTransparency]. All transparency values are shifted linearly to the new range, so a
              fully transparency object (transparency 1.0) would appear with a transparency of maxConstantTransparency in the
              viewport, allowing highly transparent objects to be made visible.  This flag only affects constant (non-textured)
              transparent objects.
        
          - maximumNumHardwareLights : mhl (bool)          []
        
          - modelPanel : mp                (unicode)       [create]
              Allows the created model editor to be embedded in the named model panel. Intended for use with custom model editors
              created via the API (i.e. the flag would be used on the derived MPxModelEditorCommand), though the flag may also be used
              on the base modelEditor command to restore a default Maya model editor to the panel. Note that the model editor
              previously owned by the panel is deleted.
        
          - motionTrails : mt              (bool)          [query,edit]
              Turn on/off the Motion Trail display in the Viewport.
        
          - nCloths : ncl                  (bool)          [query,edit]
              Turn on/off the display of nCloths for the view of the model editor.
        
          - nParticles : npa               (bool)          [query,edit]
              Turn on/off the display of nParticles for the view of the model editor.
        
          - nRigids : nr                   (bool)          [query,edit]
              Turn on/off the display of nRigids for the view of the model editor.
        
          - noUndo : nud                   (bool)          [edit]
              This flag prevents some viewport operations (such as isolate select) from being added to the undo queue.
        
          - nurbsCurves : nc               (bool)          [query,edit]
              Turn on/off the display of nurbs curves for the view of the model editor.
        
          - nurbsSurfaces : ns             (bool)          [query,edit]
              Turn on/off the display of nurbs surfaces for the view of the model editor.
        
          - objectFilter : obf             (script)        [query,edit]
              Set or query the current object filter name. An object filter is required to have already been registered.
        
          - objectFilterList : ofl         (script)        [query]
              Return a list of names of registered filters.
        
          - objectFilterListUI : ofu       (script)        [query]
              Return a list of UI names of registered filters.
        
          - objectFilterShowInHUD : ofs    (bool)          [query,edit]
              Sets whether or not to display the object filter UI name in the heads up display when an object filter is active. This
              string is concatenated with the camera name.
        
          - objectFilterUI : obu           (script)        [query]
              Query the current object filter UI name. The object filter is required to have already been registered.
        
          - occlusionCulling : ocl         (bool)          [query,edit]
              Set whether to enable occlusion culling testing when using the hardware renderer. The default value is false.
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - particleInstancers : pi        (bool)          []
        
          - pivots : pv                    (bool)          [query,edit]
              Turn on/off the display of transform pivots for the view of the model editor.
        
          - planes : pl                    (bool)          [query,edit]
              Turn on/off the display of sketch planes for the view of the model editor.
        
          - pluginObjects : po             (unicode, bool) [edit]
              Turn on/off the display of plugin objects for the view. It depends on the plugin implementation whether to respect this
              flag.
        
          - pluginShapes : ps              (bool)          [edit]
              Turn on/off the display of plugin shapes for the view. It depends on the plugin implementation whether to respect this
              flag.
        
          - polymeshes : pm                (bool)          [query,edit]
              Turn on/off the display of polygon meshes for the view of the model editor.
        
          - queryPluginObjects : qpo       (unicode)       [query]
              Query the on/off state of plugin objects display for the view. To set the on/off state, use -pluginObjects instead.
        
          - removeSelected : rs            (bool)          [edit]
              This flag causes the currently active objects to be removed from the list of objects visible in the view (if
              viewSelected is true).
        
          - rendererDeviceName : rdn       (bool)          [query]
              Query for the name of the draw API used by the Viewport 2.0 renderer for a 3d modeling viewport. The possible return
              values are VirtualDeviceGLif Maya is set to use OpenGL for Viewport 2.0 or VirtualDeviceDx11if Maya is set to use
              DirectX for Viewport 2.0. If the renderer for the 3d modeling viewport is not Viewport 2.0, an empty string will be
              returned.
        
          - rendererList : rls             (bool)          [query]
              Query for a list of the internal names for renderers available for use with the 3d modeling viewport. The default list
              contains at least base_OpenGL_Renderer, and hwRender_OpenGL_Renderer, if supported. See rendererName for more details on
              these renderers. Any plugin viewport renderers will also appear in this list.
        
          - rendererListUI : rlu           (bool)          [query]
              Query for a list of the UI names for renderers available for use with the 3d modeling viewport. The default list
              consists of the UI name for base_OpenGL_Renderer, and the UI name for hwRender_OpenGL_Renderer, if it is supported. Any
              plugin viewport renderer's UI names will also appear in this list. This list and the list returned from rendererList
              have a 1:1 correspondance.
        
          - rendererName : rnm             (unicode)       [query,edit]
              Set or get the renderer used for a 3d modeling viewport. The name provided should an internal name of a renderer. The
              'rendererList' flag can be used to query for a list of available names. The default renderers available are :
              base_OpenGL_Renderer: The default OpenGL based renderer, and hwRender_OpenGL_Renderer: The high quality hardware
              renderer. The default renderer is base_OpenGL_Renderer. The high quality renderer is only supported on certain hardware
              configurations. See the hardware qualification charts for more details.
        
          - rendererOverrideList : rol     (bool)          [query]
              Query for a list of the internal names for renderer overrides for a 3d viewport renderer. Currently only the Viewport
              2renderer supports renderer overrides.
        
          - rendererOverrideListUI : rou   (bool)          [query]
              Query for a list of the UI names for renderer overrides for a 3d viewport renderer. Currently only the Viewport
              2renderer supports renderer overrides.
        
          - rendererOverrideName : rom     (unicode)       [query,edit]
              Set or get the override used for a 3d viewport renderer. The name provided should be the internal name for an override.
              The 'rendererOverrideList' flag can be used to query for a list of available names. Currently only the Viewport
              2renderer  supports renderer overrides. Setting an empty string will unset any currently active override.
        
          - resetCustomCamera : rcc        (bool)          [edit]
              When specified will reset the camera transform for the active custom camera used for a scene render filter. It is only
              enabled when a valid scene render filter is specified.
        
          - sceneRenderFilter : srf        (unicode)       [query,edit]
              Specifies the name of a scene render filter
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - selectionHiliteDisplay : sel   (bool)          [query,edit]
              Sets whether the model panel will draw any selection hiliting on the objects in this window.
        
          - setSelected : ss               (bool)          [edit]
              This flag causes the currently active objects to be the only objects visible in the view (if viewSelected is true).
        
          - shadingModel : sml             (int)           []
        
          - shadows : sdw                  (bool)          [query,edit]
              Turn on/off the display of hardware shadows in shaded mode.
        
          - smallObjectCulling : soc       (bool)          []
        
          - smallObjectThreshold : sot     (float)         []
        
          - smoothWireframe : swf          (bool)          [query,edit]
              Turns on or off smoothing of wireframe lines and points
        
          - sortTransparent : st           (bool)          [query,edit]
              This flag turns on/off sorting of transparent objects during shaded mode refresh. Normally, objects are sorted according
              to their origin in camera space but when this flag is turned off they will be drawn according to their (depth-first
              traversal) order in the scene graph. This is a global flag that affects all model editors.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - stereoDrawMode : sdm           (bool)          []
        
          - strokes : str                  (bool)          [query,edit]
              Turn on/off the display of Paint Effects strokes for the view
        
          - subdivSurfaces : sds           (bool)          [query,edit]
              Turn on/off the display of subdivision surfaces for the view of the model editor.
        
          - textureAnisotropic : ta        (bool)          [query,edit]
              Set whether to perform anisotropic texture filtering. Will work only if the anisotropic texture filtering extension is
              supported in OpenGL on the graphics system.
        
          - textureCompression : tcp       (bool)          []
        
          - textureDisplay : td            (unicode)       [query,edit]
              Set the type of blending to use for textures. The blend is performed between the destination fragment and the texture
              fragment. The source is usually the material color. Argument options are: modulate: multiply the destination and texture
              fragment decal: overwrite the destination with the texture fragment
        
          - textureEnvironmentMap : tem    (bool)          []
        
          - textureHilight : th            (bool)          [query,edit]
              Set whether to show specular hilighting when the display is in shaded textured mode.
        
          - textureMaxSize : tms           (int)           [query,edit]
              Set maximum texture size for hardware texturing.  The integer value must be a power of 2.  Recommended values are 128 or
              256.  If the value specified is larger than the OpenGL maximim textures size for the graphics hardware it will be
              clamped to the OpenGL size.  If many large textures are used in a scene reducing this value improves performance.  On
              Impact texture memory is pinned in RAM so using large textures can cause reliability and performance problems. Again
              reducing this value will help. Software rendering does not use this value. This flag is obsolete as of Maya 6.5. The
              maxTextureResolution/mtr argument on the displayPref command should be used instead.
        
          - textureMemoryUsed : tmu        (bool)          [query]
              Returns the total number of bytes used by all texture maps.  This is typicly width\*height\*channels for all texture
              objects in the scene If the texture is mip mapped all mip map levels are included in the total though not never more
              than two level will be in use at one time
        
          - textureSampling : ts           (int)           [query,edit]
              Set the type of sampling to be used for texture display. The argument can be either: 1 : means to perform point sample2
              : means to perform bilinear interpolation (default)
        
          - textures : tx                  (bool)          [query,edit]
              Turn on/off the display of texture objects for the view
        
          - toggleExposure : tge           (bool)          [edit]
              Toggles between the current and the default exposure value of the editor.
        
          - toggleGamma : tgg              (bool)          [edit]
              Toggles between the current and the default gamma value of the editor.
        
          - transpInShadows : tis          (bool)          [query,edit]
              Set whether to enable display of transparency in shadows when using the hardware renderer. The default value is false.
        
          - transparencyAlgorithm : tal    (unicode)       [query,edit]
              Set the transparency algorithm. The options are: 1) frontAndBackCull: Two pass front and back culling technique.2)
              perPolygonSort: Draw transparent polygons in back-to-front order technique.transparency pptions 1) and 2) are supported
              by the hardware renderer. Options 1) is supported by the interactive modeling viewports. The default value is
              frontAndBackCull.
        
          - twoSidedLighting : tsl         (bool)          [query,edit]
              Turns on or off two sided lighting.  This may be used with the -default flag.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateColorMode : ucm          (bool)          [edit]
              Using this flag tells the model panel to check which color mode it should be in, and to switch accordingly.  This flag
              may be used to update a model panel after a camera image plane has been added or removed.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useBaseRenderer : ubr          (bool)          [query,edit]
              Set whether to use the baserenderer when using the hardware renderer and in interactive display
              mode(-useInteractiveMode) The default value is false.
        
          - useColorIndex : uci            (bool)          [query,edit]
              Sets whether the model panel will attempt to use color index mode when possible.  Color index mode can provide a
              performance increase for point, bounding box, and wireframe display modes. This may be used with the -default flag.
        
          - useDefaultMaterial : udm       (bool)          [query,edit]
              Sets whether the model panel will draw all the shaded surfaces using the default material as opposed to using the
              material(s) currently assigned to the surfaces.
        
          - useInteractiveMode : ui        (bool)          [query,edit]
              Turns on or off the use of the special interaction settings during playback.  This flag may be used with the -default
              flag.
        
          - useRGBImagePlane : ip          (bool)          [query,edit]
              Sets whether the model panel will be forced into RGB mode when there is an image plane attached to the panel's camera.
        
          - useReducedRenderer : urr       (bool)          []
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - userNode : un                  (unicode)       [query,edit]
              Allows the user to associate a node name with the modelEditor. The value is automatically updated in the event the node
              is deleted or renamed.
        
          - viewObjects : vo               (bool)          [query]
              Returns the name (if any) of the objectSet which contains the list of objects visible in the view if viewSelected is
              true and the list of objects being displayed does notcome from the active list.
        
          - viewSelected : vs              (bool)          [query,edit]
              This flag turns on/off viewing of selected objects. When the flag is set to true, the currently active objects are
              captured and used as the list of objects to view.
        
          - viewTransformName : vtn        (unicode)       [query,edit]
              Sets the view pipeline to be applied if color management is enabled in the current editor.
        
          - viewType : vt                  (bool)          [query]
              Returns a string indicating the type of the model editor. For the default model editor, returns the empty string. For
              custom model editor types created via the API, returns the same string as is returned via the method
              MPx3dModelView::viewType().
        
          - width : w                      (int)           [query]
              Return the width of the associated viewport in pixels.
        
          - wireframeBackingStore : wbs    (bool)          [query,edit]
              Sets whether a backing store is used to optimization the drawing of active objects. This mode can provide a performance
              increase in wireframe mode for certain scenes.
        
          - wireframeOnShaded : wos        (bool)          [query,edit]
              Sets whether the model panel will draw the wireframe on all shaded objects (if true) or only for active objects (if
              false).
        
          - xray : xr                      (bool)          [query,edit]
              Turns on or off Xray mode.  This may be used with the -default flag.                  Flag can have multiple arguments,
              passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.modelEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'modelEditor'
    
    
    __melui__ = 'modelEditor'
    
    
    __readonly__ = {}


class BlendShapeEditor(PyUI):
    """
    class counterpart of mel function `blendShapeEditor`
    
    This command creates an editor that derives from the base editor class that has controls for blendShape, control nodes.
    """
    
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getTargetControlList(self, **kwargs):
        """
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getTargetList(self, **kwargs):
        """
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def getVerticalSliders(self, **kwargs):
        """
        Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def setVerticalSliders(self, val='True', **kwargs):
        """
        Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates an editor that derives from the base editor class that has controls for blendShape, control nodes.
        
        Flags:
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - targetControlList : tcl        (bool)          [query]
        
          - targetList : tl                (bool)          [query]
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - verticalSliders : vs           (bool)          [create,query,edit]
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.blendShapeEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'blendShapeEditor'
    
    
    __melui__ = 'blendShapeEditor'
    
    
    __readonly__ = {}


class Layout(PyUI):
    def __enter__(self):
        pass
    
    
    def __exit__(self, type, value, traceback):
        pass
    
    
    def addChild(self, uiType, name='None', **kwargs):
        pass
    
    
    def asQtObject(mayaName):
        """
        Given the name of a May UI control, return the corresponding QWidget.
        If the object does not exist, returns None
        
        .. note:: Requires PySide
        """
    
        pass
    
    
    def children(self):
        pass
    
    
    def clear(self):
        pass
    
    
    def findChild(self, shortName, recurse='False'):
        pass
    
    
    def getChildren(self):
        pass
    
    
    def makeDefault(self):
        """
        set this layout as the default parent
        """
    
        pass
    
    
    def pop(self):
        """
        set the default parent to the parent of this layout
        """
    
        pass
    
    
    def walkChildren(self):
        """
        recursively yield all children of this layout
        """
    
        pass


class AnimDisplay(PyUI):
    """
    class counterpart of mel function `animDisplay`
    
    This command changes certain display options used by animation windows. In query mode, return type is based on queried flag.
    """
    
    
    
    def getModelUpdate(self, **kwargs):
        """
        Controls how changes to animCurves are propagated through the dependency graph. Valid modes are none, interactiveor delayed. If modelUpdate is nonethen changing an animCurve will not cause the model to be updated (change currentTime in order to update the model).  If modelUpdate is interactive(which is the default setting), then as interactive changes are being made to the animCurve, the model will be updated.  If modelUpdate is delayed, then the model is updated once the final change to an animCurve has been made.  With modelUpdate set to either interactiveor delayed, changes to animCurves made via commands will also cause the model to be updated.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def getRefAnimCurvesEditable(self, **kwargs):
        """
        Specify if animation curves from referenced files are editable.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def getTimeCode(self, **kwargs):
        """
        Controls whether the animation windows (time slider, graph editor and dope sheet) use time codes in their displays.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def getTimeCodeOffset(self, **kwargs):
        """
        This flag has now been deprecated.  It still exists to not break legacy scripts, but it will now do nothing.  See the new timeCode command to set and query timeCodes.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def setModelUpdate(self, val='True', **kwargs):
        """
        Controls how changes to animCurves are propagated through the dependency graph. Valid modes are none, interactiveor delayed. If modelUpdate is nonethen changing an animCurve will not cause the model to be updated (change currentTime in order to update the model).  If modelUpdate is interactive(which is the default setting), then as interactive changes are being made to the animCurve, the model will be updated.  If modelUpdate is delayed, then the model is updated once the final change to an animCurve has been made.  With modelUpdate set to either interactiveor delayed, changes to animCurves made via commands will also cause the model to be updated.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def setRefAnimCurvesEditable(self, val='True', **kwargs):
        """
        Specify if animation curves from referenced files are editable.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def setTimeCode(self, val='True', **kwargs):
        """
        Controls whether the animation windows (time slider, graph editor and dope sheet) use time codes in their displays.                  
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def setTimeCodeOffset(self, val='True', **kwargs):
        """
        This flag has now been deprecated.  It still exists to not break legacy scripts, but it will now do nothing.  See the new timeCode command to set and query timeCodes.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command changes certain display options used by animation windows. In query mode, return type is based on queried
        flag.
        
        Flags:
          - modelUpdate : upd              (unicode)       [create,query,edit]
              Controls how changes to animCurves are propagated through the dependency graph. Valid modes are none, interactiveor
              delayed. If modelUpdate is nonethen changing an animCurve will not cause the model to be updated (change currentTime in
              order to update the model).  If modelUpdate is interactive(which is the default setting), then as interactive changes
              are being made to the animCurve, the model will be updated.  If modelUpdate is delayed, then the model is updated once
              the final change to an animCurve has been made.  With modelUpdate set to either interactiveor delayed, changes to
              animCurves made via commands will also cause the model to be updated.
        
          - refAnimCurvesEditable : rae    (bool)          [create,query,edit]
              Specify if animation curves from referenced files are editable.
        
          - timeCode : tc                  (bool)          [create,query,edit]
              Controls whether the animation windows (time slider, graph editor and dope sheet) use time codes in their displays.
        
          - timeCodeOffset : tco           (unicode)       [create,query,edit]
              This flag has now been deprecated.  It still exists to not break legacy scripts, but it will now do nothing.  See the
              new timeCode command to set and query timeCodes.                  Flag can have multiple arguments, passed either as a
              tuple or a list.
        
        
        Derived from mel command `maya.cmds.animDisplay`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'animDisplay'
    
    
    __melui__ = 'animDisplay'
    
    
    __readonly__ = {}


class IconTextStaticLabel(PyUI):
    """
    class counterpart of mel function `iconTextStaticLabel`
    
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best fits the current size of the control given its current style. This command creates an iconTextStaticLabel.
    """
    
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getAlign(self, **kwargs):
        """
        The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getDisabledImage(self, **kwargs):
        """
        Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getFlipX(self, **kwargs):
        """
        Is the image flipped horizontally?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getFlipY(self, **kwargs):
        """
        Is the image flipped vertically?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getFont(self, **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getImage(self, **kwargs):
        """
        If you are not providing images with different sizes then you may use this flag for the control's image. If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getImage1(self, **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getImage2(self, **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getImage3(self, **kwargs):
        """
        This control supports three icons. The icon that best fits the current size of the control will be displayed.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getImageOverlayLabel(self, **kwargs):
        """
        A short string, up to 6 characters, representing a label that will be displayed on top of the image.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getLabel(self, **kwargs):
        """
        The text that appears in the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getLabelOffset(self, **kwargs):
        """
        The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getLtVersion(self, **kwargs):
        """
        This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getMarginHeight(self, **kwargs):
        """
        The number of pixels above and below the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getMarginWidth(self, **kwargs):
        """
        The number of pixels on either side of the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getOverlayLabelBackColor(self, **kwargs):
        """
        The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getOverlayLabelColor(self, **kwargs):
        """
        The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getRotation(self, **kwargs):
        """
        The rotation value of the image in radians.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getStyle(self, **kwargs):
        """
        The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getUseAlpha(self, **kwargs):
        """
        Is the image using alpha channel?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getVersion(self, **kwargs):
        """
        Specify the version that this control feature was introduced. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setAlign(self, val='True', **kwargs):
        """
        The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setDisabledImage(self, val='True', **kwargs):
        """
        Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is a Windows only flag.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setFlipX(self, val='True', **kwargs):
        """
        Is the image flipped horizontally?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setFlipY(self, val='True', **kwargs):
        """
        Is the image flipped vertically?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setFont(self, val='True', **kwargs):
        """
        The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont, smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setImage(self, val='True', **kwargs):
        """
        If you are not providing images with different sizes then you may use this flag for the control's image. If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setImage1(self, val='True', **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setImage2(self, val='True', **kwargs):
        """
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setImage3(self, val='True', **kwargs):
        """
        This control supports three icons. The icon that best fits the current size of the control will be displayed.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setImageOverlayLabel(self, val='True', **kwargs):
        """
        A short string, up to 6 characters, representing a label that will be displayed on top of the image.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setLabel(self, val='True', **kwargs):
        """
        The text that appears in the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setLabelOffset(self, val='True', **kwargs):
        """
        The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setLtVersion(self, val='True', **kwargs):
        """
        This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setMarginHeight(self, val='True', **kwargs):
        """
        The number of pixels above and below the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setMarginWidth(self, val='True', **kwargs):
        """
        The number of pixels on either side of the control content. The default value is 1 pixel.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setOverlayLabelBackColor(self, val='True', **kwargs):
        """
        The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setOverlayLabelColor(self, val='True', **kwargs):
        """
        The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setRotation(self, val='True', **kwargs):
        """
        The rotation value of the image in radians.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setStyle(self, val='True', **kwargs):
        """
        The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will be scaled to the size of the control.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setUseAlpha(self, val='True', **kwargs):
        """
        Is the image using alpha channel?                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setVersion(self, val='True', **kwargs):
        """
        Specify the version that this control feature was introduced. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
        fits the current size of the control given its current style. This command creates an iconTextStaticLabel.
        
        Flags:
          - align : al                     (unicode)       [create,query,edit]
              The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
              only available when -st/style is set to iconAndTextCentered.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - disabledImage : di             (unicode)       [create,query,edit]
              Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
              a Windows only flag.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - flipX : fx                     (bool)          [create,query,edit]
              Is the image flipped horizontally?
        
          - flipY : fy                     (bool)          [create,query,edit]
              Is the image flipped vertically?
        
          - font : fn                      (unicode)       [create,query,edit]
              The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
              smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - image : i                      (unicode)       [create,query,edit]
              If you are not providing images with different sizes then you may use this flag for the control's image. If the
              iconOnlystyle is set, the icon will be scaled to the size of the control.
        
          - image1 : i1                    (unicode)       [create,query,edit]
        
          - image2 : i2                    (unicode)       [create,query,edit]
        
          - image3 : i3                    (unicode)       [create,query,edit]
              This control supports three icons. The icon that best fits the current size of the control will be displayed.
        
          - imageOverlayLabel : iol        (unicode)       [create,query,edit]
              A short string, up to 6 characters, representing a label that will be displayed on top of the image.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - label : l                      (unicode)       [create,query,edit]
              The text that appears in the control.
        
          - labelOffset : lo               (int)           [create,query,edit]
              The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
        
          - ltVersion : lt                 (unicode)       [create,query,edit]
              This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
              specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
              otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
              accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - marginHeight : mh              (int)           [create,query,edit]
              The number of pixels above and below the control content. The default value is 1 pixel.
        
          - marginWidth : mw               (int)           [create,query,edit]
              The number of pixels on either side of the control content. The default value is 1 pixel.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
              The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
        
          - overlayLabelColor : olc        (float, float, float) [create,query,edit]
              The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - rotation : rot                 (float)         [create,query,edit]
              The rotation value of the image in radians.
        
          - style : st                     (unicode)       [create,query,edit]
              The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
              iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
              be scaled to the size of the control.
        
          - useAlpha : ua                  (bool)          [create,query,edit]
              Is the image using alpha channel?
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - version : ver                  (unicode)       [create,query,edit]
              Specify the version that this control feature was introduced. The argument should be given as a string of the version
              number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
              2014).
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.iconTextStaticLabel`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'iconTextStaticLabel'
    
    
    __melui__ = 'iconTextStaticLabel'
    
    
    __readonly__ = {}


class GlRenderEditor(PyUI):
    """
    class counterpart of mel function `glRenderEditor`
    
    Create a glRender view. This is a special view used for hardware rendering. This command is used to create and reparent the view as needed to support panels. See the glRender command for controlling the specific behavior of the hardware rendering. In query mode, return type is based on queried flag.
    """
    
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getLookThru(self, **kwargs):
        """
        Specify which camera the glRender view should be using.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def getViewCameraName(self, **kwargs):
        """
        Returns the name of the current camera used by the glRenderPanel. This is a query only flag.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setLookThru(self, val='True', **kwargs):
        """
        Specify which camera the glRender view should be using.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a glRender view. This is a special view used for hardware rendering. This command is used to create and reparent
        the view as needed to support panels. See the glRender command for controlling the specific behavior of the hardware
        rendering. In query mode, return type is based on queried flag.
        
        Flags:
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - lookThru : lt                  (unicode)       [create,query,edit]
              Specify which camera the glRender view should be using.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - viewCameraName : vcn           (bool)          [query]
              Returns the name of the current camera used by the glRenderPanel. This is a query only flag.                  Flag can
              have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.glRenderEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'glRenderEditor'
    
    
    __melui__ = 'glRenderEditor'
    
    
    __readonly__ = {}


class KeyframeOutliner(PyUI):
    """
    class counterpart of mel function `keyframeOutliner`
    
    This command creates/edits/queries a keyframe outliner control.
    """
    
    
    
    def animCurve(self, val='True', **kwargs):
        """
        Name of the animation curve for which to display keyframes.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getDisplay(self, **kwargs):
        """
        narrow | wide What columns to display.  When narrow, time and value will be displayed, when widetangent information will be displayed as well                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setDisplay(self, val='True', **kwargs):
        """
        narrow | wide What columns to display.  When narrow, time and value will be displayed, when widetangent information will be displayed as well                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        This command creates/edits/queries a keyframe outliner control.
        
        Flags:
          - animCurve : ac                 (unicode)       [edit]
              Name of the animation curve for which to display keyframes.
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - display : dsp                  (unicode)       [query,edit]
              narrow | wide What columns to display.  When narrow, time and value will be displayed, when widetangent information will
              be displayed as well
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.keyframeOutliner`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'keyframeOutliner'
    
    
    __melui__ = 'keyframeOutliner'
    
    
    __readonly__ = {}


class FontDialog(PyUI):
    """
    class counterpart of mel function `fontDialog`
    
    Displays a dialog of available fonts for the user to select from. The name of the selected font is returned, or an empty string if no font was selected. When the FontListflag is used, no dialog is displayed. Instead the command returns an array of the available fonts.
    """
    
    
    
    def __melcmd__(*args, **kwargs):
        """
        Displays a dialog of available fonts for the user to select from. The name of the selected font is returned, or an empty
        string if no font was selected. When the FontListflag is used, no dialog is displayed. Instead the command returns an
        array of the available fonts.
        
        Flags:
          - FontList : fl                  (bool)          [create]
              Returns an array of all available font names. No dialog is displayed.
        
          - scalable : sc                  (bool)          [create]
              Limits the fonts returned or displayed to just those that are scalable.                  Flag can have multiple
              arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.fontDialog`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'fontDialog'
    
    
    __melui__ = 'fontDialog'
    
    
    __readonly__ = {}


class KeyframeStats(PyUI):
    """
    class counterpart of mel function `keyframeStats`
    
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign, and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one column in any group can be adjustable. This command creates, edits, queries a keyframe stats control.
    """
    
    
    
    def adjustableColumn(self, val='True', **kwargs):
        """
        Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based index.  You may also specify 0 to turn off the previous adjustable column.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def adjustableColumn2(self, val='True', **kwargs):
        """
        Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly two columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def adjustableColumn3(self, val='True', **kwargs):
        """
        Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly three columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def adjustableColumn4(self, val='True', **kwargs):
        """
        Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly four columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def adjustableColumn5(self, val='True', **kwargs):
        """
        Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly five columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def adjustableColumn6(self, val='True', **kwargs):
        """
        Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not exactly six columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign(self, val='True', **kwargs):
        """
        Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type for the specified column.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign2(self, val='True', **kwargs):
        """
        Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right, and center.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign3(self, val='True', **kwargs):
        """
        Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right, and center.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign4(self, val='True', **kwargs):
        """
        Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right, and center.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign5(self, val='True', **kwargs):
        """
        Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right, and center.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAlign6(self, val='True', **kwargs):
        """
        Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right, and center.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach(self, val='True', **kwargs):
        """
        Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies column attachment types and offets.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach2(self, val='True', **kwargs):
        """
        Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right, and both.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach3(self, val='True', **kwargs):
        """
        Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right, and both.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach4(self, val='True', **kwargs):
        """
        Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right, and both.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach5(self, val='True', **kwargs):
        """
        Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right, and both.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnAttach6(self, val='True', **kwargs):
        """
        Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right, and both.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnOffset2(self, val='True', **kwargs):
        """
        This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.  Ignored if there are not exactly two columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnOffset3(self, val='True', **kwargs):
        """
        This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.  Ignored if there are not exactly three columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnOffset4(self, val='True', **kwargs):
        """
        This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.  Ignored if there are not exactly four columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnOffset5(self, val='True', **kwargs):
        """
        This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.  Ignored if there are not exactly five columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnOffset6(self, val='True', **kwargs):
        """
        This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.  Ignored if there are not exactly six columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth(self, val='True', **kwargs):
        """
        Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies the column (1 based index) and the second parameter specifies the width.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth1(self, val='True', **kwargs):
        """
        Sets the width of the first column. Ignored if there is not exactly one column.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth2(self, val='True', **kwargs):
        """
        Sets the column widths of both columns. Ignored if there are not exactly two columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth3(self, val='True', **kwargs):
        """
        Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth4(self, val='True', **kwargs):
        """
        Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth5(self, val='True', **kwargs):
        """
        Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def columnWidth6(self, val='True', **kwargs):
        """
        Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getAnimEditor(self, **kwargs):
        """
        The name of the animation editor which is associated with the control                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getPrecision(self, **kwargs):
        """
        Controls the number of digits to the right of the decimal point that will be displayed for float-valued channels. Default is 3.  Queried, returns an int.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getTimeAnnotation(self, **kwargs):
        """
        Annotate the time field with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getValueAnnotation(self, **kwargs):
        """
        Annotate the value field with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def rowAttach(self, val='True', **kwargs):
        """
        Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment types and offsets for the entire row.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setAnimEditor(self, val='True', **kwargs):
        """
        The name of the animation editor which is associated with the control                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setPrecision(self, val='True', **kwargs):
        """
        Controls the number of digits to the right of the decimal point that will be displayed for float-valued channels. Default is 3.  Queried, returns an int.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setTimeAnnotation(self, val='True', **kwargs):
        """
        Annotate the time field with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setValueAnnotation(self, val='True', **kwargs):
        """
        Annotate the value field with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        All of the group commands position their individual controls in columns starting at column 1.  The layout of each
        control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
        and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
        column in any group can be adjustable. This command creates, edits, queries a keyframe stats control.
        
        Flags:
          - adjustableColumn : adj         (int)           [create,edit]
              Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
              index.  You may also specify 0 to turn off the previous adjustable column.
        
          - adjustableColumn2 : ad2        (int)           [create,edit]
              Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
              exactly two columns.
        
          - adjustableColumn3 : ad3        (int)           [create,edit]
              Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
              not exactly three columns.
        
          - adjustableColumn4 : ad4        (int)           [create,edit]
              Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
              exactly four columns.
        
          - adjustableColumn5 : ad5        (int)           [create,edit]
              Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
              exactly five columns.
        
          - adjustableColumn6 : ad6        (int)           [create,edit]
              Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
              exactly six columns.
        
          - animEditor : ae                (unicode)       [query,edit]
              The name of the animation editor which is associated with the control
        
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - classicMode : cm               (bool)          []
        
          - columnAlign : cal              (int, unicode)  [create,edit]
              Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
              for the specified column.
        
          - columnAlign2 : cl2             (unicode, unicode) [create,edit]
              Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
              and center.
        
          - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
              Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
              and center.
        
          - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
              Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
              and center.
        
          - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
              Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
              and center.
        
          - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
              Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
              and center.
        
          - columnAttach : cat             (int, unicode, int) [create,edit]
              Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
              column attachment types and offets.
        
          - columnAttach2 : ct2            (unicode, unicode) [create,edit]
              Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
              and both.
        
          - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
              Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
              and both.
        
          - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
              Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
              and both.
        
          - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
              Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
              and both.
        
          - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
              Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
              and both.
        
          - columnOffset2 : co2            (int, int)      [create,edit]
              This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
              It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
              -columnAttach2 flag.  Ignored if there are not exactly two columns.
        
          - columnOffset3 : co3            (int, int, int) [create,edit]
              This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
              It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
              -columnAttach3 flag.  Ignored if there are not exactly three columns.
        
          - columnOffset4 : co4            (int, int, int, int) [create,edit]
              This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
              It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
              -columnAttach4 flag.  Ignored if there are not exactly four columns.
        
          - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
              This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
              It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
              -columnAttach5 flag.  Ignored if there are not exactly five columns.
        
          - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
              This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
              It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
              -columnAttach6 flag.  Ignored if there are not exactly six columns.
        
          - columnWidth : cw               (int, int)      [create,edit]
              Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
              the column (1 based index) and the second parameter specifies the width.
        
          - columnWidth1 : cw1             (int)           [create,edit]
              Sets the width of the first column. Ignored if there is not exactly one column.
        
          - columnWidth2 : cw2             (int, int)      [create,edit]
              Sets the column widths of both columns. Ignored if there are not exactly two columns.
        
          - columnWidth3 : cw3             (int, int, int) [create,edit]
              Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
        
          - columnWidth4 : cw4             (int, int, int, int) [create,edit]
              Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
        
          - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
              Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
        
          - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
              Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - precision : pre                (int)           [query,edit]
              Controls the number of digits to the right of the decimal point that will be displayed for float-valued channels.
              Default is 3.  Queried, returns an int.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - rowAttach : rat                (int, unicode, int) [create,edit]
              Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
              types and offsets for the entire row.
        
          - timeAnnotation : tan           (unicode)       [create,query,edit]
              Annotate the time field with an extra string value.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - valueAnnotation : van          (unicode)       [create,query,edit]
              Annotate the value field with an extra string value.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.keyframeStats`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'keyframeStats'
    
    
    __melui__ = 'keyframeStats'
    
    
    __readonly__ = {}


class FloatField(PyUI):
    """
    class counterpart of mel function `floatField`
    
    Create a field control that accepts only float values and is bound by a minimum and maximum value.  An invisible slider is attached to the field and accessed by holding down the Ctrl modifier key while pressing one of the mouse buttons.  Dragging the invisible slider to the right with the middle mouse button increases the field value by the amount specified with the -s/stepflag, while dragging to the left decreases the value by the same amount.  The left and right mouse buttons apply a factor of 0.1 and 10 to the step value.
    """
    
    
    
    def changeCommand(self, val='True', **kwargs):
        """
        Command executed when the field changes.  This command is not invoked when the value changes via the -v/valueflag.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def dragCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form: global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that is transferred to the drop site. By convention the first string in the array describes the user settable message type.  Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y, modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def dragCommand(self, val='True', **kwargs):
        """
        Command executed when dragging in the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def dropCallback(self, val='True', **kwargs):
        """
        Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs array describes the user defined message type. Controls that are application defined drop sites may ignore the callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages, x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def enterCommand(self, val='True', **kwargs):
        """
        Command executed when the keypad 'Enter' key is pressed.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getAnnotation(self, **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getBackgroundColor(self, **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getEditable(self, **kwargs):
        """
        The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.  If false then the field can not be changed interactively.  However, you can change the field text with the -v/valueflag regardless of the state of the -ed/editableflag.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getEnable(self, **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getEnableBackground(self, **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getFullPathName(self, **kwargs):
        """
        Return the full path name of the widget, which includes all the parents                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getHeight(self, **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getHighlightColor(self, **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getIsObscured(self, **kwargs):
        """
        Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's window is invisible or iconified.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getManage(self, **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getMaxValue(self, **kwargs):
        """
        Upper limit of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getMinValue(self, **kwargs):
        """
        Lower limit of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getNumberOfPopupMenus(self, **kwargs):
        """
        Return the number of popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getPopupMenuArray(self, **kwargs):
        """
        Return the names of all the popup menus attached to this control.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getPrecision(self, **kwargs):
        """
        Number of digits to the right of the decimal place.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getPreventOverride(self, **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getShowTrailingZeros(self, **kwargs):
        """
        Show trailing zeros or not                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getStep(self, **kwargs):
        """
        Increment for the invisible slider.   The field value will change by this amount when the invisible slider is dragged.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getValue(self, **kwargs):
        """
        Value of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getVisible(self, **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getVisibleChangeCommand(self, **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def getWidth(self, **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def noBackground(self, val='True', **kwargs):
        """
        Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def receiveFocusCommand(self, val='True', **kwargs):
        """
        Command executed when the field receives focus.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setAnnotation(self, val='True', **kwargs):
        """
        Annotate the control with an extra string value.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setBackgroundColor(self, val='True', **kwargs):
        """
        The background color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless enableBackground is also specified with a false value.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt render/multiLister/createNode/material                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setEditable(self, val='True', **kwargs):
        """
        The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.  If false then the field can not be changed interactively.  However, you can change the field text with the -v/valueflag regardless of the state of the -ed/editableflag.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setEnable(self, val='True', **kwargs):
        """
        The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and the control will appear dimmed or greyed-out indicating it is disabled.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setEnableBackground(self, val='True', **kwargs):
        """
        Enables the background color of the control.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setHeight(self, val='True', **kwargs):
        """
        The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setHighlightColor(self, val='True', **kwargs):
        """
        The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each component ranges in value from 0.0 to 1.0.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setManage(self, val='True', **kwargs):
        """
        Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All controls are created managed by default.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setMaxValue(self, val='True', **kwargs):
        """
        Upper limit of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setMinValue(self, val='True', **kwargs):
        """
        Lower limit of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setPrecision(self, val='True', **kwargs):
        """
        Number of digits to the right of the decimal place.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setPreventOverride(self, val='True', **kwargs):
        """
        If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setShowTrailingZeros(self, val='True', **kwargs):
        """
        Show trailing zeros or not                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setStep(self, val='True', **kwargs):
        """
        Increment for the invisible slider.   The field value will change by this amount when the invisible slider is dragged.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setValue(self, val='True', **kwargs):
        """
        Value of the field.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setVisible(self, val='True', **kwargs):
        """
        The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is also dependent on the visible state of its parent layout(s).                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setVisibleChangeCommand(self, val='True', **kwargs):
        """
        Command that gets executed when visible state of the control changes.                  
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def setWidth(self, val='True', **kwargs):
        """
        The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Create a field control that accepts only float values and is bound by a minimum and maximum value.  An invisible slider
        is attached to the field and accessed by holding down the Ctrl modifier key while pressing one of the mouse buttons.
        Dragging the invisible slider to the right with the middle mouse button increases the field value by the amount
        specified with the -s/stepflag, while dragging to the left decreases the value by the same amount.  The left and right
        mouse buttons apply a factor of 0.1 and 10 to the step value.
        
        Flags:
          - annotation : ann               (unicode)       [create,query,edit]
              Annotate the control with an extra string value.
        
          - backgroundColor : bgc          (float, float, float) [create,query,edit]
              The background color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
              enableBackground is also specified with a false value.
        
          - changeCommand : cc             (script)        [create,edit]
              Command executed when the field changes.  This command is not invoked when the value changes via the -v/valueflag.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
              render/multiLister/createNode/material
        
          - dragCallback : dgc             (script)        [create,edit]
              Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
              global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
              is transferred to the drop site. By convention the first string in the array describes the user settable message type.
              Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
              CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
              but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
              argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
              values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
              Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
              standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
              modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(x)d %(y)d %(modifiers)d'
        
          - dragCommand : dc               (script)        [create,edit]
              Command executed when dragging in the field.
        
          - dropCallback : dpc             (script)        [create,edit]
              Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
              callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
              $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
              array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
              $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
              the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
              callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
              these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
              specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
              Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
              x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
              '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
        
          - editable : ed                  (bool)          [create,query,edit]
              The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
              If false then the field can not be changed interactively.  However, you can change the field text with the -v/valueflag
              regardless of the state of the -ed/editableflag.
        
          - enable : en                    (bool)          [create,query,edit]
              The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
              the control will appear dimmed or greyed-out indicating it is disabled.
        
          - enableBackground : ebg         (bool)          [create,query,edit]
              Enables the background color of the control.
        
          - enterCommand : ec              (script)        [create,edit]
              Command executed when the keypad 'Enter' key is pressed.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - fullPathName : fpn             (bool)          [query]
              Return the full path name of the widget, which includes all the parents
        
          - height : h                     (int)           [create,query,edit]
              The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
        
          - highlightColor : hlc           (float, float, float) [create,query,edit]
              The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0.
        
          - isObscured : io                (bool)          [query]
              Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
              it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
              window is invisible or iconified.
        
          - manage : m                     (bool)          [create,query,edit]
              Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
              controls are created managed by default.
        
          - maxValue : max                 (float)         [create,query,edit]
              Upper limit of the field.
        
          - minValue : min                 (float)         [create,query,edit]
              Lower limit of the field.
        
          - noBackground : nbg             (bool)          [create,edit]
              Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
              background should be drawn.  The state of this flag is inherited by children of this control.
        
          - numberOfPopupMenus : npm       (bool)          [query]
              Return the number of popup menus attached to this control.
        
          - parent : p                     (unicode)       [create,query]
              The parent layout for this control.
        
          - popupMenuArray : pma           (bool)          [query]
              Return the names of all the popup menus attached to this control.
        
          - precision : pre                (int)           [create,query,edit]
              Number of digits to the right of the decimal place.
        
          - preventOverride : po           (bool)          [create,query,edit]
              If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
        
          - receiveFocusCommand : rfc      (script)        [create,edit]
              Command executed when the field receives focus.
        
          - showTrailingZeros : tze        (bool)          [create,query,edit]
              Show trailing zeros or not
        
          - step : s                       (float)         [create,query,edit]
              Increment for the invisible slider.   The field value will change by this amount when the invisible slider is dragged.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - value : v                      (float)         [create,query,edit]
              Value of the field.
        
          - visible : vis                  (bool)          [create,query,edit]
              The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
              also dependent on the visible state of its parent layout(s).
        
          - visibleChangeCommand : vcc     (script)        [create,query,edit]
              Command that gets executed when visible state of the control changes.
        
          - width : w                      (int)           [create,query,edit]
              The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
              Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.floatField`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'floatField'
    
    
    __melui__ = 'floatField'
    
    
    __readonly__ = {}


class AnimCurveEditor(PyUI):
    """
    class counterpart of mel function `animCurveEditor`
    
    Edit a characteristic of a graph editor
    """
    
    
    
    def denormalizeCurvesCommand(self, val='True', **kwargs):
        """
        Sets the script that is run to denormalize curves in the graph editor. This is intended for internal use only.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayActiveKeyTangents(self, val='True', **kwargs):
        """
        on | off | tgl Display active key tangents in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayActiveKeys(self, val='True', **kwargs):
        """
        on | off | tgl Display active keys in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayInfinities(self, val='True', **kwargs):
        """
        on | off | tgl Display infinities in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayKeys(self, val='True', **kwargs):
        """
        on | off | tgl Display keyframes in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayTangents(self, val='True', **kwargs):
        """
        on | off | tgl Display tangents in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def displayValues(self, val='True', **kwargs):
        """
        on | off | tgl Display active keys and tangents values in the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getAreCurvesSelected(self, **kwargs):
        """
        Returns a boolean to know if at least one curve is selected in the graph editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getAutoFit(self, **kwargs):
        """
        on | off | tgl Auto fit-to-view.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getClassicMode(self, **kwargs):
        """
        When on, the graph editor is displayed in Classic Mode, otherwise Suites Modeis used.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getClipTime(self, **kwargs):
        """
        Valid values: onoffDisplay the clips with their offset and scale applied to the anim curves in the clip.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getConstrainDrag(self, **kwargs):
        """
        Constrains all Graph Editor animation curve drag operations to either the X-axis, the Y-axis, or to neither of those axes. Values to supply are: 0 for not constraining any axis, 1 for constraing the X-axis, or 2 for constraining the Y-axis. When used in queries, this flag returns the latter values and these values have the same interpretation as above. Note: when the shift key is pressed before dragging the animation curve, the first mouse movement will instead determine (and override) any prior set constrained axis.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getCurvesShown(self, **kwargs):
        """
        Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getCurvesShownForceUpdate(self, **kwargs):
        """
        Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor. Unlike the curvesShown flag, this will force an update of the graph editor for the case where the mainListConnection has been modified since the last refresh.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getDisplayNormalized(self, **kwargs):
        """
        When on, display all curves normalized to the range -1 to +1.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getKeyingTime(self, **kwargs):
        """
        The current time in the given curve to be keyed in the graph editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getOutliner(self, **kwargs):
        """
        The name of the outliner that is associated with the graph editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getPreSelectionHighlight(self, **kwargs):
        """
        When on, the curve/key/tangent under the mouse pointer is highlighted to ease selection.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getResultSamples(self, **kwargs):
        """
        Specify the sampling for result curves Note: the smaller this number is, the longer it will take to update the display.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getResultScreenSamples(self, **kwargs):
        """
        Specify the screen base result sampling for result curves. If 0, then results are sampled in time.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getResultUpdate(self, **kwargs):
        """
        Valid values: interactivedelayedControls how changes to animCurves are reflected in the result curves (if results are being shown).  If resultUpdate is interactive, then as interactive changes are being made to the animCurve, the result curves will be updated.  If modelUpdate is delayed (which is the default setting), then result curves are updated once the final change to an animCurve has been made.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getShowActiveCurveNames(self, **kwargs):
        """
        Display the active curve(s)'s name.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getShowBufferCurves(self, **kwargs):
        """
        Valid values: onofftglDisplay buffer curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getShowCurveNames(self, **kwargs):
        """
        Display the curves's name.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getShowResults(self, **kwargs):
        """
        Valid values: onofftglDisplay result curves from expression or other non-keyed action.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getShowUpstreamCurves(self, **kwargs):
        """
        If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getSmoothness(self, **kwargs):
        """
        Valid values: coarseroughmediumfineSpecify the display smoothness of animation curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getSnapTime(self, **kwargs):
        """
        none | integer | keyframe Keyframe move snap in time.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getSnapValue(self, **kwargs):
        """
        none | integer | keyframe Keyframe move snap in values.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getStackedCurves(self, **kwargs):
        """
        Switches the display mode between normal (all curves sharing one set of axes) to stacked (each curve on its own value axis, stacked vertically).                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getStackedCurvesMax(self, **kwargs):
        """
        Sets the maximum value on the per-curve value axis when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getStackedCurvesMin(self, **kwargs):
        """
        Sets the minimum value on the per-curve value axis when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getStackedCurvesSpace(self, **kwargs):
        """
        Sets the spacing between curves when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def lookAt(self, val='True', **kwargs):
        """
        all | selected | currentTime FitView helpers.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def normalizeCurvesCommand(self, val='True', **kwargs):
        """
        Sets the script that is run to normalize curves in the graph editor. This is intended for internal use only.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def renormalizeCurves(self, val='True', **kwargs):
        """
        This flag causes the curve normalization factors to be recalculated.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setAutoFit(self, val='True', **kwargs):
        """
        on | off | tgl Auto fit-to-view.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setClassicMode(self, val='True', **kwargs):
        """
        When on, the graph editor is displayed in Classic Mode, otherwise Suites Modeis used.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setClipTime(self, val='True', **kwargs):
        """
        Valid values: onoffDisplay the clips with their offset and scale applied to the anim curves in the clip.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setConstrainDrag(self, val='True', **kwargs):
        """
        Constrains all Graph Editor animation curve drag operations to either the X-axis, the Y-axis, or to neither of those axes. Values to supply are: 0 for not constraining any axis, 1 for constraing the X-axis, or 2 for constraining the Y-axis. When used in queries, this flag returns the latter values and these values have the same interpretation as above. Note: when the shift key is pressed before dragging the animation curve, the first mouse movement will instead determine (and override) any prior set constrained axis.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setDisplayNormalized(self, val='True', **kwargs):
        """
        When on, display all curves normalized to the range -1 to +1.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setDocTag(self, val='True', **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setFilter(self, val='True', **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setForceMainConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setHighlightConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setMainListConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setOutliner(self, val='True', **kwargs):
        """
        The name of the outliner that is associated with the graph editor.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setParent(self, val='True', **kwargs):
        """
        Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setPreSelectionHighlight(self, val='True', **kwargs):
        """
        When on, the curve/key/tangent under the mouse pointer is highlighted to ease selection.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setResultSamples(self, val='True', **kwargs):
        """
        Specify the sampling for result curves Note: the smaller this number is, the longer it will take to update the display.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setResultScreenSamples(self, val='True', **kwargs):
        """
        Specify the screen base result sampling for result curves. If 0, then results are sampled in time.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setResultUpdate(self, val='True', **kwargs):
        """
        Valid values: interactivedelayedControls how changes to animCurves are reflected in the result curves (if results are being shown).  If resultUpdate is interactive, then as interactive changes are being made to the animCurve, the result curves will be updated.  If modelUpdate is delayed (which is the default setting), then result curves are updated once the final change to an animCurve has been made.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setSelectionConnection(self, val='True', **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setShowActiveCurveNames(self, val='True', **kwargs):
        """
        Display the active curve(s)'s name.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setShowBufferCurves(self, val='True', **kwargs):
        """
        Valid values: onofftglDisplay buffer curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setShowCurveNames(self, val='True', **kwargs):
        """
        Display the curves's name.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setShowResults(self, val='True', **kwargs):
        """
        Valid values: onofftglDisplay result curves from expression or other non-keyed action.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setShowUpstreamCurves(self, val='True', **kwargs):
        """
        If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setSmoothness(self, val='True', **kwargs):
        """
        Valid values: coarseroughmediumfineSpecify the display smoothness of animation curves.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setSnapTime(self, val='True', **kwargs):
        """
        none | integer | keyframe Keyframe move snap in time.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setSnapValue(self, val='True', **kwargs):
        """
        none | integer | keyframe Keyframe move snap in values.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setStackedCurves(self, val='True', **kwargs):
        """
        Switches the display mode between normal (all curves sharing one set of axes) to stacked (each curve on its own value axis, stacked vertically).                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setStackedCurvesMax(self, val='True', **kwargs):
        """
        Sets the maximum value on the per-curve value axis when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setStackedCurvesMin(self, val='True', **kwargs):
        """
        Sets the minimum value on the per-curve value axis when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def setStackedCurvesSpace(self, val='True', **kwargs):
        """
        Sets the spacing between curves when in stacked mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def unParent(self, val='True', **kwargs):
        """
        Specifies that the editor should be removed from its layout. This cannot be used in query mode.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def unlockMainConnection(self, val='True', **kwargs):
        """
        Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic updates.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def updateMainConnection(self, val='True', **kwargs):
        """
        Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.                  
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def valueLinesToggle(self, val='True', **kwargs):
        """
        on | off | tgl Display the value lines for high/low/zero of selected curves in the editor                  Flag can have multiple arguments, passed either as a tuple or a list.             
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        Edit a characteristic of a graph editor
        
        Flags:
          - acs : acs                      (areCurvesSelected) []
        
          - areCurvesSelected : acs        (bool)          [query]
              Returns a boolean to know if at least one curve is selected in the graph editor.
        
          - autoFit : af                   (unicode)       [query,edit]
              on | off | tgl Auto fit-to-view.
        
          - classicMode : cm               (bool)          [query,edit]
              When on, the graph editor is displayed in Classic Mode, otherwise Suites Modeis used.
        
          - clipTime : ct                  (unicode)       [query,edit]
              Valid values: onoffDisplay the clips with their offset and scale applied to the anim curves in the clip.
        
          - constrainDrag : cd             (int)           [create,query,edit]
              Constrains all Graph Editor animation curve drag operations to either the X-axis, the Y-axis, or to neither of those
              axes. Values to supply are: 0 for not constraining any axis, 1 for constraing the X-axis, or 2 for constraining the
              Y-axis. When used in queries, this flag returns the latter values and these values have the same interpretation as
              above. Note: when the shift key is pressed before dragging the animation curve, the first mouse movement will instead
              determine (and override) any prior set constrained axis.
        
          - control : ctl                  (bool)          [query]
              Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
              Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
        
          - curvesShown : cs               (bool)          [query]
              Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor.
        
          - curvesShownForceUpdate : csf   (bool)          [query]
              Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor. Unlike the
              curvesShown flag, this will force an update of the graph editor for the case where the mainListConnection has been
              modified since the last refresh.
        
          - defineTemplate : dt            (unicode)       [create]
              Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
              argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
              as the current template.
        
          - denormalizeCurvesCommand : dcc (unicode)       [create,edit]
              Sets the script that is run to denormalize curves in the graph editor. This is intended for internal use only.
        
          - displayActiveKeyTangents : dat (unicode)       [edit]
              on | off | tgl Display active key tangents in the editor.
        
          - displayActiveKeys : dak        (unicode)       [edit]
              on | off | tgl Display active keys in the editor.
        
          - displayInfinities : di         (unicode)       [edit]
              on | off | tgl Display infinities in the editor.
        
          - displayKeys : dk               (unicode)       [edit]
              on | off | tgl Display keyframes in the editor.
        
          - displayNormalized : dn         (bool)          [query,edit]
              When on, display all curves normalized to the range -1 to +1.
        
          - displayTangents : dtn          (unicode)       [edit]
              on | off | tgl Display tangents in the editor.
        
          - displayValues : dv             (unicode)       [edit]
              on | off | tgl Display active keys and tangents values in the editor.
        
          - docTag : dtg                   (unicode)       [create,query,edit]
              Attaches a tag to the editor.
        
          - exists : ex                    (bool)          [create]
              Returns whether the specified object exists or not. Other flags are ignored.
        
          - filter : f                     (unicode)       [create,query,edit]
              Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
              main list of the editor.
        
          - forceMainConnection : fmc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
              that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
              -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
        
          - highlightConnection : hlc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
              editors have a highlight list. For those that do, it is a secondary selection list.
        
          - keyingTime : kt                (unicode)       [query]
              The current time in the given curve to be keyed in the graph editor.
        
          - lockMainConnection : lck       (bool)          [create,edit]
              Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
              Further changes to the original mainConnection are ignored.
        
          - lookAt : la                    (unicode)       [edit]
              all | selected | currentTime FitView helpers.
        
          - mainListConnection : mlc       (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
              only display items contained in the selectionConnection object.
        
          - menu : m                       (script)        [create]
              Specify a script to be run when the editor is created.  The function will be passed one string argument which is the new
              editor's name.
        
          - normalizeCurvesCommand : ncc   (unicode)       [create,edit]
              Sets the script that is run to normalize curves in the graph editor. This is intended for internal use only.
        
          - outliner : o                   (unicode)       [query,edit]
              The name of the outliner that is associated with the graph editor.
        
          - panel : pnl                    (unicode)       [create,query]
              Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
              will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
              deleted.
        
          - parent : p                     (unicode)       [create,query,edit]
              Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
        
          - preSelectionHighlight : psh    (bool)          [query,edit]
              When on, the curve/key/tangent under the mouse pointer is highlighted to ease selection.
        
          - renormalizeCurves : rnc        (bool)          [edit]
              This flag causes the curve normalization factors to be recalculated.
        
          - resultSamples : rs             (time)          [query,edit]
              Specify the sampling for result curves Note: the smaller this number is, the longer it will take to update the display.
        
          - resultScreenSamples : rss      (int)           [query,edit]
              Specify the screen base result sampling for result curves. If 0, then results are sampled in time.
        
          - resultUpdate : ru              (unicode)       [query,edit]
              Valid values: interactivedelayedControls how changes to animCurves are reflected in the result curves (if results are
              being shown).  If resultUpdate is interactive, then as interactive changes are being made to the animCurve, the result
              curves will be updated.  If modelUpdate is delayed (which is the default setting), then result curves are updated once
              the final change to an animCurve has been made.
        
          - selectionConnection : slc      (unicode)       [create,query,edit]
              Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
              user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
              changes, the editor updates to show the changes.
        
          - showActiveCurveNames : acn     (bool)          [query,edit]
              Display the active curve(s)'s name.
        
          - showBufferCurves : sb          (unicode)       [query,edit]
              Valid values: onofftglDisplay buffer curves.
        
          - showCurveNames : scn           (bool)          [query,edit]
              Display the curves's name.
        
          - showResults : sr               (unicode)       [query,edit]
              Valid values: onofftglDisplay result curves from expression or other non-keyed action.
        
          - showUpstreamCurves : suc       (bool)          [query,edit]
              If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves
              for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual
              animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that,
              even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.
        
          - smoothness : s                 (unicode)       [query,edit]
              Valid values: coarseroughmediumfineSpecify the display smoothness of animation curves.
        
          - snapTime : st                  (unicode)       [query,edit]
              none | integer | keyframe Keyframe move snap in time.
        
          - snapValue : sv                 (unicode)       [query,edit]
              none | integer | keyframe Keyframe move snap in values.
        
          - stackedCurves : sc             (bool)          [query,edit]
              Switches the display mode between normal (all curves sharing one set of axes) to stacked (each curve on its own value
              axis, stacked vertically).
        
          - stackedCurvesMax : scx         (float)         [query,edit]
              Sets the maximum value on the per-curve value axis when in stacked mode.
        
          - stackedCurvesMin : scm         (float)         [query,edit]
              Sets the minimum value on the per-curve value axis when in stacked mode.
        
          - stackedCurvesSpace : scs       (float)         [query,edit]
              Sets the spacing between curves when in stacked mode.
        
          - stateString : sts              (bool)          [query]
              Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
              command string uses the string variable $editorName in place of a specific name.
        
          - unParent : up                  (bool)          [create,edit]
              Specifies that the editor should be removed from its layout. This cannot be used in query mode.
        
          - unlockMainConnection : ulk     (bool)          [create,edit]
              Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
              updates.
        
          - updateMainConnection : upd     (bool)          [create,edit]
              Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
        
          - useTemplate : ut               (unicode)       [create]
              Forces the command to use a command template other than the current one.
        
          - valueLinesToggle : vlt         (unicode)       [edit]
              on | off | tgl Display the value lines for high/low/zero of selected curves in the editor                  Flag can have
              multiple arguments, passed either as a tuple or a list.
        
          - viewLeft : vl                  (float)         []
        
          - viewRight : vr                 (float)         []
        
        
        Derived from mel command `maya.cmds.animCurveEditor`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'animCurveEditor'
    
    
    __melui__ = 'animCurveEditor'
    
    
    __readonly__ = {}


class PromptDialog(PyUI):
    """
    class counterpart of mel function `promptDialog`
    
    The promptDialog command creates a modal dialog with a message to the user, a text field in which the user may enter a response, and a variable number of buttons to dismiss the dialog.  The dialog is dismissed when the user presses any button or chooses the close item from the window menu.  In the case where a button is pressed then the name of the button selected is returned.  If the dialog is dismissed via the close item then the string returned is specified by the -ds/dismissStringflag. The default behaviour when no arguments are specified is to create an empty single button dialog. To obtain the text entered by the user simply query the -tx/textflag.
    """
    
    
    
    def getText(self, **kwargs):
        """
        The field text.                  
        
        
        Derived from mel command `maya.cmds.promptDialog`
        """
    
        pass
    
    
    def __melcmd__(*args, **kwargs):
        """
        The promptDialog command creates a modal dialog with a message to the user, a text field in which the user may enter a
        response, and a variable number of buttons to dismiss the dialog.  The dialog is dismissed when the user presses any
        button or chooses the close item from the window menu.  In the case where a button is pressed then the name of the
        button selected is returned.  If the dialog is dismissed via the close item then the string returned is specified by the
        -ds/dismissStringflag. The default behaviour when no arguments are specified is to create an empty single button dialog.
        To obtain the text entered by the user simply query the -tx/textflag.
        
        Flags:
          - backgroundColor : bgc          (float, float, float) [create]
              The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each
              component ranges in value from 0.0 to 1.0. (Windows only flag)
        
          - button : b                     (unicode)       [create]
              Create a button with the given string as it's text.
        
          - cancelButton : cb              (unicode)       [create]
              The cancel button is activated by pressing the escape key. Note that this flag does not create a button, it simply
              indicates which button created via the -b/buttonflag shall respond to the escape key.
        
          - defaultButton : db             (unicode)       [create]
              The default button is activated by pressing the enter key. Note that this flag does not create a button, it simply
              indicates which button created via the -b/buttonflag shall respond to the enter key.
        
          - dismissString : ds             (unicode)       [create]
              The string returned when the user selects the 'Close' item from the Window Manager menu.  If this flag is not set then
              the string dismissis returned.
        
          - message : m                    (unicode)       [create]
              The message text appearing in the dialog.
        
          - messageAlign : ma              (unicode)       [create]
              Align the message left, center, or right.
        
          - parent : p                     (unicode)       [create]
              Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
              parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
        
          - scrollableField : sf           (bool)          [create]
              By default a single line text field is used in the dialog. Specify true for a multi-line scroll field.
        
          - style : st                     (unicode)       [create]
              Specify the type of input expected in the input field. Vaid input types are integerfloattext. If this flag is not
              specified, we assume the input type is text.
        
          - text : tx                      (unicode)       [create,query]
              The field text.
        
          - title : t                      (unicode)       [create]
              The dialog title.                  Flag can have multiple arguments, passed either as a tuple or a list.
        
        
        Derived from mel command `maya.cmds.promptDialog`
        """
    
        pass
    
    
    __melcmd_isinfo__ = False
    
    
    __melcmdname__ = 'promptDialog'
    
    
    __melui__ = 'promptDialog'
    
    
    __readonly__ = {}


class RenderWindowEditor(PyUI):
    """
    class counterpart of mel function `renderWindowEditor`
    
    Create a editor window that can receive the result of the rendering process
    """
    
    
    
    def colorManage(self, val='True', **kwargs):
        """
        When used with the writeImage flag, causes the written image to be color-managed using the settings from the view color manager attached to the view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getAutoResize(self, **kwargs):
        """
        Lets the render view editor automatically resize the viewport or not.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getBlendMode(self, **kwargs):
        """
        Sets the blend mode for the render view. New image sent to the render view will be blended with the previous image in the render view, and the composited image will appear.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCaption(self, **kwargs):
        """
        Sets the caption which appears at the bottom of the render view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getChangeCommand(self, **kwargs):
        """
        Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the command when something changes in the editor The command should have this prototype :  command(string $editor, string $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2: buffer (single/double)3: axis 4: image displayed5: image saved in memory
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getClear(self, **kwargs):
        """
        Clear the image with the given color at the given resolution. Argumnets are respecively: width height red green blue.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCmEnabled(self, **kwargs):
        """
        Turn on or off applying color management in the View.  If set, the color management configuration set in the current view is used.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCompDisplay(self, **kwargs):
        """
        0 : disable compositing.1 : displays the composited image immediately. For example, when foreground layer tile is sent to the render view window, the composited tile is displayed in the render view window, and the original foreground layer tile is not displayed.2 : display the un-composited image, and keep the composited image for the future command. For example, when foreground layer tile is sent to the render view window, the original foreground layer tile is not displayed, and the composited tile is stored in a buffer.3 : show the current composited image. If there is a composited image in the buffer, display it.
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCompImageFile(self, **kwargs):
        """
        Open the given image file and blend with the buffer as if the image was just rendered.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getControl(self, **kwargs):
        """
        Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus. Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCurrentCamera(self, **kwargs):
        """
        Get or set the current camera. (used when redoing last render)                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getCurrentCameraRig(self, **kwargs):
        """
        Get or set the current camera rig name. If a camera rig is specified, it will be used when redoing the last render as opposed to the currentCamera value, as the currentCamera value will hold the child camera last used for rendering the camera rig.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDisplayImage(self, **kwargs):
        """
        Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack using the si/saveImageflag.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDisplayImageViewCount(self, **kwargs):
        """
        Query the number of views stored for a given image in the Editor Image Stack. This is not the same as querying using viewImageCountwhich returns the number of views for the current rendered image.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDisplayStyle(self, **kwargs):
        """
        Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask channellumto display the luminance of the image
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDocTag(self, **kwargs):
        """
        Attaches a tag to the editor.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDoubleBuffer(self, **kwargs):
        """
        Set the display in double buffer mode                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getDrawAxis(self, **kwargs):
        """
        Set or query whether the axis will be drawn.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getEditorName(self, **kwargs):
        """
        Returns the name of the editor, or an empty string if the editor has not been created yet.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getExposure(self, **kwargs):
        """
        The exposure value used by the color management of the current view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getFilter(self, **kwargs):
        """
        Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the main list of the editor.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getForceMainConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getFrameImage(self, **kwargs):
        """
        Frames the image inside the window.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getFrameRegion(self, **kwargs):
        """
        Frames the region inside the window.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getGamma(self, **kwargs):
        """
        The gamma value used by the color management of the current view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getHighlightConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all editors have a highlight list. For those that do, it is a secondary selection list.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getMainListConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will only display items contained in the selectionConnection object.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getMarquee(self, **kwargs):
        """
        The arguments define the four corners of a rectangle: top left bottom right. The rectangle defines a marquee for the render computation.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getNbImages(self, **kwargs):
        """
        returns the number of images                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getPanel(self, **kwargs):
        """
        Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is deleted.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getPcaption(self, **kwargs):
        """
        Get or set the permanent caption which appears under the image that is currently showing in the render editor.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getRealSize(self, **kwargs):
        """
        Display the image with a one to one pixel match.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getResetRegion(self, **kwargs):
        """
        Forces a reset of any marquee/region.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getScaleBlue(self, **kwargs):
        """
        Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getScaleGreen(self, **kwargs):
        """
        Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getScaleRed(self, **kwargs):
        """
        Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getSelectionConnection(self, **kwargs):
        """
        Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes changes, the editor updates to show the changes.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getShowRegion(self, **kwargs):
        """
        Shows the current region at the given resolution. The two parameters define the width and height.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getSingleBuffer(self, **kwargs):
        """
        Set the display in single buffer mode                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getSnapshot(self, **kwargs):
        """
        Makes a copy of the camera of the model editor at the given size. First argument is the editor name, second is the width, third is the height.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getStateString(self, **kwargs):
        """
        Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned command string uses the string variable $editorName in place of a specific name.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getStereo(self, **kwargs):
        """
        Puts the editor into stereo image mode.  The effective resolution of the output image is twice the size of the horizontal size. The orientation of the images can be set using the stereoOrientation flag.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getStereoImageOrientation(self, **kwargs):
        """
        Specifies the orientation of stereo camera renders.  The first argument specifies the orientation value for the firstleft image and the second argument specifies the orientation value for the right image. The orientation values are 'normal', the image appears as seen throught he camera, or 'mirrored', the image is mirrored horizontally.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getStereoMode(self, **kwargs):
        """
        Specifies how the image is displayed in the view.  By default the stereo is rendered with a side by side image.  The rendered image is a single image that is twice the size of a normal image, 'both'. Users can also choose to display as 'redcyan', 'redcyanlum', 'leftonly', 'rightonly', or 'stereo'.  both - displays both the left and right redcyan - displays the images as a red/cyan pair. redcyanlum - displays the luminance of the images as a red/cyan pair. leftonly - displays the left side only rightonly - displays the right side only stereo - mode that supports Crystal Eyes(tm) or Zscreen (tm) renders                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getToggle(self, **kwargs):
        """
        Turns the ground plane display on/off.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getViewImageCount(self, **kwargs):
        """
        The render editor has the capability to render multiple cameras within a single view. This is different from image binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-side. The viewImageCount flag tells the editor that it should prepare its internal image storage mechanism for a given number of views.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def getViewTransformName(self, **kwargs):
        """
        Sets/gets the view transform to be applied if color management is enabled in the current view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def loadImage(self, val='True', **kwargs):
        """
        load an image from disk and set it as the current Editor Image                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def lockMainConnection(self, val='True', **kwargs):
        """
        Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor. Further changes to the original mainConnection are ignored.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def nextViewImage(self, val='True', **kwargs):
        """
        The render editor has the capability to render multiple cameras within a single view. This is different from image binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-side. The nextViewImage flag tells the editor that it should prepare its internal image storage mechanism to store to the next view location.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def refresh(self, val='True', **kwargs):
        """
        requests a refresh of the current Editor Image.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def removeAllImages(self, val='True', **kwargs):
        """
        remove all the Editor Images from the Editor Image Stack                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def removeImage(self, val='True', **kwargs):
        """
        remove the current Editor Image from the Editor Image Stack                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def resetViewImage(self, val='True', **kwargs):
        """
        The render editor has the capability to render multiple cameras within a single view. This is different from image binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-side. The resetViewImage flag tells the editor that it should reset its internal image storage mechanism to the first image. This would happen at the very start of a render view render.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def saveImage(self, val='True', **kwargs):
        """
        save the current Editor Image to memory. Saved Editor Images are stored in an Editor Image Stack. The most recently saved image is stored in position 0, the second most recently saved image in position 1, and so on... To set the current Editor Image to a previously saved image use the di/displayImageflag.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setAutoResize(self, val='True', **kwargs):
        """
        Lets the render view editor automatically resize the viewport or not.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setBlendMode(self, val='True', **kwargs):
        """
        Sets the blend mode for the render view. New image sent to the render view will be blended with the previous image in the render view, and the composited image will appear.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCaption(self, val='True', **kwargs):
        """
        Sets the caption which appears at the bottom of the render view.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setChangeCommand(self, val='True', **kwargs):
        """
        Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the command when something changes in the editor The command should have this prototype :  command(string $editor, string $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2: buffer (single/double)3: axis 4: image displayed5: image saved in memory
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setClear(self, val='True', **kwargs):
        """
        Clear the image with the given color at the given resolution. Argumnets are respecively: width height red green blue.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCmEnabled(self, val='True', **kwargs):
        """
        Turn on or off applying color management in the View.  If set, the color management configuration set in the current view is used.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCompDisplay(self, val='True', **kwargs):
        """
        0 : disable compositing.1 : displays the composited image immediately. For example, when foreground layer tile is sent to the render view window, the composited tile is displayed in the render view window, and the original foreground layer tile is not displayed.2 : display the un-composited image, and keep the composited image for the future command. For example, when foreground layer tile is sent to the render view window, the original foreground layer tile is not displayed, and the composited tile is stored in a buffer.3 : show the current composited image. If there is a composited image in the buffer, display it.
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCompImageFile(self, val='True', **kwargs):
        """
        Open the given image file and blend with the buffer as if the image was just rendered.                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCurrentCamera(self, val='True', **kwargs):
        """
        Get or set the current camera. (used when redoing last render)                  
        
        
        Derived from mel command `maya.cmds.renderWindowEditor`
        """
    
        pass
    
    
    def setCurrentCameraRig(self, val='True', **kwargs):
        """
        Get or set the current camera rig name. If a camera rig is specified, it will be used when redoing the last render as opposed to the currentCamera value, as the currentCamera value will hold the child camera last used for re