#ifndef _hwReflectBumpShader_NV20
#define _hwReflectBumpShader_NV20

//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

///////////////////////////////////////////////////////////////////
//
// NOTE: PLEASE READ THE README.TXT FILE FOR INSTRUCTIONS ON
// COMPILING AND USAGE REQUIREMENTS.
//
// DESCRIPTION: NV20-specific (Geforce3) sample shader.
//				This shader can simultaneously display a
//				bumpy, reflective surface. The bump
//				is controlled through a user-specified
//				2D texture, while the reflection map
//				is a cube map.
//
//  This shader builds on the foundation demonstrated in 
//  hwUnlitShader.
//
//	Additionally, this sample demonstrates how to:
//		- Use vendor-specific extensions, namely vertex programs,
//		  texture shaders and register combiners, to achieve
//		  effects that are impossible in standard OpenGL.
//		- Convert height field bump format (used by Maya) into
//		  a normal map format, for real-time rendering.
//
//  Many parameters are easily customizable:
//		- The MNormalMapConverter::convertToNormalMap_InPlace()
//        bumpScale parameter is currently constant. You can change
//		  it to a different value to increase or decrease the 
//		  bumpiness.
//
///////////////////////////////////////////////////////////////////

#include <maya/MPxHwShaderNode.h>
#include <maya/MQuaternion.h>
#include <maya/MMatrix.h>
#include <maya/MPoint.h>

#include "MTextureCache.h"

class hwReflectBumpShader_NV20 : public MPxHwShaderNode
{
public:
                    hwReflectBumpShader_NV20();
    virtual         ~hwReflectBumpShader_NV20();
	void			releaseEverything();

    virtual MStatus compute( const MPlug&, MDataBlock& );
	virtual void      postConstructor();

	virtual MStatus	bind(const MDrawRequest& request,
						 M3dView& view);

	virtual MStatus	unbind(const MDrawRequest& request,
						   M3dView& view);

	virtual MStatus	geometry( const MDrawRequest& request,
							  M3dView& view,
							  int prim,
							  unsigned int writable,
							  int indexCount,
							  const unsigned int * indexArray,
							  int vertexCount,
							  const int * vertexIDs,
							  const float * vertexArray,
							  int normalCount,
							  const float ** normalArrays,
							  int colorCount,
							  const float ** colorArrays,
							  int texCoordCount,
							  const float ** texCoordArrays);

	virtual int		normalsPerVertex();
	virtual int		texCoordsPerVertex();

    static  void *  creator();
    static  MStatus initialize();
    static  MTypeId id;

	// We want to share the textures for this effect,
	// otherwise we will get the same 6 cube maps
	// for every surface using this effect.
	MTextureCache*	m_pTextureCache;

	GLuint			vertex_program_id;				// Vertex program handle
	void			loadVertexProgramGL();
	void			printGlError( const char *call );
	void			verify_shader_config(M3dView& view);

	void			init_ext(const char *ext);
	MStatus			getFloat3(MObject colorAttr, float colorValue[3]);
	MStatus			getString(MObject attr, MString &str);

	MPoint			cameraPosWS;
	vec3f			cameraRotation;

	float			refractionValue;
	float			bumpScale;
	bool			cubeMapOnly;

protected:
	void			clearTexCoords();

    static MObject  colorR;
	static MObject  colorG;
	static MObject  colorB;
	static MObject  color;
	static MObject  bumpR;
	static MObject  bumpG;
	static MObject  bumpB;
	static MObject	bump;
    static MObject  uCoord;
	static MObject  vCoord;
	static MObject  uvCoord;
    static MObject  uBias;
	static MObject  vBias;
    static MObject  uvFilterSize;
    static MObject  uvFilterSizeX;
    static MObject  uvFilterSizeY;

    static MObject  refraction;
	static MObject  bumpiness;

	MImage theImage_XP;
	MImage theImage_XN;
	MImage theImage_YP;
	MImage theImage_YN;
	MImage theImage_ZP;
	MImage theImage_ZN;
	GLuint texNames[6];
	MString currentTextureNames[6];

	int texCoordAllocationSize;
	float* texCoordArray1;
	float* texCoordArray2; 
	float* texCoordArray3;

	// Callbacks that we monitor so we can release OpenGL-dependant resources before
	// their context gets destroyed.
	MCallbackId fBeforeNewCB;
	MCallbackId fBeforeOpenCB;
	MCallbackId fBeforeRemoveReferenceCB;
	MCallbackId fMayaExitingCB;

	void attachSceneCallbacks();
	void detachSceneCallbacks();

	static void releaseCallback(void* clientData);

private:
	MQuaternion m_CameraRotation;
	MMatrix		m_ModelMatrix;
};

#endif /* _hwReflectBumpShader_NV20 */
