#ifndef MAYA_API_MNormalMapConverter
#define MAYA_API_MNormalMapConverter


// MNormalMapConverter.h

//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

class MNormalMapConverter
{
public:
	enum OutFormatType
	{
		RGBA,
		HILO
	};

	MNormalMapConverter(){};
	~MNormalMapConverter(){};

	// These functions assume the that file texture is square, and
	// that its dimensions are exponents of 2.
	//

	// Convert the heightfield texture to its corresponding normal map texture
	//
	bool convertToNormalMap(
		unsigned char* inImagePtr,
		unsigned int width,
		unsigned int height,
		OutFormatType outputPixelFormat,
		float bumpScale = 1.0,
		unsigned char* outImagePtr = NULL );

	// Convert the normal map texture to its corresponding heightfield texture
	//
	bool convertToHeightMap(
		unsigned char* inImagePtr,
		unsigned int width,
		unsigned int height,
		OutFormatType outputPixelFormat,
		float heightScale = 1.0,
		unsigned char* outImagePtr = NULL );

protected:

	// Convert the heightfield to the normal map texture in place
	// (replace the input texture with the normal map version)
	//
	bool convertToNormalMap_InPlace(
		unsigned char* inImagePtr,
		unsigned int width,
		unsigned int height,
		OutFormatType outputPixelFormat,
		float bumpScale );
};

#endif // MAYA_API_MNormalMapConverter
