#ifndef _hwUnlitShader
#define _hwUnlitShader

//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+


///////////////////////////////////////////////////////////////////
//
// NOTE: PLEASE READ THE README.TXT FILE FOR INSTRUCTIONS ON
// COMPILING AND USAGE REQUIREMENTS.
//
// DESCRIPTION: Simple hardware shader which uses regular OpenGL
//				texturing and disables lighting.
//
//	This sample demonstrates how to:
//		- Specify a color attribute on your HW shader plug-in 
//		  so that end-users can attach a file texture to it.
//		- Traverse what's upstream of the color attribute, including 
//		  going through shading switches if required.
//		- Using the MImage API class to load and uncompress a file 
//		  texture in any Maya-supported file format.
//		- Setting up the graphics pipeline to display the 
//		  texture correctly.
//
//
///////////////////////////////////////////////////////////////////

#include <maya/MPxHwShaderNode.h>
#include "MTextureCache.h"

class hwUnlitShader : public MPxHwShaderNode
{
public:
                    hwUnlitShader();
    virtual         ~hwUnlitShader();
	void			releaseEverything();

    virtual MStatus compute( const MPlug&, MDataBlock& );
	virtual void      postConstructor();

	virtual MStatus	bind(const MDrawRequest& request,
						 M3dView& view);

	virtual MStatus	unbind(const MDrawRequest& request,
						   M3dView& view);

	virtual MStatus	geometry( const MDrawRequest& request,
							  M3dView& view,
							  int prim,
							  unsigned int writable,
							  int indexCount,
							  const unsigned int * indexArray,
							  int vertexCount,
							  const int * vertexIDs,
							  const float * vertexArray,
							  int normalCount,
							  const float ** normalArrays,
							  int colorCount,
							  const float ** colorArrays,
							  int texCoordCount,
							  const float ** texCoordArrays);

	virtual int		normalsPerVertex();
	virtual bool	hasTransparency();
	virtual int		texCoordsPerVertex();

    static  void *  creator();
    static  MStatus initialize();
    static  MTypeId id;

	MTextureCache*	m_pTextureCache;

	void			printGlError( const char *call );

	MStatus			getFloat3(MObject colorAttr, float colorValue[3]);
	MStatus			getString(MObject attr, MString &str);

	void			updateTransparencyFlags(MString objectPath);

protected:
    static MObject  colorR;
	static MObject  colorG;
	static MObject  colorB;
	static MObject  color;


    static MObject  transparencyR;
	static MObject  transparencyG;
	static MObject  transparencyB;
	static MObject  transparency;
	float fConstantTransparency;

	MDagPath currentObjectPath;

	// Callbacks that we monitor so we can release OpenGL-dependant resources before
	// their context gets destroyed.
	MCallbackId fBeforeNewCB;
	MCallbackId fBeforeOpenCB;
	MCallbackId fBeforeRemoveReferenceCB;
	MCallbackId fMayaExitingCB;

	void attachSceneCallbacks();
	void detachSceneCallbacks();

	static void releaseCallback(void* clientData);
};

#endif /* _hwUnlitShader */
