#-
# ==========================================================================
# Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
# rights reserved.
#
# The coded instructions, statements, computer programs, and/or related 
# material (collectively the "Data") in these files contain unpublished 
# information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
# licensors, which is protected by U.S. and Canadian federal copyright 
# law and by international treaties.
#
# The Data is provided for use exclusively by You. You have the right 
# to use, modify, and incorporate this Data into other products for 
# purposes authorized by the Autodesk software license agreement, 
# without fee.
#
# The copyright notices in the Software and this entire statement, 
# including the above license grant, this restriction and the 
# following disclaimer, must be included in all copies of the 
# Software, in whole or in part, and all derivative works of 
# the Software, unless such copies or derivative works are solely 
# in the form of machine-executable object code generated by a 
# source language processor.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
# AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
# WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
# NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
# PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
# TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
# BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
# DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
# AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
# OR PROBABILITY OF SUCH DAMAGES.
#
# ==========================================================================
#+

########################################################################
# DESCRIPTION:
#
# Produces the file translator "spCustomNodeTranslator".
#
# This example implements a simple input and output file translator. The writer
# functionality of the translator searches the Maya scene for proxy nodes and
# writes out the name information to the file. The reader functionality of the
# translator simply reads the file in and displays each line.
#
# To use this file translator, first load the plug-in, then create some proxy nodes
# such as spSineNode. Then, use File > Export All to save the proxy node information
# by selecting the "Files of Type" option "spCustomNodeTranslator".
#
# You can select File > Import to read the information back in. When the file is read
# back in, output will be sent to the History panel of the Script Editor.  
# 
########################################################################

# import maya
# maya.cmds.loadPlugin("customNodeFileTranslator.py")

import math, sys

import maya.OpenMaya as OpenMaya
import maya.OpenMayaMPx as OpenMayaMPx

kPluginTranslatorTypeName = "spCustomNodeTranslator"

# Node definition
class customNodeTranslator(OpenMayaMPx.MPxFileTranslator):
	def __init__(self):
		OpenMayaMPx.MPxFileTranslator.__init__(self)
	def haveWriteMethod(self):
		return True
	def haveReadMethod(self):
		return True
	def filter(self):
		return "*.spcnt"
	def defaultExtension(self):
		return "spcnt"
	def writer( self, fileObject, optionString, accessMode ):
		#
		try:
			fullName = fileObject.resolvedFullName()
			fileHandle = open(fullName,"w")
			fileHandle.write("# Simple text file of custom node information\n")

			iterator=OpenMaya.MItDependencyNodes()
			while not iterator.isDone():
				object = iterator.thisNode()
				#
				try:
					dnFn = OpenMaya.MFnDependencyNode( object )
					userNode = dnFn.userNode()
					if ( not( userNode == None ) ):
						line = "# custom node: " + dnFn.name() + "\n"
						fileHandle.write(line)
				except:
					pass
				iterator.next()
			fileHandle.close()
		except:
			sys.stderr.write( "Failed to write file information\n")
			raise
	def processLine( self, lineStr ):
		# Normally do parsing here.  Simple example will only
		# print out the line.
		print "read <%s>" % lineStr
	def reader( self, fileObject, optionString, accessMode ):
		#
		try:
			fullName = fileObject.resolvedFullName()
			fileHandle = open(fullName,"r")
			for line in fileHandle:
				# print line
				self.processLine( line )
				# print "1"
			fileHandle.close()
		except:
			sys.stderr.write( "Failed to read file information\n")
			raise


# creator
def translatorCreator():
	return OpenMayaMPx.asMPxPtr( customNodeTranslator() )

# initialize the script plug-in
def initializePlugin(mobject):
	mplugin = OpenMayaMPx.MFnPlugin(mobject)
	try:
		mplugin.registerFileTranslator( kPluginTranslatorTypeName, None, translatorCreator )
	except:
		sys.stderr.write( "Failed to register translator: %s" % kPluginTranslatorTypeName )
		raise

# uninitialize the script plug-in
def uninitializePlugin(mobject):
	mplugin = OpenMayaMPx.MFnPlugin(mobject)
	try:
		mplugin.deregisterFileTranslator( kPluginTranslatorTypeName )
	except:
		sys.stderr.write( "Failed to deregister translator: %s" % kPluginTranslatorTypeName )
		raise
	
