
#-
# ==========================================================================
# Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
# rights reserved.
#
# The coded instructions, statements, computer programs, and/or related 
# material (collectively the "Data") in these files contain unpublished 
# information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
# licensors, which is protected by U.S. and Canadian federal copyright 
# law and by international treaties.
#
# The Data is provided for use exclusively by You. You have the right 
# to use, modify, and incorporate this Data into other products for 
# purposes authorized by the Autodesk software license agreement, 
# without fee.
#
# The copyright notices in the Software and this entire statement, 
# including the above license grant, this restriction and the 
# following disclaimer, must be included in all copies of the 
# Software, in whole or in part, and all derivative works of 
# the Software, unless such copies or derivative works are solely 
# in the form of machine-executable object code generated by a 
# source language processor.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
# AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
# WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
# NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
# PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
# TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
# BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
# DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
# AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
# OR PROBABILITY OF SUCH DAMAGES.
#
# ==========================================================================
#+

########################################################################
# DESCRIPTION:
#
# Produces the Python command "spZoomCamera". 
#
# This is a simple plug-in which divides the horizontal field of view for the
# current active camera by 2.0. It is a good example of getting the current active
# view, and of modifying the camera.
#
# To use this plug-in, do the following:
#
#	(1) Create any object for the scene.
#	(2) Select Create > Cameras > Camera.
#	(3) Direct the camera to face an object in the scene.
#	(4) Select Panels > Perspective > camera1.
#	(5) When you are in a view that looks through the camera, execute these commands:
# 
#		import maya.cmds
#		maya.cmds.loadPlugin("zoomCameraCmd.py")
#		maya.cmds.spZoomCamera() 
#
# Your view through the camera will zoom-in by a factor of 2.
#
########################################################################

import sys
import maya.OpenMaya as OpenMaya
import maya.OpenMayaUI as OpenMayaUI
import maya.OpenMayaMPx as OpenMayaMPx

kPluginCmdName = "spZoomCamera"

print "zoomCameraCmd.py has been imported...."

# command
class scriptedCommand(OpenMayaMPx.MPxCommand):
	camera = OpenMaya.MDagPath()
	def __init__(self):
		OpenMayaMPx.MPxCommand.__init__(self)

	def redoIt(self):
		global camera
		fnCamera = OpenMaya.MFnCamera(camera)
		f1 = fnCamera.focalLength()
		fnCamera.setFocalLength(f1 * 2.0)

	def undoIt(self):
		global camera
		fnCamera = OpenMaya.MFnCamera(camera)
		f1 = fnCamera.focalLength()
		fnCamera.setFocalLength(f1 / 2.0)

	def doIt(self, args):
		global camera
		camera = OpenMaya.MDagPath()	
		try:
			OpenMayaUI.M3dView.active3dView().getCamera(camera)
		except:	
			sys.stderr.write( "ERROR: getting camera \n" )
		else:
			self.redoIt()

	def isUndoable(self):
		return True

#Cmd Creator
def cmdCreator():
	return OpenMayaMPx.asMPxPtr( scriptedCommand() )
		
# Initialize the script plug-in	
def initializePlugin(obj):
	plugin = OpenMayaMPx.MFnPlugin(obj)
	try:
		plugin.registerCommand( kPluginCmdName, cmdCreator)
	except:
		sys.stderr.write( "Failed to register command: %s\n" % kPluginCmdName )

# Uninitialize the script plug-in	
def uninitializePlugin(obj):
	plugin = OpenMayaMPx.MFnPlugin(obj)
	try:
		plugin.deregisterCommand(kPluginCmdName)		
	except:
		sys.stderr.write( "Failed to unregister command: %s\n" % kPluginCmdName )

	
