//
// ==================================================================
// Copyright 2014 Autodesk, Inc.  All rights reserved.
// 
// This computer source code  and related  instructions and comments are
// the unpublished confidential and proprietary information of Autodesk,
// Inc. and are  protected  under applicable  copyright and trade secret
// law. They may not  be disclosed to, copied or used by any third party
// without the prior written consent of Autodesk, Inc.
// ==================================================================
//
//! \file synColor/loggerTypes.h
//!
//! \brief List of message logging levels, and logging function signature definition.
//!

#ifndef _SYNCOLOR_LOGGER_TYPES_H
#define _SYNCOLOR_LOGGER_TYPES_H

#include <synColor/synExport.h>
#include <synColor/synColorNamespace.h>

SYN_VISIBILITY_PUSH

namespace SYNCOLOR
{

  //! \brief List of message logging levels.
  //!
  //! Some messages meant for a log file are generated by SynColor.   By
  //! default these messages are printed in the standard output.  It is
  //! possible to override the logging function to redirect log messages to
  //! another destination.
  //!
  //! \note  Because of the breadth of error handling in SynColor, there are
  //!        currently very few messages logged by the library.  Only LEVEL_USER
  //!        messages are printed by the default logging function.
  //! \todo  Add an SDK function to set the logging level.
  //! \sa SYNCOLOR::setLoggerFunction()
  enum LogLevel
  {
    LEVEL_USER,   //!< Default and lowest logging level.  Messages at this
                  //!< level are always logged.
    LEVEL_DEBUG   //!< For debug messages. Highest logging level.  Messages of
                  //!< all levels are logged.
  };
  
  //! \brief Logging function signature.
  typedef void(*LogFunc)(LogLevel, const char *);
}

SYN_VISIBILITY_POP

#endif //_SYNCOLOR_LOGGER_H
