"""
These classes are the UI builders for the options of import and Export
of a render setup.
"""

class ImportAllUI(object):
    """
    Helper class to build the Options UI for the fileDialog2 command used when importing all
    """
    
    
    
    def addOptions(parent):
        pass
    
    
    def setImportText(data):
        """
        Preserve the text because it's consumed after the UI is gone.
        """
    
        pass
    
    
    def setMergeImportType(data):
        """
        Merge the content of the existing render setup with the imported content. 
        If an unexpected render setup object is found it will renamed using the 'importText'.
        """
    
        pass
    
    
    def setOverwriteImportType(data):
        """
        Completely overwrite the content of the existing render setup with the imported content.
        """
    
        pass
    
    
    def setRenameImportType(data):
        """
        Always rename the imported render setup content using the 'importText'.
        """
    
        pass
    
    
    def updateContent(parent, selectedFilename):
        """
        Update the displayed content following the file selection 
        Note: If the file is not a render setup file or is a directory, 
              the content (notes & preview) will be empty.
        """
    
        pass
    
    
    __dict__ = None
    
    __weakref__ = None
    
    importText = 'Import_'
    
    
    importTextEditor = None
    
    
    importType = 0
    
    
    notesEditor = None
    
    
    previewEditor = None


class ExportAllUI(object):
    """
    Helper class to build the Options UI for the fileDialog2 command used when exporting all
    """
    
    
    
    def addOptions(parent):
        pass
    
    
    def setNotesText(data):
        """
        Preserve the notes because it's consumed after the UI is gone.
        Note: Trap the focus changed which is the only way to have the text for a scroll field.
        """
    
        pass
    
    
    __dict__ = None
    
    __weakref__ = None
    
    notesText = None
    
    
    notesTextEditor = None


class ParentGuard(object):
    def __enter__(self):
        pass
    
    
    def __exit__(self, type, value, traceback):
        pass
    
    
    __dict__ = None
    
    __weakref__ = None


class ImportAOVsUI(object):
    """
    Helper class to build the Options UI for the fileDialog2 command used for importing AOVs
    """
    
    
    
    def addOptions(parent):
        pass
    
    
    def setMergeImportType(data):
        """
        Merge the content of the existing render setup with the imported content. 
        If an unexpected render setup object is found it will renamed using the 'importText'.
        """
    
        pass
    
    
    def setOverwriteImportType(data):
        """
        Completely overwrite the content of the existing render setup with the imported content.
        """
    
        pass
    
    
    __dict__ = None
    
    __weakref__ = None
    
    importType = 0



kUnknownFile = []

kOverwriteExplanation = []

kRename = []

kGeneralOptions = []

kPreview = []

kMergeExplanation = []

kMerge = []

kRenameExplanation = []

kOverwrite = []

kDefaultTextToPrepend = 'Import_'

DEFAULT_UI_INDENTATION = 12

kMergeAOVExplanation = []

kNotes = []

kTextToPrepend = []


