import exceptions

from pymel.core.uitypes import toPySideControl as toQtControl
from pymel.core.uitypes import toPySideObject as toQtObject
from pymel.core.uitypes import objectTypeUI
from pymel.core.system import Path as _Path
from pymel.internal.factories import Callback
from pymel.core.uitypes import toPySideLayout as toQtLayout
from pymel.internal.factories import CallbackWithArgs
from pymel.core.uitypes import toPySideWindow as toQtWindow
from pymel.core.uitypes import toPySideMenuItem as toQtMenuItem

class PopupError(exceptions.Exception):
    """
    Raise this exception in your scripts to cause a confirmDialog to be opened displaying the error message.
    After the user presses 'OK', the exception will be raised as normal. In batch mode the promptDialog is not opened.
    
    Parameters
    ----------
    msgOrException : str or Exception instance
        If a string, then the actual exception object returned / raised will
        be a PopupError instance, and the message displayed will be this arg;
        if an Exception instance, then the expection object returned / raised
        will be the given instance
    title : str
        title of the dialog
    button : str
        text on the confirm button of the dialog
    msg : str Or None
        If msgOrException was not an exception instance, this is ignored; if it
        is, then this controls what the displayed message is. If it is None,
        then the displayed message is the first arg of the exception instance,
        or the empty string if it has no args. If it is a string, then that will
        be the displayed message.
    icon : str
        icon to use for the confirm dialog (see confirmDialog docs for available
        icons)
    """
    
    
    
    def __init__(self, msg, *args, **kwargs):
        pass
    
    
    def __new__(cls, msgOrException, title="'Error'", button="'Ok'", msg='None', icon="'critical'"):
        pass
    
    
    __weakref__ = None



def contentBrowser(*args, **kwargs):
    """
    This command is used to edit and query a Content Browser. The Content Browser is a unique panel, so only one instance of
    it can exist at a given time. The optional argument is the name of the control.
    
    Flags:
      - addContentPath : acp           (unicode)       [edit]
          Adds the given path(s) to the libraries displayed on the Examples tab. Also updates the corresponding MAYA_CONTENT_PATH
          environment variable.
    
      - context : ctx                  (unicode, unicode, unicode) [edit]
          Sets the default location for the given context. The two optional arguments (Python only) are the category (tab) and
          location. To clear the content use empty strings for category and location.
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - location : loc                 (unicode)       [edit]
          Switches to the Examples tab and selects the given library location.
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - preview : pv                   (bool)          [edit]
          Shows / hides the preview panel. Note: this flag will not affect the currently opened Content Browser, but only any
          subsequently opened ones.
    
      - refreshTreeView : rtv          (bool)          [edit]
          Forces a refresh of the Examples tab tree view pane.
    
      - removeContentPath : rcp        (unicode)       [edit]
          Removes the given path(s) from the libraries displayed on the Examples tab. Also updates the corresponding
          MAYA_CONTENT_PATH environment variable.
    
      - saveCurrentContext : scc       (bool)          [edit]
          Saves the context for the current Content Browser tab.
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - thumbnailView : th             (bool)          [edit]
          Shows / hides the thumbnail panel. Note: this flag will not affect the currently opened Content Browser, but only any
          subsequently opened ones.
    
      - treeView : tr                  (bool)          [edit]
          Shows / hides the tree view panel. Note: this flag will not affect the currently opened Content Browser, but only any
          subsequently opened ones.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.contentBrowser`
    """

    pass


def hudSliderButton(*args, **kwargs):
    """
    This command creates a Heads-up Display (HUD) slider button control which is placed in a 2D inactive overlay plane on
    the 3D viewport. It is to be used to provide hands-on interaction designated by a user script. The HUD slider button
    control is derived from a generic HUD object and thus inherits a similar workflow. Although this command provides much
    of the same functionality as the headsUpDisplay command, it does not provide headsUpDisplay layout controls such as
    layoutVisibility, nextFreeBlock, lastOccupiedBlock, exists, remove, etc. To access that functionality, please use the
    headsUpDisplay command. This command is focused solely around the creation and management of HUD slider button controls.
    Similarly, all operations performed by this command are limited to HUDs that are slider button controls. The only
    mandatory flags, on creation are the section and block flags. Like the headsUpDisplay command, upon creation of a HUD
    slider button, an ID number will be assigned to it. This can be used to remove the HUD slider via the headsUpDisplay
    command (-rid/removeID [int IDNumber]), if desired. Alternatively, the headsUpDisplay command can remove HUD objects via
    their position (section and block), or their unique name.
    
    Flags:
      - allowOverlap : ao              (bool)          [create,query,edit]
          Sets the Heads-Up Display to be visible regardless of overlapping section widths/limitations (see -s/section flag
          description for more details).
    
      - block : b                      (int)           [create,query,edit]
          Denotes the individual block that the HUD will reside in, within a section. Each section is composed of a single column
          of blocks. The total number of blocks contained within each section is variable. The number of blocks that will be
          visible within each section is dependent on the size of blocks contained in each section and the current size of the
          window. Blocks begin enumerating from 0 and flexibly increase based on need. For HUD sliders, the format differs from
          that of the standard HUD. The layout using parameters defined by the formatting flags listed below (eg. justify,
          padding, labelWidth, valueWidth) is shown below:
          __________________________________________________________________________ |     |     |      |           |      |
          |      |        |     |     | |  P  |  J  |  LW  |  Slider   |  IP  | Value |  IP  | Button |  J  |  P  |
          |_____|_____|______|___________|______|_______|______|________|_____|_____| P = Sub-block of width, padding J =
          Justification of the entire block LW = Sub-block of width, labelWidth Slider = Length of the slider SliderValue = Sub-
          block of width, valueWidth Button = Sub-block of width, buttonWidth IP = Internal Padding Block PositioningBlocks on the
          top section begin from the top edge of the main viewport, while the bottom section begins from the bottom edge. Blocks
          are dynamically removed from visibility from the midpoint of the viewport. So, a relatively large block number will not
          draw to the viewport. Lastly, there can be at most one HUD occupying a block at any time. Trying to position a HUD in an
          occupied block will result in an error. Keep this in mind when positioning the HUD.
    
      - blockAlignment : ba            (unicode)       [create,query,edit]
          Specifies the alignment of the block within its respective column. Available alignments are: center, leftand right. The
          default alignment is left.
    
      - blockSize : bs                 (unicode)       [create,query,edit]
          Sets the height of each block. Available heights are: small, medium and large. In pixel measurements, each corresponds
          to a 20, 35 or 50 pixel height, respectively.
    
      - buttonLabel : bl               (unicode)       [create,query,edit]
          Text label of the HUD button.
    
      - buttonLabelFontSize : bfs      (unicode)       [create,query,edit]
          Sets the font size of the button label. Available sizes are: small and large.
    
      - buttonPressCommand : bpc       (script)        [create,query,edit]
          Specifies the procedure or script to run during a button mouse click event.
    
      - buttonReleaseCommand : brc     (script)        [create,query,edit]
          Specifies the procedure or script to run during a button mouse release event.
    
      - buttonShape : bsh              (unicode)       [create,query,edit]
          Specifies the shape of the button. Available button shapes are: rectangleand roundRectangle. The first will draw a
          rectangular button, while the latter is a rectangle with rounded edges.
    
      - buttonWidth : bw               (int)           [create,query,edit]
          Specifies the width of the button.
    
      - decimalPrecision : dp          (int)           [create,query,edit]
          Sets the decimal precision of any floating point value returned by the command. The valid range of precision values are
          1 to 8.
    
      - internalPadding : ip           (int)           [create,query,edit]
          Specifies the amount of padding between the internal elements of the HUD. For the hudSlider, this represents the padding
          between the slider bar and the slider value. The default padding is 10.
    
      - maxValue : max                 (float)         [create,query,edit]
          Specify the maximum value of the slider. Note:Although this flag takes in a FLOAT as an argument, if the HUD type is
          int, the value will be automatically converted internally to an integer.
    
      - minValue : min                 (float)         [create,query,edit]
          Specify the minimum value of the slider. Note:Although this flag takes in a FLOAT as an argument, if the HUD type is
          int, the value will be automatically converted internally to an integer.
    
      - padding : p                    (int)           [create,query,edit]
          Specifies the width of both the left and right margins of a block. Default value is 15 pixels.
    
      - section : s                    (int)           [create,query,edit]
          Defines the section the HUD will appear in. There are 10 sections divided across the screen. Five columns and two rows
          make up the ten element matrix which divide the main viewport. Here is a visual layout of the sections.
          ________________________ |    |    |    |    |    | |    |    |    |    |    | | 0  | 1  | 2  | 3  | 4  | |    |    |
          |    |    | |____|____|____|____|____| |    |    |    |    |    | |    |    |    |    |    | | 5  | 6  | 7  | 8  | 9  |
          |    |    |    |    |    | |____|____|____|____|____|Each section is denoted by a number from 0 to 9 as illustrated
          above. For example, if the second column of the top row was desired, the section would be defined as: -sec 1 To prevent
          HUD objects from displaying over each other and causing a clutter of letters, each row has a defined visibility
          precedence, where each section would have a visibility priority level. Depending on each priority level, when the screen
          space begins to shrink to a point where the section widths of a given row begin to collide, the HUD automatically
          compensates for this by removing the sections of least priority. These sections are made invisible and a warning is
          issued to inform the user of the removal. This continues until only the section of highest priority remains. For each
          row, the priorities are defined as follows. Using the top row as an example: Section 0, has the highest priority,
          followed by Section 4, making the outermost sections of highest priority. Next in the list is Section 2, and lastly
          Sections 1 and 3 are of the equal and least priority. This priority structure can be applied to the bottom row as well.
          The two outermost sections have the highest priority, followed by the middle section, and finally the remaining two
          sections are of lowest priority. This means that as the viewport gradually decreases in width to the point where
          sections in the top row begin to overlap, sections 1 and 3 will be removed from view first, followed by section 2, and
          finally section 4. A similar note is provided below for the block layout.
    
      - sliderDragCommand : sdc        (script)        [create,query,edit]
          Specifies the procedure or script to run during a slider mouse drag event.
    
      - sliderIncrement : si           (float)         [create,query,edit]
          Specify the number of increments along the slider. If not specified or set to 0 or less, the slider will be linearly
          even and continuous from minValue to maxValue. Note:Although this flag takes in a FLOAT as an argument, if the HUD type
          is int, the value will be automatically converted internally to an integer.
    
      - sliderLabel : sl               (unicode)       [create,query,edit]
          Text label of the HUD slider.
    
      - sliderLabelFontSize : sfs      (unicode)       [create,query,edit]
          Sets the font size of the slider label. Available sizes are: small and large.
    
      - sliderLabelWidth : slw         (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold the label. The contents of this textboxwill be left
          justified. If the width of the actual label exceeds the width of the textbox,the label will be truncated to fit within
          the dimensions of the textbox.(To see a layout of a block, see the description of the -block flag.)
    
      - sliderLength : sln             (int)           [create,query,edit]
          Specifies the length of the slider in pixels.
    
      - sliderPressCommand : spc       (script)        [create,query,edit]
          Specifies the procedure or script to run during a slider mouse click event.
    
      - sliderReleaseCommand : src     (script)        [create,query,edit]
          Specifies the procedure or script to run during a slider mouse release event.
    
      - type : t                       (unicode)       [create,query,edit]
          Specify the numeric type of the HUD. Available types are: floatand int.
    
      - value : v                      (float)         [create,query,edit]
          Set/Return the slider value if the HUD is a valid HUD slider. Note:Although this flag takes in a FLOAT as an argument,
          if the HUD type is int, the value will be automatically converted internally to an integer.
    
      - valueAlignment : va            (unicode)       [create,query,edit]
          Specifies the alignment of the data blocks and the data text, within a HUD block. Available alignments are: leftand
          right. The default alignment is left.
    
      - valueFontSize : vfs            (unicode)       [create,query,edit]
          Sets the font size of the slider value. Available sizes are: small and large.
    
      - valueWidth : vw                (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold the slider value. (To see a layout of a block, see the
          description of the -block flag.)
    
      - visible : vis                  (bool)          [create,query,edit]
          Sets the visibility of the Heads-Up Display on and off.                                    Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hudSliderButton`
    """

    pass


def toolCollection(*args, **kwargs):
    """
    This command creates a tool button collection. Collections are parented to the current default layout if no parent is
    specified with the -p/parent flag.  As children of the layout they will be deleted when the layout is deleted.
    Collections may also span more than one window if the -gl/global flag is used. In this case the collection has no parent
    and must be explicitly deleted with the 'deleteUI' command when it is no longer wanted.
    
    Flags:
      - collectionItemArray : cia      (bool)          [query]
          Returns a string list giving the long names of all the items in this collection.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - gl : gl                        (bool)          [create,query]
          Set the collection to have no parent layout.  This flag must be specified when the collection is created and can not be
          queried or edited.  Consequently, global collections must be explicitly deleted.
    
      - numberOfCollectionItems : nci  (bool)          [query]
          Returns the number of items that are in this collection.
    
      - parent : p                     (unicode)       [create]
          Specify the parent to associate the collection with.  The collection will be deleted along with the parent.  This flag
          must be specified when the collection is created and can not be edited.
    
      - select : sl                    (unicode)       [create,query,edit]
          Select the specified collection item.  If queried will return the name of the currently selected collection item.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.toolCollection`
    """

    pass


def iconTextButton(*args, **kwargs):
    """
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
    fits the current size of the control given its current style. This command creates an iconTextButton that can be
    displayed with different icons, with or without accompanying text label. When an argument is passed, it is used to give
    a name to the iconTextButton.
    
    Flags:
      - actionIsSubstitute : ais       (bool)          []
    
      - align : al                     (unicode)       [create,query,edit]
          The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
          only available when -st/style is set to iconAndTextCentered.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - command : c                    (script)        [create,query,edit]
          Command executed when the control is pressed.
    
      - commandRepeatable : rpt        (bool)          [create,query,edit]
          Set if the MEL command specified in the command flag should be repeatable or not.  The gkey, by default, is the shortcut
          to repeat the last executed command.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disabledImage : di             (unicode)       [create,query,edit]
          Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
          a Windows only flag.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - doubleClickCommand : dcc       (script)        [create,query,edit]
          Command executed when the control is double clicked.
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - flat : fla                     (bool)          [create,query,edit]
          Sets whether the control will be a flat button (0 false, 1 true).
    
      - flipX : fx                     (bool)          [create,query,edit]
          Is the image flipped horizontally?
    
      - flipY : fy                     (bool)          [create,query,edit]
          Is the image flipped vertically?
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - handleNodeDropCallback : hnd   (script)        [create,edit]
          Specify a script callback which is called when a node is dropped on the control.  The name of the node being dropped
          will be passed to the function  (python callable) or appended to the end (script) to form the command to be executed.
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - highlightImage : hi            (unicode)       [create,query,edit]
          Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with
          the -i/imageflag. This is a Windows only flag.
    
      - image : i                      (unicode)       [create,query,edit]
          If you are not providing images with different sizes then you may use this flag for the control's image. If the
          iconOnlystyle is set, the icon will be scaled to the size of the control.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three icons. The icon that best fits the current size of the control will be displayed.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string, up to 6 characters, representing a label that will be displayed on top of the image.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that appears in the control.
    
      - labelEditingCallback : lec     (script)        [create,edit]
          Specify a callback which is called after the user double clicks the label of the control to give it a new label. The new
          label string will be passed to the callback.
    
      - labelOffset : lo               (int)           [create,query,edit]
          The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - marginHeight : mh              (int)           [create,query,edit]
          The number of pixels above and below the control content. The default value is 1 pixel.
    
      - marginWidth : mw               (int)           [create,query,edit]
          The number of pixels on either side of the control content. The default value is 1 pixel.
    
      - menuItem : mi                  (unicode, unicode) [create,edit]
          Creates menu items for this button by passing in arguments for the menu item label and command for each item.  These
          should be passed as strings: labelcommandfor each use of this flag in the command. May be used mutliple times
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
          The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
    
      - overlayLabelColor : olc        (float, float, float) [create,query,edit]
          The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rotation : rot                 (float)         [create,query,edit]
          The rotation value of the image in radians.
    
      - scaleIcon : sic                (bool)          [create,edit]
          For textOnlyand iconOnlystyle, this flag has no effect. For other styles, if the flag is specified, the icon will be
          scaled to the size of the control.
    
      - selectionImage : si            (unicode)       [create,query,edit]
          Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag.
          This is a Windows only flag.
    
      - sourceType : stp               (unicode)       [create,query,edit]
          Sets the language type for the command script. Can only be used in conjunction with the c/command or
          dcc/doubleClickCommand flags. Valid values are mel(enabled by default), and python.
    
      - style : st                     (unicode)       [create,query,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
          iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
          be scaled to the size of the control.
    
      - useAlpha : ua                  (bool)          [create,query,edit]
          Is the image using alpha channel?
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this control feature was introduced. The argument should be given as a string of the version
          number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
          2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.iconTextButton`
    """

    pass


def pathButtonGrp(name='None', *args, **kwargs):
    pass


def currentParent():
    """
    shortcut for ``ui.PyUI(setParent(q=1))``
    """

    pass


def setFocus(*args, **kwargs):
    """
    Give keyboard focus to a specific control or panel, passed as an argument.
    
    
    Derived from mel command `maya.cmds.setFocus`
    """

    pass


def disableIncorrectNameWarning(*args, **kwargs):
    """
    Disable the warning dialog which complains about incorrect node names when opening Maya files.
    
    
    Derived from mel command `maya.cmds.disableIncorrectNameWarning`
    """

    pass


def messageLine(*args, **kwargs):
    """
    This command creates a message line where tool feedback is shown.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.messageLine`
    """

    pass


def workspaceControlState(*args, **kwargs):
    """
    Create or modify preferred window attributes for workspace controls. The size and position of a workspace control is
    retained during application sessions (although position only applies to workspace controls that are alone in a floating
    workspace docking panel). A default workspace control state is created when a workspace control is closed. Workspace
    control states must be named and, consequently, only affect the workspace control with a matching name. In query mode,
    return type is based on queried flag.
    
    Flags:
      - exists : ex                    (bool)          [create]
          Returns true|false depending upon whether the specified object exists. Other flags are ignored.
    
      - height : h                     (int)           [create,query,edit]
          Height of the window.
    
      - leftEdge : le                  (int)           [create,query,edit]
          Left edge position of the window.
    
      - maximized : max                (bool)          [create,query,edit]
          Maximize the window.
    
      - remove : r                     (bool)          [create]
          Remove a window preference.
    
      - topEdge : te                   (int)           [create,query,edit]
          Top edge position of the window.
    
      - topLeftCorner : tlc            (int, int)      [create,query,edit]
          Top and left edge position of the window.
    
      - width : w                      (int)           [create,query,edit]
          Width of the window.
    
      - widthHeight : wh               (int, int)      [create,query,edit]
          Width and height of the window.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.workspaceControlState`
    """

    pass


def windowPref(*args, **kwargs):
    """
    Create or modify preferred window attributes.  The size and position of a window is retained during and between
    application sessions.  A default window preference is created when a window is closed.  Window preferences must be named
    and, consequently, only affect the window with a matching name. Note that window preferences are not applied to the main
    Maya window nor the Command window. In query mode, return type is based on queried flag.
    
    Flags:
      - enableAll : ea                 (bool)          [create,query]
          Enable/disable all window preferences.  Preferences are enabled by default.  Set this flag to false and window's will
          ignore all preference values.
    
      - exists : ex                    (bool)          [create]
          Returns true|false depending upon whether the specified object exists. Other flags are ignored.
    
      - height : h                     (int)           [create,query,edit]
          Height of the window.
    
      - leftEdge : le                  (int)           [create,query,edit]
          Left edge position of the window.
    
      - loadAll : la                   (bool)          [create]
          Reads in file with window attributes from disk.
    
      - maximized : max                (bool)          [create,query,edit]
          Maximize the window.
    
      - parentMain : pm                (bool)          [create,query]
          Set whether window is parented to main application window. Windows only.
    
      - remove : r                     (bool)          [create]
          Remove a window preference.
    
      - removeAll : ra                 (bool)          [create]
          Remove all window preferences.
    
      - restoreMainWindowState : rms   (unicode)       [create]
          Reads in file with main window state (positions of toolbars and dock controls).
    
      - saveAll : sa                   (bool)          [create]
          Writes out file with window attributes.
    
      - saveMainWindowState : sms      (unicode)       [create]
          Writes out file with main window state (positions of toolbars and dock controls).
    
      - topEdge : te                   (int)           [create,query,edit]
          Top edge position of the window.
    
      - topLeftCorner : tlc            (int, int)      [create,query,edit]
          Top and left edge position of the window.
    
      - width : w                      (int)           [create,query,edit]
          Width of the window.
    
      - widthHeight : wh               (int, int)      [create,query,edit]
          Width and height of the window.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.windowPref`
    """

    pass


def linearPrecision(*args, **kwargs):
    """
    This command controls the display of linear strings in the interface. (See the linearField command). Setting this
    affects any linear strings displayed afterwards, formatting them so they will show at most the specified number of
    digits after the decimal point. Allowed values are 0 through 6. In query mode, return type is based on queried flag.
    
    
    Derived from mel command `maya.cmds.linearPrecision`
    """

    pass


def subMenuItem(*args, **kwargs):
    """
    shortcut for ``menuItem(subMenu=True)``
    """

    pass


def colorIndexSliderGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a color slider group consisting of a label, a color canvas
    and a slider. The value of the slider defines a color index into the a color table. The corresponding color is displayed
    in the canvas.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the value changes.  This command is not invoked when the value changes via the -v/value flag.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command executed when the value changes by dragging the slider's value marker.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraLabel : el                (unicode)       [create,query,edit]
          Sets the string to be the text for the extra label.
    
      - forceDragRefresh : fdr         (bool)          []
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - invisible : inv                (int)           [create,query,edit]
          Set the invisible color index.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          Label text for the group.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (int)           [create,query,edit]
          Maximum color index.
    
      - minValue : min                 (int)           [create,query,edit]
          Minimum color index.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (int)           [create,query,edit]
          Color index.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.colorIndexSliderGrp`
    """

    pass


def autoLayout(*args, **kwargs):
    """
    This command creates a form layout control. A form layout allows absolute and relative positioning of the controls that
    are its immediate children. Controls have four edges: top, left, bottom and right. There are only two directions that
    children can be positioned in, right-left and up-down. The attach flags take the direction of an attachment from the
    argument that names the edge to attach (the second argument). Any or all edges of a child may be attached. There are six
    ways to attach them: Attach to Form - Attaches an edge to the relevant side of the form layout. Thus -attachForm button3
    leftwill attach the left edge of the button to the left edge of the form.Attach to Opposite Side of Form - Attaches an
    edge relative to the furthest side of the form layout.Attach to Another Control - Attaches an edge to the closest edge
    of the other control named.Attach to Opposite Side of Another Control - Attaches an edge relative to the furthest side
    of another control.Attach to Position - Attaches an edge to a position on the form layout.  The position is given as a
    fixed fraction of the -nd/numDivisions value and as this value defaults to 100 it is easiest to think of it as a
    percentage of the form's size.Attach to Nothing - Attaches an edge to nothing. The size of the child control will
    determine this edge's position.Each edge attachment may have an offset that acts to separate controls visually. There is
    no default positioning relationship so to have children appear in the form they must have at least one edge attached in
    each direction. Note:In the flag definitions the arguments follow these rules: controlmust be the name of an immediate
    child of the form layout.edgemust be one of top, left, bottom, or right.positionmay range from 0 to the number of
    divisions as specified with the -nd/numberOfDivisions flag and gives the fraction of the width of the form as a
    measurement. This normally means 0-100 so  positionmay be thought of as a percentage.offsetis an integer value in
    pixels.These are multi-use flags so any number of attachments may be made in a single command. Note:Avoid making control
    attachments that form a loop in control dependencies. For example: window; string $form = `formLayout`; string $btn1 =
    `button`; string $btn2 = `button`; string $btn3 = `button`;formLayout -edit-attachControl $btn2 top2 $btn1-attachControl
    $btn3 top2 $btn2-attachControl $btn1 right2 $btn3 $form;showWindow; $btn2 is attached to $btn1, $btn3 is attached to
    $btn2, and $btn1 is attached to $btn3. Thus, the placement of $btn1 is dependent on the placement of $btn3, which is
    dependent on the placement of $btn2, which is dependent on the placement of $btn1. The last control attachment will have
    created a loop in the dependencies. To prevent runtime errors, Maya will ignore this attachment and instead issue a
    warning that a cyclical control attachment has been detected in the script.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attachControl : ac             (unicode, unicode, int, unicode) [create,edit]
          Arguments are: control, edge, offset, control Valid edge values are: top| bottom| left| right. Attach a control to
          another control.
    
      - attachForm : af                (unicode, unicode, int) [create,edit]
          Arguments are: control, edge, offset. Valid edge values are: top| bottom| left| right. Attach the specified control to
          the form, offset by the specified amount.
    
      - attachNone : an                (unicode, unicode) [create,edit]
          Arguments are: control, edge Valid edge values are: top| bottom| left| right. Attach a control to nothing.
    
      - attachOppositeControl : aoc    (unicode, unicode, int, unicode) [create,edit]
          Arguments are: control, edge, offset, control Valid edge values are: top| bottom| left| right. Attach a control to the
          opposite side of another control.
    
      - attachOppositeForm : aof       (unicode, unicode, int) [create,edit]
          Arguments are: control, edge, offset. Valid edge values are: top| bottom| left| right. Attach a control to the opposite
          side of the form.
    
      - attachPosition : ap            (unicode, unicode, int, int) [create,edit]
          Arguments are: control, edge, offset, position Valid edge values are: top| bottom| left| right. Attach a control to a
          position in the form.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfDivisions : nd         (int)           [create,query,edit]
          Specify the number of horizontal and vertical divisions across the form. Value must be greater than 0.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.formLayout`
    """

    pass


def swatchDisplayPort(*args, **kwargs):
    """
    This command creates a 3dPort that displays a swatch representing the shading node. The optional argument is the name of
    the 3dPort.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - borderColor : bc               (float, float, float) [create,query,edit]
          The border color of the swatch.
    
      - borderWidth : bw               (int)           [create,query,edit]
          The border width of the swatch.  The value will be clamped between 0 and 4.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - pressCommand : pc              (script)        [create,edit]
          Specifies the command to be run when the swatch is clicked on.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - renderPriority : rp            (int)           [create,edit]
          Specifies the priority to render the swatch. This flag can only be used in parallel swatch rendering. When more than one
          swatch are waiting in the render queue, this flag can be used to specify which one has the higher priority to be
          rendered. By default, the flag is set to 0 - low priority. The larger the number, the higher priority is used to render
          the swatch. Maya pre-defined the render priority for the swatch in Node Editor, Attribute Editor and Hypershade as
          below: 0: The lowest render priority. 1: The render priority for the swatch in Node Editor. 2: The render priority for
          the swatch in the working area of HyperShade 3: The render priority for the swatch in Attribute Editor. For example,
          when creating a display port in AE using the swatchDisplayPort command, option -rp 3is used.
    
      - renderSize : rs                (int)           [create,query,edit]
          The render size of the swatch.  The value will be clamped between 32 and 512.
    
      - shadingNode : sn               (PyNode)        [create,query,edit]
          Name of the shadingNode.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - widthHeight : wh               (int, int)      [create,edit]
          The width and height of the port.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.swatchDisplayPort`
    """

    pass


def progressWindow(*args, **kwargs):
    """
    The progressWindow command creates a window containing a status message, a graphical progress gauge, and optionally a
    Hit ESC to Cancellabel for interruptable operations. Only one progress window is allowed on screen at a time. While the
    window is visible, the busy cursor is shown.
    
    Flags:
      - endProgress : ep               (bool)          [create]
          Terminates the progress window. No other flags can be used at the same time. This is normally issued through MEL in
          response to the -ic/isCancelled flag being set or if the progress value reaches its maximum.
    
      - isCancelled : ic               (bool)          [query]
          Returns true if the user has tried to cancel the operation. Returns false otherwise.
    
      - isInterruptable : ii           (bool)          [create,query,edit]
          Returns true if the progress window should respond to attempts to cancel the operation. The cancel button is disabled if
          this is set to true.
    
      - maxValue : max                 (int)           [create,query,edit]
          The maximum or endingvalue of the progress indicator. If the progress value is greater than the -max/maxValue, the
          progress value will be set to the maximum. Default value is 100.
    
      - minValue : min                 (int)           [create,query,edit]
          The minimum or startingvalue of the progress indicator. If the progress value is less than the -min/minValue, the
          progress value will be set to the minimum. Default value is 0.
    
      - progress : pr                  (int)           [create,query,edit]
          The amount of progress currently shown on the control. The value will always be between min and max. Default is equal to
          the minimum when the control is created.
    
      - status : st                    (unicode)       [create,query,edit]
          The status text appearing above the progress gauge.
    
      - step : s                       (int)           [edit]
          Increments the -pr/progress value by the amount specified.
    
      - title : t                      (unicode)       [create,query,edit]
          The window title.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.progressWindow`
    """

    pass


def exclusiveLightCheckBox(*args, **kwargs):
    """
    This command creates a checkBox that controls a light's exclusive non-exclusive status.  An exclusive light is one that
    is not hooked up to the default-light-list, thus it does not illuminate all objects be default.  However an exclusive
    light can be linked to an object.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       []
    
      - light : lt                     (PyNode)        [create]
          The light that is to be made exclusive/non-exclusive.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.exclusiveLightCheckBox`
    """

    pass


def getPanel(*args, **kwargs):
    """
    This command returns panel and panel configuration information.
    
    Modifications:
      - returns a Panel object for flags: (containing or underPointer or withFocus)
      - returns a list of Panel objects for flags: not typeOf
    
    Flags:
      - allConfigs : ac                (bool)          [create]
          Return the names of the all panel configuration in a string array.
    
      - allPanels : all                (bool)          [create]
          Return the names of all the panels in a string array.
    
      - allScriptedTypes : ast         (bool)          [create]
          Return the names of all types of scripted panels in a string array.
    
      - allTypes : at                  (bool)          [create]
          Return the names of all types of panels, except scripted types in a string array.
    
      - atPosition : ap                (int, int)      [create]
          Return the name of the panel which contains the specified screen coordinates. An empty string is returned if there is no
          panel at those coordinates.
    
      - configWithLabel : cwl          (unicode)       [create]
          Return the name of the panel configuration with the specified label text.
    
      - containing : c                 (unicode)       [create]
          Return the name of the panel containing the specified control. An empty string is returned if the specified control is
          not in any panel.
    
      - invisiblePanels : inv          (bool)          [create]
          Return the names of all the invisible panels in a string array.
    
      - scriptType : sty               (unicode)       [create]
          Return the names of all scripted panels of the specified type in a string array.
    
      - type : typ                     (unicode)       [create]
          Return the names of all panels of the specified type in a string array.
    
      - typeOf : to                    (unicode)       [create]
          Return the type of the specified panel.
    
      - underPointer : up              (bool)          [create]
          Return the name of the panel that the pointer is currently over. An empty string is returned if the pointer is not over
          any panel.
    
      - visiblePanels : vis            (bool)          [create]
          Return the names of all the visible panels in a string array.
    
      - withFocus : wf                 (bool)          [create]
          Return the name of the panel that currently has focus.  If no panel has focus then the last panel that had focus is
          returned.
    
      - withLabel : wl                 (unicode)       [create]
          Return the name of the panel with the specified label text.                  Flag can have multiple arguments, passed
          either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.getPanel`
    """

    pass


def iconTextRadioCollection(*args, **kwargs):
    """
    This command creates a cluster for iconTextRadioButtons.  Clusters will be parented to the current default layout if no
    parent is specified with the -p/parent flag. As children of the layout they will be deleted when the layout is deleted.
    Clusters may also span more than one window if the -g/global flag is used. In this case the cluster has no parent so
    must be explicitly deleted with the 'deleteUI' command.
    
    Flags:
      - collectionItemArray : cia      (bool)          [query]
          Returns a string list giving the long names of all the items in this collection.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disableCommands : dcm          (bool)          [edit]
          Allows a particular iconTextRadioButton in the collection to be selected without invoking the commands attached to the
          -cc/changeCommand, -onc/onCommand, or -ofc/offCommand flags. This flag is only meaningful when used in conjuction with
          the -edit and -select flags.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - gl : gl                        (bool)          [create,query]
          Set the collection to have no parent layout.  If the collection has a parent layout then it will be deleted with that
          layout, otherwise if it is specified to be global it must be explicitly deleted.
    
      - numberOfCollectionItems : nci  (bool)          [query]
          Returns the number of items that are in this collection.
    
      - parent : p                     (unicode)       [create]
          Set the specified layout to be the parent layout of the cluster.
    
      - select : sl                    (unicode)       [create,query,edit]
          Select the specified collection item.  If queried will return the name of the currently selected collection item.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.iconTextRadioCollection`
    """

    pass


def hudButton(*args, **kwargs):
    """
    This command creates a Heads-up Display (HUD) button control which is placed in a 2D inactive overlay plane on the 3D
    viewport. It is to be used to provide hands-on interaction designated by a user script. The HUD button is derived from a
    generic HUD object and thus inherits a similar workflow. Although this command provides much of the same functionality
    as the headsUpDisplay command, it does not provide headsUpDisplay layout controls such as layoutVisibility,
    nextFreeBlock, lastOccupiedBlock, exists, remove, etc. To access that functionality, please use the headsUpDisplay
    command. This command is focused solely around the creation and management of HUD button controls. Similarly, all
    operations performed by this command are limited to HUDs that are button controls. The only mandatory flags, on creation
    are the section and block flags. Like the headsUpDisplay command, upon creation of a HUD button, an ID number will be
    assigned to it. This can be used to remove the HUD via the headsUpDisplay command (-rid/removeID [int IDNumber]), if
    desired. Alternatively, the headsUpDisplay command can remove HUD objects via their position (section and block), or
    their unique name.
    
    Flags:
      - allowOverlap : ao              (bool)          [create,query,edit]
          Sets the Heads-Up Display to be visible regardless of overlapping section widths/limitations (see -s/section flag
          description for more details).
    
      - block : b                      (int)           [create,query,edit]
          Denotes the individual block that the HUD will reside in, within a section. Each section is composed of a single column
          of blocks. The total number of blocks contained within each section is variable. The number of blocks that will be
          visible within each section is dependent on the size of blocks contained in each section and the current size of the
          window. Blocks begin enumerating from 0 and flexibly increase based on need. For HUD buttons, the format differs from
          that of the standard HUD. The layout using parameters defined by the formatting flags listed below (eg. justify,
          padding, buttonWidth) is shown below: __________________________________ |     |     |          |     |     | |  P  |  J
          |  Button  |  J  |  P  | |_____|_____|__________|_____|_____| P = Sub-block of width, padding J = Justification of the
          entire block Button = Sub-block of width, buttonWidth Block PositioningBlocks on the top section begin from the top edge
          of the main viewport, while the bottom section begins from the bottom edge. Blocks are dynamically removed from
          visibility from the midpoint of the viewport. So, a relatively large block number will not draw to the viewport. Lastly,
          there can be at most one HUD occupying a block at any time. Trying to position a HUD in an occupied block will result in
          an error. Keep this in mind when positioning the HUD.
    
      - blockAlignment : ba            (unicode)       [create,query,edit]
          Specifies the alignment of the block within its respective column. Available alignments are: center, leftand right. The
          default alignment is left.
    
      - blockSize : bs                 (unicode)       [create,query,edit]
          Sets the height of each block. Available heights are: small, medium and large. In pixel measurements, each corresponds
          to a 20, 35 or 50 pixel height, respectively.
    
      - buttonShape : bsh              (unicode)       [create,query,edit]
          Specifies the shape of the button. Available button shapes are: rectangleand roundRectangle. The first will draw a
          rectangular button, while the latter is a rectangle with rounded edges.
    
      - buttonWidth : bw               (int)           [create,query,edit]
          Specifies the width of the button.
    
      - label : l                      (unicode)       [create,query,edit]
          Text label of the HUD button.
    
      - labelFontSize : lfs            (unicode)       [create,query,edit]
          Sets the font size of the label. Available sizes are: small and large.
    
      - padding : p                    (int)           [create,query,edit]
          Specifies the width of both the left and right margins of a block. Default value is 15 pixels.
    
      - pressCommand : pc              (script)        [create,query,edit]
          Specifies the procedure or script to run during a mouse click event.
    
      - releaseCommand : rc            (script)        [create,query,edit]
          Specifies the procedure or script to run during a mouse release event.
    
      - section : s                    (int)           [create,query,edit]
          Defines the section the HUD will appear in. There are 10 sections divided across the screen. Five columns and two rows
          make up the ten element matrix which divide the main viewport. Here is a visual layout of the sections.
          ________________________ |    |    |    |    |    | |    |    |    |    |    | | 0  | 1  | 2  | 3  | 4  | |    |    |
          |    |    | |____|____|____|____|____| |    |    |    |    |    | |    |    |    |    |    | | 5  | 6  | 7  | 8  | 9  |
          |    |    |    |    |    | |____|____|____|____|____|Each section is denoted by a number from 0 to 9 as illustrated
          above. For example, if the second column of the top row was desired, the section would be defined as: -sec 1 To prevent
          HUD objects from displaying over each other and causing a clutter of letters, each row has a defined visibility
          precedence, where each section would have a visibility priority level. Depending on each priority level, when the screen
          space begins to shrink to a point where the section widths of a given row begin to collide, the HUD automatically
          compensates for this by removing the sections of least priority. These sections are made invisible and a warning is
          issued to inform the user of the removal. This continues until only the section of highest priority remains. For each
          row, the priorities are defined as follows. Using the top row as an example: Section 0, has the highest priority,
          followed by Section 4, making the outermost sections of highest priority. Next in the list is Section 2, and lastly
          Sections 1 and 3 are of the equal and least priority. This priority structure can be applied to the bottom row as well.
          The two outermost sections have the highest priority, followed by the middle section, and finally the remaining two
          sections are of lowest priority. This means that as the viewport gradually decreases in width to the point where
          sections in the top row begin to overlap, sections 1 and 3 will be removed from view first, followed by section 2, and
          finally section 4. A similar note is provided below for the block layout.
    
      - visible : vis                  (bool)          [create,query,edit]
          Sets the visibility of the Heads-Up Display on and off.                                    Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hudButton`
    """

    pass


def nodeOutliner(*args, **kwargs):
    """
    The nodeOutliner command creates, edits and queries an outline control that shows dependency nodes and their attributes.
    Compound attributes are further expandable to show their children. Additional configure flags allow multi selection,
    customizable commands to issue upon selection, and showing connections (and connectability) to a single input attribute.
    There are also the abilities to add/remove/replace nodes through the command line interface, and drag/add. In some
    configurations, dragging a connected attribute of a node will load the node at the other end of the connection. There is
    a right mouse button menu and a flag to attach a command to it. The menu is used to list the specific connections of a
    connected attribute. Clicking over any spot but the row of a connected attribute will show an empty menu. By default,
    there is no command attached to the menu. In query mode, return type is based on queried flag.
    
    Flags:
      - addCommand : ac                (script)        [create,query,edit]
          Command executed when the node outliner adds something. String commands use substitution of the term %node for whatever
          is added, eg, if you want to print the object added, the command should be print(\%node \\n\.  Callable python objects
          are passed the node name.
    
      - addObject : a                  (PyNode)        [edit]
          add the given object to the display
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attrAlphaOrder : aao           (unicode)       [create,query,edit]
          Specify how attributes are to be sorted.  Current recognised values are defaultfor no sorting and ascendto sort
          attributes from 'a' to ''z' and descendto sort from 'z' to 'a'. Notes: a) this only applies to top level attributes.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - connectivity : c               (PyNode)        [query,edit]
          Takes an attribute argument (nodeName.attributeName), dims any attributes that can't connect to the given, and
          highlights any attributes already connected
    
      - currentSelection : cs          (bool)          [query]
          Retruns a string array containing what is currently selected
    
      - dc : dc                        (callable)      []
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - lastClickedNode : lcn          (bool)          []
    
      - lastMenuChoice : lmc           (unicode)       [query]
          Returns the text of the most recent menu selection.
    
      - longNames : ln                 (bool)          [query,edit]
          Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the
          niceNamesflag is set.  Default is short names. Queried, returns a boolean.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - menuCommand : mc               (script)        [edit]
          Attaches the given command to each item in the popup menu.
    
      - menuMultiOption : mmo          (bool)          [query,edit]
          Sets whether a menu option labelled next availablewill appear as the first option on any multi-attribute's right mouse
          button menu.  Defaults to True.
    
      - multiSelect : ms               (bool)          [query,edit]
          Allow multiSelect; more than one thing to be selected at a time
    
      - niceNames : nn                 (bool)          [query,edit]
          Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the
          longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the
          longNames flag. Default is on. Queried, returns a boolean.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - noConnectivity : nc            (bool)          [edit]
          Reset the node outliner to not show any connectivity, ie, redraw all rows normally.
    
      - nodesDisplayed : nd            (bool)          [query]
          Returns a string array containing the list of nodes showing in the node Outliner
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - pressHighlightsUnconnected : phu (bool)          [query,edit]
          Sets whether clicking on an unconnected plug will select it or not.  Default is True.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - redraw : r                     (bool)          []
    
      - redrawRow : rr                 (bool)          []
    
      - remove : rm                    (unicode)       [edit]
          remove the given object from the display
    
      - removeAll : rma                (bool)          [edit]
          remove all objects from the display
    
      - replace : rpl                  (PyNode)        [query,edit]
          replace what's displayed with the given objects
    
      - selectCommand : sc             (script)        [query,edit]
          Command issued by selecting.  Different from the cflag in that this command will only be issued if something is
          selected.
    
      - showConnectedOnly : sco        (bool)          [query,edit]
          show (true) or hide (false) only attributes that are connected matching input/output criteria
    
      - showHidden : sh                (bool)          [query,edit]
          show (true) or hide (false) UI invisible attributes that match the input/output criteria
    
      - showInputs : si                (bool)          [query,edit]
          show only UI visible attributes that can be connected to
    
      - showNonConnectable : snc       (bool)          [query,edit]
          show (true) or hide (false) non connectable attributes that match the input/output criteria
    
      - showNonKeyable : snk           (bool)          [query,edit]
          show (true) or hide (false) non keyframeable (animatable) attributes that match the input/output criteria
    
      - showOutputs : so               (bool)          [query,edit]
          show only UI visible attributes that can be connected from
    
      - showPublished : sp             (bool)          [query,edit]
          Show only published attributes for an asset or a member of an asset. This flag is ignored on nodes not related to
          assets.
    
      - showReadOnly : sro             (bool)          [query,edit]
          show only read only attributes attributes that can be connected from
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.nodeOutliner`
    """

    pass


def saveAllShelves(*args, **kwargs):
    """
    This command writes all shelves that are immediate children of the specified control layout to the prefs directory.
    
    
    Derived from mel command `maya.cmds.saveAllShelves`
    """

    pass


def minimizeApp(*args, **kwargs):
    """
    This command minimizes (iconifies) all of the application's windows into a single desktop icon.  To restore the
    application click on the desktop icon.
    
    
    Derived from mel command `maya.cmds.minimizeApp`
    """

    pass


def refreshEditorTemplates(*args, **kwargs):
    """
    This command refreshes all cached attribute editor templates, including those copied from the standard AE. These are the
    templates constructed internally on a per node type basis. This is useful if attribute elements have changed and the
    templates need to be re-evaluated accordingly.
    
    
    Derived from mel command `maya.cmds.refreshEditorTemplates`
    """

    pass


def menuSet(*args, **kwargs):
    """
    Create a menu set which is used to logically order menus for display in the main menu bar.  Such menu sets can be edited
    and reordered dynamically.
    
    Flags:
      - addMenu : am                   (unicode)       [create]
          Appends a menu onto the end of the current menu set.
    
      - allMenuSets : ams              (bool)          [query]
          Returns an array of the all the menu set object names in use.  Query returns string array.
    
      - currentMenuSet : cms           (unicode)       [create,query]
          The currently active menu set under which all operations affect (append, insert, remove, etc.).  Query returns string.
    
      - exists : ex                    (unicode)       [query]
          Returns whether the specified menu set exists.  This query flag supports string arguments. ie. menuSet -q -exists
          animationMenuSet;
    
      - hotBoxVisible : hbv            (bool)          [create,query,edit]
          Whether this menu set should be displayed in the hotbox as well as in the main menubar.
    
      - insertMenu : im                (unicode, int)  [create]
          Inserts a menu into a specified index in the current menu set.
    
      - label : l                      (unicode)       [create,query]
          The label of the current menu set.  Query returns string.
    
      - menuArray : ma                 (<type 'unicode'>, ...) [create,query]
          An array of menu names (strings) in the current menu set.  Query returns string array.
    
      - moveMenu : mm                  (unicode, int)  [create]
          Moves a specified menu from the current menu set to a new position.
    
      - moveMenuSet : mms              (unicode, int)  [create]
          Moves a specified menu set to another index.
    
      - numberOfMenuSets : nms         (bool)          [query]
          Number of menuSets in total.  Query returns int.
    
      - numberOfMenus : nm             (bool)          [query]
          The mumber of menus in the current menu set.  Query returns int.
    
      - permanent : p                  (bool)          [create,query,edit]
          Whether this menu set can be removed.
    
      - removeMenu : rm                (unicode)       [create]
          Removes a specified menu from the current menu set.
    
      - removeMenuSet : rms            (unicode)       [create]
          Removes the specified menu set object from the list of all menu sets.                  Flag can have multiple arguments,
          passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.menuSet`
    """

    pass


def connectControl(*args, **kwargs):
    """
    This command attaches a UI widget, specified as the first argument, to one or more dependency node attributes. The
    attributes/nodes don't have to exist yet, they will get looked up as needed. With no flag specified, this command works
    on these kinds of controls: floatField, floatScrollBar, floatSlider, intField, intScrollBar, intSlider, floatFieldGrp,
    intFieldGrp, checkBox, radioCollection, and optionMenu. With the indexflag, It will also work on the individual
    components of all other groups. This command sets up a two-way connectionbetween the control and the (first-specified)
    attribute. If this first attribute is changed in any way, the control will be appropriately updated to match its value.
    Summary: if you change the control, ALL the connected attributes change. If you change the FIRST attribute attached to
    the control, then the control will change. NOTE: the two-way connection will not be established if the attributes do not
    exist when the connectControlcommand is run. If the user later uses the control, the connection will be established at
    that time. To effectively use connectControlwith radioCollections and optionMenus, you must attach a piece of data to
    each radioButton and menuItem. This piece of data (an integer) can be attached using the dataflag in the radioButtonand
    menuItemcommands. When the button/item is selected, the attribute will be set to the value of its data. When the
    attribute is changed, the collection (or optionMenu) will switch to the item that matches the new attribute value. If no
    item matches, it will be left unchanged. There are some specialized controls that have connection capability (and more)
    built right into them. See attrFieldSliderGrp, attrFieldGrp, and attrColorSliderGrp. Using these classes can be easier
    than using connectControl.
    
    Flags:
      - fileName : fi                  (bool)          [create]
          This flag causes the connection to be treated as a filename, and the conversion from internal to external filename
          representation is made as the data is copied. This only applies to connections to Tfield controls.
    
      - index : index                  (int)           [create]
          This flag enables you to pick out a sub-control from a group that contains a number of different controls. For example,
          you can connect one field of a floatFieldGrp.  You must count each member of the group, including any text labels that
          may exist.  For example, if you have a check box group with a label, the label will count as index 1, and the first
          check box as index 2.  (Indices are 1-based)
    
      - preventContextualMenu : pcm    (bool)          [create]
          If true, this flag will block the right mouse button menu of the associated control attribute.
    
      - preventOverride : po           (bool)          [create]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.connectControl`
    """

    pass


def panel(*args, **kwargs):
    """
    This command allows editing or querying properties of any panels. Not all of the common properites of panels can be used
    with this command. Flags such as -tearOff and -replacePanel require that you use the explicit panel command. The command
    'getPanel -typeOf panelName' will return the explicit type of a panel. In query mode, return type is based on queried
    flag.
    
    Flags:
      - control : ctl                  (bool)          [query]
          Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels
          may not have controls at times.  This flag can return if no control is present.
    
      - copy : cp                      (unicode)       [edit]
          Makes this panel a copy of the specified panel.  Both panels must be of the same type.
    
      - createString : cs              (bool)          [edit]
          Command string used to create a panel
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the Maya panel.
    
      - editString : es                (bool)          [edit]
          Command string used to edit a panel
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - init : init                    (bool)          [create,edit]
          Initializes the panel's default state.  This is usually done automatically on file -new and file -open.
    
      - isUnique : iu                  (bool)          [query]
          Returns true if only one instance of this panel type is allowed.
    
      - label : l                      (unicode)       [query,edit]
          Specifies the user readable label for the panel.
    
      - menuBarVisible : mbv           (bool)          [create,query,edit]
          Controls whether the menu bar for the panel is displayed.
    
      - needsInit : ni                 (bool)          [query,edit]
          (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for
          initialization.  Used during file -new and file -open.
    
      - parent : p                     (unicode)       [create]
          Specifies the parent layout for this panel.
    
      - popupMenuProcedure : pmp       (script)        [query,edit]
          Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The
          procedure should take one string argument which is the panel's name.
    
      - replacePanel : rp              (unicode)       [edit]
          Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.
    
      - tearOff : to                   (bool)          [query,edit]
          Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag
          will return if the panel has been torn off into its own window.
    
      - tearOffCopy : toc              (unicode)       [create]
          Will create this panel as a torn of copy of the specified source panel.
    
      - unParent : up                  (bool)          [edit]
          Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.panel`
    """

    pass


def attrControlGrp(*args, **kwargs):
    """
    This command creates a control of the type most appropriate for the specified attribute, and associates the control with
    the attribute. Any change to the control will cause a change in the attribute value, and any change to the attribute
    value will be reflected in the control. Not all attribute types are supported.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Sets or queries the annotation value of the control group.
    
      - attribute : a                  (PyNode)        [create,query,edit]
          Sets or queries the attribute the control represents. The name of the attribute must be fully specified, including the
          name of the node. Some types of attributes are not supported, but most commonly used attribute types are.
    
      - changeCommand : cc             (script)        [create,query,edit]
          Sets or queries the change command of the control group. The change command will be executed when the control is used to
          change the value of the attribute.
    
      - enable : en                    (bool)          [create,query,edit]
          Sets or queries the enable state of the control group. The control is dimmed if the enable state is set to false.
    
      - handlesAttribute : ha          (PyNode)        [query,edit]
          Returns true or false as to whether this command can create a control for the specified attribute.
    
      - hideMapButton : hmb            (bool)          [create,query,edit]
          Force the map button to remain hidden for this control.
    
      - label : l                      (unicode)       [create,query,edit]
          Sets or queries the label of the control group.
    
      - preventOverride : po           (bool)          [create,query,edit]
          Sets or queries the prevent adjustment state of the control group. If true, the RMB menu for the control will not allow
          adjustments to be made.                                    Flag can have multiple arguments, passed either as a tuple or
          a list.
    
    
    Derived from mel command `maya.cmds.attrControlGrp`
    """

    pass


def saveShelf(*args, **kwargs):
    """
    This command saves the specified shelf (first argument) to the specified file (second argument). Note that this command
    doesn't work well with controls that have mixed mel and python command callbacks.  Also, because it saves the state to a
    mel file, it does not work with callbacks that are python callable objects.
    
    
    Derived from mel command `maya.cmds.saveShelf`
    """

    pass


def promptBoxGenerator(*args, **kwargs):
    """
    Keep prompting for values until cancelled
    """

    pass


def defaultLightListCheckBox(*args, **kwargs):
    """
    This command creates a checkBox that controls whether a shadingGroup is connected/disconnected from the
    defaultLightList.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       []
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - shadingGroup : sg              (PyNode)        [create,edit]
          The shading group that is to be connected/disconnected from the defaultLightList.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.defaultLightListCheckBox`
    """

    pass


def promptBox(title, message, okText, cancelText, **kwargs):
    """
    Prompt for a value. Returns the string value or None if cancelled
    """

    pass


def menu(*args, **kwargs):
    """
    This command creates a new menu and adds it to the default window's menubar if no parent is specified.  The menu can be
    enabled/disabled. Note that this command may also be used on menu objects created using the command menuItem -sm/subMenu
    true.
    
    Modifications
      - added ability to query parent
    
    Flags:
      - allowOptionBoxes : aob         (bool)          [create,query]
          Deprecated. All menus now always allow option boxes. Indicate whether the menu will be able to support option box menu
          items.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteAllItems : dai           (bool)          [create,edit]
          Delete all the items in this menu.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the menu.
    
      - enable : en                    (bool)          [create,query,edit]
          Enables/disables the menu.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - familyImage : fi               (unicode)       [create,query,edit]
          The filename of the icon associated with the menu. This icon will be used if a menu item does not have an icon image
          defined.
    
      - helpMenu : hm                  (bool)          [create,query,edit]
          Indicates that this menu is the help menu and will be the right most menu in the menu bar. On Unix systems the help menu
          is also right justified in the menu bar.
    
      - itemArray : ia                 (bool)          [query]
          Return string array of the menu item names.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that is displayed for the menu.  If no label is supplied then the menuName will be used.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2014, 2015). Currently only
          accepts major version numbers (e.g. 2014.5 should be given as 2014).
    
      - mnemonic : mn                  (unicode)       [create,query,edit]
          Set the Alt key to post that menu.  The character specified must match the case of its corresponding character in the
          menu item text, but selection from the keyboard is case insensitive.
    
      - numberOfItems : ni             (bool)          [query]
          Return number of items in the menu.
    
      - parent : p                     (unicode)       [create]
          Specify the window that the menu will appear in.
    
      - postMenuCommand : pmc          (script)        [create,edit]
          Specify a script to be executed when the menu is about to be shown.
    
      - postMenuCommandOnce : pmo      (bool)          [create,query,edit]
          Indicate the -pmc/postMenuCommandshould only be invoked once.  Default value is false, ie. the -pmc/postMenuCommandis
          invoked every time the menu is shown.
    
      - tearOff : to                   (bool)          [create]
          Makes the menu tear-off-able.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this menu feature was introduced. The argument should be given as a string of the version
          number (e.g. 2014, 2015). Currently only accepts major version numbers (e.g. 2014.5 should be given as 2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          Shows/hides the menu.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.menu`
    """

    pass


def cmdShell(*args, **kwargs):
    """
    This command creates a scrolling field that behaves similar to a unix shell for entering user input.  You may specify
    the number of lines that will be remembered by the field with the -nsl/numberOfSavedLines flag.  The default number of
    lines saved is 100.  The shellField also maintains a command history buffer. You can specify the number of input lines
    that will be saved with the -hlc/historyLineCount flag.  The default size of this buffer is 10.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - clear : cl                     (bool)          [create]
          Erases all visible text, and also deletes any text that had scrolled of the top of the field.  After clearing the field
          it will be blank, and you will not be able to scroll up to see previous lines.  This flag does not affect the command
          history buffer, however.
    
      - command : c                    (unicode)       []
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfHistoryLines : nhl     (int)           [create,query,edit]
          The number of input lines to be saved in the command history buffer.  You can cycle through this buffer by pressing the
          up and down arrow keys.  Valid values are 0 through 32767.  Any value less than 0 will be handled as if 0 was specified.
          Similarly, any value greater than 32767 will be handled as if 32767 was specified.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - numberOfSavedLines : nsl       (int)           [create,query,edit]
          The total number of lines (the scrolled lines and currently visible lines) that will be remembered by the field. Any
          lines beyond this number will be lost, and the user will not be able to review them by scrolling.  Valid values are 1
          through 32767.  Any value less than 1 will be handled as if 1 was specified.  Similarly, any value greater than 32767
          will be handled as if 32767 was specified.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - prompt : pr                    (unicode)       [create,query,edit]
          The text that is used as a prompt.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.cmdShell`
    """

    pass


def radioButton(*args, **kwargs):
    """
    This command creates a radio button that is added to the most recently created radio collection if the
    -cl/collectionflag is not used.
    
    Flags:
      - align : al                     (unicode)       [create,query,edit]
          This flag is obsolete and should no longer be used. The radio button label will always be left-aligned.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the radio button's state is changed. Note that this flag should not be used in conjunction with
          onCommand and offCommand. That is, one should either use changeCommand and test the state of the radio button from
          inside the callback, or use onCommand and offCommand as separate callbacks.
    
      - collection : cl                (unicode)       [create]
          To explicitly add a radio button to a collection of radio buttons specify the name of the radio collection.
    
      - data : da                      (int)           [create,query,edit]
          Internal data associated with the radio button.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the radio button.  By default, this flag is set to true and the radio button value may be changed by
          clicking on it.  If false then the radio button is 'read only' and can not be clicked on. The value of the radio button
          can always be changed with the -sl/selectflag regardless of the state of the -ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The label text.  The default label is the name of the control.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - offCommand : ofc               (script)        [create,edit]
          Command executed when the radio button is turned off.
    
      - onCommand : onc                (script)        [create,edit]
          Command executed when the radio button is turned on.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - recomputeSize : rs             (bool)          [create,query,edit]
          If true then the control will recompute it's size to just fit the size of the label.  If false then the control size
          will remain fixed as you change the size of the label.  The default value of this flag is true.
    
      - select : sl                    (bool)          [create,query,edit]
          Select the radio button.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.radioButton`
    """

    pass


def treeView(*args, **kwargs):
    """
    This command creates a custom control.
    
    Flags:
      - addItem : ai                   (unicode, unicode) [create,edit]
          Adds a tree view item to the tree view. First argument specifies the item's name, second argument specifies the item's
          parent (use an empty string to have it at the top level of the tree)
    
      - allowDragAndDrop : adr         (bool)          [create,query,edit]
          Allow the user to perform drag and drop of treeView items.  If enabled, re-ordering / re-parenting operations can be
          perfomed with the middle mouse button. This flag takes precendence over other drag and drop related flags. Defaults to
          true.
    
      - allowHiddenParents : ahp       (bool)          [create,query,edit]
          If not cleared(default), the treeView will make parent nodes of visible nodes automatically visible
    
      - allowMultiSelection : ams      (bool)          [create,query,edit]
          Specify multi or single selection mode. Allow the user to perform multiple selection by holding ctrl or shift key while
          selecting items of treeView items. Defaults to true.
    
      - allowReparenting : arp         (bool)          [create,query,edit]
          Allow the user to reparent items in the tree view using the middle mouse button. Defaults to true. If false, user can
          still reorder items within a group using the middle mouse button.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attachButtonRight : abr        (int)           [create,edit]
          Sets tree view item's buttons to appear on the right or left. Argument specifies if they are to be attached to the
          right, if it is set to false they will attach on the left.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - borderHighlite : bh            (unicode, bool) [create,edit]
          Sets an item's border as highlit or not. First Argument specifies item, second argument specifies on or off.
    
      - borderHighliteColor : bcl      (unicode, float, float, float) [create,edit]
          Sets the color an item's border highlite will turn when highlite is enabled. first parameter specifies layer three float
          values specify RGB values, between 0 and 1.
    
      - buttonErase : bef              (bool)          [create,query,edit]
          If buttonErase was set true , then even if the button of the treeView item  is set invisible , the treeView will still
          erase the buttonRect of this treeView item with background . First argument is the item name  , second argument is
          whether buttonErase was set true or false
    
      - buttonState : bst              (unicode, int, unicode) [create,edit]
          Sets the state of a button. First argument specifies the layer, second argument specifies which button, third argument
          specifies the state Possible states: buttonUp- button is up buttonDown- button is down buttonThirdState- button is in
          state three (used by the 3StateButtonbutton style)
    
      - buttonStyle : bs               (unicode, int, unicode) [create,edit]
          Sets the type of button, used to indicate possible states and if the button is reset upon release. First argument
          specifies the layer, second argument specifies which button, third argument specifies the type of button Possible button
          types: pushButton- two possible states, button is reset to up upon release 2StateButton- two possible states, button
          changes state on click 3StateButton- three button states, button changes state on click
    
      - buttonTextIcon : bti           (unicode, int, unicode) [create,edit]
          Sets a one letter text to use as the icon to use for a specific button on a specific item. First argument specifies the
          item, second argument specifies the button, third argument specifies the icon text.
    
      - buttonTooltip : btp            (unicode, int, unicode) [create,edit]
          Sets a tooltip for specific button on a specific item. First argument specifies the item, second argument specifies the
          button, third argument specifies the tooltip.
    
      - buttonTransparencyColor : btc  (unicode, int, float, float, float) [create,edit]
          Sets the background color of a button that will be used if buttonTransparencyOverride is enabled. First argument
          specifies item, second argument specifies button, three floats specify RGB values, between 0 and 1.
    
      - buttonTransparencyOverride : bto (unicode, int, bool) [create,edit]
          Sets a button's background as being overridden or not. First argument specifies item, second argument specifies button,
          third argument specifies overridden or not.
    
      - buttonVisible : bvf            (unicode, int, bool) [create]
          Sets a button as visible or not. First Argument specifies item. Second Argument specifies a button. Third Argument
          specifies visible or not.
    
      - children : ch                  (unicode)       [query]
          Query the children of an item. If the argument is null, all items will be returned.
    
      - clearSelection : cs            (bool)          [create,edit]
          Clears all selected items.
    
      - contextMenuCommand : cmc       (script)        [create,edit]
          Set the callback function to be invoked just before any attached context menu is shown. This can be used as a
          replacement to, or in addition to the postMenuCommand flag on the popupMenu command. The function should accept a string
          which will be the item that was clicked on (empty if no item was hit). The function should return true if the menu
          should be shown, false otherwise.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - displayLabel : dl              (unicode, unicode) [create,edit]
          Set a label for the item that is different than the string that identifies the item. This label will be used in the
          display of the item. The first parameter specifies the item, the second specifies the display label.
    
      - displayLabelSuffix : dls       (unicode, unicode) [create,edit]
          Set a suffix for the display label for the item. This suffix will not be shown when renaming the item in the tree view.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragAndDropCommand : dad       (script)        [create,edit]
          Sets the callback function to be invoked upon drag and drop of layers. the callback function should take as parameters:
          - a string array of the dropped items - a string array of the items previous parents - an integer array of the items
          previous indexes - a string for the item(s) new parent - an integer array for the item's new indexes - a string for the
          item that now comes before the dropped items - a string for the item that now comes after the dropped items
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editLabelCommand : elc         (script)        [create,edit]
          Set the callback function to be invoked when the user changes the name of an item by double clicking it in the UI. The
          callback should accept two string arguments: the item name and the new name. The item name refers to the name of the
          item and not the display label. The callback function should return a string. An empty string indicates that the rename
          operation was invalid and the control should revert to the original name. If the rename operation is valid the callback
          should return a string that identifies the item, possibly different from the new display name entered by the user.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enableButton : eb              (unicode, int, int) [create,edit]
          Sets a specific button on a specific item to being usable or not. First argument specifies the item, second argument
          specifies the button, third argument specifies on or off.
    
      - enableKeys : enk               (bool)          [edit]
          By default the treeview does not accept input from the keyboard.  By enabling keyboard support The treeview will support
          up/down navigation using the up/down arrow keys.
    
      - enableLabel : enl              (unicode, int)  [create,edit]
          enables or disables the label of a tree view item from being displayed. The first parameter specifies the item, the
          second specifies on or off.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - expandCollapseCommand : ecc    (script)        [create,edit]
          Set the callback function to be invoked upon hitting the expand/collapse button. The function should take as parameters:
          - a string for the item for which the expand/collapse button was hit - an integer for the state of expansion
    
      - expandItem : ei                (unicode, bool) [create,edit]
          Expands or collapses an item's children. First argument specifies the item, second argument specifies expanded or
          collapsed.
    
      - flatButton : fb                (int)           []
    
      - font : fn                      (unicode, unicode) [create,query,edit]
          The first parameter specifies the item string for the TtreeViewNode in the TtreeNodeMap. The second string specifies the
          font for the text. Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fontFace : ff                  (unicode, int)  [create,edit]
          Sets the font face used for the specified item's text: 0 for normal, 1 for bold, 2 for italic.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - hideButtons : hb               (bool)          [create,edit]
          Hides the buttons for an item in the tree view. Can only be used when adding the item to the tree with the addItemflag.
          Space for the buttons is left to make sure items still line up correctly under their parent.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - highlite : hl                  (unicode, bool) [create,edit]
          Sets an item as highlit. Highliting is shown by outlining the item. First parameter specifies the item, the second
          specifies the highliting or not.
    
      - highliteColor : hc             (unicode, float, float, float) [create,edit]
          Sets the color an item's highlite will turn when highlite is enabled. first parameter specifies layer three float values
          specify RGB values, between 0 and 1.
    
      - ignoreButtonClick : ibc        (unicode, int, int) [create,edit]
          Sets a specific button on a specific item to ignore the button clicks First argument specifies the item ,second argument
          specifies the button, third argument specifies on or off
    
      - image : i                      (unicode, int, unicode) [create,edit]
          Sets an image to use as the icon for the button. First argument specifies the item, second argument specifies the
          button, third argument specifies the image.
    
      - isItemExpanded : iie           (unicode)       [query]
          Is the item in the tree view expanded.
    
      - isLeaf : il                    (unicode)       [query]
          Query whether an item is a leaf.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - item : it                      (unicode)       [query]
          Specify the item to query. Used with the flag selectionColorand itemAnnotation.
    
      - itemAnnotation : ia            (unicode, unicode) [create,query,edit]
          Annotate the specified item with an extra string value. When used for query, this flag has no argument and needs to be
          used with the flag item.
    
      - itemDblClickCommand : idc      (script)        [create,edit]
          Set the callback function to be invoked when an item in the tree has been double clicked. The callback should accept one
          string, the display label of the item that was double clicked. If this callback is defined, it supersedes the normal
          item renaming behavior.
    
      - itemDblClickCommand2 : dc2     (script)        [create,edit]
          Set the callback function to be invoked when an item in the tree has been double clicked. This callback is similar to
          itemDblClickCommand(idc), but it accepts two strings: the name and the display label of the item that was double
          clicked. If this callback is defined, it supersedes the normal item renaming behavior
    
      - itemExists : iex               (unicode)       [create,query]
          Queries the existence of the specified Tree View item.
    
      - itemIndex : idx                (unicode)       [create,query]
          Get the index for the specified item in the list of children of the item's parent. Index is 0-based.
    
      - itemParent : ip                (unicode)       [create,query]
          If the specified item is a child, it returns the parent item. If the specified item is not a child it returns nothing.
    
      - itemRenamedCommand : irc       (script)        [create,edit]
          Set the callback function to be invoked when an item in the tree has been renamed. This occurs if there is a successful
          return of the command attached by editLabelCommandor unconditionally if there is no editLabelCommand. The callback
          should accept two strings, the old name and the new name of the item that was renamed.
    
      - itemSelected : isl             (unicode)       [query]
          Queries the item is currently selected or not.
    
      - itemVisible : iv               (unicode, bool) [create,query,edit]
          Control the given item's visibility.
    
      - labelBackgroundColor : lbc     (unicode, float, float, float) [create,edit]
          Set the background color for text label for a particular item in the tree. The first parameter specifies layer. Set
          (-1.0, -1.0, -1.0) to restore the background to the default of transparent
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfButtons : nb           (int)           [create,edit]
          Specifies the number of buttons for items in the tree.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - ornament : ornament            (unicode, int, int, int) [create,edit]
          Sets an item as having an ornament (a small colored circle), its on/off state, if it should have a dot, and its size.
          First Argument specifies item, second argument specifies on or off, third argument specifies dotted or not, fourth
          argument specifies radius (in pixels).
    
      - ornamentColor : orc            (unicode, float, float, float) [create,edit]
          Sets the color an ornament will be draw with for the specified layer.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - pressCommand : pc              (<type 'int'>, script) [create,edit]
          Sets the callback function to be invoked upon clicking a treeView button. First argument specifies which treeView
          button. Second argument specifies the callback function to be executed the callback function should take as parameters:
          - a string for the clicked button's item - an int for the clicked button's state
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - removeAll : ra                 (bool)          [create,edit]
          Removes all items from the tree view.
    
      - removeItem : ri                (unicode)       [create,edit]
          Removes a tree view item from the tree view. If this item has children items, all children items are removed. First
          argument specifies the item's name.
    
      - reverseTreeOrder : rto         (bool)          [create,edit]
          Controls the order the tree will be drawn in (reversed if true).
    
      - rightPressCommand : rpc        (<type 'int'>, script) [create,edit]
          Sets the callback function to be invoked upon right clicking a treeView button. First argument specifies which treeView
          button. Second argument specifies the callback function to be executed the callback function should take as parameters:
          - a string for the clicked button's item - an int for the clicked button's state
    
      - select : sl                    (unicode, int)  []
    
      - selectCommand : sc             (script)        [create,edit]
          Set the callback function to be invoked when an item is selected or deselected in the tree. The function should accept
          one string argument and one integer argument: the item name and the select state respectively. If the function returns
          true, the select/deselect is considered valid and will occur normally, otherwise it will be disallowed. name and
    
      - selectItem : si                (unicode, bool) [create,query,edit]
          Sets an item's selected state. first argument specifies the item, second argument specifies selection status. When used
          for query without arguments, return all selected items in the treeview.
    
      - selectionChangedCommand : scc  (script)        [create,edit]
          Set the callback function to be invoked when a complete selection operation triggered by the user has occurred
          successfully. The callback is invoked if the selectCommandcallback has returned a non-empty value (or always there is no
          selectCommandcallback). This differs from selectCommand in that a simple selection replacement will generate two
          callbacks with selectCommand(one for deselect of the old item and one for select of the new), whereas
          selectionChangedCommandwill only be invoked once, after the selection is complete. The callback is not passed any
          parameters and does not need to return any value (i.e. It is simply a notification mechanism).
    
      - selectionColor : scl           (unicode, float, float, float) [create,query,edit]
          Sets the color an item will turn to indicate that it is selected. first parameter specifies the item three float values
          specify RGB values, between 0 and 1. When used for query, this flag has no argument and needs to be used with the flag
          item. It returns the color an item will become if it is selected.
    
      - showItem : shi                 (unicode)       [create,edit]
          Show the  item. Scroll the list as necessary so that item is visible.
    
      - textColor : tc                 (unicode, float, float, float) [create,edit]
          Sets the label's text color for the specified layer. first argument specifies layer. three float values specify RGB
          values, between 0 and 1.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.treeView`
    """

    pass


def shelfLayout(*args, **kwargs):
    """
    This command creates a new empty shelf layout. The shelf layout can accept drops of commands scripts.
    
    Flags:
      - alignment : aln                (unicode)       [create,query,edit]
          Sets the alignment of the buttons in the layout. Valid options are leftand right.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - cellHeight : ch                (int)           [create,query,edit]
          Set or query the height of the items in the shelf.
    
      - cellWidth : cw                 (int)           [create,query,edit]
          Set or query the width of the items in the shelf.
    
      - cellWidthHeight : cwh          (int, int)      [create,query,edit]
          Set the width and height of the items in the shelf.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2014, 2015). Currently only
          accepts major version numbers (e.g. 2014.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - position : pos                 (unicode, int)  [create,edit]
          Specify the name of a child control in the grid layout along with a 1-based integer value indicating the desired
          position of the child. Positions increase from left to right within a row and then wrap around to the next row
          increasing from top to bottom. For example, a grid layout with 3 columns and 2 rows has 6 visible positions where 1, 2
          and 3 occupy the first row and 4, 5 and 6 occupy the second.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - spacing : spa                  (int)           [create,query,edit]
          Sets the space between children.
    
      - style : st                     (unicode)       [create,query,edit]
          Set or query the current style of the items in the shelf.  Valid styles are iconOnly, textOnly, iconAndTextHorizontaland
          iconAndTextVertical.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this feature was introduced. The argument should be given as a string of the version number
          (e.g. 2014, 2015). Currently only accepts major version numbers (e.g. 2014.5 should be given as 2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.shelfLayout`
    """

    pass


def defaultNavigation(*args, **kwargs):
    """
    The defaultNavigation command defines default behaviours when creating or manipulating connections between nodes and
    when navigating between nodes via those connections. This command is primarily used by attribute editors.
    
    Flags:
      - connectToExisting : ce         (bool)          [create]
          Connect the destination (which is a node.attribute or simply node) to an existing source. If the source is specified (as
          node.attribute or simply as node), the command will proceed immediately. If the source is not specified, the user will
          be prompted to specify one. Once a source has been specified, a best guess will be made about what the user is trying to
          accomplish by connecting the two, based on the type of source and type of destination. The command will connect the
          nodes/attributes according to the best guess. The destination is specified using the destinationflag and the source
          specified using the sourceflag.
    
      - createNew : cn                 (bool)          [create]
          Create a new node and connect it to the node.attribute specified using the destinationflag.
    
      - defaultAttribute : da          (bool)          [create]
          Returns the name of the attribute to which a connectNodeToNode would connect, given the source(attribute) and
          destination(node) flags. Returns a string.
    
      - defaultTraversal : dtv         (bool)          [create]
          Returns the name of the node to which it would make the most sense to navigate to from the destination node.attribute
          specified. The destination is specified using the destinationflag. Returns a string.
    
      - defaultWorkingNode : dwn       (bool)          [create]
          Returns the name of the node which the user is most likely to want to work with if they are interested in the attributes
          of the destination node. The destination is specified using the destinationflag. Returns a string.
    
      - delete : delete                (bool)          [create]
          Delete nodes with connections flowing into the node.attribute specified by the destinationflag.
    
      - destination : d                (PyNode)        [create]
          Specifies an existing destination attribute for a createNew or connectToExisting.
    
      - disconnect : dis               (bool)          []
    
      - force : f                      (bool)          [create]
          If set to true, then an attempt to connect a source attribute to a destination attribute which already has a source will
          cause the existing source to be disconnected and the new source to be connected in its place. Default value is true.
    
      - ignore : i                     (bool)          [create]
          Ignore any connections flowing into the node.attribute specified by the destinationflag.
    
      - navigatorDecisionString : nds  (unicode)       [create]
          This is your opportunity to pass the navigator a string that can help it decide what behaviour to execute.
    
      - quiet : qt                     (bool)          [create]
          If set to true, then under no circumstances should the user be prompted for more information. Default value is false.
    
      - relatedNodes : ren             (bool)          [create]
          List nodes which are conceptually related to the node.attribute specified by the destination. Related nodes may include,
          but are not limited to, nodes which are directly or indirectly connected to the destination. The destination is
          specified using the destinationflag. Returns an array of strings.
    
      - source : s                     (PyNode)        [create]
          Specifies an existing source attribute for a connectToExisting.
    
      - unignore : u                   (bool)          [create]
          Stop ignoring any connections flowing into the node.attribute specified by the destinationflag.                  Flag
          can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.defaultNavigation`
    """

    pass


def hotkey(*args, **kwargs):
    """
    This command sets the single-key hotkeys for the entire application.             In query mode, return type is based on
    queried flag.
    
    Flags:
      - altModifier : alt              (bool)          [create,query]
    
      - autoSave : autoSave            (bool)          [create]
          If set to true then the hotkeys will always be saved when you quit.  If false then the hotkeys are not saved unless
          savePrefs -hotkeysis used.
    
      - commandModifier : cmd          (bool)          [create]
          The Command key must be pressed to get the hotkey. This is only available on systems which have a separate command key.
          Note that if menu item accelerator keys are being used (menuItem -ke/keyEquivalent), then the accelerator key settings
          override the hotkey settings.
    
      - ctrlModifier : ctl             (bool)          [create,query]
          The Ctrl key must be pressed to get the hotkey. Note that if menu item accelerator keys are being used (menuItem
          -ke/keyEquivalent), then the accelerator key settings override the hotkey settings.
    
      - ctxClient : cc                 (unicode)       [create,query]
          Specifies the hotkey context. It is used together with the other flags to modify or query the hotkey for a certain
          hotkey context. If it is not specified, the global hotkey context will be taken into account. Check hotkeyCtx command to
          see how the hotkeys work with the hotkey contexts.
    
      - dragPress : dp                 (bool)          [create]
          Specify true and the command may be executed during manipulator dragging, if the tool context also allows this. This
          flag is false by default.
    
      - factorySettings : fs           (bool)          [create]
          Resets the hotkeys back to the initial defaults.
    
      - isModifier : mod               (bool)          [create]
          This flag is obsolete and should no longer be used.
    
      - keyShortcut : k                (unicode)       [create]
          Specify what key is being set. The key must be either a single ascii character (capital and lowercase can be set
          independently) or one of the keyword strings for the specialkeyboard characters. The valid keywords are:Up, Down, Right,
          Left,Home, End, Page_Up, Page_Down, InsertReturn, SpaceF1 to F12Tab (Will only work when modifiers are specified)Delete,
          Backspace (Will only work when modifiers are specified)
    
      - name : n                       (unicode)       [create,query]
          The name of the namedCommand object that will be executed when the key is pressed.
    
      - pressCommandRepeat : pcr       (bool)          [create]
          Specify true and the command may be repeated by executing the command repeatLast. This flag is false by default.
    
      - releaseCommandRepeat : rcr     (bool)          [create]
          Specify true and the command may be repeated by executing the command repeatLast. This flag is false by default.
    
      - releaseName : rn               (unicode)       [create,query]
          The name of the namedCommand object that will be executed when the key is released.
    
      - shiftModifier : sht            (bool)          [create,query]
          The Shift key must be pressed to get the hotkey.
    
      - sourceUserHotkeys : suh        (bool)          [create]
          This flag is obsolete. Please use import flag from hotkeySet command to import the user hotkeys.Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hotkey`
    """

    pass


def headsUpDisplay(*args, **kwargs):
    """
    This command creates a Heads-up Display (HUD) object which is placed in a 2D inactive overlay plane on the 3D viewport.
    It is to be used to provide hands-on information designated by a user script. The text string displayed on the viewport
    is formatted using the various flags of this command. The only mandatory flags, on creation are the section and block
    flags. Note if the preset OR command/trigger flags are not present, only a label will be drawn on the viewport. Upon
    creation of a HUD object, an ID number will be assigned to it. This can be used to remove the HUD object (-rid/removeID
    [int IDNumber]), if desired. Alternatively, HUD objects may be removed via their position (section and block), or their
    unique name.
    
    Flags:
      - allDescendants : ad            (bool)          [create,edit]
          This flag can only be used in conjunction with the -ac/attributeChange flag. If it is specified, and the HUD is attached
          to a compound or multi attribute, then the HUD command will run due to changes to the specified attribute as well as
          changes to its descendants.
    
      - allowOverlap : ao              (bool)          [create,query,edit]
          Sets the Heads-Up Display to be visible regardless of overlapping section widths/limitations (see -s/section flag
          description for more details).
    
      - attachToRefresh : atr          (bool)          [create,query,edit]
          Attaches the command to the refresh process. The script is then run each time an idle refresh is run and updates
          directly following it.
    
      - attributeChange : ac           (unicode)       [create,edit]
          Runs the command when the named attribute changes value. The string must identify both the dependency node and the
          particular attribute. If the dependency node is deleted, this HUD is removed (even if the deletion is undoable).
    
      - block : b                      (int)           [create,query,edit]
          Denotes the individual block that the HUD will reside in, within a section. Each section is composed of a single column
          of blocks. The total number of blocks contained within each section is variable. The number of blocks that will be
          visible within each section is dependent on the size of blocks contained in each section and the current size of the
          window. Blocks begin enumerating from 0 and flexibly increase based on need. The resultant output string of each HUD is
          formatted within each block, using parameters defined by the formatting flags listed below (eg. justify, padding,
          labelWidth and dataWidth). The layout is shown in the following diagram: __________________________________________ |
          |     |        |         |     |     | |  P  |  J  |   LW   |   DWX   |  J  |  P  |
          |_____|_____|________|_________|_____|_____| P = Sub-block of width, padding J = Justification of the entire block LW =
          Sub-block of width, labelWidth DWX = X number of sub-blocks of width, dataWidth, for X data elements. Block LayoutThe
          above diagram shows the layout of each block. The widths: padding, labelWidth and dataWidth are defined by their
          respective flags. To elaborate on the layout of the blocks, First the padding of the block is calculated. Then the two
          main sub-blocks (LW and DWX) in the above diagram, are justified and positioned together between the left and right
          margins of the block. The widths of the main sub-blocks are not variable based on it's contents. The only sub-block in
          the above diagram which is unique is the DWX sub-block which actually represents X number of sub-blocks, where X is the
          number of data elements returned by the command. Block PositioningBlocks on the top section begin from the top edge of
          the main viewport, while the bottom section begins from the bottom edge. Blocks are dynamically removed from visibility
          from the midpoint of the viewport. So, a relatively large block number will not draw to the viewport. Lastly, there can
          be at most one HUD occupying a block at any time. Trying to position a HUD in an occupied block will result in an error.
          Keep this in mind when positioning the HUD.
    
      - blockAlignment : ba            (unicode)       [create,query,edit]
          Specifies the alignment of the block within its respective column. Available alignments are: center, leftand right. The
          default alignment is left.
    
      - blockSize : bs                 (unicode)       [create,query,edit]
          Sets the height of each block. Available heights are: small, medium and large. In pixel measurements, each corresponds
          to a 20, 35 or 50 pixel height, respectively.
    
      - command : c                    (script)        [create,query,edit]
          Specifies the procedure or script to run, in order to obtain the desired information. This must return a value or an
          array of values. A warning will be displayed if the command does not return a value. This flag MUST always be
          accompanied by a trigger flag (eg. a condition flag, an event flag, an attachToRefresh flag, etc.).
    
      - conditionChange : cc           (unicode)       [create,edit]
          A trigger which runs the command (to sample the data), when the named condition changes. The named condition must be
          pre-defined or a user defined boolean. To get a list of what conditions exist, use the -lc/listConditions flag.
    
      - conditionFalse : cf            (unicode)       [create,edit]
          A trigger which runs the command (to sample the data), when the named condition becomes false. The named condition must
          be pre-defined or a user defined boolean. To get a list of what conditions exist, use the -lc/listConditions flag.
    
      - conditionTrue : ct             (unicode)       [create,edit]
          A trigger which runs the command (to sample the data), when the named condition becomes true. The named condition must
          be pre-defined or a user defined boolean. To get a list of what conditions exist, use the -lc/listConditions flag.
    
      - connectionChange : con         (unicode)       [create,edit]
          Runs the command when the named attribute changes its connectivity. The string must identify both the dependency node
          and the particular attribute. If the dependency node is deleted, this HUD is removed (even if the deletion is undoable).
    
      - dataAlignment : da             (unicode)       [create,query,edit]
          Specifies the alignment of the data blocks and the data text, within a HUD block. Available alignments are: leftand
          right. The default alignment is left.
    
      - dataFontSize : dfs             (unicode)       [create,query,edit]
          Sets the font size of the returned data. Available sizes are: small and large.
    
      - dataWidth : dw                 (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold a data value. For commands which return more than one
          value (ie. arrays), one of these textboxeswill be created for each data element, each with this specified width. If the
          width of the data value exceeds the width of the textbox, the data value will be truncated to fit within the dimensions
          of the textbox.(To see a layout of a block, see the description of the -block flag.)
    
      - decimalPrecision : dp          (int)           [create,query,edit]
          Sets the decimal precision of any floating point value returned by the command. The valid range of precision values are
          1 to 8.
    
      - disregardIndex : di            (bool)          [create,edit]
          This flag can only be used in conjunction with the -ac/attributeChange flag. If it is specified, and the HUD is attached
          to a multi (indexed) attribute, then the HUD command will run no matter which attribute in the multi changes.
    
      - event : ev                     (unicode)       [create,edit]
          Runs the command when the named event occurs. The named event, must be a pre-defined Maya event. To get a list of what
          events exist, use the -le/listEvents flag.
    
      - exists : ex                    (bool)          [create,query]
          This flag returns whether the given object exists in the Heads-Up Display layout. An object name must be supplied with
          this command. This flag cannot be combined with any other flag.
    
      - getOption : op                 (unicode)       [query]
          This flag will return the value of the option specified by the string. See setOption for a list of options
    
      - gridColor : gco                (int)           [create,query,edit]
          This flag specifies a color for the grid lines using the inactive color palette. Specifying an index number between 1 to
          23 will select the corresponding color in the palette.
    
      - label : l                      (unicode)       [create,query,edit]
          Text string that appears to the left of the desired information.
    
      - labelFontSize : lfs            (unicode)       [create,query,edit]
          Sets the font size of the label. Available sizes are: small and large.
    
      - labelWidth : lw                (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold the label. The contents of this textboxwill be left
          justified. If the width of the actual label exceeds the width of the textbox,the label will be truncated to fit within
          the dimensions of the textbox.(To see a layout of a block, see the description of the -block flag.)
    
      - lastOccupiedBlock : lob        (int)           [create]
          Returns the block number of the last occupied block in a given section.
    
      - layoutVisibility : lv          (bool)          [create,query,edit]
          Sets the visibility of Heads-Up Display layout on and off. This does not modify individual visibilities of heads-up
          displays, but turns off the layout so that no heads-up displays will draw to screen. Personalized settings for the
          visibilities of HUDs are kept safe. This flag can only be used by itself, excepting edit and query.
    
      - listConditions : lc            (bool)          [create,query]
          This flag will return a string array containing all names of the available conditions.
    
      - listEvents : le                (bool)          [create,query]
          This flag will return a string array containing all names of the available events.
    
      - listHeadsUpDisplays : lh       (bool)          [create,query]
          This flag will return a string array containing all names of existing HUDs.
    
      - listNodeChanges : lnc          (bool)          [create,query]
          This flag will return a string array containing all names of the available node changes.
    
      - listPresets : lp               (bool)          [create,query]
          This flag will return a string array containing all names of the available preset HUDs.
    
      - name : n                       (unicode)       [edit]
          This flag only permits the EDITING of the name of the Heads-Up Display.
    
      - nextFreeBlock : nfb            (int)           [create]
          Returns the block number of the next free block in a given section.
    
      - nodeChanges : nc               (unicode)       [create,query,edit]
          Works only with selection based triggers (ie. SelectionChangedor SomethingSelected), otherwise this flag is ignored.
          This flag attaches the HUD script to execute on specific node changes of any selected node. This flag is used to set a
          nodeChange. In order to reset a nodeChange, use the -rnc/resetNodeChanges flag. To view a list of all available node
          changes, use the -lnc/listNodeChanges flag. The following is a list of available node changes and their function:
          attributeChange:  The script will be sensitive to any attribute changes in the currently                   selected
          nodes. connectionChange: The script will be sensitive to any connection changes in the currently
          selected nodes. instanceChange:   The script will be sensitive to any changes to an instance in the
          currently selected nodes. On query mode, this flag will return the values of all nodeChanges in pairs of values (the
          name of the nodeChange followed by its value). WARNING: (Performance Warning)          Attaching a nodeChange trigger to
          a selection based trigger can cause a large          performance drop, if the node change that is being watched is
          caused by the          HUD script itself. With this said, an attempt should be made to keep the HUD command/script
          simple and limited to retrieving data. Changing an attribute, creating or                  modifying a connection or
          instance will all result in a performance drop.
    
      - padding : p                    (int)           [create,query,edit]
          Specifies the width of both the left and right margins of a block. Default value is 15 pixels.
    
      - preset : pre                   (unicode)       [create,query,edit]
          This setting is used to select certain pre-defined HUDs, some of which retrieve specific data, that is unobtainable
          through normal MEL commands or scripts. This flag is mutually exclusive from the command and trigger flag combination.
          However, presets can work with all other headsUpDisplay attribute flags (ie. block alignment, label, dataFontSize,
          etc.), unless otherwise specified below. To obtain a list of available presets, use the -lp/listPresets flag on this
          command. The following is a list of available presets and a description of each: cameraNamesThis will return the camera
          name that the view is looking through, in the data block, for each view that the HUD is drawing to.polyVertsThis will
          return three values in the data block, regarding the number of vertices that are visible by the camera. 1st Value:
          Represents the number of camera visible vertices, both active and inactive.2nd Value: Represents the number of camera
          visible vertices, on active objects only.3rd Value: Represents the number of camera visible vertices, that are
          active.polyEdgesThis will return three values in the data block, regarding the number of edges that are visible by the
          camera. The order of these three values are similar to the polyVerts preset.polyFacesThis will return three values in
          the data block, regarding the number of faces that are visible by the camera. The order of these three values are
          similar to the polyVerts preset.polyUVsThis will return three values in the data block, regarding the number of UVs that
          are visible by the camera. The order of these three values are similar to the polyVerts preset.polyTrianglesThis will
          return three values in the data block, regarding the number of triangles that are visible by the camera. The order of
          these three values are similar to the polyVerts preset.materialLoadingCountThis will return the material loading count.
          It updates on each refresh.textureLoadingCountThis will return the texture loading count. It updates on each
          refresh.frameRateThis will return a single string carrying both the frame rate and the fpsstring in the data block. It
          updates on each refresh.viewAxisThis will draw the orientation of the grid axes within the HUD. It updates on each
          refresh. While this preset can take in all attribute flags, the only one which will have an effect are block attribute
          related flags (ie. block alignment and block size). The block dimensions of this preset are: blockSize - largeand
          blockWidth - 50, which results in a 50x50 pixel region.distanceFromCameraThis will return in the data block the distance
          from the view's camera to the centre of the bounding box containing the selected objects in the view.
    
      - refresh : r                    (bool)          [create]
          This flag forces the given Heads-Up Display element to refresh, updating the value displayed.  This flag cannot be
          combined with any other flag.
    
      - remove : rem                   (bool)          [create,edit]
          This command will remove a given HUD object, given a specified HUD name. This flag will override all other flags and is
          mutually exclusive from the other remove flags.
    
      - removeID : rid                 (int)           [create,edit]
          This command will remove a given HUD object, given a specified HUD ID number assigned to it at creation time. This flag
          will override all other flags and is mutually exclusive from the other remove flags.
    
      - removePosition : rp            (int, int)      [create,edit]
          This command will remove the contents of a specific block location in the HUD layout. This flag will override all other
          flags and is mutually exclusive from the other remove flags. Syntax for this flag is: -removePosition/rp [section]
          [block].
    
      - resetNodeChanges : rnc         (unicode)       [edit]
          This flag will reset a specificied nodeChange back to false. This flag only operates under the edit flag. See the
          description for the -nc/nodeChanges flag for further details.
    
      - scriptResult : sr              (bool)          [query]
          This flag is only used in conjunction with the query flag. Calling a query on this flag returns the most recent result
          of the HUD.
    
      - section : s                    (int)           [create,query,edit]
          Defines the section the HUD will appear in. There are 10 sections divided across the screen. Five columns and two rows
          make up the ten element matrix which divide the main viewport. Here is a visual layout of the sections.
          ________________________ |    |    |    |    |    | |    |    |    |    |    | | 0  | 1  | 2  | 3  | 4  | |    |    |
          |    |    | |____|____|____|____|____| |    |    |    |    |    | |    |    |    |    |    | | 5  | 6  | 7  | 8  | 9  |
          |    |    |    |    |    | |____|____|____|____|____|Each section is denoted by a number from 0 to 9 as illustrated
          above. For example, if the second column of the top row was desired, the section would be defined as: -sec 1 To prevent
          HUD objects from displaying over each other and causing a clutter of letters, each row has a defined visibility
          precedence, where each section would have a visibility priority level. Depending on each priority level, when the screen
          space begins to shrink to a point where the section widths of a given row begin to collide, the HUD automatically
          compensates for this by removing the sections of least priority. These sections are made invisible and a warning is
          issued to inform the user of the removal. This continues until only the section of highest priority remains. For each
          row, the priorities are defined as follows. Using the top row as an example: Section 0, has the highest priority,
          followed by Section 4, making the outermost sections of highest priority. Next in the list is Section 2, and lastly
          Sections 1 and 3 are of the equal and least priority. This priority structure can be applied to the bottom row as well.
          The two outermost sections have the highest priority, followed by the middle section, and finally the remaining two
          sections are of lowest priority. This means that as the viewport gradually decreases in width to the point where
          sections in the top row begin to overlap, sections 1 and 3 will be removed from view first, followed by section 2, and
          finally section 4. A similar note is provided below for the block layout.
    
      - setOption : so                 (unicode, unicode) [edit]
          This flag will edit the option specified by the first string. Current options are: smpPolyCount - cageor smp- in smooth
          mesh preview, determines the poly count display
    
      - showGrid : sg                  (bool)          [create,query,edit]
          This flag will toggle the display of the grid lines of the HUD layout.
    
      - visible : vis                  (bool)          [create,query,edit]
          Sets the visibility of the Heads-Up Display on and off.                                    Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.headsUpDisplay`
    """

    pass


def folderButtonGrp(name='None', *args, **kwargs):
    pass


def iconTextStaticLabel(*args, **kwargs):
    """
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
    fits the current size of the control given its current style. This command creates an iconTextStaticLabel.
    
    Flags:
      - align : al                     (unicode)       [create,query,edit]
          The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
          only available when -st/style is set to iconAndTextCentered.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disabledImage : di             (unicode)       [create,query,edit]
          Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
          a Windows only flag.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - flipX : fx                     (bool)          [create,query,edit]
          Is the image flipped horizontally?
    
      - flipY : fy                     (bool)          [create,query,edit]
          Is the image flipped vertically?
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          If you are not providing images with different sizes then you may use this flag for the control's image. If the
          iconOnlystyle is set, the icon will be scaled to the size of the control.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three icons. The icon that best fits the current size of the control will be displayed.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string, up to 6 characters, representing a label that will be displayed on top of the image.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that appears in the control.
    
      - labelOffset : lo               (int)           [create,query,edit]
          The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - marginHeight : mh              (int)           [create,query,edit]
          The number of pixels above and below the control content. The default value is 1 pixel.
    
      - marginWidth : mw               (int)           [create,query,edit]
          The number of pixels on either side of the control content. The default value is 1 pixel.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
          The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
    
      - overlayLabelColor : olc        (float, float, float) [create,query,edit]
          The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rotation : rot                 (float)         [create,query,edit]
          The rotation value of the image in radians.
    
      - style : st                     (unicode)       [create,query,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
          iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
          be scaled to the size of the control.
    
      - useAlpha : ua                  (bool)          [create,query,edit]
          Is the image using alpha channel?
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this control feature was introduced. The argument should be given as a string of the version
          number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
          2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.iconTextStaticLabel`
    """

    pass


def hotBox(*args, **kwargs):
    """
    This command controls parameters related to the hotBox menubar palette. When the command is invoked with no flags, the
    hotBox is popped up. In query mode, return type is based on queried flag.
    
    Flags:
      - PaneOnlyMenus : po             (bool)          [create]
          Sets a row of menus to be the only visible row.
    
      - PaneToggleMenus : pt           (bool)          [create,query]
          Sets the visibilty of a row of menus to on or off.
    
      - animationOnlyMenus : ao        (bool)          [create,query]
    
      - animationToggleMenus : at      (bool)          [create,query]
    
      - clothOnlyMenus : clo           (bool)          [create,query]
    
      - clothToggleMenus : clt         (bool)          [create,query]
    
      - commonOnlyMenus : co           (bool)          [create,query]
    
      - commonToggleMenus : ct         (bool)          [create,query]
    
      - customMenuSetsToggleMenus : cst (bool)          [create,query]
    
      - displayCenterOnly : dco        (bool)          [create]
          Three different display styles are defined for the hotBox. It can be fully displayed (dh), display only the marking menu
          zones (dzo) or no display (dco) which means that the entire screen can be used to access the marking menus defined in
          the center zone.
    
      - displayHotbox : dh             (bool)          [create,query]
    
      - displayStyle : ds              (bool)          [query]
          Returns a string that identifies the flag used to set the current display style. The results can be dh, dzo, or dco,
          depending on  which style the hotBox is using at the moment.
    
      - displayZonesOnly : dzo         (bool)          [create,query]
    
      - dynamicsOnlyMenus : do         (bool)          [create,query]
    
      - dynamicsToggleMenus : dt       (bool)          [create,query]
    
      - liveOnlyMenus : lo             (bool)          [create,query]
    
      - liveToggleMenus : lt           (bool)          [create,query]
    
      - menuSetOnly : mso              (unicode)       []
    
      - menuSetToggle : mst            (unicode, bool) []
    
      - modelingOnlyMenus : mdo        (bool)          [create,query]
    
      - modelingToggleMenus : mdt      (bool)          [create,query]
    
      - noClickCommand : ncc           (script)        [create]
          The command to be executed if the hotBox is engaged and then disengaged within noClickDelay time units.
    
      - noClickDelay : ncd             (float)         [create]
          If the hotBox is engaged and then disengaged within this time interval, then the noClickCommand is executed. The time
          interval is in seconds.  The default value is 0.1.
    
      - noClickPosition : ncp          (bool)          [create]
          If a -noClickCommand has been specified then this flag will cause the X and Y screen coordinates of the mouse pointer to
          be appended as arguments to that command. The coordinates used are those of the pointer at the time when the hotbox
          command was initiated.
    
      - noKeyPress : nkp               (bool)          [create,query]
          Normally the hotbox is popped by a pressing a keyboard key. Use the nkpflag to pop the hotbox from a device other than
          the keyboard (still use the rlflag to unpop the hotbox).
    
      - polygonsOnlyMenus : plo        (bool)          [create,query]
    
      - polygonsToggleMenus : plt      (bool)          [create,query]
    
      - position : pos                 (int, int)      [create]
          Specify the screen position the hotbox should be centered at next time it is displayed.  The default is the cursor
          position.
    
      - release : rl                   (bool)          [create,query]
          Action to be called on the release of the key which invoked the hotbox
    
      - renderingOnlyMenus : ro        (bool)          [create,query]
    
      - renderingToggleMenus : rt      (bool)          [create,query]
    
      - riggingOnlyMenus : rgo         (bool)          [create,query]
    
      - riggingToggleMenus : rgt       (bool)          [create,query]
    
      - rmbPopups : rmb                (bool)          [create,query]
          Enables/Disables a popup menu of the current function set. This popup menu appear when the right mouse button is pressed
          in the center zone of the hotbox.
    
      - showAllToggleMenus : a         (bool)          [create,query]
          Sets the visibility of all menus to on or off. When queried, will only return true if all menu rows are visible.
    
      - surfacesOnlyMenus : so         (bool)          [create,query]
    
      - surfacesToggleMenus : st       (bool)          [create,query]
    
      - transparenyLevel : tr          (int)           [create,query]
          The percentage of transparency, from 0 to 100. Currently, only the values 0, 25, 50, 75 and 100 are supported.  Any
          other values will be rounded off to the nearest supported value.
    
      - updateMenus : um               (bool)          [create]
          Reloads the hotBox menus from the main menubar. This flag is used when the menus in the main menubar are modified, and
          the hotBox menus need to be refreshed.                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.hotBox`
    """

    pass


def showsHourglass(func):
    """
    Decorator - shows the hourglass cursor until the function returns
    """

    pass


def colorEditor(*args, **kwargs):
    """
    The colorEditorcommand displays a modal dialog that may be used to specify colors in RGB or HSV. The default behaviour
    when no arguments are specified is to provide an initial color of black (rgb 0.0 0.0 0.0). The command will return the
    user's color component values along with a boolean to indicate whether the dialog was dismissed by pressing the
    OKbutton.  As an alternative to responding to the colorEditorcommand's return string you can now query the
    -rgb/rgbValue, -hsv/hsvValue, and -r/resultflags to get the same information. The final argument is 1 if the dialog's
    OKbutton was pressed, and 0 if the Cancelbutton was pressed.In query mode, return type is based on queried flag.
    
    Flags:
      - alpha : a                      (float)         []
    
      - hsvValue : hsv                 (float, float, float) [create,query]
          Three float values corresponding to the hue, saturation, and value color components, where the hue value ranges from 0.0
          to 360.0 and the saturation and value components range from 0.0 to 1.0.  Use this flag to specify the initial color of
          the Color Editor, or query this flag to determine the color set in the editor.
    
      - mini : m                       (bool)          [create]
          Enable the mini color editor mode.
    
      - parent : p                     (unicode)       [create]
          Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
          parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
    
      - position : pos                 (bool)          [create]
          Specify the window position for the dialog.
    
      - result : r                     (bool)          [query]
          This query only flag returns true if the dialog's OKbutton was pressed, false otherwise.  If you query this flag
          immediately after showing the Color Editor then it will return the same value as the boolean value returned in the
          colorEditorcommand's return string.
    
      - rgbValue : rgb                 (float, float, float) [create,query]
          Three float values corresponding to the red, green, and blue color components, all of which range from 0.0 to 1.0.  Use
          this flag to specify the initial color of the Color Editor, or query this flag to determine the color set in the editor.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.colorEditor`
    """

    pass


def nodeIconButton(*args, **kwargs):
    """
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
    fits the current size of the control given its current style. This command creates a button that can be displayed with
    different icons, with or without a text label. If the button is drag and dropped onto other controls (e.g., HyperShade),
    the command will be executed and the return string will be used as the name of a dropped node.
    
    Flags:
      - align : al                     (unicode)       [create,query,edit]
          The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
          only available when -st/style is set to iconAndTextCentered.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - command : c                    (script)        [create,query,edit]
          Command executed when the control is pressed. The command should return a string which will be used to facilitate node
          drag and drop.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disabledImage : di             (unicode)       [create,query,edit]
          Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
          a Windows only flag.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - flipX : fx                     (bool)          [create,query,edit]
          Is the image flipped horizontally?
    
      - flipY : fy                     (bool)          [create,query,edit]
          Is the image flipped vertically?
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          If you are not providing images with different sizes then you may use this flag for the control's image. If the
          iconOnlystyle is set, the icon will be scaled to the size of the control.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three icons. The icon that best fits the current size of the control will be displayed.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string, up to 6 characters, representing a label that will be displayed on top of the image.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that appears in the control.
    
      - labelOffset : lo               (int)           [create,query,edit]
          The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - marginHeight : mh              (int)           [create,query,edit]
          The number of pixels above and below the control content. The default value is 1 pixel.
    
      - marginWidth : mw               (int)           [create,query,edit]
          The number of pixels on either side of the control content. The default value is 1 pixel.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
          The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
    
      - overlayLabelColor : olc        (float, float, float) [create,query,edit]
          The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rotation : rot                 (float)         [create,query,edit]
          The rotation value of the image in radians.
    
      - style : st                     (unicode)       [create,query,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
          iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
          be scaled to the size of the control.
    
      - useAlpha : ua                  (bool)          [create,query,edit]
          Is the image using alpha channel?
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this control feature was introduced. The argument should be given as a string of the version
          number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
          2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.nodeIconButton`
    """

    pass


def scrollField(*args, **kwargs):
    """
    This command creates a scrolling field that handles multiple lines of text.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the value changes. This command is executed whenever the field loses focus.
    
      - clear : cl                     (bool)          [create,edit]
          Removes all text in the field.
    
      - command : c                    (unicode)       []
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
          If false then the field is 'read only' and can not be typed into. The text in the field can always be changed with the
          -tx/text flag regardless of the state of the -ed/editable flag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enterCommand : ec              (script)        [create,edit]
          Command executed when the enter key is pressed. This applies to the enter key on the numeric keypad only.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fontPointSize : fns            (int)           [create,query,edit]
          The font point size for the text.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - insertText : it                (unicode)       [create,edit]
          Insert text into the field at the current insertion position (specified by the -ip/insertionPosition flag).
    
      - insertionPosition : ip         (int)           [create,query,edit]
          The insertion position for inserted text.  This is a 1 based value where position 1 specifies the beginning of the
          field.  Position 0 may be used to specify the end of the field.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - keyPressCommand : kpc          (script)        [create,edit]
          Command executed when any key is pressed.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfLines : nl             (int)           [query]
          Number of lines in the scroll field.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - qtFont : qfn                   (unicode)       [create,query,edit]
          The Qt font family for the text.
    
      - selection : sl                 (bool)          [query]
          The selected text in the field.  An empty string is returned if there is no selected text.
    
      - text : tx                      (unicode)       [create,query,edit]
          The field text.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - wordWrap : ww                  (bool)          [create]
          Specify true to break lines at spaces, tabs, or newlines.  Text will continue on the following line.  A value of false
          will not break text between words, in which case text may disappear beyond the edge of the field.  This flag must be set
          at create time. Lines do not word wrap by default.                  Flag can have multiple arguments, passed either as a
          tuple or a list.
    
    
    Derived from mel command `maya.cmds.scrollField`
    """

    pass


def hotkeyEditorPanel(*args, **kwargs):
    """
    A hotkeyEditor creates a new hotkey editor in the current layout. The hotkey editor lets you assign predefined commands,
    MEL scripts, or marking menus to keys and key combinations.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hotkeyEditorPanel`
    """

    pass


def gradientControl(*args, **kwargs):
    """
    This command creates a control that displays the gradient attribute specified. The gradient attribute must be of the
    correct form and naming. It should be a multi attribute with each entry a compound composed of: Either a color compound
    or a float value (the control will automatically detect which and display a ramp or graph accordingly).A single float
    attribute for position.An enum for the interpolation types.Currently the routines to get the value of a ramp structure
    (with interpolation) are not available through MEL, which limits the use of this control by end users. The MEL command
    AEaddRampControl should be used to attach this control to an attribute from attribute editor templates.
    
    Flags:
      - adaptiveScaling : adaptiveScaling (bool)          [create,query,edit]
          Allow the ramp widget display to scale vertically to accommodate values greater than 1.0. True if adaptive scaling is
          enabled, false (the default) if not.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attribute : at                 (PyNode)        [create]
          Specifies the name of the gradient attribute to control.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfControls : nc          (int)           [query]
          Returns the number of controls in the ramp widget
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - refreshOnRelease : ror         (int)           [create,query,edit]
          Define how updates are dispatched during interactive editing of the ramp widget. True causes updates to only dispatch
          after releasing the mouse button after editing. False (the default) causes updates to dispatch interactively during
          editing (e.g. while moving ramp curve points). Note that the global update mode, if set to on releasecan disable the
          effect of this option.
    
      - selectedColorControl : scc     (unicode)       [create,edit]
          Specifies the name of a color control to edit the selected color.
    
      - selectedInterpControl : sic    (unicode)       [create,edit]
          Specifies the name of an enum control to edit the selected interpolation.
    
      - selectedPositionControl : spc  (unicode)       [create,edit]
          Specifies the name of a float slider to edit the selected position.
    
      - staticNumberOfControls : snc   (bool)          [create,query,edit]
          When 'true', this flag disables the creation/deletion of ramp entries (control points) via ramp widget interaction.
          Default is false.
    
      - staticPositions : sp           (bool)          [create,query,edit]
          When 'true', this flag disables the interactive modification of ramp entry positions. Default is false.
    
      - upperLimitControl : ulc        (unicode)       [create,query,edit]
          Specify the name of a text control which is updated with the current upper display limit for the ramp. This option is
          only effective when adaptiveScaling is specified.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - verticalLayout : vl            (bool)          [create,query,edit]
          When 'true', this makes the control orient vertically rather than horizontally. The default is `false` or horizontal.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.gradientControl`
    """

    pass


def helpLine(*args, **kwargs):
    """
    This command creates a help line where tool help/hints are shown.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.helpLine`
    """

    pass


def attrFieldSliderGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a pre-packaged collection of label text, float field and
    float slider (for values with a min or max specified) The group also supports the notion of a larger secondary range of
    possible field values. If an attribute is specified for this object, then it will use any min and max values defined in
    the attribute.  The user-specified values can reduce the min and max, but cannot expand them. The field created here is
    an expression field -- while normally operating as a float field, the user can type in any expression starting with the
    character =.  This will expand the field to occupy the space previously taken by the slider. The field also has an
    automatic menu brought up by the right mouse button. The contents of this menu change depending on the state of the
    attribute being watched by the field.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attribute : at                 (unicode)       [create,query,edit]
          The name of a unique attribute of type double or int. This newly created field will be attached to the attribute, so
          that modifications to one will change the other.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          The command string is executed when the value of the slider or floatField changes.  It will be executed only once after
          a drag of the slider.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraButton : eb               (bool)          [create]
          Add an extra icon button to the end of this control.
    
      - extraButtonCommand : ebc       (script)        [create,edit]
          The command string is executed when the extra button is clicked.
    
      - extraButtonIcon : ebi          (unicode)       [create,query,edit]
          The icon file name of the extra button.
    
      - fieldMaxValue : fmx            (float)         [create,query,edit]
          Set the maximum value for the field.  This flag allows you to specify a maximum bound for the field higher than that of
          the slider.   (See note above about max and min values.)
    
      - fieldMinValue : fmn            (float)         [create,query,edit]
          Set the minimum value for the field.  This flag allows you to specify a minimum bound for the field lower than that of
          the slider.  (See note above about max and min values.)
    
      - fieldStep : fs                 (float)         [create,query,edit]
          Sets the increment for the float field.
    
      - forceAddMapButton : fmb        (bool)          [create]
          Force adding a map button to this control. If this option is true, option hideMapButton is suppressed.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - hideMapButton : hmb            (bool)          [create]
          Force the map button to remain hidden for this control.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          By default, the label of this field will be the name of the attribute.  This flag can be used to override that name with
          whatever string you want.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (float)         [create,query,edit]
          Sets the maximum value for both the slider and the field. (See note above about min and max values)
    
      - minValue : min                 (float)         [create,query,edit]
          Sets the minimum value for both the slider and the field. (by default max and min are set according to what is in the
          attribute, if anything.  If no max and min are specified, or if only one of the two are specified, then no slider is
          created.)
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [create,edit]
          Sets the number of digits to the right of the decimal. (If attached to an int attribute, this is automatically set to 0
          and cannot be overridden.)
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - sliderMaxValue : smx           (float)         [create,query,edit]
          Set the maximum value for the slider.  The slider max will be clipped to the field max.
    
      - sliderMinValue : smn           (float)         [create,query,edit]
          Set the minimum value for the slider.  The slider min will be clipped to the field min.
    
      - sliderStep : ss                (float)         [create,query,edit]
          On Linux the slider step value represents the amount the value will increase or decrease when you click either side of
          the slider.
    
      - step : s                       (float)         [create,query,edit]
          Sets the increment for both the slider and float field.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - vertical : vr                  (bool)          [create,query]
          Whether the orientation of the controls in this group are horizontal (default) or vertical.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.attrFieldSliderGrp`
    """

    pass


def picture(*args, **kwargs):
    """
    This command creates a static image.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          Sets the image given the .xpm file name.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - tile : tl                      (bool)          [create,query,edit]
          If true, the picture is tiled to fill the picture area. False by default. (Windows only flag)
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.picture`
    """

    pass


def symbolCheckBox(*args, **kwargs):
    """
    This command creates a symbol check box.  A symbol check box is a simple control containing a pixmap and a state of
    either on or off. Commands can be attached to any or all of the following events:  when the symbol check box is turned
    on, turned off, or simply when it's state is changed.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the check box's state is changed. Note that this flag should not be used in conjunction with
          onCommand and offCommand. That is, one should either use changeCommand and test the state of the check box from inside
          the callback, or use onCommand and offCommand as separate callbacks.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disableOffImage : dfi          (unicode)       [create,query,edit]
          Image displayed when the check box is off and disabled.
    
      - disableOnImage : dni           (unicode)       [create,query,edit]
          Image displayed when the check box is on and disabled.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          Image of the check box.
    
      - innerMargin : im               (bool)          [create,query,edit]
          This flag will revert the symbolCheckBox to its pre Maya 2.5 behaviour of having a 2 pixel inner margin. This flag is
          for backward compatibility on Linux only, and will be removed in future releases.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - offCommand : ofc               (script)        [create,edit]
          Command executed when the symbol check box is turned off.
    
      - offImage : ofi                 (unicode)       [create,query,edit]
          Image displayed when the check box is off.
    
      - onCommand : onc                (script)        [create,edit]
          Command executed when the symbol check box is turned on.
    
      - onImage : oni                  (unicode)       [create,query,edit]
          Image displayed when the check box is on.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (bool)          [create,query,edit]
          Value of the check box.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.symbolCheckBox`
    """

    pass


def promptDialog(*args, **kwargs):
    """
    The promptDialog command creates a modal dialog with a message to the user, a text field in which the user may enter a
    response, and a variable number of buttons to dismiss the dialog.  The dialog is dismissed when the user presses any
    button or chooses the close item from the window menu.  In the case where a button is pressed then the name of the
    button selected is returned.  If the dialog is dismissed via the close item then the string returned is specified by the
    -ds/dismissStringflag. The default behaviour when no arguments are specified is to create an empty single button dialog.
    To obtain the text entered by the user simply query the -tx/textflag.
    
    Flags:
      - backgroundColor : bgc          (float, float, float) [create]
          The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. (Windows only flag)
    
      - button : b                     (unicode)       [create]
          Create a button with the given string as it's text.
    
      - cancelButton : cb              (unicode)       [create]
          The cancel button is activated by pressing the escape key. Note that this flag does not create a button, it simply
          indicates which button created via the -b/buttonflag shall respond to the escape key.
    
      - defaultButton : db             (unicode)       [create]
          The default button is activated by pressing the enter key. Note that this flag does not create a button, it simply
          indicates which button created via the -b/buttonflag shall respond to the enter key.
    
      - dismissString : ds             (unicode)       [create]
          The string returned when the user selects the 'Close' item from the Window Manager menu.  If this flag is not set then
          the string dismissis returned.
    
      - message : m                    (unicode)       [create]
          The message text appearing in the dialog.
    
      - messageAlign : ma              (unicode)       [create]
          Align the message left, center, or right.
    
      - parent : p                     (unicode)       [create]
          Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
          parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
    
      - scrollableField : sf           (bool)          [create]
          By default a single line text field is used in the dialog. Specify true for a multi-line scroll field.
    
      - style : st                     (unicode)       [create]
          Specify the type of input expected in the input field. Vaid input types are integerfloattext. If this flag is not
          specified, we assume the input type is text.
    
      - text : tx                      (unicode)       [create,query]
          The field text.
    
      - title : t                      (unicode)       [create]
          The dialog title.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.promptDialog`
    """

    pass


def shelfButton(*args, **kwargs):
    """
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
    fits the current size of the control given its current style. This command creates an iconTextButtonthat is designed to
    be on the shelf. The button contains a command that can be drag'n'dropped.
    
    Flags:
      - actionIsSubstitute : ais       (bool)          []
    
      - align : al                     (unicode)       [create,query,edit]
          The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
          only available when -st/style is set to iconAndTextCentered.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - command : c                    (script)        [create,query,edit]
          Command executed when the control is pressed.
    
      - commandRepeatable : rpt        (bool)          [create,query,edit]
          Set if the MEL command specified in the command flag should be repeatable or not.  The gkey, by default, is the shortcut
          to repeat the last executed command.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disabledImage : di             (unicode)       [create,query,edit]
          Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
          a Windows only flag.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - doubleClickCommand : dcc       (script)        [create,query,edit]
          Command executed when the control is double clicked.
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enableCommandRepeat : ecr      (bool)          [create,query,edit]
          This flag only affects menu items to which a command can be attached.  Specify true and the command may be repeated by
          executing the command repeatLast.  This flag is true by default for all items except for option box items.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - flat : fla                     (bool)          [create,query,edit]
          Sets whether the control will be a flat button (0 false, 1 true).
    
      - flipX : fx                     (bool)          [create,query,edit]
          Is the image flipped horizontally?
    
      - flipY : fy                     (bool)          [create,query,edit]
          Is the image flipped vertically?
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - handleNodeDropCallback : hnd   (script)        [create,edit]
          Specify a script callback which is called when a node is dropped on the control.  The name of the node being dropped
          will be passed to the function  (python callable) or appended to the end (script) to form the command to be executed.
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - highlightImage : hi            (unicode)       [create,query,edit]
          Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with
          the -i/imageflag. This is a Windows only flag.
    
      - image : i                      (unicode)       [create,query,edit]
          If you are not providing images with different sizes then you may use this flag for the control's image. If the
          iconOnlystyle is set, the icon will be scaled to the size of the control.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three icons. The icon that best fits the current size of the control will be displayed.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string, up to 6 characters, representing a label that will be displayed on top of the image.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that appears in the control.
    
      - labelEditingCallback : lec     (script)        [create,edit]
          Specify a callback which is called after the user double clicks the label of the control to give it a new label. The new
          label string will be passed to the callback.
    
      - labelOffset : lo               (int)           [create,query,edit]
          The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - marginHeight : mh              (int)           [create,query,edit]
          The number of pixels above and below the control content. The default value is 1 pixel.
    
      - marginWidth : mw               (int)           [create,query,edit]
          The number of pixels on either side of the control content. The default value is 1 pixel.
    
      - menuItem : mi                  (unicode, unicode) [create,edit]
          Creates menu items for this button by passing in arguments for the menu item label and command for each item.  These
          should be passed as strings: labelcommandfor each use of this flag in the command. May be used mutliple times
    
      - menuItemPython : mip           (int)           []
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - noDefaultPopup : ndp           (bool)          [create]
          Disable the default popup menus.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
          The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
    
      - overlayLabelColor : olc        (float, float, float) [create,query,edit]
          The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rotation : rot                 (float)         [create,query,edit]
          The rotation value of the image in radians.
    
      - scaleIcon : sic                (bool)          [create,edit]
          For textOnlyand iconOnlystyle, this flag has no effect. For other styles, if the flag is specified, the icon will be
          scaled to the size of the control.
    
      - selectionImage : si            (unicode)       [create,query,edit]
          Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag.
          This is a Windows only flag.
    
      - sourceType : stp               (unicode)       [create,query,edit]
          Sets the language type for the command script. Can only be used in conjunction with the c/command or
          dcc/doubleClickCommand flags. Valid values are mel(enabled by default), and python.
    
      - style : st                     (unicode)       [create,query,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
          iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
          be scaled to the size of the control.
    
      - useAlpha : ua                  (bool)          [create,query,edit]
          Is the image using alpha channel?
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this control feature was introduced. The argument should be given as a string of the version
          number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
          2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.shelfButton`
    """

    pass


def fileDialog(*args, **kwargs):
    pass


def falloffCurve(*args, **kwargs):
    """
    This command creates a control for editing a 2D control curve. The control attaches to an optionVar used to store and
    retrieve the encoded control points stored in a string.
    
    Flags:
      - addControlVertex : acv         (unicode)       [edit]
          Used to add a control vertex for the curve.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - asString : asString            (unicode)       [query,edit]
          Used to query and set the value of the curve as a string of comma separated values
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [edit]
          Specifies a command to be executed whenever the value of this curve is modified. This option should not be used when
          specifying an optionVar.
    
      - currentKey : ck                (int)           [create,query,edit]
          Returns the index of the currently selected key.
    
      - currentKeyValue : ckv          (float, float)  [query,edit]
          Get or set the value of the currently selected key.
    
      - customCurveWidget : ccw        (bool)          [create,query,edit]
          Determines whether or not the curve widget is using a custom curve. When a custom curve is used, it is stored by a
          falloff curve in the brush tool settings, and the flag should be true.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteControlVertex : dcv      (int)           [edit]
          Used to delete a control vertex of the curve.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - optionVar : ov                 (unicode)       [create,query,edit]
          Specifies the name of the option var used to store and retrieve the string value capturing the curve.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - readOnly : ro                  (bool)          [create,query,edit]
          Specifies if the curve is read only or not. If true, the curve can't be edited.
    
      - snapToGrid : stg               (bool)          [create,query,edit]
          Specifies whether or not curve control points snap to grid when they are being moved.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.falloffCurve`
    """

    pass


def dynPaintEditor(*args, **kwargs):
    """
    Create a editor window that can be painted into
    
    Flags:
      - activeOnly : ao                (bool)          [query,edit]
          For Scene mode, this determines if only the active strokes will be refreshed.
    
      - autoSave : autoSave            (bool)          [query,edit]
          For Canvas mode, this determines if the buffer will be saved to a disk file after every stroke. Good for painting
          textures and viewing the results in shaded display in the model view.
    
      - camera : cam                   (unicode)       [query,edit]
          Sets the name of the camera which the Paint Effects panel looks through.
    
      - canvasMode : cm                (bool)          [query,edit]
          Sets the Paint Effects panel into Canvas mode if true.
    
      - canvasUndo : cu                (bool)          [edit]
          Does a fast undo in Canvas mode. This is a special undo because we are not using any history when we paint in Canvas
          mode so we provide a single level undo for the Canvas.
    
      - changeCommand : cc             (unicode, unicode, unicode, unicode) [create,query,edit]
          Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the
          command when something changes in the editor The command should have this prototype :  command(string $editor, string
          $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2:
          buffer (single/double)3: axis 4: image displayed5: image saved in memory
    
      - clear : cl                     (float, float, float) [edit]
          Clears the buffer (if in Canvas mode) to the floating point values (R,G,B).
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - currentCanvasSize : ccs        (bool)          [query]
          In Query mode, this returns the (X,Y) resolution of the current canvas.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - displayAppearance : dsa        (unicode)       [query,edit]
          Sets the display appearance of the model panel.  Possible values are wireframe, points, boundingBox, smoothShaded,
          flatShaded.  This flag may be used with the -interactive and -default flags.  Note that only wireframe, points, and
          boundingBoxare valid for the interactive mode.
    
      - displayFog : dfg               (bool)          [query,edit]
          For Scene mode, this determines if fog will be displayed in the Paint Effects panel when refreshing the scene. If fog is
          on, but this is off, fog will only be drawn on the strokes, not the rest of the scene.
    
      - displayImage : di              (int)           [query,edit]
          Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack
          using the si/saveImageflag.
    
      - displayLights : dsl            (unicode)       [query,edit]
          Sets the lighting for shaded mode.  Possible values are selected, active, all, default.
    
      - displayStyle : dst             (unicode)       [create,query,edit]
          Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask
          channellumto display the luminance of the image
    
      - displayTextures : dtx          (bool)          [query,edit]
          Turns on or off display of textures in shaded mode
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - doubleBuffer : dbf             (bool)          [create,query,edit]
          Set the display in double buffer mode
    
      - drawAxis : da                  (bool)          [create,query,edit]
          Set or query whether the axis will be drawn.
    
      - drawContext : drc              (bool)          [query]
          Returns the name of the context.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fastUpdate : fu                (int)           []
    
      - fileName : fil                 (unicode)       [query,edit]
          This sets the file to which the canvas will be saved.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - iconGrab : ig                  (bool)          [edit]
          This puts the Paint Effects panel into Grab Icon mode where the user is expected to drag out a section of the screen to
          be made into an icon.
    
      - loadImage : li                 (unicode)       [edit]
          load an image from disk and set it as the current Editor Image
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - menu : mn                      (unicode)       [create]
          Sets the name of the script used to build a menu in the editor. The script takes the editor name as an argument.
    
      - nbImages : nim                 (bool)          [query]
          returns the number of images
    
      - newImage : ni                  (int, int, float, float, float) [query,edit]
          Starts a new image in edit mode, setting the resolution to the integer values (X,Y) and clearing the buffer to the
          floating point values (R,G,B). In Query mode, this returns the (X,Y) resolution of the current Image.
    
      - paintAll : pa                  (float)         [edit]
          Redraws the buffer in current refresh mode.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - redrawLast : rl                (bool)          [edit]
          Redraws the last stroke again. Useful when it's brush has just changed. This feature does a fast undo and redraws the
          stroke again.
    
      - refresh : ref                  (bool)          [edit]
          requests a refresh of the current Editor Image.
    
      - refreshMode : rmd              (int)           [query,edit]
          Sets the refresh mode to the specified value. 0 - Do not draw strokes on refresh, 1 - Redraw strokes in wireframe mode,
          2 - Redraw strokes in final rendered mode.
    
      - removeAllImages : ra           (bool)          [edit]
          remove all the Editor Images from the Editor Image Stack
    
      - removeImage : ri               (bool)          [edit]
          remove the current Editor Image from the Editor Image Stack
    
      - rollImage : rig                (float, float)  [edit]
          In Canvas mode, this rolls the image by the floating point values (X,Y). X and Y are between 0 (no roll) and 1 (full
          roll). A value of .5 rolls the image 50% (ie. the border moves to the center of the screen.
    
      - saveAlpha : sa                 (bool)          [query,edit]
          For Canvas mode, this determines if the alpha will be saved when storing the canvas to a disk file.
    
      - saveBumpmap : sbm              (unicode)       [query,edit]
          Saves the current buffer as a bump map to the specified file.
    
      - saveImage : si                 (bool)          [edit]
          save the current Editor Image to memory. Saved Editor Images are stored in an Editor Image Stack. The most recently
          saved image is stored in position 0, the second most recently saved image in position 1, and so on... To set the current
          Editor Image to a previously saved image use the di/displayImageflag.
    
      - scaleBlue : sb                 (float)         [create,query,edit]
          Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000
    
      - scaleGreen : sg                (float)         [create,query,edit]
          Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000
    
      - scaleRed : sr                  (float)         [create,query,edit]
          Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - singleBuffer : sbf             (bool)          [create,query,edit]
          Set the display in single buffer mode
    
      - snapShot : snp                 (bool)          [edit]
          Takes a snapshot of the current camera view.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - swap : swp                     (int)           []
    
      - tileSize : ts                  (int)           [edit]
          Sets the size of the tile for the hardware texture redraw of the display buffer.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - undoCache : uc                 (bool)          [edit]
          By default the last image is cached for undo. If this is set false, then undoing will be disabled in canvas mode and
          undo in scene mode will force a full refresh. Less memory will be used if this is set false before the first clear or
          refresh of the current scene.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - wrap : wr                      (bool, bool)    [query,edit]
          For Canvas mode, should the buffer wrap in U, and V (respectively) when painting.
    
      - writeImage : wi                (unicode)       [edit]
          write the current Editor Image to disk
    
      - zoom : zm                      (float)         [query,edit]
          Zooms the Canvas image by the specified value.                  Flag can have multiple arguments, passed either as a
          tuple or a list.
    
    
    Derived from mel command `maya.cmds.dynPaintEditor`
    """

    pass


def savePrefs(*args, **kwargs):
    """
    This command saves preferences to disk. If no flags are specified then all pref types get saved out.
    
    Flags:
      - colors : c                     (bool)          [create]
          Save the color prefs to disk
    
      - general : g                    (bool)          [create]
          Save the general prefs to disk (optionVars)
    
      - hotkeys : hk                   (bool)          [create]
          Save the hotkeys to disk
    
      - menuSets : ms                  (bool)          [create]
          Save the menuSet preferences to disk
    
      - plugins : pl                   (bool)          [create]
          Save the plug-in prefs to disk
    
      - uiLayout : ui                  (bool)          [create]
          Save each window's size and position to disk                  Flag can have multiple arguments, passed either as a tuple
          or a list.
    
    
    Derived from mel command `maya.cmds.savePrefs`
    """

    pass


def multiTouch(*args, **kwargs):
    """
    Used to interact with the Gestura (multi-touch) library.                 In query mode, return type is based on queried
    flag.
    
    Flags:
      - gestures : g                   (bool)          [create,query]
          Enables/Disables multi touch gestures.
    
      - trackpad : t                   (int)           [create,query]
          Sets the trackpad mode.  Values can be: 1 - Cursor Control only2 - Multi-touch Gestures Only3 - Cursor and Multi-
          touchNote: this is a Maconly flag.                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.multiTouch`
    """

    pass


def intSlider(*args, **kwargs):
    """
    Create a slider control that accepts only integer values and is bound by a minimum and maximum value.  The slider
    displays a marker indicating the current value of the slider relative to it's minimum and maximum values.  Click and
    drag the marker or on the slider itself to change the current value.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the value changes.  This command is not invoked when the value changes via the -v/value flag.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command executed when the value changes by dragging the slider's value marker.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - horizontal : hr                (bool)          [create,query]
          Orientation of the slider.  This flag is true by default which corresponds to a horizontally oriented slider.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (int)           [create,query,edit]
          Upper limit of the slider.
    
      - minValue : min                 (int)           [create,query,edit]
          Lower limit of the slider.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - step : s                       (int)           [create,query,edit]
          The step value represents the amount the value will increase or decrease when you click either side of the slider.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (int)           [create,query,edit]
          Value of the slider.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.intSlider`
    """

    pass


def currentMenuParent():
    """
    shortcut for ``ui.PyUI(setParent(q=1, menu=1))``
    """

    pass


def nodeEditor(*args, **kwargs):
    """
    This command creates/edits/queries a nodeEditor editor. The optional argument is the name of the control.
    
    Flags:
      - activeTab : at                 (int)           [query,edit]
          Gets/sets the index of the tab widget's (active) visible tab. Note: the index is zero-based.
    
      - addNewNodes : ann              (bool)          [create,query,edit]
          New nodes should be added to the graph, default is on.
    
      - addNode : an                   (unicode)       [edit]
          Adds a specified node to the graph. Passing an empty string means the current model selection will be added to the
          graph.
    
      - additiveGraphingMode : agm     (bool)          [create,query,edit]
          When enabled, the graphing will add node networks to the existing graph instead of replacing it.
    
      - allAttributes : ala            (bool)          [create,query,edit]
          Attributes should not be filtered out of the graph, default is off.
    
      - allNodes : aln                 (bool)          [create,query,edit]
          Nodes should not be filtered out of the graph, default is off.
    
      - allowNewTabs : ant             (bool)          [query]
          Query only. Returns whether this Node Editor is allowed to have new tabs added, either by creating a new tab or
          duplicating an existing one.
    
      - allowTabTearoff : att          (bool)          [create,edit]
          Control whether or not the tabs can be torn off and floated. Defaults to true.
    
      - autoSizeNodes : asn            (bool)          [create,query,edit]
          When enabled, default node widths will be dynamically determined by the node name length, default is on.
    
      - backToParentView : bpv         (bool)          [edit]
          Show the contents of parent container node.
    
      - beginCreateNode : bcn          (bool)          [edit]
          Begin interactive node-creation at the mouse position. This will create a control which allows quick creation of a node
          in the editor.The actual creation is delegated to the createNodeCommand.
    
      - beginNewConnection : bnc       (unicode)       [edit]
          Begin a new interactive connection at the given attribute.
    
      - breakSelectedConnections : bsc (bool)          [edit]
          Break the selected attribute connections.
    
      - closeAllTabs : cat             (bool)          [edit]
          Close all tabs on the tab widget.
    
      - closeTab : clt                 (int)           [edit]
          Closes the tab on the tab widget at the specified index. Note: using this flag on a torn-off tab will close the node
          editor since there can be only a single tab. In this case the index argument is ignored.
    
      - consistentNameSize : cns       (bool)          [create,query,edit]
          When enabled, the size of the node name will consistently match the current zoom level. When disabled, the node name
          size will remain the same after zooming out past a certain level. Default is on.
    
      - contentsChangedCommand : cc    (script)        [create,query,edit]
          Specifies a function to be called whenever the contents of the node editor changes.
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - createInfo : ci                (unicode)       [create,edit]
          Creates or modifies a hyperGraphInfo network to save the state of the editor.
    
      - createNodeCommand : cnc        (script)        [create,query,edit]
          Specifies a function to be used to create nodes through the editor. The function will be passed the name of the chosen
          node type. This is used by the tab-create workflow. By default createNodeis used.
    
      - createTab : ct                 (int, unicode)  [create,edit]
          Create a new tab inserting it into the tab widget at the specified index. If index is out of range (such as -1), the tab
          is simply appended. You can optionally (Python only) specify a tab label, otherwise it will be set with a default name.
          In Mel using an empty string () for the tab label will set it with a default name. The new tab becomes the current
          (active) tab. Note: Only certain Node Editors are allowed to create new tabs, which can be checked by using the
          -allowNewTabs flag.
    
      - customAttributeListEdit : cal  (unicode, unicode) [query,edit]
          Create/Edit the custom attribute list for the given node by entering a special Edit Modefor the node. Note: only one
          node in the node editor can be in this edit mode at a time. If another node is selected the edit mode will end
          automatically. To end the edit mode use an empty string for node.Takes an optional edit mode command which accepts:
          hideall(sets all the attributes to hidden), showall(sets all the attributes to visible), preview(temporarily shows only
          the visible attributes), revert(restores the visibility settings of the attributes to what they were before edit mode)
          and reset(the visible attributes are reset so that only the interesting attributes are displayed).In query mode returns
          the name of the node, if any, in edit mode. Note: the optional string argument is ignored in query mode.
    
      - cycleHUD : ch                  (bool)          [create,edit]
          Change the HUD to the next state.
    
      - defaultPinnedState : dps       (bool)          [create,query,edit]
          Sets default pinned state of all nodes, 1 for pinned, 0 for unpinned. default value 0
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteSelected : deleteSelected (bool)          [edit]
          Delete the selected nodes and break the selected connections.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - dotFormat : dot                (unicode)       [query,edit]
          In query mode:Get the graph information in DOT format. The flag argument specifies a file path to write to.If -is
          supplied, the data is returned as a string, otherwise the size in bytes of the written file is returned.In edit
          mode:Sets the positions of nodes in the graph from a Graphviz output file in plainformat. Only the node position, width
          and height information is used.If the argument starts with graph , it will be treated as the plain data instead of a
          filename.
    
      - downstream : ds                (bool)          [create,edit]
          Include nodes that are downstream of the root nodes.
    
      - duplicateTab : dpt             (int, int)      [create,edit]
          Duplicates the tab at the specified index, placing it at the second optional (Python only) specified index. To place
          duplicated tab at the end use -1. The duplicated tab becomes the current (active) tab. Note: Only certain Node Editors
          are allowed to duplicate tabs, which can be checked by using the -allowNewTabs flag.
    
      - editorMode : em                (unicode)       []
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extendToShapes : ets           (bool)          [create,query,edit]
          Include child shapes for each selected transform.
    
      - feedbackConnection : fbc       (bool)          [query]
          Returns a description of the connection(s) at the current mouse position in the editor view, if any. The connection(s)
          will be returned as a list of strings, which are pairs of plugs for each connection.
    
      - feedbackNode : fbn             (bool)          [query]
          Returns the name of the node at the current mouse position in the editor view, if any.
    
      - feedbackPlug : fbp             (bool)          [query]
          Returns the name of the plug (attribute) at the current mouse position in the editor view, if any.
    
      - feedbackTabIndex : fbi         (bool)          [query]
          Returns the index of the tab at the current mouse position in the editor view, if any.
    
      - feedbackType : fbt             (bool)          [query]
          Returns the most specific type of the feedback item (item at the current mouse position) in the editor view, if any.
          Will be one of plug, node, tab, connectionor an empty string. Use the other feedback\* flags to query the item
          description.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - filterCreateNodeTypes : fcn    (script)        [create,query,edit]
          Specifies a function to be used to filter the list of node types which appear in the inline-creation menu (tab key). The
          function should accept one string array argument and return a string array.
    
      - focusCommand : fc              (script)        [create,query,edit]
          Specifies a function to be called whenever focus changes for the node editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - frameAll : fa                  (bool)          [edit]
          Frame all the contents of the node editor.
    
      - frameModelSelection : fms      (bool)          [edit]
          Frame the current model selection.
    
      - frameSelected : fs             (bool)          [edit]
          Frame the selected contents of the node editor.
    
      - getNodeList : gnl              (bool)          [query]
          Returns a list of all nodes displayed in the editor.
    
      - graphSelectedConnections : gsc (bool)          [edit]
          Graph the nodes connected by the selected attribute connections.
    
      - graphSelection : gsl           (bool)          [edit]
          Graph the nodes that are currently selected.
    
      - gridSnap : gs                  (bool)          [create,query,edit]
          Toggle grid snapping on/off.
    
      - gridVisibility : gv            (bool)          [create,query,edit]
          Toggle grid visiblity on/off.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - hudMessage : hm                (unicode, int, float) [edit]
          Display the given message on the editor HUD. The flag arguments are (message, type, duration), where type is:upper-left
          corner.top center.upper-right corner.center.Duration 0 means the message stays until removed. Duration 0 means it stays
          for that number of seconds.An empty message erases whatever is currently displayed for the given type.
    
      - ignoreAssets : ia              (bool)          [create,query,edit]
          Deprecated. Do not use in scripts.
    
      - inContainerView : icv          (bool)          [query]
          Query only. Returns whether the current editor view is a display of the contents of a particular container. When in such
          a view, most graphing functionality will be blocked to maintain its accuracy.
    
      - isContainerNode : icn          (unicode)       [query]
          Query only. Returns whether or not the given node is a container node.
    
      - island : isl                   (bool)          [query,edit]
          Deprecated. Do not use in scripts.
    
      - keyPressCommand : kpc          (script)        [create,query,edit]
          Specifies a function to be called when a key is pressed and the editor has focus.The function will be passed the name of
          the editor and an (uppercase) string representation of the key that was pressed, and should return true if the key was
          handled, and false if it was not.Note: `getModifiers` can be used to query the current state of key modifiers.
    
      - keyReleaseCommand : krc        (script)        [create,query,edit]
          Specifies a function to be called when a key is released and the editor has focus.The function will be passed the name
          of the editor and an (uppercase) string representation of the key that was released, and should return true if the key
          was handled, and false if it was not.Note: `getModifiers` can be used to query the current state of key modifiers.
    
      - layout : lay                   (bool)          [edit]
          Perform an automatic layout of the graph.
    
      - layoutCommand : lc             (script)        [create,query,edit]
          Specifies a function to override the default action when a graph layout is required. The function will be passed the
          name of editor. The function should arrange the nodes in the graph.
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - nodeSwatchSize : nss           (unicode)       [edit]
          Sets the icon swatch size of selected nodes in the active scene (all nodes if none are selected). Size values are
          smalland large.
    
      - nodeTitleMode : ntm            (unicode)       [create,query,edit]
          Gets/sets the node title display mode of the current scene. Mode values are: name(Display node names), type(Display node
          types), none(Do not display titles)
    
      - nodeViewMode : nvm             (unicode)       [edit]
          Sets the attribute view mode of selected nodes in the active scene (all nodes if none are selected). Mode values are:
          simple(no attributes displayed), connected(connected attributes only), all(all interesting attributes displayed) and
          custom(use custom attribute view).
    
      - openContainerView : ocv        (unicode, bool) [edit]
          Open a view of the contents of the given container node. The boolean argument determines whether or not to open it in a
          new tab (rather than as a child of the current container)
    
      - panView : pv                   (float, float)  [edit]
          Pan the view by the given amount. Arguments of 0 0 will reset the view translation.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - pinSelectedNodes : psn         (bool)          [edit]
          Pins or unpins the selected nodes. If no nodes are selected, this will apply to all displayed nodes.
    
      - popupMenuScript : pms          (script)        [create,query,edit]
          Set the script to be called to register the popup menu with the control for this editor. The script will be called with
          a string argument which gives the name of the editor whose control the popup menu should be parented to.
    
      - primary : pr                   (bool)          [query]
          Query only. Returns whether this node editor is the primaryone. The primary editor is the only one that will show and
          allow tabs.
    
      - redockTab : rdt                (bool)          [query,edit]
          If this tab was torn-off from the primary node editor, then the tab and all its data will be re-docked back into the
          primary editor and this node editor will be closed. In query mode returns whether this tab was torn-off and is available
          to be re-docked.
    
      - removeDownstream : rd          (bool)          [edit]
          Removes all items downstream to the currently active selection.
    
      - removeNode : rem               (unicode)       [edit]
          Removes a node from the graph. An empty string indicates that currently selected nodes should be removed.
    
      - removeUnselected : run         (bool)          [edit]
          Removes unselected nodes from graph.
    
      - removeUpstream : ru            (bool)          [edit]
          Removes all items upstream to the currently active selection.
    
      - renameNode : ren               (unicode)       [edit]
          Rename a node in the graph. Depending on the zoom level of the view, an edit field will either appear on the node item
          or in a popup dialog to allow the new name to be entered.
    
      - renameTab : rt                 (int, unicode)  [edit]
          Renames the tab at the specified index with the (optional) name. If no name is specified (Python only) or an empty
          string () is used then an inline edit field is opened to rename the tab.
    
      - restoreInfo : ri               (unicode)       [create,edit]
          Restores the editor state corresponding to supplied hyperGraphInfo node.
    
      - restoreLastClosedTab : rlt     (bool)          [query,edit]
          If this node editor is the primary one, then restore the last closed tab (if any). In query mode returns whether there
          is a tab available to restore.
    
      - rootNode : rn                  (unicode)       [create,edit]
          Add a node name as a root node of the graph. Passing an empty string clears the current root node list. When queried,
          returns the list of current root nodes.
    
      - rootsFromSelection : rfs       (bool)          [create,edit]
          Specify that the root nodes for the graph should taken from the currently active selection.
    
      - scaleView : sv                 (float)         [edit]
          Scales the graph view by the given factor. An argument of zero means reset to default.
    
      - selectAll : sa                 (bool)          [edit]
          Select all items in the graph.
    
      - selectConnectionNodes : scn    (bool)          [edit]
          Select the nodes connected by the selected attribute connections.
    
      - selectDownstream : sd          (bool)          [edit]
          Select all items downstream to the currently active selection.
    
      - selectFeedbackConnection : sfc (bool)          [edit]
          Select the feedback connection(s) in the editor view, if any.
    
      - selectNode : sln               (unicode)       [query,edit]
          Select a node in the graph. Passing an empty string clears the current selection. When queried, returns the list of
          currently selected nodes.
    
      - selectUpstream : su            (bool)          [edit]
          Select all items upstream to the currently active selection.
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - settingsChangedCallback : scc  (script)        [create,query,edit]
          Specifies a function to be called whenever settings for the node editor get changed.
    
      - shaderNetworks : sns           (bool)          [edit]
          Graph the shader network for all the objects on the selection list that have shaders.
    
      - showAllNodeAttributes : saa    (unicode)       [edit]
          Display all attributes for the given node, not just primary attributes. Passing an empty string will apply this to all
          currently selected nodes. If no nodes are selected, this will be applied to all displayed nodes in the graph.
    
      - showNamespace : sn             (bool)          [create,query,edit]
          Specifies whether nodes will have their namespace displayed if they are not in the root namespace.
    
      - showSGShapes : ssg             (bool)          [create,query,edit]
          Show shapes that are connected to the network through a shading group.
    
      - showShapes : ss                (bool)          [create,query,edit]
          Show shape nodes.
    
      - showTabs : tab                 (bool)          [create]
          Creation time flag to explicitly control the visibility of the tabs. If this is set to true or false the tabs visibility
          will respect that setting. If this flag is not explicitly set then the tabs will be visible in the primary node editor
          and tear off tabs, but will not be visible for other editors that are not the primary editor.
    
      - showTransforms : st            (bool)          [create,query,edit]
          Show transforms.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - syncedSelection : ssl          (bool)          [create,query,edit]
          Keep the graph selection in sync with the model selection.
    
      - tabChangeCommand : tcc         (script)        [create,edit]
          Command executed when the current (active) tab is changed. Re-selecting the current tab will not invoke this command.
          NOTE: This command will also be executed when switching into, out of, and between compound views.
    
      - toggleAttrFilter : taf         (bool)          [edit]
          Toggles the display of the attribute filter field on selected nodes. If any of the selected nodes have the field
          displayed, this operation will hide the field for all nodes in the selection. If no nodes are selected, this will apply
          to all displayed nodes.
    
      - toggleSelectedPins : tsp       (bool)          [edit]
          Toggles pinned state on selected nodes. If any selected nodes are unpinned, this operation will choose to pin all nodes.
          If no nodes are selected, this will apply to all displayed nodes.
    
      - toggleSwatchSize : tss         (unicode)       [edit]
          Toggles the swatch size of the given node between small and large. If supplied node name was empty, this will be applied
          to selection, and if no nodes are selected this is applied to all nodes in editor. When selection is a combination of
          small and large swatch sizes, this will set selection to large swatch mode.
    
      - toolTipCommand : ttc           (script)        [create,query,edit]
          Specifies a function to override the tooltip that is displayed for a node. The function will be passed the name of the
          node under the cursor, and should return a text string to be displayed. A simple HTML 4 subset is supported.
    
      - traversalDepthLimit : tdl      (int)           [create,query,edit]
          Specify the maximum number of edges which will be followed from any root node when building the graph. A negative value
          means unlimited. Default is unlimited.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - upstream : ups                 (bool)          [create,edit]
          Include nodes that are upstream of the root nodes.
    
      - useAssets : ua                 (bool)          [create,query,edit]
          Use assets and published attributes instead of contents and actual attributes.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - vnnCompound : vc               (bool)          [query]
          Query only. Returns the path name of the currently viewed compound
    
      - vnnDgContainer : vd            (bool)          [query]
          Query only. Returns the name of the dg container that owns the currently viewed compound
    
      - vnnRuntime : vr                (bool)          [query]
          Query only. When in container view, returns the name of the runtime to which the dg container belongs. When not in
          container view this returns an empty string.                  Flag can have multiple arguments, passed either as a tuple
          or a list.
    
    
    Derived from mel command `maya.cmds.nodeEditor`
    """

    pass


def palettePort(*args, **kwargs):
    """
    This command creates an array of color cells. It could be used to to store an retrieve some colors you want to manage
    during your working session.
    
    Flags:
      - actualTotal : at               (int)           [create,query]
          Set the actual number of palette entries. This number must be greater than zero, but not be greater than maximum number
          of palette entries defined by the dimensionsflag.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          This command string will be executed when a color in the palette is changed.
    
      - colorEditable : ced            (bool)          [create,query,edit]
          If true then the user can modify the current index's color.
    
      - colorEdited : ce               (script)        [create,edit]
          This command string will be executed when a color in the palette is edited.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - dimensions : dim               (int, int)      [create,query]
          Set the dimensions of the array.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          If true then the user can change the current color.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - hsvValue : hsv                 (int, int, float, float, float) [create,query,edit]
          Set a color for a given cell, using HSV format. On query return the color of the current cell.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - redraw : r                     (bool)          [create,edit]
          Forces a redraw of the array
    
      - rgbValue : rgb                 (int, float, float, float) [create,query,edit]
          Set a color for a given cell, using RGB format. On query return the color of the current cell.
    
      - setCurCell : scc               (int)           [create,query,edit]
          Set the current cell in the array to the given index. Returns the current cell when queried.
    
      - topDown : td                   (bool)          [create]
          If this flag is true, it indicates that first entry should appear in top left as opposed to the bottom left.
    
      - transparent : t                (int)           [create,query,edit]
          Set a given cell to be the transparent color.  A cell value of -1 indicates that no cell is transparent.  On query
          returns the current transparent cell.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.palettePort`
    """

    pass


def _findLongName(name, type='None'):
    pass


def mayaDpiSetting(*args, **kwargs):
    """
    Provide Maya interface scaling based on system DPI or custom scale setting or no scaling. Please note that the change
    will only take effect after relaunching Maya.
    
    Flags:
      - mode : m                       (int)           [create,query]
          Specifies the interface scaling mode: 0 - System Dpi Based Scaling1 - Custom Scaling (Must provide the custom scale
          value with flag -scaleValue2 - No Scaling
    
      - realScaleValue : rsv           (bool)          [query]
          This is a query mode only flag which returns the real scale value depending on current scaling mode and defined scale
          value: mode 0 - Return the current real scale value which is the ratio of current system dpi to default system dpimode 1
          - Return the current real scale value which is the product of the defined scale value and the ratio of current system
          dpi to default system dpimode 2 - Always return 1.0 which indicates real scale is 100% when the scaling mode is no
          scaling.
    
      - scaleValue : sv                (float)         [create,query]
          Specifies the custom scale of the interface if scaling mode is 1. The allowed values are [1.0, 1.25, 1.5, 2.0]. In query
          mode, return the scale value depend on current scaling mode: mode 0 - Always return 1.0 which indicates 100% scalingmode
          1 - Return the custom scale value usedmode 2 - Always return 1.0 which indicates no custom scaling
    
      - systemDpi : sd                 (bool)          [query]
          This is a query mode only flag which returns the current system dpi value.                                 Flag can have
          multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.mayaDpiSetting`
    """

    pass


def showWindow(*args, **kwargs):
    """
    Make a window visible. If no window is specified then the current window (most recently created) is used. See also the
    windowcommand's vis/visibleflag. If the specified window is iconified, it will be opened.
    
    
    Derived from mel command `maya.cmds.showWindow`
    """

    pass


def promptForPath(**kwargs):
    """
    Prompt the user for a folder path
    """

    pass


def rangeControl(*args, **kwargs):
    """
    This command creates a control used for displaying and modifying the current playback range. Note: only one master
    rangeControl may exist. Any addition rangeControls that a user creates are slaved to the master range control widget.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changedCommand : cc            (script)        [create,edit]
          script to be executed when the range changes
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxRange : max                 (time)          [create,query,edit]
          Controls the max range displayable in the control
    
      - minRange : min                 (time)          [create,query,edit]
          Controls the max range displayable in the control
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - widthHeight : wh               (int, int)      [create,edit]
          Controls the dimensions of the control                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.rangeControl`
    """

    pass


def renderWindowEditor(*args, **kwargs):
    """
    Create a editor window that can receive the result of the rendering process
    
    Flags:
      - autoResize : ar                (bool)          [create,query,edit]
          Lets the render view editor automatically resize the viewport or not.
    
      - blendMode : blm                (int)           [create,query,edit]
          Sets the blend mode for the render view. New image sent to the render view will be blended with the previous image in
          the render view, and the composited image will appear.
    
      - caption : cap                  (unicode)       [create,query,edit]
          Sets the caption which appears at the bottom of the render view.
    
      - changeCommand : cc             (unicode, unicode, unicode, unicode) [create,query,edit]
          Parameters: First string: commandSecond string: editorNameThird string: editorCmdFourth string: updateFuncCall the
          command when something changes in the editor The command should have this prototype :  command(string $editor, string
          $editorCmd, string $updateFunc, int $reason)  The possible reasons could be : 0: no particular reason1: scale color2:
          buffer (single/double)3: axis 4: image displayed5: image saved in memory
    
      - clear : cl                     (int, int, float, float, float) [create,query,edit]
          Clear the image with the given color at the given resolution. Argumnets are respecively: width height red green blue.
    
      - cmEnabled : cme                (bool)          [query,edit]
          Turn on or off applying color management in the View.  If set, the color management configuration set in the current
          view is used.
    
      - colorManage : com              (bool)          [edit]
          When used with the writeImage flag, causes the written image to be color-managed using the settings from the view color
          manager attached to the view.
    
      - compDisplay : cd               (int)           [create,query,edit]
          0 : disable compositing.1 : displays the composited image immediately. For example, when foreground layer tile is sent
          to the render view window, the composited tile is displayed in the render view window, and the original foreground layer
          tile is not displayed.2 : display the un-composited image, and keep the composited image for the future command. For
          example, when foreground layer tile is sent to the render view window, the original foreground layer tile is not
          displayed, and the composited tile is stored in a buffer.3 : show the current composited image. If there is a composited
          image in the buffer, display it.
    
      - compImageFile : cif            (unicode)       [create,query,edit]
          Open the given image file and blend with the buffer as if the image was just rendered.
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - currentCamera : crc            (unicode)       [create,query,edit]
          Get or set the current camera. (used when redoing last render)
    
      - currentCameraRig : crg         (unicode)       [create,query,edit]
          Get or set the current camera rig name. If a camera rig is specified, it will be used when redoing the last render as
          opposed to the currentCamera value, as the currentCamera value will hold the child camera last used for rendering the
          camera rig.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - displayImage : di              (int)           [query,edit]
          Set a particular image in the Editor Image Stack as the current Editor Image. Images are added to the Editor Image Stack
          using the si/saveImageflag.
    
      - displayImageViewCount : dvc    (int)           [query]
          Query the number of views stored for a given image in the Editor Image Stack. This is not the same as querying using
          viewImageCountwhich returns the number of views for the current rendered image.
    
      - displayStyle : dst             (unicode)       [create,query,edit]
          Set the mode to display the image. Valid values are: colorto display the basic RGB imagemaskto display the mask
          channellumto display the luminance of the image
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - doubleBuffer : dbf             (bool)          [create,query,edit]
          Set the display in double buffer mode
    
      - drawAxis : da                  (bool)          [create,query,edit]
          Set or query whether the axis will be drawn.
    
      - editorName : en                (bool)          [query]
          Returns the name of the editor, or an empty string if the editor has not been created yet.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - exposure : exp                 (float)         [query,edit]
          The exposure value used by the color management of the current view.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - frameImage : fi                (bool)          [create,query,edit]
          Frames the image inside the window.
    
      - frameRegion : fr               (bool)          [create,query,edit]
          Frames the region inside the window.
    
      - gamma : ga                     (float)         [query,edit]
          The gamma value used by the color management of the current view.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - loadImage : li                 (unicode)       [edit]
          load an image from disk and set it as the current Editor Image
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - marquee : mq                   (float, float, float, float) [create,query,edit]
          The arguments define the four corners of a rectangle: top left bottom right. The rectangle defines a marquee for the
          render computation.
    
      - nbImages : nim                 (bool)          [query]
          returns the number of images
    
      - nextViewImage : nvi            (bool)          [create,edit]
          The render editor has the capability to render multiple cameras within a single view. This is different from image
          binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-
          side. The nextViewImage flag tells the editor that it should prepare its internal image storage mechanism to store to
          the next view location.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - pcaption : pca                 (unicode)       [create,query,edit]
          Get or set the permanent caption which appears under the image that is currently showing in the render editor.
    
      - realSize : rs                  (bool)          [create,query,edit]
          Display the image with a one to one pixel match.
    
      - refresh : ref                  (bool)          [edit]
          requests a refresh of the current Editor Image.
    
      - removeAllImages : ra           (bool)          [edit]
          remove all the Editor Images from the Editor Image Stack
    
      - removeImage : ri               (bool)          [edit]
          remove the current Editor Image from the Editor Image Stack
    
      - resetRegion : rr               (bool)          [create,query,edit]
          Forces a reset of any marquee/region.
    
      - resetViewImage : rvi           (bool)          [create,edit]
          The render editor has the capability to render multiple cameras within a single view. This is different from image
          binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-
          side. The resetViewImage flag tells the editor that it should reset its internal image storage mechanism to the first
          image. This would happen at the very start of a render view render.
    
      - saveImage : si                 (bool)          [edit]
          save the current Editor Image to memory. Saved Editor Images are stored in an Editor Image Stack. The most recently
          saved image is stored in position 0, the second most recently saved image in position 1, and so on... To set the current
          Editor Image to a previously saved image use the di/displayImageflag.
    
      - scaleBlue : sb                 (float)         [create,query,edit]
          Define the scaling factor for the blue component in the View. The default value is 1 and can be between -1000 to +1000
    
      - scaleGreen : sg                (float)         [create,query,edit]
          Define the scaling factor for the green component in the View. The default value is 1 and can be between -1000 to +1000
    
      - scaleRed : sr                  (float)         [create,query,edit]
          Define the scaling factor for the red component in the View. The default value is 1 and can be between -1000 to +1000
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - showRegion : srg               (int, int)      [create,query,edit]
          Shows the current region at the given resolution. The two parameters define the width and height.
    
      - singleBuffer : sbf             (bool)          [create,query,edit]
          Set the display in single buffer mode
    
      - snapshot : snp                 (unicode, int, int) [create,query,edit]
          Makes a copy of the camera of the model editor at the given size. First argument is the editor name, second is the
          width, third is the height.
    
      - snapshotMode : snm             (bool)          []
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - stereo : s                     (int)           [create,query,edit]
          Puts the editor into stereo image mode.  The effective resolution of the output image is twice the size of the
          horizontal size. The orientation of the images can be set using the stereoOrientation flag.
    
      - stereoImageOrientation : sio   (unicode, unicode) [create,query,edit]
          Specifies the orientation of stereo camera renders.  The first argument specifies the orientation value for the
          firstleft image and the second argument specifies the orientation value for the right image. The orientation values are
          'normal', the image appears as seen throught he camera, or 'mirrored', the image is mirrored horizontally.
    
      - stereoMode : sm                (unicode)       [create,query,edit]
          Specifies how the image is displayed in the view.  By default the stereo is rendered with a side by side image.  The
          rendered image is a single image that is twice the size of a normal image, 'both'. Users can also choose to display as
          'redcyan', 'redcyanlum', 'leftonly', 'rightonly', or 'stereo'.  both - displays both the left and right redcyan -
          displays the images as a red/cyan pair. redcyanlum - displays the luminance of the images as a red/cyan pair. leftonly -
          displays the left side only rightonly - displays the right side only stereo - mode that supports Crystal Eyes(tm) or
          Zscreen (tm) renders
    
      - toggle : tgl                   (bool)          [create,query,edit]
          Turns the ground plane display on/off.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - viewImageCount : vic           (int)           [create,query,edit]
          The render editor has the capability to render multiple cameras within a single view. This is different from image
          binning where an image is saved. Multiple image views are useful for comparing two different camera renders side-by-
          side. The viewImageCount flag tells the editor that it should prepare its internal image storage mechanism for a given
          number of views.
    
      - viewTransformName : vtn        (unicode)       [query,edit]
          Sets/gets the view transform to be applied if color management is enabled in the current view.
    
      - writeImage : wi                (unicode)       [edit]
          write the current Editor Image to disk                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.renderWindowEditor`
    """

    pass


def iconTextCheckBox(*args, **kwargs):
    """
    This control supports up to 3 icon images and 4 different display styles.  The icon image displayed is the one that best
    fits the current size of the control given its current style. This command creates an iconTextCheckBox.
    
    Flags:
      - align : al                     (unicode)       [create,query,edit]
          The label alignment.  Alignment values are left, right, and center. By default, the label is aligned center. Currently
          only available when -st/style is set to iconAndTextCentered.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,query,edit]
          Command executed when the control's state is changed. Note that this flag should not be used in conjunction with
          onCommand and offCommand. That is, one should either use changeCommand and test the state of the control from inside the
          callback, or use onCommand and offCommand as separate callbacks.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - disabledImage : di             (unicode)       [create,query,edit]
          Image used when the button is disabled. Image size must be the same as the image specified with the i/imageflag. This is
          a Windows only flag.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - flat : fla                     (bool)          [create,query,edit]
          Sets whether the control will be a flat button (0 false, 1 true).
    
      - flipX : fx                     (bool)          [create,query,edit]
          Is the image flipped horizontally?
    
      - flipY : fy                     (bool)          [create,query,edit]
          Is the image flipped vertically?
    
      - font : fn                      (unicode)       [create,query,edit]
          The font for the text.  Valid values are boldLabelFont, smallBoldLabelFont, tinyBoldLabelFont, plainLabelFont,
          smallPlainLabelFont, obliqueLabelFont, smallObliqueLabelFont, fixedWidthFontand smallFixedWidthFont.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - highlightImage : hi            (unicode)       [create,query,edit]
          Highlight image displayed while the cursor is over the control. Image size must be the same as the image specified with
          the -i/imageflag. This is a Windows only flag.
    
      - image : i                      (unicode)       [create,query,edit]
          If you are not providing images with different sizes then you may use this flag for the control's image. If the
          iconOnlystyle is set, the icon will be scaled to the size of the control.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three icons. The icon that best fits the current size of the control will be displayed.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string, up to 6 characters, representing a label that will be displayed on top of the image.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The text that appears in the control.
    
      - labelOffset : lo               (int)           [create,query,edit]
          The label offset. Default is 0. Currently only available when -st/style is set to iconAndTextCentered.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - marginHeight : mh              (int)           [create,query,edit]
          The number of pixels above and below the control content. The default value is 1 pixel.
    
      - marginWidth : mw               (int)           [create,query,edit]
          The number of pixels on either side of the control content. The default value is 1 pixel.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - offCommand : ofc               (script)        [create,query,edit]
          Command executed when the control is turned off.
    
      - onCommand : onc                (script)        [create,query,edit]
          Command executed when the control is turned on.
    
      - overlayLabelBackColor : olb    (float, float, float, float) [create,query,edit]
          The RGBA color of the shadow behind the label defined by imageOverlayLabel. Default is 50% transparent black: 0 0 0 .5
    
      - overlayLabelColor : olc        (float, float, float) [create,query,edit]
          The RGB color of the label defined by imageOverlayLabel. Default is a light grey: .8 .8 .8
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rotation : rot                 (float)         [create,query,edit]
          The rotation value of the image in radians.
    
      - selectionHighlightImage : shi  (unicode)       [create,query,edit]
          Image displayed while the control is selected and the cursor is over the control. Image size must be the same as the
          image specified with the -i/imageflag. This is a Windows only flag.
    
      - selectionImage : si            (unicode)       [create,query,edit]
          Image displayed while the control is selected. Image size must be the same as the image specified with the -i/imageflag.
          This is a Windows only flag.
    
      - style : st                     (unicode)       [create,query,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontal, iconAndTextVertical, and
          iconAndTextCentered. (Note: iconAndTextCenteredis only available on Windows). If the iconOnlystyle is set, the icon will
          be scaled to the size of the control.
    
      - useAlpha : ua                  (bool)          [create,query,edit]
          Is the image using alpha channel?
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (bool)          [create,query,edit]
          Sets or returns the state of the control.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this control feature was introduced. The argument should be given as a string of the version
          number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as
          2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.iconTextCheckBox`
    """

    pass


def workspaceLayoutManager(*args, **kwargs):
    """
    The Workspace Layout Manager loads and saves the layout of the various toolbars and windows in the user interface. This
    command allows listing and managing their properties.
    
    Flags:
      - collapseMainWindowControls : cmw (unicode, bool) [create]
          Saves main window layout and collapses all other controls in main window except the given one (first parameter) if it
          doesn't have any size constraint. Second parameter specifies if main window UI elements should be hidden or not.
    
      - current : cu                   (bool)          [create,query]
          Get the name of the current layout.
    
      - delete : d                     (unicode)       [create]
          Delete the given workspace. The string is the name of the layout, not the file name.
    
      - i : i                          (unicode)       [create]
          Import the given workspace file to the workspaces directory. The string is an absolute path.
    
      - listLayouts : ll               (bool)          [create]
          List the names of the registered layouts.
    
      - listUserLayouts : lul          (bool)          []
    
      - modified : m                   (unicode)       [create]
          Check whether or not the specified layout has been modified.
    
      - parentWorkspaceControl : pwc   (unicode)       [create]
          Returns the parent workspace control of the given UI (panel) or empty string if it doesn't exist.
    
      - reset : rs                     (bool)          [create]
          Reset the current workspace to its original layout. Factory layouts will be reverted to default while user layouts will
          be reloaded from disk.
    
      - restoreMainWindowControls : rmw (bool)          [create]
          Restores main window layout to the one saved with -cmw/-collapseMainWindowControlsflag . The loaded workspace file will
          be deleted once it is restored.
    
      - save : s                       (bool)          [create]
          Save the current layout.
    
      - saveAs : sa                    (unicode)       [create]
          Save the current layout under the specified name.
    
      - setCurrent : sc                (unicode)       [create]
          Load the given workspace.  The string is the name of the layout, not the file name.
    
      - setCurrentCallback : scc       (unicode)       [create]
          MEL only.  The string is interpreted as a MEL callback, which is called each time a layout is set as current (with
          -setCurrentflag). The callback is of the form: global proc MySetCurrentCallback(string $layoutName)
    
      - type : t                       (unicode)       [create]
          Get the type of the specified layout: FACTORY, FACTORY_OVERRIDE or USER.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.workspaceLayoutManager`
    """

    pass


def outlinerEditor(*args, **kwargs):
    """
    This command creates an outliner editor which can be used to display a list of objects.WARNING: some flag combinations
    may not behave as you expect.  The command is really intended for internal use for creating the outliner used by the
    various editors.
    
    Flags:
      - allowMultiSelection : ams      (bool)          [create,edit]
          If true then multiple selection will be allowed in the outliner.
    
      - alwaysToggleSelect : ats       (bool)          [create,edit]
          If true, then clicking on an item in the outliner will select or deselect it without affecting the selection of other
          items (unless allowMultiSelection is false). If false, clicking on an item in the outliner will replace the current
          selection with the selected item.
    
      - animLayerFilterOptions : alf   (unicode)       [create,query,edit]
          Specifies whether a filter is to be applied when displaying animation layers. If so, the options can be allAffecting(no
          filter), active(only the active layers on the object will be displayed) and animLayerEditor(the settings will be taken
          from the animation layer editor).
    
      - attrAlphaOrder : aao           (unicode)       [create,query,edit]
          Specify how attributes are to be sorted. Current recognised values are defaultfor no sorting and ascendto sort
          attributes from 'a' to ''z' and descendto sort from 'z' to 'a'. Notes: a) this only applies to top level attributes.
    
      - attrFilter : af                (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be placed on this editor. This filters the attributes displayed in the
          editor.
    
      - autoExpand : xpd               (bool)          [create,query,edit]
          This flag specifies whether or not objects that are loaded in should have their attributes automatically expanded.
    
      - autoExpandLayers : ael         (bool)          [create,query,edit]
          If true then when a node with animation layer is displayed, all the animation layers will show up in expanded form.
    
      - autoSelectNewObjects : autoSelectNewObjects (bool)          [create,query,edit]
          This flag specifies whether or not new objects added to the outliner should be automatically selected.
    
      - containersIgnoreFilters : cif  (bool)          [create,query,edit]
          This flag specifices whether or not filters should be ignored when displaying container contents.
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - directSelect : ds              (bool)          [create,edit]
          If true then clicking on an item in the outliner will add or remove just that item from the selection connection. If
          false then clicking on an item in the outliner causes the selection connection to be reloaded with the currently
          selected items in the outliner.
    
      - displayMode : dm               (unicode)       [create,query,edit]
          Affects how the outliner displays when a filter is applied. List mode is a non-indented flat list. DAG mode indents to
          represent the hierarchical structure of the model.
    
      - doNotSelectNewObjects : dns    (bool)          [create,query,edit]
          If true this flag specifies that new objects added to the outliner will not be selected, even if they are active.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - dropIsParent : dip             (bool)          [create,query,edit]
          This flag specifies the mode for drag and drop. If the flag is true, dropping items will do a reparent. If it is false,
          dropping will reorder items. By default, the flag is true (parent).
    
      - editAttrName : ean             (bool)          [create,query,edit]
          This flag specifies whether or not attribute names can be edited. By default double-clicking on an attribute will open
          the expression editor for that attribute.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - expandAllItems : eai           (bool)          [create,edit]
          Expand or collapse all items in the outliner.
    
      - expandAllSelectedItems : eas   (bool)          [create,edit]
          Expand or collapse all selected items in the outliner.
    
      - expandAttribute : att          (bool)          [edit]
          Force the outliner to fill the selection list with only attributes.
    
      - expandConnections : xc         (bool)          [create,query,edit]
          This flag specifies whether or not attributes should be expanded to show their input connections. Note: currently the
          expansion will only show animCurves.
    
      - expandObjects : eo             (bool)          [create,query,edit]
          This flag specifies whether or not objects that are loaded in should be automatically expanded.
    
      - feedbackItemName : fbn         (bool)          [query]
          Returns the outliner item name at the current mouse position, if any.
    
      - feedbackRowNumber : fbr        (bool)          [query]
          Returns the outliner row number at the current mouse position, if any.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - getCurrentSetOfItem : gcs      (int)           [query]
          Returns the current set of item at the given row. As an item can belong to number of sets, current set is the set to
          which the item belongs to currently.
    
      - highlightActive : ha           (bool)          [create,query,edit]
          This flag specifies whether or not the outliner should highlight objects that are active. Note: if the outliner is
          driving the contents of another editor, setting highlightActive to true may produce unexpected behavior.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - highlightSecondary : hs        (bool)          [create,query,edit]
          This flag specifies whether or not the outliner should highlight objects that are contained in the highlightConnection.
    
      - ignoreDagHierarchy : hir       (bool)          [create,query,edit]
          This flag specifies whether or not DAG objects are displayed in their DAG hierarchy. Warning: using this flag without
          some other form of sensible filtering will lead to a very confusing outliner.
    
      - ignoreHiddenAttribute : iha    (bool)          [create,query,edit]
          Sets whether or not the outliner ignores the 'hidden in outliner' flag on nodes.
    
      - ignoreOutlinerColor : ioc      (bool)          [create,query,edit]
          Sets whether or not the outliner ignores the 'use outliner color' flag on nodes.
    
      - isChildSelected : ics          (PyNode)        [query]
          This flag allows you to query if one or more of the children of the specified item is selected in the outliner. The item
          should be specified using a unique DAG path. Note that if the specified item appears multiple times in the outliner, the
          result will be true if one or more children of any occurrence of the specified item in the outliner is/are selected.
    
      - isSet : isSet                  (int)           [query]
          Returns true if the item present at the given row is a set.
    
      - isSetMember : ism              (int)           [query]
          Returns true if the item present at the given row is a set member.
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - longNames : ln                 (bool)          [query,edit]
          Controls whether long or short attribute names will be used in the interface.  Note that this flag is ignored if the
          -niceNames flag is set.  Default is short names. Queried, returns a boolean.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - mapMotionTrails : mmt          (bool)          [create,query,edit]
          Sets whether or not we replace the motion trail in the outliner with the object it is trailing.
    
      - masterOutliner : mst           (unicode)       [create,query,edit]
          This flag is the name of an outliner that this outliner will share the objects and state from. When an outliner is
          shared, all of its state information comes from, and is applied to, the master outliner.
    
      - niceNames : nn                 (bool)          [query,edit]
          Controls whether the attribute names will be displayed in a more user-friendly, readable way.  When this is on, the
          longNames flag is ignored.  When this is off, attribute names will be displayed either long or short, according to the
          longNames flag. Default is on. Queried, returns a boolean.
    
      - object : obj                   (PyNode)        [query]
          This flags is used together with the parentObjectflag to get the name of the parent object for the specified object.
    
      - organizeByLayer : obl          (bool)          [create,query,edit]
          If true then when a node with animation layer is displayed, attributes will be displayed according to the layer(s) it
          belongs to. eg:  Layer1 Attr1 Attr2 Layer2 Attr1  If it is false then the outliner will be organized primarily by
          attributes. eg:  Attr1 Layer1 Layer2 Attr2 Layer1
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - parentObject : po              (bool)          [query]
    
      - pinPlug : pin                  (PyNode)        [create,query,edit]
          Pins the named plug, so it always appears in the outliner, irrespective of the incoming selection connection. In query
          mode, returns a list of the pinned plugs.
    
      - refresh : rfs                  (bool)          [edit]
          Causes the outliner to refresh itself.
    
      - removeFromCurrentSet : rcs     (int)           [edit]
          Removes selected members of a set from their current set. Current set is the set to which item at the given row belongs
          to. If no selected items, the item at the given row is removed from its current set.
    
      - renameItem : rni               (int)           [edit]
          Renames the item at the given row index in the outliner.
    
      - renameSelectedItem : rsi       (bool)          [edit]
          Rename the first selected item in the outliner.
    
      - renderFilterActive : rfa       (bool)          [query]
          This is a query only flag which returns true if the render setup filter is Active, i.e one of the four render filters
          (Inside Selected, Outside Selected, Inside All Layers, Outside All Layers) is applied on the outliner currently, false
          otherwise.
    
      - renderFilterIndex : rfi        (int)           [create,query,edit]
          Sets the Render Setup Filter to the index passed. This only works if the filter is visible in outliner and its selection
          is not locked. Valid indices are: 0 - Scene2 - Inside Selected3 - Outside Selected4 - Inside All Layers5 - Outside All
          LayersDefault: Scene 0 In query mode returns current index of the filter.
    
      - renderFilterVisible : rfv      (bool)          [create,query,edit]
          Show/Hide the Render Setup Filter in outliner. In query mode returns whether the Render Setup Filter is visible or not.
    
      - selectCommand : sec            (script)        [create,query,edit]
          A command to be executed when an item is selected.
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - selectionOrder : sod           (unicode)       [edit]
          Specify how objects are sorted in selection list. Current recognised values are selectionfor sorting in selection order
          and displayto sort objects in the same order that the outliner does.
    
      - setFilter : sf                 (unicode)       [create,query,edit]
          Specifies the name of a filter which is used to filter which (if any) sets to display.
    
      - setsIgnoreFilters : sif        (bool)          [create,query,edit]
          This flag specifies whether or not the filter should be ignored for expanding sets to show set members (default is
          true).
    
      - showAnimCurvesOnly : aco       (bool)          [create,query,edit]
          This flag modifies the showConnected flag.  If showConnected is set to true then this flag will cause display of only
          those attributes that are connected to an animCurve. If showConnected is set to false then this flag does nothing.
    
      - showAnimLayerWeight : saw      (bool)          [create,query,edit]
          If true then when a node with animation layer is displayed, the weight of the layer will be displayed if it is keyed.
    
      - showAssets : a                 (bool)          [create,query,edit]
          This flags specifies whether assets should be shown in the outliner.
    
      - showAssignedMaterials : sam    (bool)          [create,query,edit]
          Specifies whether to show assigned materials under shapes.
    
      - showAttrValues : av            (bool)          [create,query,edit]
          This flag specifies whether attribute values or attribute names should be displayed. Note: currently only string
          attributes can have their values displayed.
    
      - showAttributes : atr           (bool)          [create,query,edit]
          Specifies whether to show attributes or not.
    
      - showCompounds : cmp            (bool)          [create,query,edit]
          This flag specifies whether or not compound attributes should be displayed, or just the leaf attributes. Note: if
          showConnected is true, and the compound attribute is connected, it will still be displayed.
    
      - showConnected : con            (bool)          [create,query,edit]
          This flag modifies the showAttributes flag.  If showAttributes is set to true then this flag will cause display of only
          those attributes that are connected in the dependency graph. If showAttributes is set to false then this flag does
          nothing.
    
      - showContainedOnly : sco        (bool)          [create,query,edit]
          This flags specifies whether nodes belonging to containers should be show under the container node only. Otherwise, it
          will show up under the world as well.
    
      - showContainerContents : scc    (bool)          [create,query,edit]
          This flags specifies whether the contents of the container should be shown under the container node in the outliner.
    
      - showDagOnly : dag              (bool)          [create,query,edit]
          This flag specifies whether all dependency graph objects will be displayed, or just DAG objects.
    
      - showLeafs : laf                (bool)          [create,query,edit]
          This flag specifies whether or not leaf attributes should be displayed, or just the compound attributes. Note: if
          showConnected is true, and the leaf attribute is connected, it will still be displayed.
    
      - showMuteInfo : smi             (bool)          []
    
      - showNamespace : sn             (bool)          [create,query,edit]
          This flag specifies whether all objects will have their namespace displayed, if namespace different than root.
    
      - showNumericAttrsOnly : num     (bool)          [create,query,edit]
          This flag specifies whether or not all attributes should be displayed, or just numeric attributes. Note: if
          showConnected is true, and the attribute is connected, it will still be displayed.
    
      - showPinIcons : spi             (bool)          [create,query,edit]
          Sets whether pin icons are shown for unpinned plugs.
    
      - showPublishedAsConnected : spc (bool)          [create,query,edit]
          This flags enables attributes that are published to be displayed in italics. Otherwise, only attributes connected as a
          destination are shown in italics.
    
      - showReferenceMembers : rm      (bool)          [create,query,edit]
          Specifies whether to show reference node members under the reference node in the outliner.
    
      - showReferenceNodes : rn        (bool)          [create,query,edit]
          Specifies whether to show reference nodes or not.
    
      - showSelected : sc              (bool)          [create,edit]
          If true then the selected items are expanded in the outliner.
    
      - showSetMembers : ssm           (bool)          [create,query,edit]
          If true then when a set is expanded, the set members will be displayed. If false, then only other sets will be
          displayed.
    
      - showShapes : shp               (bool)          [create,query,edit]
          Specifies whether to show shapes or not.
    
      - showTextureNodesOnly : tno     (bool)          [create,query,edit]
          This flag modifies the showConnected flag. If showConnected is set to true then this flag will cause display of only
          those attributes that are connected to a texture node. If showConnected is set to false then this flag does nothing.
    
      - showTimeEditor : ste           (bool)          [create,query,edit]
          If true, all nodes related to the Time Editor will be shown as a hierarchy.
    
      - showUVAttrsOnly : uv           (bool)          [create,query,edit]
          This flag specifies whether or not all attributes should be displayed, or just uv attributes. Note: currently the only
          attribute which will be displayed is Shape.uvSet.uvSetName.
    
      - showUnitlessCurves : su        (bool)          [create,query,edit]
          This flag (in combination with -expandConnections) specifies whether or not connection expansion should show unitless
          animCurves.
    
      - showUpstreamCurves : suc       (bool)          [create,query,edit]
          Specifies exactly which attributes are displayed when showAttributes and expandConnections are both true. If true, the
          dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves for example
          in a typical driven key setup, where first the driven key curve is encountered, followed by the actual animation curve
          that drives the source object). If false, only the first curves encountered will be shown. Note that, even if false,
          multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.
    
      - sortOrder : so                 (unicode)       [create,query,edit]
          Specify how objects are to be sorted.  Current recognised values are nonefor no sorting and dagNameto sort DAG objects
          by name. Notes: a) non-DAG objects are always sorted by nodeType and name. b) when sortOrder is set to dagName, objects
          cannot be reordered using drag-and-drop, they can however be reparented.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - transmitFilters : tf           (bool)          [create,query,edit]
          This flag specifies how the selectionConnection is populated when attribute filters are enabled.  If this flag is set to
          true, then all the attributes that pass the filter will be placed on the selectionConnection.  By default this flag is
          false.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - unpinPlug : unp                (PyNode)        [create,edit]
          Unpins the named plug.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.outlinerEditor`
    """

    pass


def popupMenu(*args, **kwargs):
    """
    This command creates a popup menu and attaches it to the current control if no parent is specified.  The popup menu is
    posted with the right mouse button by default. Popup menus can be added to any kind of control, however, on some
    widgets, only the standard menu button (3rd mouse button) can be used to trigger popup menus. This is to meet generally
    accepted UI guidelines that assign the 3rd mouse button and only this one to popup menus, and also to prevent unexpected
    behavior of controls like text fields, that expect 1st and 2nd button to be reserved for contextual operations like text
    or item selection...
    
    Flags:
      - allowOptionBoxes : aob         (bool)          [create,query]
          Indicate whether the menu will be able to support option box menu items.  An error results if an option box item is
          added to a menu that doesn't allow them.  This flag may be queried and must be specified when the popup menu is created.
          The default value is false.
    
      - altModifier : alt              (bool)          [create,query,edit]
          Specify this flag if the Alt modifier must be pressed when posting the popup menu.
    
      - button : b                     (int)           [create,query,edit]
          Indicate which button posts the popup menu.  Valid values range from 1 to 3 where 1 is the left most button on the
          mouse.
    
      - ctrlModifier : ctl             (bool)          [create,query,edit]
          Specify this flag if the Cntl modifier must be pressed when posting the popup menu.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteAllItems : dai           (bool)          [edit]
          Delete all the items in this menu.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - itemArray : ia                 (bool)          [query]
          Return string array of the menu item names.
    
      - markingMenu : mm               (bool)          [create,query,edit]
          Set the marking menu state of this popup menu.
    
      - numberOfItems : ni             (bool)          [query]
          Return number of items in the menu.
    
      - parent : p                     (unicode)       [create]
          Specify the control that the popup menu will appear in.
    
      - postMenuCommand : pmc          (script)        [create,edit]
          Specify a script to be executed when the popup menu is about to be shown.
    
      - postMenuCommandOnce : pmo      (bool)          [create,query,edit]
          Indicate the -pmc/postMenuCommandshould only be invoked once.  Default value is false, ie. the -pmc/postMenuCommandis
          invoked every time the popup menu is shown.
    
      - shiftModifier : sh             (bool)          [create,query,edit]
          Specify this flag if the Shift modifier must be pressed when posting the popup menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.popupMenu`
    """

    pass


def hyperShade(*args, **kwargs):
    """
    Commands for shader editing in the hypergraph
    
    Flags:
      - assign : a                     (unicode)       [create]
          Assign the specified shader node to renderable objects on the active list. The node can either be a shading group or the
          shader node attached to the shading group.
    
      - clearWorkArea : cwa            (bool)          [create]
          Push the current work area on to the stack and create a clear work area
    
      - collapse : clp                 (unicode)       [create]
          Hide the upstream nodes from the specified node.
    
      - createNode : rcn               (unicode)       [create]
          Create a node of the specified type.  This is called when a new rendering node is created using drag and drop from the
          image browser or from the RMB context sensitive menu on nodes in the Visor Create folders.
    
      - dependGraphArea : dg           (bool)          [create]
          When setting a work area, and the work area doesn't already exist this flag inicates a new graph should be created that
          is either a depend graph or a folder view.
    
      - downStream : ds                (bool)          [create]
          Show nodes downstream from the specified node
    
      - duplicate : dup                (bool)          [create]
          Duplicate upstream nodes.  If the node is a shader make sure duplicate include the shading group if there is one
    
      - fixRenderSize : fix            (bool)          [create]
          If set to true dont rerender swatches when they change size as the user zooms
    
      - incremental : inc              (bool)          [create]
          Enable or disable incremental layout when making new nodes or connections
    
      - listDownstreamNodes : ldn      (PyNode)        [create]
          List all the downstream render nodes from the specified nodes.
    
      - listDownstreamShaderNodes : lds (PyNode)        [create]
          List all the downstream shader nodes from the specified nodes.
    
      - listUpstreamNodes : lun        (PyNode)        [create]
          List all the upstream render nodes from the specified nodes.
    
      - name : n                       (unicode)       [create]
          Name for the work area created by this command
    
      - networks : net                 (bool)          [create]
          Do an incremental layout on all of the nodes in the current selection list and that are in the current work area.
    
      - noSGShapes : nsg               (bool)          [create]
          Display only shapes that are connected to nodes in the network other than a shading group.
    
      - noShapes : ns                  (bool)          [create]
          Display no shapes when graphing networks.
    
      - noTransforms : nt              (bool)          [create]
          Display no transforms when graphing networks.
    
      - objects : o                    (unicode)       [create]
          Select the objects which are attached to the specified shader node. The shader node can be either the shading group or
          the shader attached to the shading group.  When this flag's argument is the empty string, we will use the currently
          selected shder node as the input.
    
      - renderCreateAndDrop : rcd      (unicode)       [create]
          Create a render node of the specified type and put user into drag and drop mode to place or connect it.
    
      - reset : rst                    (bool)          [create]
          Reset the Hypershade panel to its initial state.  In particular delete all the work areas.
    
      - resetGraph : rsg               (bool)          [create]
          Reset the current graph.  Typically called prior to rebuilding a folder in a Hypershade view.
    
      - resetSwatch : rss              (bool)          [create]
          For all selected nodes remove user defined swatches if the node has one
    
      - setAllowsRegraphing : sar      (bool)          [create]
          For internal use only.
    
      - setWorkArea : swa              (unicode)       [create]
          Set the work area to the existing named work area
    
      - shaderNetwork : sn             (unicode)       [create]
          Show the shader network for the specified material node.  If the materials shading group has a displacement or volume
          map these will be shown.  If not then the shading group will not be shown.
    
      - shaderNetworks : sns           (bool)          [create]
          Show the shader network for all the objects on the selection list that have shaders.
    
      - shaderNetworksSelectMaterialNodes : smn (bool)          [create]
          Select the material nodes in the shader network for all the objects on the selection list that have shaders.
    
      - snapShot : snp                 (bool)          [create]
          Put hypergraph in snapshot mode.  This is only for testing
    
      - uncollapse : ucl               (unicode)       [create]
          Unhide the upstream nodes from the specified node.
    
      - upStream : ups                 (bool)          [create]
          Show nodes upstream from the specified node
    
      - userDefinedLayout : udl        (bool)          [create]
          Enable or disable remembrance of user defined layouts.  Default is disabled until this functionality is better tested.
    
      - workAreaAddCmd : waa           (unicode)       [create]
          Set the MEL procedure called when a new work area is added to HyperShade
    
      - workAreaDeleteCmd : wad        (unicode)       [create]
          Set the MEL procedure called when a work area is deleted in HyperShade
    
      - workAreaSelectCmd : was        (unicode)       [create]
          Set the MEL procedure called when a work area is selected in HyperShade                                    Flag can have
          multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hyperShade`
    """

    pass


def toolButton(*args, **kwargs):
    """
    This command creates a toolButton that is added to the most recently created tool button collection unless the
    cl/collectionflag is used. It also attaches the named tool, activating it when this control is selected. By default,
    this control only handles one tool at a time.  Using the t/toolflag to associate a new tool will simply override the
    previous attached tool.  If you use the amt/allowMultipleToolsflag then you will be able to attach more than one tool
    with this control.  Only one tool will be current within the control.  To access the other tools press the right mouse
    button to display a popup menu containing all the tools associated with this control.  If you set the
    piv/popupIndicatorVisibleflag then a small arrow will be drawn on the control to indicate that additional tools are
    attached to this control.
    
    Flags:
      - allowMultipleTools : amt       (bool)          [create,query]
          Indicates whether this control will allow you to attach more than one tool.  By default, this control accepts only one
          tool. You can add multiple tools by setting this flag to true. Only one tool will be current and displayed at any one
          time. Use the pop up menu attached to the right mouse button to view all the tools.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the control's state is changed. Note that this flag should not be used in conjunction with
          onCommand and offCommand. That is, one should either use changeCommand and test the state of the control from inside the
          callback, or use onCommand and offCommand as separate callbacks.
    
      - collection : cl                (unicode)       [create,edit]
          To explicitly add a tool button to a tool collection.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - doubleClickCommand : dcc       (script)        [create,edit]
          Command executed when the control is double clicked.
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image1 : i1                    (unicode)       [create,query,edit]
    
      - image2 : i2                    (unicode)       [create,query,edit]
    
      - image3 : i3                    (unicode)       [create,query,edit]
          This control supports three images.  The image that best fits the current size of the control will be displayed.  This
          flag applies the image to the current tool.
    
      - imageOverlayLabel : iol        (unicode)       [create,query,edit]
          A short string (5 characters) label that will be displayed on top of the icon.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - ltVersion : lt                 (unicode)       [create,query,edit]
          This flag is used to specify the Maya LT version that this control feature was introduced, if the version flag is not
          specified, or if the version flag is specified but its argument is different. This value is only used by Maya LT, and
          otherwise ignored. The argument should be given as a string of the version number (e.g. 2013, 2014). Currently only
          accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be given as 2014).
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - offCommand : ofc               (script)        [create,edit]
          Command executed when the control is turned off.
    
      - onCommand : onc                (script)        [create,edit]
          Command executed when the control is turned on.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupIndicatorVisible : piv    (bool)          [create,query,edit]
          Edit this flag to set the visibility of the popup tool indicator. The indicator is a simple image that appears in the
          top right corner of the button when more that one tool is associated with this control. This flag is queryable and true
          by default.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - select : sl                    (bool)          [create,edit]
          Will set this button as the selected one.  This flag also queries the select state of the control.
    
      - style : st                     (unicode)       [create,edit]
          The draw style of the control.  Valid styles are iconOnly, textOnly, iconAndTextHorizontaland iconAndTextVertical.
    
      - tool : t                       (unicode)       [create,query,edit]
          The name of the tool to be attached to the button.  If the tool specified is already attached to this button then it
          will be selected.  Query this flag to return the current tool.  This flag may be specified more than once to attach more
          than one tool.
    
      - toolArray : ta                 (bool)          [query]
          This query only flag returns the names of all the tools attached to the toolButton control.
    
      - toolCount : tc                 (bool)          [query]
          This query only flag return the number of tools attached to the toolButton control.
    
      - toolImage1 : ti1               (unicode, unicode) [create,query,edit]
    
      - toolImage2 : ti2               (unicode, unicode) [create,query,edit]
    
      - toolImage3 : ti3               (unicode, unicode) [create,query,edit]
          This control supports three images.  The image that best fits the current size of the control will be displayed.  This
          flag applies the image to the specified tool.  The first argument is the name of the tool and the second is the name of
          the image.  When queried an array of tool icon pairs is returned.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - version : ver                  (unicode)       [create,query,edit]
          Specify the version that this tool button feature was introduced. The argument should be given as a string of the
          version number (e.g. 2013, 2014). Currently only accepts major version numbers (e.g. 2013 Ext 1, or 2013.5 should be
          given as 2014).
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.toolButton`
    """

    pass


def modelPanel(*args, **kwargs):
    """
    This command creates a panel consisting of a model editor. See the modelEditorcommand documentation for more
    information.
    
    Flags:
      - barLayout : bl                 (bool)          [query]
          This flag returns the name of the layout which is the parent of the panels icon bar.
    
      - camera : cam                   (unicode)       [query,edit]
          Query or edit the camera in a modelPanel.
    
      - control : ctl                  (bool)          [query]
          Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels
          may not have controls at times.  This flag can return if no control is present.
    
      - copy : cp                      (unicode)       [edit]
          Makes this panel a copy of the specified panel.  Both panels must be of the same type.
    
      - createString : cs              (bool)          [edit]
          Command string used to create a panel
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the Maya panel.
    
      - editString : es                (bool)          [edit]
          Command string used to edit a panel
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - init : init                    (bool)          [create,edit]
          Initializes the panel's default state.  This is usually done automatically on file -new and file -open.
    
      - isUnique : iu                  (bool)          [query]
          Returns true if only one instance of this panel type is allowed.
    
      - label : l                      (unicode)       [query,edit]
          Specifies the user readable label for the panel.
    
      - menuBarVisible : mbv           (bool)          [create,query,edit]
          Controls whether the menu bar for the panel is displayed.
    
      - modelEditor : me               (bool)          [query]
          This flag returns the name of the model editor contained by the panel.
    
      - needsInit : ni                 (bool)          [query,edit]
          (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for
          initialization.  Used during file -new and file -open.
    
      - parent : p                     (unicode)       [create]
          Specifies the parent layout for this panel.
    
      - popupMenuProcedure : pmp       (script)        [query,edit]
          Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The
          procedure should take one string argument which is the panel's name.
    
      - replacePanel : rp              (unicode)       [edit]
          Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.
    
      - tearOff : to                   (bool)          [query,edit]
          Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag
          will return if the panel has been torn off into its own window.
    
      - tearOffCopy : toc              (unicode)       [create]
          Will create this panel as a torn of copy of the specified source panel.
    
      - unParent : up                  (bool)          [edit]
          Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.modelPanel`
    """

    pass


def getMainProgressBar():
    pass


def textFieldButtonGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command adds a button to the textFieldGrp command.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - buttonCommand : bc             (script)        [create,edit]
          Command attached to the button.
    
      - buttonLabel : bl               (unicode)       [create,query,edit]
          Label text of the button.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the field text changes and user presses Enter or Return.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
          If false then the field is 'read only' and can not be typed into. The text in the field can always be changed with the
          -tx/textflag regardless of the state of the -ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enableButton : eb              (bool)          [create,query,edit]
          Enable state of the button.  By default, this flag is set to true and the button is enabled.  Specify true, and the
          button will appear dimmed or greyed-out indicating it is disabled.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fileName : fi                  (unicode)       [create,query,edit]
          Text in the field as a filename. This does conversions between internal and external (UI) file representation.
    
      - forceChangeCommand : fcc       (bool)          [create,edit]
          If used together with -text or -inserText flag, change command will be executed after text modification.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - insertText : it                (unicode)       [create,edit]
          Insert text into the field at the current insertion position (specified by the -ip/insertionPosition flag).
    
      - insertionPosition : ip         (int)           [create,query,edit]
          The insertion position for inserted text.  This is a 1 based value where position 1 specifies the beginning of the
          field.  Position 0 may be used to specify the end of the field.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          Label text for the group.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - placeholderText : pht          (unicode)       [create,query,edit]
          Setting this property makes the line edit display a grayed-out placeholder text as long as the text field is empty and
          the widget doesn't have focus. By default, this property contains an empty string.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - text : tx                      (unicode)       [create,query,edit]
          Text in the field.
    
      - textChangedCommand : tcc       (script)        [create,edit]
          Command executed immediately when the field text changes.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.textFieldButtonGrp`
    """

    pass


def layoutDialog(*args, **kwargs):
    """
    The layoutDialog command creates a modal dialog containing a formLayout with 100 divisions. The formLayout can be
    populated with arbitrary UI elements through use of the '-ui/-uiScript' flag. NOTE:A layoutDialog is not a window and
    certain UI elements will not function properly within it. In particular menuBars and panels containing menuBars should
    not be used with the layoutDialog.
    
    Flags:
      - backgroundColor : bgc          (float, float, float) [create]
          The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. (Windows only flag)
    
      - dismiss : dis                  (unicode)       [create]
          Dismiss the current layoutDialog. The specified string will be set as the result of the initial layoutDialog command.
    
      - parent : p                     (unicode)       [create]
          Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
          parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
    
      - title : t                      (unicode)       [create]
          The dialog title.
    
      - uiScript : ui                  (script)        [create]
          The specified MEL procedure name will be invoked to build the UI of the layoutDialog. This flag is required when
          creating a layoutDialog. The top-level control of a layoutDialog is a formLayout with 100 divisions. It can be accessed
          by calling 'setParent -q' at the beginning of the specified MEL procedure.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.layoutDialog`
    """

    pass


def headsUpMessage(*args, **kwargs):
    """
    This command draws a message in the 3d view.  The message is automatically erased at the next screen refresh.
    
    Flags:
      - horizontalOffset : ho          (int)           [create]
          If this flag is specified, the message will appear the specified distance (in pixels) to the right of the point.
          Otherwise, a default horizontal offset of 0 pixels is used.
    
      - object : o                     (unicode)       [create]
          If an object is specified, then the message is drawn just above the object's bounding-box centre point. If this flag is
          not specified, or the object is not found, then the message is centred in the current view.
    
      - selection : s                  (bool)          [create]
          If this flag is specified, the message will be centred among the currently selected objects.  This flag does nothing if
          the object flag is also specified.
    
      - time : t                       (float)         [create]
          If this flag is specified, the message will be displayed for a minimum of the given amount of time (in seconds).
          Otherwise a default time of 1.0 seconds is used.
    
      - uvTextureEditor : uve          (bool)          []
    
      - verticalOffset : vo            (int)           [create]
          If this flag is specified, the message will appear the specified distance (in pixels) above the point. Otherwise, a
          default vertical offset of 0 pixels is used.                  Flag can have multiple arguments, passed either as a tuple
          or a list.
    
      - viewport : vp                  (bool)          []
    
    
    Derived from mel command `maya.cmds.headsUpMessage`
    """

    pass


def rowLayout(*args, **kwargs):
    """
    This command creates a layout capable of positioning children into a single horizontal row.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.
    
      - adjustableColumn1 : ad1        (int)           [create]
          Specifies that the first column has an adjustable size that changes with the size of the parent layout. Ignored if there
          isn't exactly one column.
    
      - adjustableColumn2 : ad2        (int)           [create]
          Specifies which of the two columns has an adjustable size that changes with the size of the parent layout. Ignored if
          there isn't exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create]
          Specifies which of the three columns has an adjustable size that changes with the size of the parent layout. Ignored if
          there isn't exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create]
          Specifies which of the four columns has an adjustable size that changes with the size of the parent layout. Ignored if
          there isn't exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create]
          Specifies which of the five columns has an adjustable size that changes with the size of the parent layout. Ignored if
          there isn't exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create]
          Specifies which of the six columns has an adjustable size that changes with the size of the parent layout. Ignored if
          there isn't exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Text alignment for the specified column. Valid values are left, right, and center
    
      - columnAlign1 : cl1             (unicode)       [create]
          Text alignment for the first column. Valid values are left, right, and center. Ignored if there isn't exactly one
          column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create]
          Text alignment for both columns. Valid values are left, right, and center. Ignored if there isn't exactly two columns.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create]
          Text alignment for all three columns. Valid values are left, right, and center. Ignored if there isn't exactly three
          columns.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create]
          Text alignment for all four columns. Valid values are left, right, and center. Ignored if there isn't exactly four
          columns.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create]
          Text alignment for all five columns. Valid values are left, right, and center. Ignored if there isn't exactly five
          columns.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create]
          Text alignment for all six columns. Valid values are left, right, and center. Ignored if there isn't exactly six
          columns.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Horizontally attach a particular column.  The first argument is a 1-based index specifying the column.  The second
          argument is the attachment, valid values are left, right, and both.  The third argument is the offset value.
    
      - columnAttach1 : ct1            (unicode)       [create]
          Attachment type for the first column.  Ignored if there isn't exactly one column. Valid values are left, right, and
          both.
    
      - columnAttach2 : ct2            (unicode, unicode) [create]
          Attachment type for both columns.  Ignored if there isn't exactly two columns. Valid values are left, right, and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create]
          Attachment type for all three columns.  Ignored if there isn't exactly three columns. Valid values are left, right, and
          both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create]
          Attachment type for all four columns.  Ignored if there isn't exactly four columns. Valid values are left, right, and
          both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create]
          Attachment type for all five columns.  Ignored if there isn't exactly five columns. Valid values are left, right, and
          both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create]
          Attachment type for all six columns.  Ignored if there isn't exactly six columns. Valid values are left, right, and
          both.
    
      - columnOffset1 : co1            (int)           [create]
          Used in conjunction with the -columnAttach1 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for the first column.  The offsets applied are based on the attachments specified with the -columnAttach1 flag.
          Ignored if there isn't exactly one column.
    
      - columnOffset2 : co2            (int, int)      [create]
          Used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for both columns.  The offsets applied are based on the attachments specified with the -columnAttach2 flag.
          Ignored if there isn't exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create]
          Used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for all three columns.  The offsets applied are based on the attachments specified with the -columnAttach3 flag.
          Ignored if there isn't exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create]
          Used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for all four columns.  The offsets applied are based on the attachments specified with the -columnAttach4 flag.
          Ignored if there isn't exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create]
          Used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for all five columns.  The offsets applied are based on the attachments specified with the -columnAttach5 flag.
          Ignored if there isn't exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create]
          Used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.  Sets the
          offset for all six columns.  The offsets applied are based on the attachments specified with the -columnAttach6 flag.
          Ignored if there isn't exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Width of a particular column.  The first argument is a 1-based index specifying the column.  The second argument is the
          width value.
    
      - columnWidth1 : cw1             (int)           [create]
          Width for the first column.  Ignored if there isn't exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create]
          Widths for both columns.  Ignored if there isn't exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create]
          Widths for all three columns.  Ignored if there isn't exactly three columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create]
          Widths for all four columns.  Ignored if there isn't exactly four columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create]
          Widths for all five columns.  Ignored if there isn't exactly five columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create]
          Widths for all six columns.  Ignored if there isn't exactly six columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfColumns : nc           (int)           [create,query]
          Number of columns in the row.  The specified number of columns must be a value greater than 0.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Vertically attach a particular column.  The first argument is a 1-based index specifying the column.  The second
          argument is the attachment, valid values are top, bottom, and both.  The third argument is the offset value.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.rowLayout`
    """

    pass


def saveMenu(*args, **kwargs):
    """
    This command is used for saving the contents of a menu, so that another instance of the menu may be recreated later. The
    command writes out a file which, when run as a script, will rebuild the menuItems contained in the original menu. Note
    that the fileName is relative to the user's marking menu preference directory. Note that this command is used solely by
    the Marking Menu Editor and is not intended to be used for general purposes. Note that this command doesn't work well
    with controls that have mixed mel and python command callbacks.  Also, because it saves the menu state to a mel file, it
    does not work with callbacks that are python callable objects. The first argument is the name of the manu to save, the
    second one is the name of the file.
    
    
    Derived from mel command `maya.cmds.saveMenu`
    """

    pass


def editorTemplate(*args, **kwargs):
    """
    The editorTemplate command allows the user to specify the conceptual layout of an attribute editor and leave the details
    of exactly which UI elements are used in the final result to the automatic dialog generation mechanism.
    
    Flags:
      - addAdskAssetControls : aac     (bool)          [create]
          Adds controls for dynamic attributes of adskMaterial nodes and organizes them in a layout according to the XML ui
          description specified in the asset library.
    
      - addComponents : acp            (bool)          [create]
          This flag will add a frameLayout with a channel box which will display any selected components for the object.
    
      - addControl : ac                (bool)          [create]
          The first argument is the name of the attribute for which you wish to add a control. You can assume that when the editor
          is created from the template, an appropriate type of control will be used. The second string argument is optional, and
          can be used to specify a command (or script) to be executed when the attribute is changed.
    
      - addDynamicControl : adc        (bool)          [create]
          As -addControl with the exception that the attribute for which the control is to be created/attached is dynamic. [Note:
          -addControl will also work for dynamic attributes, but will not preserve their order in the attribute editor].
    
      - addExtraControls : aec         (bool)          [create]
          By default, if there are attributes of a node which you do not -addControl or -suppress, then controls will be created
          automatically and appended to the end of editor created from the template. This flag allows you to specify a particular
          place in the template for such controls to be automatically inserted. If dynamic attributes have not already been
          addressed with -addControl, they will also be placed here.  A frameLayout will automatically be generated for you when
          you use this flag.
    
      - addSeparator : addSeparator    (bool)          [create]
          Adds a separator to the template.
    
      - annotateFieldOnly : afo        (bool)          [create]
          This flag can only be used with the -annotation flag.  By default, for any Attribute Editor controlGroups created by the
          -addControl flag, the -annotation flag displays its annotation string when the mouse hovers over any control that is
          part (the label, the value field, etc.) of the group.  Use this flag to limit display of the annotation to only the
          value field of the controlGroup.  This flag is ignored if the controlGroup has no value field (e.g., checkBoxGrp)
    
      - annotation : ann               (unicode)       [create]
          This flag can only be used with the -addControl or the -addDynamicControl flags. The string will be used as an
          annotation on the controls created in the attribute editor.
    
      - beginLayout : bl               (unicode)       [create]
          Begins a layout in the template with the title specified by the string argument. Items between this flag and    its
          corresponding -endLayout flag will be contained within the layout. You can assume that when the editor is created from
          the template, an appropriate type of layout will be used. (frameLayout).
    
      - beginNoOptimize : bn           (bool)          [create]
          Specifies that the layout of items between this flag and its corresponding -endNoOptimize flag is not to be optimized to
          minimize space.
    
      - beginScrollLayout : bsl        (bool)          [create]
          Begins a scrollLayout.  Items between this flag and its corresponding -endScrollLayout flag will be contained within the
          layout.
    
      - callCustom : ccu               (bool)          [create]
          Specifies that at this point in the template when building the dialog, the procedure specified by the first argument is
          to be called to create some UI objects when a new node type is edited. The procedure specified by the second argument is
          to be called if an attribute editor already exists and another node of the same type is now to be edited. The replacing
          procedure should connect any controls created by the creating procedure to the equivalent attributes in the new node. A
          list of zero or more attributes specifies the attributes which the two procedures will involve. The procedures should
          have the signature: proc AEcustomNew(string attributeName1, string attributeName2) The number of attributes specified in
          the call should correspond to the number of attributes in the procedure signature.
    
      - collapse : cl                  (bool)          [create]
          This flag is only valid when used in conjunction with a -bl/beginLayout flag.  It is used to specify the initial
          expand/collapse state of the layout.  A true value will cause the layout to be collapsed upon creation, while a false
          value will expand the layout.  The default is true (ie. collapsed).
    
      - debugMode : dbm                (bool)          []
    
      - dimControl : dc                (unicode, unicode, bool) [create]
          This flag is only useful AFTER a control has already been created (using the -addControl flag).  The first argument is
          the node name and the second is the attribute whose control you wish to affect.  The third argument is a boolean which
          specifies whether to dim (true) or undim (false) the associated control.
    
      - endLayout : el                 (bool)          [create]
          Ends a layout in the template started by -beginLayout.
    
      - endNoOptimize : en             (bool)          [create]
          Ends a set of non-optimized items.
    
      - endScrollLayout : esl          (bool)          [create]
          Ends a scrollLayout.
    
      - extraControlsLabel : ecl       (unicode)       [create]
          By default the label is Extra Attributes. Specify an alternate label or an empty string to hide the label. This flag
          must be used in conjuction with the -aec/addExtraControls flag.
    
      - interruptOptimize : io         (bool)          [create]
          Enforces a division between two sets of items whose layouts may be optimized.
    
      - label : l                      (unicode)       [create]
          This flag can only be used with the -addControl or the -addDynamicControl flags.  And it must be specified FIRST. The
          string will override the name of the attribute that will be displayed in the attribute editor.
    
      - listExtraAttributes : lea      (unicode)       [create]
          List extra attributes.This flag is only useful AFTER a control has already been created (using the -addControl flag).
          The first argument is the node name.
    
      - preventOverride : po           (bool)          [create]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - queryControl : qc              (unicode, unicode) [create]
          This flag is only useful AFTER a control has already been created (using the -addControl flag).  The first argument is
          the node name and the second is the attribute whose control you wish to query.  Note that in most cases, using this flag
          is identical to issuing a getAttr command, however, in the case of textFields (e.g. for message attributes), the text
          value currently being displayed will be returned, NOT the actual attribute value.
    
      - queryLabel : ql                (unicode, unicode) [create]
          This flag is only useful AFTER a control has already been created (using the -addControl flag).  The first argument is
          the node name and the second is the attribute whose control label you wish to query.  In most cases this flag returns
          the same value as the attribute's nice name, but when a -label flag was present on the -addControl command that created
          the control, -queryLabel will return that value instead
    
      - queryName : qn                 (unicode, unicode) [create]
          This flag is only useful AFTER a control has already been created (using the -addControl flag).  The first argument is
          the node name and the second is the attribute whose control name you wish to query.
    
      - removeControl : rc             (unicode, unicode) [create]
          This flag is obsolete and should no longer be used.
    
      - suppress : s                   (unicode)       [create]
          Prevent a control for the attribute specified by the string argument from appearing in the editor created from the
          template.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.editorTemplate`
    """

    pass


def scriptedPanelType(*args, **kwargs):
    """
    This command defines the callbacks for a type of scripted panel.  The panel type created by this command is then used
    when creating a scripted panel.  See also the 'scriptedPanel' command.
    
    Flags:
      - addCallback : acb              (unicode)       [create,query,edit]
          This flag specifies the callback procedure for adding the panel to a particular control layout.  The parent layout is
          guaranteed to be the current default layout when the proc is called.  If its name is required then it can be queried
          with 'setParent -q'.  Any editors should be parented here. global proc procName (string $panelName) { .... }
    
      - copyStateCallback : ocb        (unicode)       [create,query,edit]
          This flag specifies the callback procedure for copying the state of the panel when a tear-off copy of the panel is made.
          The callback proc has the form: global proc procName (string $panelName, string $newPanelName) { .... } This procedure
          will be executed immediately after the addCallback procedure has finished executing. At that point, the copied panel
          will be fully created and accessible to facilitate copying of panel settings. Note: the addCallback procedure is called
          after the createCallback procedure has been called.
    
      - createCallback : ccb           (unicode)       [create,query,edit]
          This flag specifies the callback procedure for initially creating the panel object.  No UI should be created here.  Any
          editors owned by the panel should be created here unparented. The callback proc has the form: global proc procName
          (string $panelName) { .... }
    
      - customView : cv                (bool)          [create,query,edit]
          This flag specifies if this view is a custom 3d view for MPx3dModelView types. This flag should only be used for
          MPx3dModelView types.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteCallback : dcb           (unicode)       [create,query,edit]
          This flag specifies the callback procedure for final deletion of the panel.  The callback proc has the form: global proc
          procName (string $panelName) { .... }
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - initCallback : icb             (unicode)       [create,query,edit]
          This flag specifies the callback procedure for the initialize callback.  This will be called on file -new and file -open
          to give the panel an opportunity to re-initialize to a starting state, if required. The panel may be parented or
          unparented at this time. The callback proc has the form: global proc procName (string $panelName) { .... }
    
      - label : l                      (unicode)       [create,query,edit]
          Label for the panel
    
      - obsolete : o                   (bool)          [create,query,edit]
          This flag specifies that this type is no longer used in Maya.
    
      - removeCallback : rcb           (unicode)       [create,query,edit]
          This flag specifies the callback procedure for removing the panel from its current control layout.  Any editors should
          be unparented here. The callback proc has the form: global proc procName (string $panelName) { .... }
    
      - retainOnFileOpen : rfo         (bool)          [create,query,edit]
          This flag specifies if panels of this type should be retained after restoring panel cofiguration during file open.
          Default value is false.
    
      - saveStateCallback : scb        (unicode)       [create,query,edit]
          This flag specifies the callback procedure for saving the state of the panel.  The callback proc has the form: global
          proc string procName (string $panelName) { .... } Note that the proc returns a string.  This string will be executed
          after the createCallback has been called to facilitate restoring the panel state.
    
      - unique : u                     (bool)          [create,query,edit]
          This flag specifies if only one instance of this type of panel can exist at a given time.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.scriptedPanelType`
    """

    pass


def floatField(*args, **kwargs):
    """
    Create a field control that accepts only float values and is bound by a minimum and maximum value.  An invisible slider
    is attached to the field and accessed by holding down the Ctrl modifier key while pressing one of the mouse buttons.
    Dragging the invisible slider to the right with the middle mouse button increases the field value by the amount
    specified with the -s/stepflag, while dragging to the left decreases the value by the same amount.  The left and right
    mouse buttons apply a factor of 0.1 and 10 to the step value.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the field changes.  This command is not invoked when the value changes via the -v/valueflag.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command executed when dragging in the field.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
          If false then the field can not be changed interactively.  However, you can change the field text with the -v/valueflag
          regardless of the state of the -ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enterCommand : ec              (script)        [create,edit]
          Command executed when the keypad 'Enter' key is pressed.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (float)         [create,query,edit]
          Upper limit of the field.
    
      - minValue : min                 (float)         [create,query,edit]
          Lower limit of the field.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [create,query,edit]
          Number of digits to the right of the decimal place.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - receiveFocusCommand : rfc      (script)        [create,edit]
          Command executed when the field receives focus.
    
      - showTrailingZeros : tze        (bool)          [create,query,edit]
          Show trailing zeros or not
    
      - step : s                       (float)         [create,query,edit]
          Increment for the invisible slider.   The field value will change by this amount when the invisible slider is dragged.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (float)         [create,query,edit]
          Value of the field.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.floatField`
    """

    pass


def keyframeOutliner(*args, **kwargs):
    """
    This command creates/edits/queries a keyframe outliner control.
    
    Flags:
      - animCurve : ac                 (unicode)       [edit]
          Name of the animation curve for which to display keyframes.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - display : dsp                  (unicode)       [query,edit]
          narrow | wide What columns to display.  When narrow, time and value will be displayed, when widetangent information will
          be displayed as well
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.keyframeOutliner`
    """

    pass


def menuSetPref(*args, **kwargs):
    """
    Provides the functionality to save and load menuSets between sessions of Maya. For Internal Use Only! In query mode,
    return type is based on queried flag.
    
    Flags:
      - exists : e                     (bool)          [query]
          Returns whether the menuSet preferences file exists or not.
    
      - force : f                      (bool)          [create,edit]
          Forces a specified operation to continue even if errors are encountered (such as invalid preferences).
    
      - loadAll : la                   (bool)          [create]
          Loads all the menuSets from the preferences file only if the preferences version matches, or the -force flag is enabled.
          On successful load, of a prefs file, an empty string is returned, otherwise, a description of the problem encountered is
          returned.
    
      - removeAll : ra                 (bool)          [create]
          Removes all the menuSets from the preferences file (removes the whole file).
    
      - saveAll : sa                   (bool)          [create]
          Saves all the current menuSets into the preferences file.
    
      - saveBackup : sb                (bool)          [create]
          Saves a backup of the current menu set preferences file if one exists.  This backup will be saved in the same location
          as the current preferences file.
    
      - version : v                    (bool)          [query]
          The base version string which is saved out to file. It is also checked upon loading in order to indicate changes in the
          default prefs since the prefs were last saved out.                  Flag can have multiple arguments, passed either as a
          tuple or a list.
    
    
    Derived from mel command `maya.cmds.menuSetPref`
    """

    pass


def devicePanel(*args, **kwargs):
    """
    This command is now obsolete. It is included only for the purpose of file compatibility. It creates a blank panel.
    
    
    Derived from mel command `maya.cmds.devicePanel`
    """

    pass


def attrEnumOptionMenu(*args, **kwargs):
    """
    This command creates an enumerated attribute control. It is usually an option menu.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attribute : at                 (PyNode)        [create,edit]
          Attribute that the menu controls.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          The command string is executed when the value of the option menu changes.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enumeratedItem : ei            (int, unicode)  [create]
          Enumerated item and the corresponding string.  If this flag is not supplied when the control is created, then the
          command will try to read the values from the attribute.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          The label text.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.attrEnumOptionMenu`
    """

    pass


def control(*args, **kwargs):
    """
    This command allows you to edit or query the properties of any control.                  In query mode, return type is
    based on queried flag.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.control`
    """

    pass


def soundControl(*args, **kwargs):
    """
    This command creates a control used for changing current time and scratching/scrubbing through sound files.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - beginScrub : bs                (bool)          [edit]
          Set this widget up for sound scrubbing. Subsequent changes to current time will result in sound scrubbingbehavior, until
          the -endScrubcommand is issued for this widget.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - displaySound : ds              (bool)          [query,edit]
          Turn sound display off.  Query returns int.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - endScrub : es                  (bool)          [edit]
          End sound scubbing for this widget.  This stops sound scrubbing behavior and should be issued before any subsequent
          -beginScrubflags
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxTime : max                  (time)          [create,query,edit]
          Controls the max time of the range displayed in the control. Query returns float.
    
      - minTime : min                  (time)          [create,query,edit]
          Controls the min time of the range displayed in the control. Query returns float.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - pressCommand : pc              (unicode)       [create,edit]
          script to run on mouse-down in this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - releaseCommand : rc            (unicode)       [create,edit]
          script to run on mouse-up in this control.
    
      - repeatChunkSize : rcs          (float)         [query,edit]
          How much sound (in the current time unit) is repeated when -repeatOnHold is true.  Default is 1.0.
    
      - repeatOnHold : roh             (bool)          [query,edit]
          Repeat sound during mouse-down events
    
      - resample : r                   (bool)          [edit]
          Resample the sound display to fit the widget
    
      - sound : s                      (unicode)       [query,edit]
          Name of audio depend node whose data should display in the sound-display widget. Query returns string.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - waveform : wf                  (unicode)       [query,edit]
          Determines what part of the sound waveform to display, when -displaySound is true. Valid values are top, bottom, and
          both.  Default is top. Query returns string.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.soundControl`
    """

    pass


def menuBarLayout(*args, **kwargs):
    """
    Create a layout containing a menu bar.  The menu bar will appear and behave similar to any menu bar created with the
    'window -menuBar true' command. Menus may be created with a menuBarLayout as their parent.  Child controls are simply
    positioned to fill the menuBarLayout area beneath the menu bar consequently, some other layout should be used as the
    immediate child.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - menuArray : ma                 (bool)          [query]
          Return a string array containing the names of the menus in the layout's menu bar.
    
      - menuBarVisible : mbv           (bool)          [create,query,edit]
          Visibility of the menu bar.
    
      - menuIndex : mi                 (unicode, int)  [edit]
          Sets the index of a specified menu.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfMenus : nm             (bool)          [query]
          Return the number of menus attached to the layout's menu bar.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.menuBarLayout`
    """

    pass


def renameUI(*args, **kwargs):
    """
    This command renames the UI object passed as first arument to the new name specified as second argument. If the new name
    is a duplicate, or not valid, then re-naming fails and the old name is returned.
    
    
    Derived from mel command `maya.cmds.renameUI`
    """

    pass


def window(*args, **kwargs):
    """
    This command creates a new window but leaves it invisible. It is most efficient to add the window's elements and then
    make it visible with the showWindow command. The window can have an optional menu bar. Also, the title bar and
    minimize/maximize buttons can be turned on or off. If the title bar is off, then you cannot have minimize or maximize
    buttons. Note: The window will require a control layout of some kind to arrange the controls (buttons, sliders, fields,
    etc.).  Examples of control layouts are columnLayout, formLayout, rowLayout, etc. Note: This command will clear the
    uiTemplate stack.  Templates for a window need to be set after the window cmd.
    
    Flags:
      - backgroundColor : bgc          (float, float, float) [create,edit]
          The background color of the window. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - closeCommand : cc              (script)        [create,edit]
          Script executed after the window is closed.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attach a tag to the window.
    
      - dockCorner : dc                (unicode, unicode) [create]
          Specifies which docking areas occupied the four different corners of the window. By default docking windows on the
          bottom or top will span the whole window. Use multiple instances of this flag to allow the left and right docking areas
          to occupy the corners. This method has two arguments: docking corner and docking area. Possible values for docking
          corner are topLeft, topRight, bottomLeft, and bottomRight. Possible values for docking area are left, right, top, and
          bottom.
    
      - dockStation : ds               (bool)          [create]
          When set this flag specifies that this window can contain other docked sub-windows.
    
      - dockingLayout : dl             (unicode)       [create,query,edit]
          When queried this flag will return a string holding the docking layout information. This string can be set when creating
          or editing a docking station to restore the previous docking layout. This string is a hexadecimal representation of a
          binary string and is not meant to be humanly readable, but can be saved and loaded using the optionVar command to
          restore layouts across sessions of Maya.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - frontWindow : fw               (bool)          [query]
          Return the name of the front window.  Note: you must supply the name of any window (the window does not need to exist).
          Returns unknownif the front window cannot be determined.
    
      - height : h                     (int)           [create,query,edit]
          Height of the window excluding any window frame in pixels.
    
      - iconName : iconName            (unicode)       [create,query,edit]
          The window's icon title.  By default it is the same as the window's title.
    
      - iconify : i                    (bool)          [create,query,edit]
          Icon state of the window.
    
      - interactivePlacement : ip      (bool)          [create]
          Deprecated flag. Recognized but not implemented. This flag will be removed in a future version of Maya.
    
      - leftEdge : le                  (int)           [create,query,edit]
          Position of the left edge of the window.
    
      - mainMenuBar : mm               (bool)          []
    
      - mainWindow : mw                (bool)          [create,query,edit]
          Main window for the application.  The main window has an 'Exit' item in the Window Manager menu.  By default, the first
          created window becomes the main window.
    
      - maximizeButton : mxb           (bool)          [create,query,edit]
          Turns the window's maximize button on or off.
    
      - menuArray : ma                 (bool)          [query]
          Return a string array containing the names of the menus in the window's menu bar.
    
      - menuBar : mb                   (bool)          [create,query]
          Adds an empty menu bar to the window. The Qt name of the object will be m_menubar_nameOfTheWindow.
    
      - menuBarCornerWidget : mcw      (unicode, unicode) [query,edit]
          This flag specify a widget to add to a corner of parent window. The first argument corresponds to the widget name and
          the second to the position of the widget. Possible values for widget position are topLeft, topRight, bottomLeft,
          bottomRight. In query mode this flag returns all the corner widget names in the following order: topLeft, topRight,
          bottomLeft, bottomRight. Add -mbr/-menuBarResizeflag to the changeCommandof widget passed (first argument) so that it
          will always have an appropriate size.
    
      - menuBarResize : mbr            (bool)          [edit]
          This flag should be used along with -mcw/-menuBarCornerWidgetflag. This is used to resize the menu bar so that the
          corner widgets are updated.
    
      - menuBarVisible : mbv           (bool)          [create,query,edit]
          Visibility of the menu bar (if there is one).
    
      - menuIndex : mi                 (unicode, int)  [edit]
          Sets the index of a specified menu.
    
      - minimizeButton : mnb           (bool)          [create,query,edit]
          Turns the window's minimize button on or off.
    
      - minimizeCommand : mnc          (script)        [create,edit]
          Script executed after the window is minimized (iconified).
    
      - nestedDockingEnabled : nde     (bool)          [create]
          Controls whether nested docking is enabled or not.  Nested docking allows for docking windows next to other docked
          windows for more possible arrangement styles.
    
      - numberOfMenus : nm             (bool)          [query]
          Return the number of menus attached to the window's menu bar.
    
      - parent : p                     (unicode)       [create]
          Specifies a parent window or layout which the created window is always on top of. Note: If the parent is a window the
          created window is not modal, so events are still propagated to the parent window.
    
      - resizeToFitChildren : rtf      (bool)          [create,query,edit]
          The window will always grow/shrink to just fit the controls it contains.
    
      - restoreCommand : rc            (script)        [create,edit]
          Script executed after the window is restored from it's minimized (iconified) state.
    
      - retain : ret                   (bool)          [create]
          Retains the window after it has been closed.  The default is to delete the window when it is closed.
    
      - sizeable : s                   (bool)          [create,query,edit]
          Whether or not the window may be interactively resized.
    
      - state : st                     (unicode)       [create,query,edit]
          When queried this flag will return a string holding the window state information. This string is a hexadecimal
          representation of a binary string and is not meant to be humanly readable, but can be saved and loaded using the
          optionVar command to restore window state across sessions of Maya.
    
      - title : t                      (unicode)       [create,query,edit]
          The window's title.
    
      - titleBar : tb                  (bool)          [create,query,edit]
          Turns the window's title bar on or off.
    
      - titleBarMenu : tbm             (bool)          [create,query,edit]
          Controls whether the title bar menu exists in the window title bar. Only valid if -tb/titleBaris true. This Windows only
          flag is true by default.
    
      - toolbox : tlb                  (bool)          [create,query,edit]
          Makes this a toolbox style window.  A Windows only flag that makes the title bar smaller and uses a slightly different
          display style.
    
      - topEdge : te                   (int)           [create,query,edit]
          Position of the top edge of the window.
    
      - topLeftCorner : tlc            (int, int)      [create,query,edit]
          Position of the window's top left corner.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The window's visibility.
    
      - width : w                      (int)           [create,query,edit]
          Width of the window excluding any window frame in pixels.
    
      - widthHeight : wh               (int, int)      [create,query,edit]
          Window's width and height excluding any window frame in pixels.                  Flag can have multiple arguments,
          passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.window`
    """

    pass


def toggleWindowVisibility(*args, **kwargs):
    """
    Toggle the visibility of a window. If no window is specified then the current window (most recently created) is used.
    See also the windowcommand's vis/visibleflag.
    
    
    Derived from mel command `maya.cmds.toggleWindowVisibility`
    """

    pass


def keyframeStats(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates, edits, queries a keyframe stats control.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - animEditor : ae                (unicode)       [query,edit]
          The name of the animation editor which is associated with the control
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - classicMode : cm               (bool)          []
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [query,edit]
          Controls the number of digits to the right of the decimal point that will be displayed for float-valued channels.
          Default is 3.  Queried, returns an int.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - timeAnnotation : tan           (unicode)       [create,query,edit]
          Annotate the time field with an extra string value.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - valueAnnotation : van          (unicode)       [create,query,edit]
          Annotate the value field with an extra string value.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.keyframeStats`
    """

    pass


def nameField(*args, **kwargs):
    """
    This command creates an editable field that can be linked to the name of a Maya object. The field will always show the
    name of the object.
    
    (<function nameField at 0x000002073DE52438>, <function addCmdDocsCallback at 0x000002073D685588>, ('nameField', ''), {})
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,query,edit]
          This command is executed when the field text is changed by the user.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - drawInactiveFrame : dif        (bool)          [create,query,edit]
          Sets whether the name field draws itself with a frame when it is inactive. By default, this option is false.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - nameChangeCommand : ncc        (script)        [create,query,edit]
          This command is executed when the name of the node changes. NOTE: this will be executed when the node name changes,
          whether or not the name-change originated with the user typing into the field. If you want to attach a command to be
          executed when the user types into the field, use the -cc/changeCommand flag.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - object : o                     (unicode)       [create,query,edit]
          Attaches the field to the named dage object, so that the field will always display the object's name.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - receiveFocusCommand : rfc      (script)        [create,query,edit]
          Command executed when the field receives focus.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.nameField`
    """

    pass


def _createClassCommands():
    pass


def radioButtonGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates from one to four radio buttons in a single row. By default
    the radio buttons will share a single collection, but they can also share the collection of another radio button group.
    The buttons can also have an optional text label.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - annotation1 : an1              (unicode)       [create,query,edit]
          specifies the tooptip of the first radiobutton
    
      - annotation2 : an2              (unicode)       [create,query,edit]
          specifies the tooptip of the second radiobutton
    
      - annotation3 : an3              (unicode)       [create,query,edit]
          specifies the tooptip of the third radiobutton
    
      - annotation4 : an4              (unicode)       [create,query,edit]
          specifies the tooptip of the fourth radiobutton
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the group changes state. Note that this flag should not be used in conjunction with onCommand and
          offCommand. That is, one should either use changeCommand and test the state of a radio button from inside the callback,
          or use onCommand and offCommand as separate callbacks.
    
      - changeCommand1 : cc1           (script)        [create,edit]
    
      - changeCommand2 : cc2           (script)        [create,edit]
    
      - changeCommand3 : cc3           (script)        [create,edit]
    
      - changeCommand4 : cc4           (script)        [create,edit]
          Specify a changed state command for each respective radio button.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - data1 : da1                    (int)           [create,query,edit]
    
      - data2 : da2                    (int)           [create,query,edit]
    
      - data3 : da3                    (int)           [create,query,edit]
    
      - data4 : da4                    (int)           [create,query,edit]
          Internal data associated with each radio button.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the group.  By default, this flag is set to true and the radio button values may be changed by
          clicking on them.  If false then the radio buttons are 'read only' and can not be clicked on. The value of the radio
          button can always be changed with the sl/selectflags regardless of the state of the ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enable1 : en1                  (bool)          [create,query,edit]
    
      - enable2 : en2                  (bool)          [create,query,edit]
    
      - enable3 : en3                  (bool)          [create,query,edit]
    
      - enable4 : en4                  (bool)          [create,query,edit]
          Enable state of the individual radio buttons.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          When present on creation an optional text label will be built with the group.  The string specifies the label text.
    
      - label1 : l1                    (unicode)       [create,query,edit]
    
      - label2 : l2                    (unicode)       [create,query,edit]
    
      - label3 : l3                    (unicode)       [create,query,edit]
    
      - label4 : l4                    (unicode)       [create,query,edit]
          Specify label strings for the respective radio buttons in the group.
    
      - labelAnnotation : la           (unicode)       [create,query,edit]
          when present on creation an optional text label will be built with the group . The string specifies the label tooltip
    
      - labelArray2 : la2              (unicode, unicode) [create,query,edit]
    
      - labelArray3 : la3              (unicode, unicode, unicode) [create,query,edit]
    
      - labelArray4 : la4              (unicode, unicode, unicode, unicode) [create,query,edit]
          Specify multiple labels in a single flag.  These flags are ignored if the number of radio buttons doesn't match.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - numberOfRadioButtons : nrb     (int)           [create]
          Number of radio buttons in the group (1 - 4).
    
      - offCommand : ofc               (script)        [create,edit]
          Command executed when any radio button turns off.
    
      - offCommand1 : of1              (script)        [create,edit]
    
      - offCommand2 : of2              (script)        [create,edit]
    
      - offCommand3 : of3              (script)        [create,edit]
    
      - offCommand4 : of4              (script)        [create,edit]
          Off command for each respective radio button.
    
      - onCommand : onc                (script)        [create,edit]
          Command executed when any radio button turns on.
    
      - onCommand1 : on1               (script)        [create,edit]
    
      - onCommand2 : on2               (script)        [create,edit]
    
      - onCommand3 : on3               (script)        [create,edit]
    
      - onCommand4 : on4               (script)        [create,edit]
          On command for each respective radio button.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - select : sl                    (int)           [create,query,edit]
          Selected radio button.  The argument is a 1 based integer.
    
      - shareCollection : scl          (unicode)       [create]
          Specify the radioButtonGrp that this radio group is to be associated with.  By default the radio group will be a
          separate collection.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - vertical : vr                  (bool)          [create,query]
          Whether the orientation of the radio buttons in this group are horizontal (default) or vertical.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.radioButtonGrp`
    """

    pass


def timeControl(*args, **kwargs):
    """
    This command creates a control that can be used for changing current time, displaying/editing keys, and
    displaying/scrubbing sound.Note: only one timeControl may be created.  The one Maya creates on startup can be accessed
    from the global string variable $gPlayBackSlider. Also, it is not a good idea to delete it.
    
    Flags:
      - animCurveNames : acn           (bool)          [create,query]
          When showKeysis not none, querying this flag will return the names of all the animCurves for which keyframe ticks are
          being displayed.  Query returns string[].
    
      - animLayerFilterOptions : alf   (unicode)       [create,query,edit]
          Specifies whether a filter is to be applied when displaying animation layers. If so, the options can be allAffecting(no
          filter), active(only the active layers on the object will be displayed) and animLayerEditor(the settings will be taken
          from the animation layer editor).
    
      - animLayerShowWeight : asw      (bool)          [create,query,edit]
          Specifies or queries whether weights are to be shown when displaying animation layers.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - beginScrub : bs                (bool)          [edit]
          Set this widget up for sound scrubbing. Subsequent changes to current time will result in sound scrubbingbehavior, until
          the -endScrubcommand is issued for this widget.
    
      - currentFrameColor : cfc        (float, float, float, float) [edit]
          This flag is used to specify the rgba color of the current frame overlay rectangle in the timeControl.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - displaySound : ds              (bool)          [query,edit]
          Turn sound display off.  Query returns int.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - endScrub : es                  (bool)          [edit]
          End sound scubbing for this widget.  This stops sound scrubbing behavior and should be issued before any subsequent
          -beginScrubflags
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - forceRedraw : fd               (bool)          [create,edit]
          Force a redraw of the time control UI. Similiar to forceRefresh but does not rebuild key information.
    
      - forceRefresh : fr              (bool)          [create,edit]
          Force a refresh of the time control UI.
    
      - foregroundColor : fgc          (float, float, float) [edit]
          This flag is used to specify the rgb color of the vertical lines and numeric text in the timeControl.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - globalTime : gt                (bool)          [create,query,edit]
          truemeans this widget controls and displays the global, dependency graph time.  falsemeans time changes here do NOT
          affect the dependency graph. Query returns int.
    
      - greasePencilSequenceNames : gn (bool)          [query]
          Returns the names of all grease pencil sequences that have frames being displayed in the time line.  Query returns
          string[].
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the time slider will use as its source of content.  The time
          slider will only display keys for items contained in the selectionConnection object.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - pressCommand : pc              (script)        [create,edit]
          script to run on mouse-down in this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - range : rng                    (bool)          [create,query]
          Returns string representing the currently highlighted range visible on the time slider.  A range from 10 to 20 would be
          returned as 10:20.  When there's no range visible on the time slider, the query returns a range spanning the current
          time: for example, 10:11.  These values are in the current time unit.
    
      - rangeArray : ra                (bool)          [create,query]
          Returns a float array representing the currently highlighted range visible on the time slider.  A range from 10 to 20
          would be returned as { 10.0, 20.0 }.  When there's no range visible on the time slider, the query returns values
          spanning the current time: { 10.0, 11.0 }.  These values are in the current time unit.
    
      - rangeVisible : rv              (bool)          [create,query]
          Returns true if a currently highlighted range is visible on the time slider, false if no.
    
      - releaseCommand : rc            (script)        [create,edit]
          script to run on mouse-up in this control.
    
      - repeatChunkSize : rcs          (float)         [query,edit]
          How much sound (in the current time unit) is repeated when -repeatOnHold is true.  Default is 1.0.
    
      - repeatOnHold : roh             (bool)          [query,edit]
          Repeat sound during mouse-down events
    
      - resample : r                   (bool)          [edit]
          Resample the sound display to fit the widget
    
      - showGreaseFrames : sg          (unicode)       [create,query,edit]
          activewill show grease frames for the active camera.  noneshows no grease frames.  allwill show all grease frames.
          Default active.  Query returns string.
    
      - showKeys : sk                  (unicode)       [create,query,edit]
          activewill show tick marks for keyframes on all active objects.  noneshows no tick marks.  Any other name is taken as
          the name of a channel box whose selected attributes will display tick marks.  Default active.  Query returns string.
    
      - showKeysCombined : skc         (bool)          [create,query,edit]
          This flag can be used in conjunction with the showKeys flag to enable a combination of active+ channel boxbehavior.
          Specifically, if channel box attributes are selected, tick marks will be shown for those attributes. If no channel box
          attributes are selected, tick marks will be shown for keyframes on all active objects.
    
      - snap : sn                      (bool)          [create,query,edit]
          truemeans this widget is constrained to having values that are integers representing the current time unit.. falsemeans
          the current time indicator is free floatingand not constrained.
    
      - sound : s                      (unicode)       [query,edit]
          Name of audio depend node whose data should display in the sound-display widget. Query returns string.
    
      - tickSize : ts                  (int)           [create,query,edit]
          Specifies the width of keyframe ticks drawn in the time slider. The value will be clamped to the range [1, 63].
    
      - tickSpan : tsp                 (int)           [create,query,edit]
          Specifies the interval between keyframe ticks in the timeControl. For example, a value of 10, will place ticks at 0, 10,
          20, etc.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - waveform : wf                  (unicode)       [query,edit]
          Determines what part of the sound waveform to display, when -displaySound is true. Valid values are top, bottom, and
          both.  Default is top. Query returns string.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.timeControl`
    """

    pass


def confirmDialog(*args, **kwargs):
    """
    The confirmDialog command creates a modal dialog with a message to the user and a variable number of buttons to dismiss
    the dialog.  The dialog is dismissed when the user presses any button or chooses the close item from the window menu.
    In the case where a button is pressed then the name of the button selected is returned.  If the dialog is dismissed via
    the close item then the string returned is specified by the dismissStringflag. The default behaviour when no arguments
    are specified is to create an empty single button dialog.
    
    Flags:
      - annotation : ann               (unicode)       [create]
          set the annotation for the buttons
    
      - backgroundColor : bgc          (float, float, float) [create]
          The background color of the dialog. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. (Windows only flag)
    
      - button : b                     (unicode)       [create]
          Create a button with the given string as it's text.
    
      - cancelButton : cb              (unicode)       [create]
          The cancel button is activated by pressing the escape key. Note that this flag does not create a button, it simply
          indicates which button created via the buttonflag shall respond to the escape key.
    
      - defaultButton : db             (unicode)       [create]
          The default button is activated by pressing the enter key. Note that this flag does not create a button, it simply
          indicates which button created via the buttonflag shall respond to the enter key.
    
      - dismissString : ds             (unicode)       [create]
          The string returned when the user selects the 'Close' item from the Window Manager menu.  If this flag is not set then
          the string dismissis returned.
    
      - icon : icn                     (unicode)       [create]
          The user can specify one of the four standard icons -- question, information, warningand critical.  The question icon
          indicates that the messsage is asking a question.  The information icon indicates that the message is nothing out of the
          ordinary.  The warning icon indicates that the message is a warning, but can be dealt with.  The critical icon indicates
          that the message represents a critical problem. When no icon flag is present, we assume the user does not want to
          include any icon in the confirm dialog.
    
      - message : m                    (unicode)       [create]
          The message text appearing in the dialog.
    
      - messageAlign : ma              (unicode)       [create]
          Align the message left, center, or right.
    
      - parent : p                     (unicode)       [create]
          Specify the parent window for the dialog.  The dialog will be centered on this window and raise and lower with it's
          parent. By default, the dialog is not parented to a particular window and is simply centered on the screen.
    
      - title : t                      (unicode)       [create]
          The dialog title.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.confirmDialog`
    """

    pass


def _createOtherCommands():
    pass


def thumbnailCaptureComponent(*args, **kwargs):
    """
    This command is used to generate a thumbnail/playblast sequence from the scene. In query mode, return type is based on
    queried flag.
    
    Flags:
      - capture : c                    (bool)          [create]
          Create a new component to capture a sequence of image for the current scene.
    
      - capturedFrameCount : cfc       (bool)          [query]
          Query only. Return the number of frames that have been captured.
    
      - closeCurrentSession : ccs      (bool)          [create]
          Delete the current thumbnail component (preview image will be destroyed).
    
      - delete : d                     (bool)          [create]
          Delete the generated image sequence and preview for the current capture session.
    
      - endFrame : ef                  (int)           [create,query]
          Set the end captured frame. Only valid when the -c/captureflag is set. If -sf/startFrameis set and not -ef/endFrame, or
          if endFrame is smaller than startFrame, endFrame will be automatically set to startFrame.
    
      - fileDialogCallback : fdc       (unicode)       [create]
          MEL only. Set the callback file dialog which is called after the capture component window has been closed. Only valid
          when the -c/captureflag is set.
    
      - fileDialogProcessing : fdp     (bool)          []
    
      - isSessionOpened : iso          (bool)          [query]
          Returns true if a thumbnail/playblast capture session is currently running (already opened and still not
          cancelled/saved).
    
      - launchedFromOptionsBox : lfo   (bool)          [query]
          Returns true if the thumbnail capture component was launched through the options dialog box, else false.
    
      - previewPath : pp               (bool)          [query]
          Returns the generated preview path (the first frame of generated sequence resized to 100x100 px).
    
      - removeProjectThumbnail : rpt   (unicode)       [create]
          Remove all captured thumbnail/playblast from the given project file path.
    
      - save : s                       (unicode)       [create]
          Save the generated image sequence for the given file to disk. The file path must be an absolute path.
    
      - selectedFileName : sfn         (bool)          []
    
      - startFrame : sf                (int)           [create,query]
          Set the start captured frame. Only valid when -c/captureflag is set.                  Flag can have multiple arguments,
          passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.thumbnailCaptureComponent`
    """

    pass


def floatSliderGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a pre-packaged collection of controls containing a label
    text, an float field and a float slider. The text and field controls are optional.  Editing or querying the field range
    values has no effect if the -f/fieldflag was not specified when the group was created. This group also allows you to
    enter values into the field outside of the slider range which is limited by the -min/minValueand -max/maxValueflags.  To
    do this, use the -fmn/fieldMinValueand -fmx/fieldMaxValueflags to specify a greater range of values. Note that the
    command will not allow you to specify a -fmn/fieldMinValuegreater than the -min/minValuevalue nor a
    -fmx/fieldMaxValueless than the -max/maxValuevalue. If you do supply a larger field range with the -fmn/fieldMinValueand
    -fmx/fieldMaxValueflags then you will notice that entering a value in the field that is outside of the slider range will
    result in extending the slider range as well.  For example, if you create a slider group with the following command:
    floatSliderGrp -min -10 -max 10 -fieldMinValue -100 -fieldMaxValue 100; Then you will be able to use the slider to
    select any value from -10 to 10. At the same time you will be able to enter into the field any value from -100 to 100.
    If you enter a value, say 20, then the new slider range will grow such that this value is now accessible through the
    slider as well.  In fact, the new slider limit will become double of that what you entered.  Note that the slider limits
    will never grow beyond the field limits, in other words if you entered the value 80 then the slider will be clipped to
    the field limit of 100 and not doubled to 160.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command string executed when the value of the slider changes.  It will be executed only once after a drag of the slider.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command string executed repeatedly during a drag of the slider.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraLabel : el                (unicode)       [create,query,edit]
          If present on creation this specifies that there will be an extra label appearing after the slider.  Sets the string to
          be the text for the extra label.
    
      - field : f                      (bool)          [create]
          Indicates whether the group will have an editable float field present that reflects the value of the slider.
    
      - fieldMaxValue : fmx            (float)         [create,query,edit]
          Maximum value that may be entered in the field.  This value may be set to any value greater than the -max/maxValueflag.
          By default, it is equal to the -max/maxValueflag.
    
      - fieldMinValue : fmn            (float)         [create,query,edit]
          Minimum value that may be entered in the field.  This value may be set to any value less than the -min/minValueflag.  By
          default, it is equal to the -min/minValueflag.
    
      - fieldStep : fs                 (float)         [create,query,edit]
          Increment for the field.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          If present on creation the group will have static text.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (float)         [create,query,edit]
          Maximum value for both the slider and the field.
    
      - minValue : min                 (float)         [create,query,edit]
          Minimum value for both the slider and the field.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [create,edit]
          Number of digits to the right of the decimal.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - sliderStep : ss                (float)         [create,query,edit]
          The slider step value represents the amount the value will increase or decrease when you click either side of the
          slider.
    
      - step : s                       (float)         [create,query,edit]
          Increment for both the slider and field.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (float)         [create,query,edit]
          Value of the group.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.floatSliderGrp`
    """

    pass


def intField(*args, **kwargs):
    """
    Create a field control that accepts only integer values and is bound by a minimum and maximum value.  An invisible
    slider is attached to the field and accessed by holding down the Ctrl modifier key while pressing one of the mouse
    buttons.  Dragging the invisible slider to the right with the middle mouse button increases the field value by the
    amount specified with the -s/stepflag, while dragging to the left decreases the value by the same amount.  The left and
    right mouse buttons apply a factor of 0.1 and 10 to the step value.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the value changes.  This command is not invoked when the value changes via the -v/valueflag.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command executed when the value changes by dragging the invisible slider.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the field.  By default, this flag is set to true and the field value may be changed by typing into it.
          If false then the field is 'read only' and can not be typed into. The value of the field can always be changed with the
          -v/valueflag regardless of the state of the -ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enterCommand : ec              (script)        [create,edit]
          Command executed when the keypad 'Enter' key is pressed.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (int)           [create,query,edit]
          Upper limit of the field.
    
      - minValue : min                 (int)           [create,query,edit]
          Lower limit of the field.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - receiveFocusCommand : rfc      (script)        [create,edit]
          Command executed when the field receives focus.
    
      - step : s                       (int)           [create,query,edit]
          Increment for the invisible slider.  The field value will change by this amount when the invisible slider is dragged.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (int)           [create,query,edit]
          Value of the field.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.intField`
    """

    pass


def intFieldGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a pre-packaged collection of label text and editable integer
    fields. The label text is optional and one to four fields can be created.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command string executed when the value of any of the fields changes.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command string executed when dragging the invisible slider in any of the fields.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enable1 : en1                  (bool)          [create,query,edit]
    
      - enable2 : en2                  (bool)          [create,query,edit]
    
      - enable3 : en3                  (bool)          [create,query,edit]
    
      - enable4 : en4                  (bool)          [create,query,edit]
          Enable state for the respective field.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraLabel : el                (unicode)       [create,query,edit]
          If present on creation this specifies that there will be an extra label in the group.  Sets the string to be label text
          to the right of fields.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          If present on creation this specifies that there will be a label to the left of the fields.  Sets the string to be the
          label text.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfFields : nf            (int)           [create]
          Set the number of fields on creation.  One to four fields are available.  The default is one field.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (int, int, int, int) [create,query,edit]
          Values for all fields.
    
      - value1 : v1                    (int)           [create,query,edit]
    
      - value2 : v2                    (int)           [create,query,edit]
    
      - value3 : v3                    (int)           [create,query,edit]
    
      - value4 : v4                    (int)           [create,query,edit]
          Value for the respective field.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.intFieldGrp`
    """

    pass


def viewManip(*args, **kwargs):
    """
    Mel access to the view cube manipulator.                 In query mode, return type is based on queried flag.
    
    Flags:
      - bottomLeft : bl                (bool)          [create,query]
          Positions the cube in the bottom left of the screen.
    
      - bottomRight : br               (bool)          [create,query]
          Positions the cube in the bottom right of the screen.
    
      - compassAngle : ca              (float)         [create,query]
          Angle (in degrees) to rotate the compass.
    
      - dragSnap : ds                  (bool)          [create,query]
          Enable snapping of orbit direction to view cube part directions during drag operation.
    
      - drawCompass : dc               (bool)          [create,query]
          Show compass below the view cube.
    
      - fitToView : ftv                (bool)          [create]
          Fits the scene bounding box to the active view.
    
      - frontParameters : fp           (unicode)       []
    
      - goDefault : gd                 (bool)          []
    
      - goHome : gh                    (bool)          []
    
      - homeParameters : hp            (unicode)       []
    
      - levelCamera : lc               (bool)          [create]
          Flattens the camera view rotation relative to the ground plane.
    
      - minOpacity : mo                (float)         [create,query]
          Opacity level (in range [0,1]) on view cube when the cursor is away from it (it is fully opaque when the cursor is in
          the view cube area).
    
      - namespace : ns                 (unicode)       []
    
      - postCommand : p                (unicode)       []
    
      - preCommand : pr                (unicode)       []
    
      - preserveSceneUp : psu          (bool)          []
    
      - resetFront : rf                (bool)          []
    
      - resetHome : rh                 (bool)          []
    
      - restoreCenter : rc             (bool)          [create]
          Repositions the pivot point for orbiting/tumbling the scene to the center of the scene's bounding box.
    
      - selectionLockParameters : slp  (unicode)       []
    
      - setFront : sf                  (bool)          []
    
      - setHome : sh                   (bool)          []
    
      - size : s                       (unicode)       [create,query]
          Set or query the size of the View Cube, which can be one of tiny, small, normal, largeor auto. When set to autothe View
          Cube will be automatically set to the size most appropriate for the view.
    
      - toggleSelectionLock : tsl      (bool)          []
    
      - topLeft : tl                   (bool)          [create,query]
          Positions the cube in the top left of the screen.
    
      - topRight : tr                  (bool)          [create,query]
          Positions the cube in the top right of the screen.
    
      - visible : v                    (bool)          [create,query]
          Shows/hides the view manip.
    
      - zoomToFitScene : zf            (bool)          [create,query]
          Zoom the camera during animated transitions to fit the scene object in the viewport.                  Flag can have
          multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.viewManip`
    """

    pass


def loadPrefObjects(*args, **kwargs):
    """
    This command loads preference dependency nodes from userPrefObjects.ma, if it exists, from the user preference
    directory.
    
    
    Derived from mel command `maya.cmds.loadPrefObjects`
    """

    pass


def _lsUI(**kwargs):
    pass


def hotkeyCheck(*args, **kwargs):
    """
    This command checks if the given hotkey is mapped to a nameCommand object.  If so, the annotation of the nameCommand
    object is returned. Otherwise an empty string is returned.
    
    Flags:
      - altModifier : alt              (bool)          [create]
          Specifies if the Alt key is pressed.
    
      - commandModifier : cmd          (bool)          [create]
          Specifies if the command key is pressed.
    
      - ctrlModifier : ctl             (bool)          [create]
          Specifies if the Ctrl key is pressed.
    
      - isRepeatable : ir              (bool)          []
    
      - keyString : k                  (unicode)       [create]
          The key to check.
    
      - keyUp : kup                    (bool)          [create]
          Specifies if the hotkey is on keyup or keydown (i.e. Release or Press).
    
      - optionModifier : opt           (bool)          [create]
          Specifies if the option key is pressed.                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
      - toBeRemovedInFutureMayaRelease : key (unicode)       []
    
    
    Derived from mel command `maya.cmds.hotkeyCheck`
    """

    pass


def hardwareRenderPanel(*args, **kwargs):
    """
    This command creates, edit and queries hardware render panels which contain only a hardware render editor.
    
    Flags:
      - camera : cam                   (unicode)       [query,edit]
          Query or edit the camera in a gl render panel.
    
      - control : ctl                  (bool)          [query]
          Returns the top level control for this panel. Usually used for getting a parent to attach popup menus. CAUTION: panels
          may not have controls at times.  This flag can return if no control is present.
    
      - copy : cp                      (unicode)       [edit]
          Makes this panel a copy of the specified panel.  Both panels must be of the same type.
    
      - createString : cs              (bool)          [edit]
          Command string used to create a panel
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the Maya panel.
    
      - editString : es                (bool)          [edit]
          Command string used to edit a panel
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - glRenderEditor : gre           (bool)          [query]
          Query only. This flag returns the name of the gl render editor contained in the panel.
    
      - init : init                    (bool)          [create,edit]
          Initializes the panel's default state.  This is usually done automatically on file -new and file -open.
    
      - isUnique : iu                  (bool)          [query]
          Returns true if only one instance of this panel type is allowed.
    
      - label : l                      (unicode)       [query,edit]
          Specifies the user readable label for the panel.
    
      - menuBarVisible : mbv           (bool)          [create,query,edit]
          Controls whether the menu bar for the panel is displayed.
    
      - needsInit : ni                 (bool)          [query,edit]
          (Internal) On Edit will mark the panel as requiring initialization. Query will return whether the panel is marked for
          initialization.  Used during file -new and file -open.
    
      - parent : p                     (unicode)       [create]
          Specifies the parent layout for this panel.
    
      - popupMenuProcedure : pmp       (script)        [query,edit]
          Specifies the procedure called for building the panel's popup menu(s). The default value is buildPanelPopupMenu.  The
          procedure should take one string argument which is the panel's name.
    
      - replacePanel : rp              (unicode)       [edit]
          Will replace the specified panel with this panel.  If the target panel is within the same layout it will perform a swap.
    
      - tearOff : to                   (bool)          [query,edit]
          Will tear off this panel into a separate window with a paneLayout as the parent of the panel. When queried this flag
          will return if the panel has been torn off into its own window.
    
      - tearOffCopy : toc              (unicode)       [create]
          Will create this panel as a torn of copy of the specified source panel.
    
      - unParent : up                  (bool)          [edit]
          Specifies that the panel should be removed from its layout. This (obviously) cannot be used with query.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hardwareRenderPanel`
    """

    pass


def disable(*args, **kwargs):
    """
    This command enables or disables the control passed as argument.
    
    Flags:
      - value : v                      (bool)          [create]
          If true, this command disables the control. If false, this command enables the control. Default value is true (disable)
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.disable`
    """

    pass


def commandLine(*args, **kwargs):
    """
    This command creates a single line for command input/output.The left half is for input, the right half for output.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - command : c                    (script)        [create,edit]
          Command executed when the command line text changes.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - enterCommand : ec              (script)        [create,edit]
          Command executed when the keypad 'Enter' key is pressed.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - holdFocus : hf                 (int)           [create,query,edit]
          Sets whether the command line should hold focus after exectuing a command.
    
      - inputAnnotation : ian          (unicode)       [create,query,edit]
          Annotate the input field with an extra string value.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfHistoryLines : nhl     (int)           [create,query,edit]
          Sets the maximum number of commands saved to the command line history. Up to -nhl/numberOfHistoryLines previous commands
          will be available by pressing the up-arrow from within the input field. The default value is 50.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - outputAnnotation : oan         (unicode)       [create,query,edit]
          Annotate the output field with an extra string value.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - sourceType : st                (unicode)       [create,query,edit]
          Sets the source type of this command line. Currently supports mel(enabled by default) and python.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.commandLine`
    """

    pass


def animCurveEditor(*args, **kwargs):
    """
    Edit a characteristic of a graph editor
    
    Flags:
      - acs : acs                      (areCurvesSelected) []
    
      - areCurvesSelected : acs        (bool)          [query]
          Returns a boolean to know if at least one curve is selected in the graph editor.
    
      - autoFit : af                   (unicode)       [query,edit]
          on | off | tgl Auto fit-to-view.
    
      - classicMode : cm               (bool)          [query,edit]
          When on, the graph editor is displayed in Classic Mode, otherwise Suites Modeis used.
    
      - clipTime : ct                  (unicode)       [query,edit]
          Valid values: onoffDisplay the clips with their offset and scale applied to the anim curves in the clip.
    
      - constrainDrag : cd             (int)           [create,query,edit]
          Constrains all Graph Editor animation curve drag operations to either the X-axis, the Y-axis, or to neither of those
          axes. Values to supply are: 0 for not constraining any axis, 1 for constraing the X-axis, or 2 for constraining the
          Y-axis. When used in queries, this flag returns the latter values and these values have the same interpretation as
          above. Note: when the shift key is pressed before dragging the animation curve, the first mouse movement will instead
          determine (and override) any prior set constrained axis.
    
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - curvesShown : cs               (bool)          [query]
          Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor.
    
      - curvesShownForceUpdate : csf   (bool)          [query]
          Returns a string array containing the names of the animCurve nodes currently displayed in the graph editor. Unlike the
          curvesShown flag, this will force an update of the graph editor for the case where the mainListConnection has been
          modified since the last refresh.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - denormalizeCurvesCommand : dcc (unicode)       [create,edit]
          Sets the script that is run to denormalize curves in the graph editor. This is intended for internal use only.
    
      - displayActiveKeyTangents : dat (unicode)       [edit]
          on | off | tgl Display active key tangents in the editor.
    
      - displayActiveKeys : dak        (unicode)       [edit]
          on | off | tgl Display active keys in the editor.
    
      - displayInfinities : di         (unicode)       [edit]
          on | off | tgl Display infinities in the editor.
    
      - displayKeys : dk               (unicode)       [edit]
          on | off | tgl Display keyframes in the editor.
    
      - displayNormalized : dn         (bool)          [query,edit]
          When on, display all curves normalized to the range -1 to +1.
    
      - displayTangents : dtn          (unicode)       [edit]
          on | off | tgl Display tangents in the editor.
    
      - displayValues : dv             (unicode)       [edit]
          on | off | tgl Display active keys and tangents values in the editor.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - keyingTime : kt                (unicode)       [query]
          The current time in the given curve to be keyed in the graph editor.
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - lookAt : la                    (unicode)       [edit]
          all | selected | currentTime FitView helpers.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - menu : m                       (script)        [create]
          Specify a script to be run when the editor is created.  The function will be passed one string argument which is the new
          editor's name.
    
      - normalizeCurvesCommand : ncc   (unicode)       [create,edit]
          Sets the script that is run to normalize curves in the graph editor. This is intended for internal use only.
    
      - outliner : o                   (unicode)       [query,edit]
          The name of the outliner that is associated with the graph editor.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - preSelectionHighlight : psh    (bool)          [query,edit]
          When on, the curve/key/tangent under the mouse pointer is highlighted to ease selection.
    
      - renormalizeCurves : rnc        (bool)          [edit]
          This flag causes the curve normalization factors to be recalculated.
    
      - resultSamples : rs             (time)          [query,edit]
          Specify the sampling for result curves Note: the smaller this number is, the longer it will take to update the display.
    
      - resultScreenSamples : rss      (int)           [query,edit]
          Specify the screen base result sampling for result curves. If 0, then results are sampled in time.
    
      - resultUpdate : ru              (unicode)       [query,edit]
          Valid values: interactivedelayedControls how changes to animCurves are reflected in the result curves (if results are
          being shown).  If resultUpdate is interactive, then as interactive changes are being made to the animCurve, the result
          curves will be updated.  If modelUpdate is delayed (which is the default setting), then result curves are updated once
          the final change to an animCurve has been made.
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - showActiveCurveNames : acn     (bool)          [query,edit]
          Display the active curve(s)'s name.
    
      - showBufferCurves : sb          (unicode)       [query,edit]
          Valid values: onofftglDisplay buffer curves.
    
      - showCurveNames : scn           (bool)          [query,edit]
          Display the curves's name.
    
      - showResults : sr               (unicode)       [query,edit]
          Valid values: onofftglDisplay result curves from expression or other non-keyed action.
    
      - showUpstreamCurves : suc       (bool)          [query,edit]
          If true, the dependency graph is searched upstream for all curves that drive the selected plugs (showing multiple curves
          for example in a typical driven key setup, where first the driven key curve is encountered, followed by the actual
          animation curve that drives the source object). If false, only the first curves encountered will be shown. Note that,
          even if false, multiple curves can be shown if e.g. a blendWeighted node is being used to combine multiple curves.
    
      - smoothness : s                 (unicode)       [query,edit]
          Valid values: coarseroughmediumfineSpecify the display smoothness of animation curves.
    
      - snapTime : st                  (unicode)       [query,edit]
          none | integer | keyframe Keyframe move snap in time.
    
      - snapValue : sv                 (unicode)       [query,edit]
          none | integer | keyframe Keyframe move snap in values.
    
      - stackedCurves : sc             (bool)          [query,edit]
          Switches the display mode between normal (all curves sharing one set of axes) to stacked (each curve on its own value
          axis, stacked vertically).
    
      - stackedCurvesMax : scx         (float)         [query,edit]
          Sets the maximum value on the per-curve value axis when in stacked mode.
    
      - stackedCurvesMin : scm         (float)         [query,edit]
          Sets the minimum value on the per-curve value axis when in stacked mode.
    
      - stackedCurvesSpace : scs       (float)         [query,edit]
          Sets the spacing between curves when in stacked mode.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - valueLinesToggle : vlt         (unicode)       [edit]
          on | off | tgl Display the value lines for high/low/zero of selected curves in the editor                  Flag can have
          multiple arguments, passed either as a tuple or a list.
    
      - viewLeft : vl                  (float)         []
    
      - viewRight : vr                 (float)         []
    
    
    Derived from mel command `maya.cmds.animCurveEditor`
    """

    pass


def symbolButton(*args, **kwargs):
    """
    This command creates a symbol button.  A symbol button behaves like a regular button, the only difference is a symbol
    button displays an image rather that a text label.  A command may be attached to the button which will be executed when
    the button is pressed.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - command : c                    (script)        [create,query,edit]
          Command executed when the symbol button is pressed.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          Image for the button.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.symbolButton`
    """

    pass


def gradientControlNoAttr(*args, **kwargs):
    """
    This command creates a control for editing a ramp (2D control curve). The control attaches to an optionVar used to store
    and retrieve the encoded gradient control points stored in a string.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - asString : asString            (unicode)       [query,edit]
          Used to query and set the value of the ramp as a string of comma separated values
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [edit]
          Specifies a command to be executed whenever the value of this ramp is modified. This option should not be used when
          specifying an optionVar.
    
      - currentKey : ck                (int)           [create,query,edit]
          Returns the index of the currently selected key.
    
      - currentKeyChanged : ckc        (script)        [edit]
          Specifies a command to be executed whenever the selected key changes.
    
      - currentKeyColorValue : clv     (float, float, float) [query,edit]
          Get or set the color of the currently selected key. Only useful if the ramp is set to be a color ramp.
    
      - currentKeyCurveValue : cvv     (bool)          [query,edit]
          Get or set the value of the currently selected key. Only useful if the ramp is set to be a curve ramp.
    
      - currentKeyInterpValue : civ    (int)           [query,edit]
          Get or set the interpolation value for the current key.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [edit]
          Specifies a command to be executed while the ramp is being modified.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - optionVar : ov                 (unicode)       [create,query,edit]
          Specifies the name of the option var used to store and retrieve the string value capturing the curve.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rampAsColor : rac              (bool)          [create,query,edit]
          Sets whether the ramp should be viewed as a colour ramp or as a curve.  Default is as a curve.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - valueAtPoint : vap             (float)         [query]
          Used during query to specify the point at which to query the curve.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.gradientControlNoAttr`
    """

    pass


def attributeMenu(*args, **kwargs):
    """
    Action to generate popup connection menus for Hypershade. This command is used internally by the Hypershade panel.
    
    Flags:
      - beginMenu : beg                (bool)          [create]
          If true the menu will be used to start a connection edit so it will list all available attributes for either inputs or
          outputs.  If false the menu will be used to complete a connection so it will list only the attributes compatible with
          the attribute at the other end of the connection.  A plug must be supplied in this case.
    
      - editor : edt                   (unicode)       [create]
          Name of the Hypergraph, Hypershade or Visor editor for which this menu is being built.  This argument is no longer
          mandatory. If it is omitted, the inputs flag and the node must be used to specify the search targets. This allows
          attributeMenu to be used in the absence of a hypershade editor.
    
      - finishMenu : fsh               (bool)          [create]
          finishes the menu
    
      - inputs : inp                   (bool)          [create]
          If true only attributes which can be used as inputs will be listed.  If false only attributes which can be used as
          outputs will be listed
    
      - plug : p                       (PyNode)        [create]
          If inputs is false then we are completing a connection and the name of the plug at the other end of the connection must
          be supplied.
    
      - regPulldownMenuCommand : rpm   (unicode)       [create]
          This flag will register a callback that allows the user to define their own popup menu for a specific node type for use
          in the Hypershade and Hypergraph editor. The command signature should look like this: global proc int proc_name(string
          $editorName, string $nodeName, string $plug, string $mode, string $menuType) The method should return 0 if it does not
          recognize the node type and the default attributeMenu popup menu will be displayed. If the callback returns one then the
          menu is considered built and no other menuItems will be added to the popup. The return value from this flag will be the
          ID to use for the -unregPulldownMenuCommand flag.
    
      - unregPulldownMenuCommand : upm (int)           [create]
          This flag will unregister a callback procedure that was registered with the -regPulldownMenuCommand flag. The argument
          should be the integer identifier returned from the -regPulldownMenuCommand flag.                                    Flag
          can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.attributeMenu`
    """

    pass


def timePort(*args, **kwargs):
    """
    This command creates a simple time control widget. See also the timeControlcommand.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - globalTime : gt                (bool)          [create,query,edit]
          truemeans this widget controls and displays the global, dependency graph time.  falsemeans time changes here do NOT
          affect the dependency graph. Query returns int.
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - snap : sn                      (bool)          [create,query,edit]
          truemeans this widget is constrained to having values that are integers representing the current time unit.. falsemeans
          the current time indicator is free floatingand not constrained.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.timePort`
    """

    pass


def attrNavigationControlGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a pre-packaged label navigation button. The group is used to
    help the user manage connections to a particular attribute. When creating the control you have the opportunity to attach
    scripts to the control that are executed on various UI events.  You can define what happens when the navigation button
    is pressed, and when a node is dragged and dropped onto this attribute. The navigation button can traverse to the
    connected node or can bring up UI to create new connections to the attribute. The button also can show you state
    information: if there already exists a connection/if the connection is ignored.
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attrNavDecision : attrNavDecision (PyNode, <type 'unicode'>) [create,query,edit]
          The first argument is the name of an attribute. The button will be attached to the attribute so the button can be kept
          in synch with the attribute.  The second argument is the navigatorDecisionString that can guide the behaviour that the
          navigator implements.
    
      - attribute : at                 (PyNode)        [create,query,edit]
          The name of an attribute. The button will be attached to the attribute so the button can be kept in synch with the
          attribute.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - connectAttrToDropped : cad     (script)        [create,query,edit]
          The script to execute when a node is dragged and dropped onto an attribute (multilister dnd attribute editor). Your
          script should take in two arguments: the source node and destination attribute respectively.
    
      - connectNodeToDropped : cnd     (script)        [create,query,edit]
          The script to execute when a node is dragged and dropped onto a node (the multilister issues this).  Your script should
          take in two arguments: the source node and destination node respectively.
    
      - connectToExisting : ce         (script)        [create,query,edit]
          The script to execute when a connection should be made to an existing node.
    
      - createNew : cn                 (script)        [create,query,edit]
          The script to execute when a new connectionis requested.
    
      - defaultTraversal : dtv         (script)        [create,query,edit]
          The script to execute to find out the name of the default traversal node.  The script you attach should be able to take
          in one argument (the attribute) and return the name of the node that is the default traversal node.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - delete : delete                (script)        [create,query,edit]
          The script to execute when the connection (and the node connected to) should be deleted.
    
      - disconnect : d                 (script)        [create,query,edit]
          The script to execute when a disconnectionis requested.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraButton : eb               (bool)          [create]
          Add an extra icon button to the last of this control.
    
      - extraButtonCommand : ebc       (script)        [create,edit]
          The command string is executed when the extra button is clicked.
    
      - extraButtonIcon : ebi          (unicode)       [create,query,edit]
          The icon file name of the extra button.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - ignore : i                     (script)        [create,query,edit]
          The script to execute when the connection should be ignored.
    
      - ignoreNotSupported : ins       (bool)          []
          Obsolete flag; has no effect.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          Text for the control.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - noIgnorableMenu : nim          (bool)          [create,edit]
          Not show ignorable related popup menu when right click the label.
    
      - noKeyableMenu : nkm            (bool)          [create,edit]
          Not show keyable related popup menu when right click the label.
    
      - notIgnorableMenu : nim         (bool)          []
    
      - notKeyableMenu : nkm           (bool)          []
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - relatedNodes : ren             (script)        [create,query,edit]
          The script to execute to find out what the related nodes are.  The script you attach should be able to take in one
          argument (the attribute) and return a list of strings that are the name of the nodes that are related.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - unignore : u                   (script)        [create,query,edit]
          The script to execute when the connection should be unignored.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.attrNavigationControlGrp`
    """

    pass


def falloffCurveAttr(*args, **kwargs):
    """
    This command creates a control for editing a 2D control curve. This control attaches to a curve attribute, which must be
    a multi attribute where each entry is a compound composed of: A single float for control point positionA single float
    for control point valueThe MEL command AEaddCurveControl should be used to attach this control to an attribute in the
    attribute editor templates.
    
    Flags:
      - addControlVertex : acv         (unicode)       [edit]
          Used to add a control vertex for the curve.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - asString : asString            (unicode)       [query,edit]
          Used to query and set the value of the curve as a string of comma separated values
    
      - attribute : at                 (PyNode)        [create]
          Specifies the name of the curve attribute to control.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [edit]
          Specifies a command to be executed whenever the value of this curve is modified.
    
      - currentKey : ck                (int)           [create,query,edit]
          Returns the index of the currently selected key.
    
      - currentKeyValue : ckv          (float, float)  [query,edit]
          Get or set the value of the currently selected key.
    
      - customCurveWidget : ccw        (bool)          [create,query,edit]
          Determines whether or not the curve widget is using a custom curve. When a custom curve is used, it is stored by a
          falloff curve in the brush tool settings, and the flag should be true.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteControlVertex : dcv      (int)           [edit]
          Used to delete a control vertex of the curve.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - readOnly : ro                  (bool)          [create,query,edit]
          Specifies if the curve is read only or not. If true, the curve can't be edited.
    
      - selectedPositionControl : spc  (unicode)       [create,edit]
          Specifies the name of a float slider to edit the selected key position.
    
      - selectedValueControl : svc     (unicode)       [create,edit]
          Specifies the name of a float slider to edit the selected key value.
    
      - snapToGrid : stg               (bool)          [create,query,edit]
          Specifies whether or not curve control points snap to grid when they are being moved.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.falloffCurveAttr`
    """

    pass


def uiTemplate(name='None', force='False', exists='None'):
    """
    This command creates a new command template object. Template objects can hold default flag arguments for multiple UI
    commands. The command arguments are specified with the individual commands using the -defineTemplate flag and the
    desired flags and arguments.  See also setUITemplate.
    
    Flags:
      - defineTemplate : dt            (unicode)       []
    
      - exists : ex                    (bool)          [create]
          Returns true|false depending upon whether the specified uiTemplate exists.  Other flags are ignored.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
      - useTemplate : ut               (unicode)       []
    
    
    Derived from mel command `maya.cmds.uiTemplate`
    """

    pass


def scmh(*args, **kwargs):
    """
    Set the current manipulator handle value(s).  In UI units (where applicable), though the syntax is set to handle the
    unit type of the current manipulator handle (if available).
    
    Flags:
      - absolute : a                   (bool)          [create]
          The values are absolute
    
      - ignore : i                     (int)           [create]
          This is a multiuse flag which specifies that the index-th (1-based) entry is to be ignored
    
      - quiet : q                      (bool)          [create]
          This flag suppresses all error messages
    
      - relative : r                   (bool)          [create]
          The values are relative                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.scmh`
    """

    pass


def setNodeTypeFlag(*args, **kwargs):
    """
    This command sets static data on the specified node type. This will affect the class of node type as a whole.  The
    argument passed may be the name of the node type or the node type tag.  Node type tags may be found using the objectType
    command.
    
    Flags:
      - display : dsp                  (bool)          [create]
          Sets whether the node type will appear in the UI or not.  Setting display to false will cause the node type to not
          appear in the UI.
    
      - threadSafe : ts                (bool)          [create,query]
          Sets whether the node type will evaluate in parallel when using the parallel DG evaluation option in Viewport 2.0. In
          query mode returns true if the node type will evaluate in parallel when using the parallel DG evaluation option in
          Viewport 2.0.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.setNodeTypeFlag`
    """

    pass


def hudSlider(*args, **kwargs):
    """
    This command creates a Heads-up Display (HUD) slider control which is placed in a 2D inactive overlay plane on the 3D
    viewport. It is to be used to provide hands-on interaction designated by a user script. The HUD slider is derived from a
    generic HUD object and thus inherits a similar workflow. Although this command provides much of the same functionality
    as the headsUpDisplay command, it does not provide headsUpDisplay layout controls such as layoutVisibility,
    nextFreeBlock, lastOccupiedBlock, exists, remove, etc. To access that functionality, please use the headsUpDisplay
    command. This command is focused solely around the creation and management of HUD sliders. Similarly, all operations
    performed by this command are limited to HUDs that are sliders. The only mandatory flags, on creation are the section
    and block flags. Like the headsUpDisplay command, upon creation of a HUD slider, an ID number will be assigned to it.
    This can be used to remove the HUD slider via the headsUpDisplay command (-rid/removeID [int IDNumber]), if desired.
    Alternatively, the headsUpDisplay command can remove HUD objects via their position (section and block), or their unique
    name.
    
    Flags:
      - allowOverlap : ao              (bool)          [create,query,edit]
          Sets the Heads-Up Display to be visible regardless of overlapping section widths/limitations (see -s/section flag
          description for more details).
    
      - block : b                      (int)           [create,query,edit]
          Denotes the individual block that the HUD will reside in, within a section. Each section is composed of a single column
          of blocks. The total number of blocks contained within each section is variable. The number of blocks that will be
          visible within each section is dependent on the size of blocks contained in each section and the current size of the
          window. Blocks begin enumerating from 0 and flexibly increase based on need. For HUD sliders, the format differs from
          that of the standard HUD. The layout using parameters defined by the formatting flags listed below (eg. justify,
          padding, labelWidth, valueWidth) is shown below: __________________________________________________________________ |
          |     |        |            |      |             |     |     | |  P  |  J  |   LW   |   Slider   |  IP  | SliderValue |
          J  |  P  | |_____|_____|________|____________|______|_____________|_____|_____| P = Sub-block of width, padding J =
          Justification of the entire block LW = Sub-block of width, labelWidth Slider = Length of the slider SliderValue = Sub-
          block of width, valueWidth IP = Internal padding Block PositioningBlocks on the top section begin from the top edge of
          the main viewport, while the bottom section begins from the bottom edge. Blocks are dynamically removed from visibility
          from the midpoint of the viewport. So, a relatively large block number will not draw to the viewport. Lastly, there can
          be at most one HUD occupying a block at any time. Trying to position a HUD in an occupied block will result in an error.
          Keep this in mind when positioning the HUD.
    
      - blockAlignment : ba            (unicode)       [create,query,edit]
          Specifies the alignment of the block within its respective column. Available alignments are: center, leftand right. The
          default alignment is left.
    
      - blockSize : bs                 (unicode)       [create,query,edit]
          Sets the height of each block. Available heights are: small, medium and large. In pixel measurements, each corresponds
          to a 20, 35 or 50 pixel height, respectively.
    
      - decimalPrecision : dp          (int)           [create,query,edit]
          Sets the decimal precision of any floating point value returned by the command. The valid range of precision values are
          1 to 8.
    
      - dragCommand : dc               (script)        [create,query,edit]
          Specifies the procedure or script to run during a mouse drag event.
    
      - internalPadding : ip           (int)           [create,query,edit]
          Specifies the amount of padding between the internal elements of the HUD. For the hudSlider, this represents the padding
          between the slider bar and the slider value. The default padding is 10.
    
      - label : l                      (unicode)       [create,query,edit]
          Text label of the HUD.
    
      - labelFontSize : lfs            (unicode)       [create,query,edit]
          Sets the font size of the label. Available sizes are: small and large.
    
      - labelWidth : lw                (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold the label. The contents of this textboxwill be left
          justified. If the width of the actual label exceeds the width of the textbox,the label will be truncated to fit within
          the dimensions of the textbox.(To see a layout of a block, see the description of the -block flag.)
    
      - maxValue : max                 (float)         [create,query,edit]
          Specify the maximum value of the slider. Note:Although this flag takes in a FLOAT as an argument, if the HUD type is
          int, the value will be automatically converted internally to an integer.
    
      - minValue : min                 (float)         [create,query,edit]
          Specify the minimum value of the slider. Note:Although this flag takes in a FLOAT as an argument, if the HUD type is
          int, the value will be automatically converted internally to an integer.
    
      - padding : p                    (int)           [create,query,edit]
          Specifies the width of both the left and right margins of a block. Default value is 15 pixels.
    
      - pressCommand : pc              (script)        [create,query,edit]
          Specifies the procedure or script to run during a mouse click event.
    
      - releaseCommand : rc            (script)        [create,query,edit]
          Specifies the procedure or script to run during a mouse release event.
    
      - section : s                    (int)           [create,query,edit]
          Defines the section the HUD will appear in. There are 10 sections divided across the screen. Five columns and two rows
          make up the ten element matrix which divide the main viewport. Here is a visual layout of the sections.
          ________________________ |    |    |    |    |    | |    |    |    |    |    | | 0  | 1  | 2  | 3  | 4  | |    |    |
          |    |    | |____|____|____|____|____| |    |    |    |    |    | |    |    |    |    |    | | 5  | 6  | 7  | 8  | 9  |
          |    |    |    |    |    | |____|____|____|____|____|Each section is denoted by a number from 0 to 9 as illustrated
          above. For example, if the second column of the top row was desired, the section would be defined as: -sec 1 To prevent
          HUD objects from displaying over each other and causing a clutter of letters, each row has a defined visibility
          precedence, where each section would have a visibility priority level. Depending on each priority level, when the screen
          space begins to shrink to a point where the section widths of a given row begin to collide, the HUD automatically
          compensates for this by removing the sections of least priority. These sections are made invisible and a warning is
          issued to inform the user of the removal. This continues until only the section of highest priority remains. For each
          row, the priorities are defined as follows. Using the top row as an example: Section 0, has the highest priority,
          followed by Section 4, making the outermost sections of highest priority. Next in the list is Section 2, and lastly
          Sections 1 and 3 are of the equal and least priority. This priority structure can be applied to the bottom row as well.
          The two outermost sections have the highest priority, followed by the middle section, and finally the remaining two
          sections are of lowest priority. This means that as the viewport gradually decreases in width to the point where
          sections in the top row begin to overlap, sections 1 and 3 will be removed from view first, followed by section 2, and
          finally section 4. A similar note is provided below for the block layout.
    
      - sliderIncrement : si           (float)         [create,query,edit]
          Specify the number of increments along the slider. If not specified or set to 0 or less, the slider will be linearly
          even and continuous from minValue to maxValue. Note:Although this flag takes in a FLOAT as an argument, if the HUD type
          is int, the value will be automatically converted internally to an integer.
    
      - sliderLength : sl              (int)           [create,query,edit]
          Specifies the length of the slider in pixels.
    
      - type : t                       (unicode)       [create,query,edit]
          Specify the numeric type of the HUD. Available types are: floatand int.
    
      - value : v                      (float)         [create,query,edit]
          Set/Return the slider value if the HUD is a valid HUD slider. Note:Although this flag takes in a FLOAT as an argument,
          if the HUD type is int, the value will be automatically converted internally to an integer.
    
      - valueAlignment : va            (unicode)       [create,query,edit]
          Specifies the alignment of the data blocks and the data text, within a HUD block. Available alignments are: leftand
          right. The default alignment is left.
    
      - valueFontSize : vfs            (unicode)       [create,query,edit]
          Sets the font size of the slider value. Available sizes are: small and large.
    
      - valueWidth : vw                (int)           [create,query,edit]
          Specifies the pixel width of the virtual textboxwhich will hold the slider value. (To see a layout of a block, see the
          description of the -block flag.)
    
      - visible : vis                  (bool)          [create,query,edit]
          Sets the visibility of the Heads-Up Display on and off.                                    Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.hudSlider`
    """

    pass


def switchTable(*args, **kwargs):
    """
    This command creates/edits/queries the switch table control. The optional argument is the name of the control.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label1 : l1                    (unicode)       [edit]
          Set the label of the first column
    
      - label2 : l2                    (unicode)       [edit]
          Set the label of the second column
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - selectedRow : sr               (bool)          [query]
          The current row selected.
    
      - switchNode : sn                (PyNode)        [query,edit]
          The switch node to be displayed in the control.
    
      - underPointerRow : upr          (bool)          [query]
          The row under the pointer.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.switchTable`
    """

    pass


def artBuildPaintMenu(*args, **kwargs):
    """
    ??
    
    
    Derived from mel command `maya.cmds.artBuildPaintMenu`
    """

    pass


def flowLayout(*args, **kwargs):
    """
    This command creates a layout that arranges its children along a single line (either horizontal or vertical). Depending
    on the value of the -wrap boolean flag (default is false), if the layout's parent cannot fit all the children on one
    line, the children will either wrap onto the next line(s) or be truncated.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - columnSpacing : cs             (int)           [create,query,edit]
          Sets the space between children.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - vertical : v                   (bool)          [create,query]
          Whether the orientation of the layout is horizontal (default) or vertical.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - wrap : wr                      (bool)          [create,query,edit]
          When set to true, if the layout's parent cannot fit all the children in a single line, the children will wrap onto the
          next line(s). Default setting is false.                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.flowLayout`
    """

    pass


def glRenderEditor(*args, **kwargs):
    """
    Create a glRender view. This is a special view used for hardware rendering. This command is used to create and reparent
    the view as needed to support panels. See the glRender command for controlling the specific behavior of the hardware
    rendering. In query mode, return type is based on queried flag.
    
    Flags:
      - control : ctl                  (bool)          [query]
          Query only. Returns the top level control for this editor. Usually used for getting a parent to attach popup menus.
          Caution: It is possible for an editor to exist without a control. The query will return NONEif no control is present.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Attaches a tag to the editor.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - filter : f                     (unicode)       [create,query,edit]
          Specifies the name of an itemFilter object to be used with this editor. This filters the information coming onto the
          main list of the editor.
    
      - forceMainConnection : fmc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object. This is a variant of the -mainListConnection flag in
          that it will force a change even when the connection is locked. This flag is used to reduce the overhead when using the
          -unlockMainConnection , -mainListConnection, -lockMainConnection flags in immediate succession.
    
      - highlightConnection : hlc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its highlight list. Not all
          editors have a highlight list. For those that do, it is a secondary selection list.
    
      - lockMainConnection : lck       (bool)          [create,edit]
          Locks the current list of objects within the mainConnection, so that only those objects are displayed within the editor.
          Further changes to the original mainConnection are ignored.
    
      - lookThru : lt                  (unicode)       [create,query,edit]
          Specify which camera the glRender view should be using.
    
      - mainListConnection : mlc       (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will use as its source of content. The editor will
          only display items contained in the selectionConnection object.
    
      - panel : pnl                    (unicode)       [create,query]
          Specifies the panel for this editor. By default if an editor is created in the create callback of a scripted panel it
          will belong to that panel. If an editor does not belong to a panel it will be deleted when the window that it is in is
          deleted.
    
      - parent : p                     (unicode)       [create,query,edit]
          Specifies the parent layout for this editor. This flag will only have an effect if the editor is currently un-parented.
    
      - selectionConnection : slc      (unicode)       [create,query,edit]
          Specifies the name of a selectionConnection object that the editor will synchronize with its own selection list. As the
          user selects things in this editor, they will be selected in the selectionConnection object. If the object undergoes
          changes, the editor updates to show the changes.
    
      - stateString : sts              (bool)          [query]
          Query only flag. Returns the MEL command that will create an editor to match the current editor state. The returned
          command string uses the string variable $editorName in place of a specific name.
    
      - unParent : up                  (bool)          [create,edit]
          Specifies that the editor should be removed from its layout. This cannot be used in query mode.
    
      - unlockMainConnection : ulk     (bool)          [create,edit]
          Unlocks the mainConnection, effectively restoring the original mainConnection (if it is still available), and dynamic
          updates.
    
      - updateMainConnection : upd     (bool)          [create,edit]
          Causes a locked mainConnection to be updated from the orginal mainConnection, but preserves the lock state.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - viewCameraName : vcn           (bool)          [query]
          Returns the name of the current camera used by the glRenderPanel. This is a query only flag.                  Flag can
          have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.glRenderEditor`
    """

    pass


def optionMenu(*args, **kwargs):
    """
    This command creates a popup menu control.  The command creates the control and provides its menu.  Subsequent calls to
    the menuItem command will place them in the popup.  Note that commands attached to menu items will not get called.
    Attach any commands via the -cc/changedCommand flag.
    
    Modifications:
      - returns an empty list when the result is None for flags: (query and (itemListLong or itemListShort))
    
    Flags:
      - alwaysCallChangeCommand : acc  (bool)          []
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - beforeShowPopup : bsp          (script)        [create,edit]
          Callback that is called just before we show the drop down menu.
    
      - changeCommand : cc             (script)        [create,edit]
          Adds a callback that is called when a new item is selected. The MEL script will have the newly selected item's value
          substituted for #1. For Python, the callback should be a callable object which accepts one argument, which is the newly
          selected item's value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - deleteAllItems : dai           (bool)          []
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - itemListLong : ill             (bool)          [query]
          The long names of the menu items.
    
      - itemListShort : ils            (bool)          [query]
          The short names of the menu items.
    
      - label : l                      (unicode)       [create,query,edit]
          The optional label text to the left of the popup menu.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfItems : ni             (bool)          [query]
          The number of menu items.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - select : sl                    (int)           [create,query,edit]
          The current menu item.  The argument and return value is 1-based.  Note that the current menu item can only be set if it
          is enabled.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (unicode)       [create,query,edit]
          The text of the current menu item.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.optionMenu`
    """

    pass


def horizontalLayout(*args, **kwargs):
    pass


def radioCollection(*args, **kwargs):
    """
    This command creates a radio button collection. Collections are parented to the current default layout if no parent is
    specified with the -p/parentflag.  As children of the layout they will be deleted when the layout is deleted.
    Collections may also span more than one window if the -gl/globalflag is used. In this case the collection has no parent
    and must be explicitly deleted with the deleteUIcommand when it is no longer wanted.
    
    Flags:
      - collectionItemArray : cia      (bool)          [query]
          Return a string list giving the long names of all the items in this collection.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - gl : gl                        (bool)          [create,query]
          Set the collection to have no parent layout.  Global collections must be explicitly deleted.
    
      - numberOfCollectionItems : nci  (bool)          [query]
          Return the number of items in this collection.
    
      - parent : p                     (unicode)       [create]
          The parent of the collection.  The collection will be deleted along with the parent.
    
      - select : sl                    (unicode)       [create,query,edit]
          Select the specified collection item.  If queried will return the name of the currently selected collection item.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.radioCollection`
    """

    pass


def componentBox(*args, **kwargs):
    """
    This command creates a component box, which is sensitive to the active list.  It displays certain components of the last
    node on the active list, and provides a two-way connection to keep the widget up to date.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - execute : exe                  (unicode, bool) [edit]
          Immediately executes the command string once for every cell (or every selected cell, if the boolean argument is TRUE) in
          the component box, for every matching selected object (ie, for every object would be affected if you changed a cell
          value.)  Before the command is executed, #Ais substituted with the name of the attribute, and #Nwith the name of the
          node, and #Pwith the full path name of the node.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - labelWidth : lw                (int)           [query,edit]
          An optional flag which is used to modify the width assigned to labels appearing in the componentBox.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxHeight : mh                 (int)           [query,edit]
          An optional flag which is used to limit the height of the componentBox.
    
      - maxWidth : mw                  (int)           [query,edit]
          An optional flag which is used to limit the width of the componentBox.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [query,edit]
          Controls the number of digits to the right of the decimal point that will be displayed for float-valued components.
          Default is 3.  Queried, returns an int.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowHeight : rh                 (int)           [edit]
          An optional flag which is used to set the height of all rows in the componentBox.
    
      - selectedAttr : sla             (bool)          [query]
          Returns a list of names of all the attributes that are selected. This flag is ignored when not being queried.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.componentBox`
    """

    pass


def textManip(*args, **kwargs):
    """
    Shows/hides the text manip.              In query mode, return type is based on queried flag.
    
    Flags:
      - visible : v                    (bool)          [create,query]
          Shows/hides the text manip.                  Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.textManip`
    """

    pass


def textCurves(*args, **kwargs):
    """
    The textCurves command creates NURBS curves from a text string using the specified font. A single letter can be made up
    of more than one NURBS curve. The number of curves per letter varies with the font.
    
    Flags:
      - caching : cch                  (bool)          []
    
      - constructionHistory : ch       (bool)          []
    
      - deprecatedFontName : dfn       (bool)          []
    
      - font : f                       (unicode)       [create]
          The font to use.
    
      - frozen : fzn                   (bool)          []
    
      - name : n                       (unicode)       [create]
          Sets the name of the newly-created node. If it contains namespace path, the new node will be created under the specified
          namespace; if the namespace does not exist, it will be created.
    
      - nodeState : nds                (int)           []
    
      - object : o                     (bool)          [create]
          Create the result, or just the dependency node.
    
      - text : t                       (unicode)       [create]
          The string to create the curves for.                  Flag can have multiple arguments, passed either as a tuple or a
          list.
    
    
    Derived from mel command `maya.cmds.textCurves`
    """

    pass


def floatSliderButtonGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates a float slider component with optional button and symbol
    buttons. TelfFloatSliderGrpCmd.cpp
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - buttonCommand : bc             (script)        [create,edit]
          Command string to be executed when the button is pressed.
    
      - buttonLabel : bl               (unicode)       [create,query,edit]
          The button text.
    
      - changeCommand : cc             (script)        [create,edit]
          Command string executed when the value of the slider changes.  It will be executed only once after a drag of the slider.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dragCommand : dc               (script)        [create,edit]
          Command string executed repeatedly during a drag of the slider.
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - extraLabel : el                (unicode)       [create,query,edit]
          If present on creation this specifies that there will be an extra label appearing after the slider.  Sets the string to
          be the text for the extra label.
    
      - field : f                      (bool)          [create]
          Indicates whether the group will have an editable float field present that reflects the value of the slider.
    
      - fieldMaxValue : fmx            (float)         [create,query,edit]
          Maximum value that may be entered in the field.  This value may be set to any value greater than the -max/maxValueflag.
          By default, it is equal to the -max/maxValueflag.
    
      - fieldMinValue : fmn            (float)         [create,query,edit]
          Minimum value that may be entered in the field.  This value may be set to any value less than the -min/minValueflag.  By
          default, it is equal to the -min/minValueflag.
    
      - fieldStep : fs                 (float)         [create,query,edit]
          Increment for the field.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - image : i                      (unicode)       [create,query,edit]
          Image displayed on the symbol button.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          If present on creation the group will have static text.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - maxValue : max                 (float)         [create,query,edit]
          Maximum value for both the slider and the field.
    
      - minValue : min                 (float)         [create,query,edit]
          Minimum value for both the slider and the field.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - precision : pre                (int)           [create,edit]
          Number of digits to the right of the decimal.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - rowAttach : rat                (int, unicode, int) [create,edit]
          Arguments are : column, attachment type, offset. Possible attachments are: top | bottom | both. Specifies attachment
          types and offsets for the entire row.
    
      - sliderStep : ss                (float)         [create,query,edit]
          The slider step value represents the amount the value will increase or decrease when you click either side of the
          slider.
    
      - step : s                       (float)         [create,query,edit]
          Increment for both the slider and field.
    
      - symbolButtonCommand : sbc      (script)        [create,edit]
          Command string executed when the symbol button is pressed.
    
      - symbolButtonDisplay : sbd      (bool)          [create,query,edit]
          Visibility of the symbol button.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - value : v                      (float)         [create,query,edit]
          Value of the group.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.floatSliderButtonGrp`
    """

    pass


def autoPlace(*args, **kwargs):
    """
    This command takes a point in the centre of the current modeling pane and projects it onto the live surface. This
    produces a point in 3 space which is returned. If the um/useMouseflag is set the current mouse position is used rather
    than the centre of the modeling pane.
    
    Flags:
      - useMouse : um                  (bool)          [create]
          Use the current mouse position rather than the centre of the active view.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.autoPlace`
    """

    pass


def fontDialog(*args, **kwargs):
    """
    Displays a dialog of available fonts for the user to select from. The name of the selected font is returned, or an empty
    string if no font was selected. When the FontListflag is used, no dialog is displayed. Instead the command returns an
    array of the available fonts.
    
    Flags:
      - FontList : fl                  (bool)          [create]
          Returns an array of all available font names. No dialog is displayed.
    
      - scalable : sc                  (bool)          [create]
          Limits the fonts returned or displayed to just those that are scalable.                  Flag can have multiple
          arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.fontDialog`
    """

    pass


def inViewEditor(*args, **kwargs):
    """
    Mel access to the In-View Editor. In-View Editors display a customizable subset of a node's attributes, letting you
    adjust attributes directly in a scene instead of opening the Channel Box or Attribute Editor. In query mode, return type
    is based on queried flag.
    
    Flags:
      - visible : v                    (bool)          [create,query]
          Shows/hides the In-View Editor outside the Show Manips context.                  Flag can have multiple arguments,
          passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.inViewEditor`
    """

    pass


def verticalLayout(*args, **kwargs):
    pass


def formLayout(*args, **kwargs):
    """
    This command creates a form layout control. A form layout allows absolute and relative positioning of the controls that
    are its immediate children. Controls have four edges: top, left, bottom and right. There are only two directions that
    children can be positioned in, right-left and up-down. The attach flags take the direction of an attachment from the
    argument that names the edge to attach (the second argument). Any or all edges of a child may be attached. There are six
    ways to attach them: Attach to Form - Attaches an edge to the relevant side of the form layout. Thus -attachForm button3
    leftwill attach the left edge of the button to the left edge of the form.Attach to Opposite Side of Form - Attaches an
    edge relative to the furthest side of the form layout.Attach to Another Control - Attaches an edge to the closest edge
    of the other control named.Attach to Opposite Side of Another Control - Attaches an edge relative to the furthest side
    of another control.Attach to Position - Attaches an edge to a position on the form layout.  The position is given as a
    fixed fraction of the -nd/numDivisions value and as this value defaults to 100 it is easiest to think of it as a
    percentage of the form's size.Attach to Nothing - Attaches an edge to nothing. The size of the child control will
    determine this edge's position.Each edge attachment may have an offset that acts to separate controls visually. There is
    no default positioning relationship so to have children appear in the form they must have at least one edge attached in
    each direction. Note:In the flag definitions the arguments follow these rules: controlmust be the name of an immediate
    child of the form layout.edgemust be one of top, left, bottom, or right.positionmay range from 0 to the number of
    divisions as specified with the -nd/numberOfDivisions flag and gives the fraction of the width of the form as a
    measurement. This normally means 0-100 so  positionmay be thought of as a percentage.offsetis an integer value in
    pixels.These are multi-use flags so any number of attachments may be made in a single command. Note:Avoid making control
    attachments that form a loop in control dependencies. For example: window; string $form = `formLayout`; string $btn1 =
    `button`; string $btn2 = `button`; string $btn3 = `button`;formLayout -edit-attachControl $btn2 top2 $btn1-attachControl
    $btn3 top2 $btn2-attachControl $btn1 right2 $btn3 $form;showWindow; $btn2 is attached to $btn1, $btn3 is attached to
    $btn2, and $btn1 is attached to $btn3. Thus, the placement of $btn1 is dependent on the placement of $btn3, which is
    dependent on the placement of $btn2, which is dependent on the placement of $btn1. The last control attachment will have
    created a loop in the dependencies. To prevent runtime errors, Maya will ignore this attachment and instead issue a
    warning that a cyclical control attachment has been detected in the script.
    
    Flags:
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - attachControl : ac             (unicode, unicode, int, unicode) [create,edit]
          Arguments are: control, edge, offset, control Valid edge values are: top| bottom| left| right. Attach a control to
          another control.
    
      - attachForm : af                (unicode, unicode, int) [create,edit]
          Arguments are: control, edge, offset. Valid edge values are: top| bottom| left| right. Attach the specified control to
          the form, offset by the specified amount.
    
      - attachNone : an                (unicode, unicode) [create,edit]
          Arguments are: control, edge Valid edge values are: top| bottom| left| right. Attach a control to nothing.
    
      - attachOppositeControl : aoc    (unicode, unicode, int, unicode) [create,edit]
          Arguments are: control, edge, offset, control Valid edge values are: top| bottom| left| right. Attach a control to the
          opposite side of another control.
    
      - attachOppositeForm : aof       (unicode, unicode, int) [create,edit]
          Arguments are: control, edge, offset. Valid edge values are: top| bottom| left| right. Attach a control to the opposite
          side of the form.
    
      - attachPosition : ap            (unicode, unicode, int, int) [create,edit]
          Arguments are: control, edge, offset, position Valid edge values are: top| bottom| left| right. Attach a control to a
          position in the form.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - childArray : ca                (bool)          [query]
          Returns a string array of the names of the layout's immediate children.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by children of this control.
    
      - numberOfChildren : nch         (bool)          [query]
          Returns in an int the number of immediate children of the layout.
    
      - numberOfDivisions : nd         (int)           [create,query,edit]
          Specify the number of horizontal and vertical divisions across the form. Value must be greater than 0.
    
      - numberOfPopupMenus : npm       (bool)          [query]
          Return the number of popup menus attached to this control.
    
      - parent : p                     (unicode)       [create,query]
          The parent layout for this control.
    
      - popupMenuArray : pma           (bool)          [query]
          Return the names of all the popup menus attached to this control.
    
      - preventOverride : po           (bool)          [create,query,edit]
          If true, this flag disallows overriding the control's attribute via the control's right mouse button menu.
    
      - useTemplate : ut               (unicode)       [create]
          Forces the command to use a command template other than the current one.
    
      - visible : vis                  (bool)          [create,query,edit]
          The visible state of the control.  A control is created visible by default.  Note that a control's actual appearance is
          also dependent on the visible state of its parent layout(s).
    
      - visibleChangeCommand : vcc     (script)        [create,query,edit]
          Command that gets executed when visible state of the control changes.
    
      - width : w                      (int)           [create,query,edit]
          The width of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
          Flag can have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.formLayout`
    """

    pass


def createEditor(*args, **kwargs):
    """
    This command creates a property sheet for any dependency node. The second argument is the name of the node, and the
    first is the name of a layout into which the property sheet controls should be placed. The property sheets created by
    this command can by user-customized using the editorTemplatecommand.
    
    Flags:
      - noCloseOnDelete : nc           (bool)          []
    
      - queueForDelete : qfd           (bool)          [create]
          The specified layout is put on a queue.  When the queue is full, layouts past the end of the queue are automatically
          deleted.  If the layout is already on the queue, it is moved to the front.  This allows us to dispose of editors when
          they are no longer being used.  This flag should only be used by the showEditor.mel script.                  Flag can
          have multiple arguments, passed either as a tuple or a list.
    
    
    Derived from mel command `maya.cmds.createEditor`
    """

    pass


def inViewMessage(*args, **kwargs):
    """
    Used for displaying in-view messages. Note: On Linux, the alphaand textAlphaflags for inViewMessage are only supported
    when running a window manager that supports compositing (transparency and opacity).  Otherwise, they are ignored.  In
    addition, the flags for message fading: -fade, -fadeInTime, -fadeStay and -fadeOutTimeare supported, but the message
    will display without a fade effect if the window manager doesn't support compositing.
    
    Flags:
      - alpha : a                      (float)         [create]
          Sets the maximum alpha transparency for the message box.
    
      - assistMessage : amg            (unicode)       [create]
          The user assistance message to be displayed, can be html format.
    
      - backColor : bkc                (int)           [create]
          Sets the background color for the message using the format 0xAARRGGBB, alpha is not taken into account.
    
      - clear : cl                     (unicode)       [create]
          Use this flag to clear the message at a specified position. The supported positions are the same as for the
          -pos/position flag.
    
      - dragKill : dk                  (bool)          [create]
          Use this flag if the message needs to be deleted on mouse drag.
    
      - fade : f                       (bool)          [create]
          Whether the message will fade after a time interval or not.
    
      - fadeInTime : fit               (int)           [create]
          Sets how long it takes for the image to fade in (milliseconds).
    
      - fadeOutTime : fot              (int)           [create]
          Sets how long it takes for the image to fade out (milliseconds).
    
      - fadeStayTime : fst             (int)           [create]
          Sets how long the image stays at max opacity  (milliseconds).
    
      - font : ft                      (unicode)       [create]
          Sets the message to a font (eg. Arial).
    
      - fontSize : fts                 (int)           [create]
          Sets the message font size.
    
      - frameOffset : fof              (int)           [create]
          Sets how far the message appears from the edge of the viewport in pixels.
    
      - hide : hd                      (bool)          [create]
          Hides all messages.
    
      - message : msg                  (unicode)       [create]
          The message to be displayed, can be html format. General message, inherited by -amg/assistMessageand -smg/statusMessage.
    
      - minimize : min                 (bool)          [create]
          Minimize all messages.
    
      - position : pos                 (unicode)       [create]
          The position that the message will appear at relative to the active viewport. The supported positions
          are:topLefttopCentertopRightmidLeftmidCentermidCenterTopmidCenterBotmidRightbotLeftbotCenterbotRight
    
      - restore : res                  (bool)          [create]
          Restore all messages.
    
      - show : sh                      (bool)          [create]
          Shows all messages.
    
      - statusMessage : smg            (unicode)       [create]
          The status info message to be displayed, can be html format.
    
      - textAlpha : ta                 (float)         [create]
          Sets the maximum alpha transparency for the message text.
    
      - textOffset : tof               (int)           [create]
          Sets how far the text appears from the edge of the message box in pixels.
    
      - uvEditor : uv                  (bool)          [create]
          Show the message in the active UV editor view.                  Flag can have multiple arguments, passed either as a
          tuple or a list.
    
    
    Derived from mel command `maya.cmds.inViewMessage`
    """

    pass


def checkBoxGrp(*args, **kwargs):
    """
    All of the group commands position their individual controls in columns starting at column 1.  The layout of each
    control (ie. column) can be customized using the -cw/columnWidth, -co/columnOffset, -cat/columnAttach, -cal/columnAlign,
    and -adj/adjustableColumnflags.  By default, columns are left aligned with no offset and are 100 pixels wide.  Only one
    column in any group can be adjustable. This command creates from one to four check boxes in a single row. They can have
    an optional text label. TelfBaseGrpCmd.cpp
    
    Flags:
      - adjustableColumn : adj         (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the sizing of the layout.  The column value is a 1-based
          index.  You may also specify 0 to turn off the previous adjustable column.
    
      - adjustableColumn2 : ad2        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly two columns.
    
      - adjustableColumn3 : ad3        (int)           [create,edit]
          Specifies that the column has an adjustable size that changes with the size of the parent layout. Ignored if there are
          not exactly three columns.
    
      - adjustableColumn4 : ad4        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly four columns.
    
      - adjustableColumn5 : ad5        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly five columns.
    
      - adjustableColumn6 : ad6        (int)           [create,edit]
          Specifies which column has an adjustable size that changes with the size of the parent layout. Ignored if there are not
          exactly six columns.
    
      - annotation : ann               (unicode)       [create,query,edit]
          Annotate the control with an extra string value.
    
      - backgroundColor : bgc          (float, float, float) [create,query,edit]
          The background color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0. When setting backgroundColor, the background is automatically enabled, unless
          enableBackground is also specified with a false value.
    
      - changeCommand : cc             (script)        [create,edit]
          Command executed when the group changes state. Note that this flag should not be used in conjunction with onCommand and
          offCommand. That is, one should either use changeCommand and test the state of a check box from inside the callback, or
          use onCommand and offCommand as separate callbacks.
    
      - changeCommand1 : cc1           (script)        [create,edit]
    
      - changeCommand2 : cc2           (script)        [create,edit]
    
      - changeCommand3 : cc3           (script)        [create,edit]
    
      - changeCommand4 : cc4           (script)        [create,edit]
          Specify a changed state command for each respective check box.
    
      - columnAlign : cal              (int, unicode)  [create,edit]
          Arguments are : column number, alignment type. Possible alignments are: left | right | center. Specifies alignment type
          for the specified column.
    
      - columnAlign2 : cl2             (unicode, unicode) [create,edit]
          Sets the text alignment of both columns.  Ignored if there are not exactly two columns. Valid values are left, right,
          and center.
    
      - columnAlign3 : cl3             (unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 3 columns.  Ignored if there are not exactly 3 columns. Valid values are left, right,
          and center.
    
      - columnAlign4 : cl4             (unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 4 columns.  Ignored if there are not exactly 4 columns. Valid values are left, right,
          and center.
    
      - columnAlign5 : cl5             (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 5 columns.  Ignored if there are not exactly 5 columns. Valid values are left, right,
          and center.
    
      - columnAlign6 : cl6             (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the text alignment for all 6 columns.  Ignored if there are not exactly 6 columns. Valid values are left, right,
          and center.
    
      - columnAttach : cat             (int, unicode, int) [create,edit]
          Arguments are : column number, attachment type, and offset. Possible attachments are: left | right | both. Specifies
          column attachment types and offets.
    
      - columnAttach2 : ct2            (unicode, unicode) [create,edit]
          Sets the attachment type of both columns. Ignored if there are not exactly two columns. Valid values are left, right,
          and both.
    
      - columnAttach3 : ct3            (unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 3 columns. Ignored if there are not exactly 3 columns. Valid values are left, right,
          and both.
    
      - columnAttach4 : ct4            (unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 4 columns. Ignored if there are not exactly 4 columns. Valid values are left, right,
          and both.
    
      - columnAttach5 : ct5            (unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 5 columns. Ignored if there are not exactly 5 columns. Valid values are left, right,
          and both.
    
      - columnAttach6 : ct6            (unicode, unicode, unicode, unicode, unicode, unicode) [create,edit]
          Sets the attachment type for all 6 columns. Ignored if there are not exactly 6 columns. Valid values are left, right,
          and both.
    
      - columnOffset2 : co2            (int, int)      [create,edit]
          This flag is used in conjunction with the -columnAttach2 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the two columns.  The offsets applied are based on the attachments specified with the
          -columnAttach2 flag.  Ignored if there are not exactly two columns.
    
      - columnOffset3 : co3            (int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach3 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the three columns.  The offsets applied are based on the attachments specified with the
          -columnAttach3 flag.  Ignored if there are not exactly three columns.
    
      - columnOffset4 : co4            (int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach4 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the four columns.  The offsets applied are based on the attachments specified with the
          -columnAttach4 flag.  Ignored if there are not exactly four columns.
    
      - columnOffset5 : co5            (int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach5 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the five columns.  The offsets applied are based on the attachments specified with the
          -columnAttach5 flag.  Ignored if there are not exactly five columns.
    
      - columnOffset6 : co6            (int, int, int, int, int, int) [create,edit]
          This flag is used in conjunction with the -columnAttach6 flag.  If that flag is not used then this flag will be ignored.
          It sets the offset for the six columns.  The offsets applied are based on the attachments specified with the
          -columnAttach6 flag.  Ignored if there are not exactly six columns.
    
      - columnWidth : cw               (int, int)      [create,edit]
          Arguments are : column number, column width. Sets the width of the specified column where the first parameter specifies
          the column (1 based index) and the second parameter specifies the width.
    
      - columnWidth1 : cw1             (int)           [create,edit]
          Sets the width of the first column. Ignored if there is not exactly one column.
    
      - columnWidth2 : cw2             (int, int)      [create,edit]
          Sets the column widths of both columns. Ignored if there are not exactly two columns.
    
      - columnWidth3 : cw3             (int, int, int) [create,edit]
          Sets the column widths for all 3 columns. Ignored if there are not exactly 3 columns.
    
      - columnWidth4 : cw4             (int, int, int, int) [create,edit]
          Sets the column widths for all 4 columns. Ignored if there are not exactly 4 columns.
    
      - columnWidth5 : cw5             (int, int, int, int, int) [create,edit]
          Sets the column widths for all 5 columns. Ignored if there are not exactly 5 columns.
    
      - columnWidth6 : cw6             (int, int, int, int, int, int) [create,edit]
          Sets the column widths for all 6 columns. Ignored if there are not exactly 6 columns.
    
      - defineTemplate : dt            (unicode)       [create]
          Puts the command in a mode where any other flags and args are parsed and added to the command template specified in the
          argument. They will be used as default arguments in any subsequent invocations of the command when templateName is set
          as the current template.
    
      - docTag : dtg                   (unicode)       [create,query,edit]
          Add a documentation flag to the control.  The documentation flag has a directory structure like hierarchy. Eg. -dt
          render/multiLister/createNode/material
    
      - dragCallback : dgc             (script)        [create,edit]
          Adds a callback that is called when the middle mouse button is pressed.  The MEL version of the callback is of the form:
          global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods) The proc returns a string array that
          is transferred to the drop site. By convention the first string in the array describes the user settable message type.
          Controls that are application defined drag sources may ignore the callback. $mods allows testing for the key modifiers
          CTL and SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTL, 3 == CTL + SHIFT. In Python, it is similar,
          but there are two ways to specify the callback.  The recommended way is to pass a Python function object as the
          argument.  In that case, the Python callback should have the form: def callbackName( dragControl, x, y, modifiers ): The
          values of these arguments are the same as those for the MEL version above. The other way to specify the callback in
          Python is to specify a string to be executed.  In that case, the string will have the values substituted into it via the
          standard Python format operator.  The format values are passed in a dictionary with the keys dragControl, x, y,
          modifiers.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(x)d %(y)d %(modifiers)d'
    
      - dropCallback : dpc             (script)        [create,edit]
          Adds a callback that is called when a drag and drop operation is released above the drop site.  The MEL version of the
          callback is of the form: global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int
          $y, int $type) The proc receives a string array that is transferred from the drag source. The first string in the msgs
          array describes the user defined message type. Controls that are application defined drop sites may ignore the callback.
          $type can have values of 1 == Move, 2 == Copy, 3 == Link. In Python, it is similar, but there are two ways to specify
          the callback.  The recommended way is to pass a Python function object as the argument.  In that case, the Python
          callback should have the form: def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ): The values of
          these arguments are the same as those for the MEL version above. The other way to specify the callback in Python is to
          specify a string to be executed.  In that case, the string will have the values substituted into it via the standard
          Python format operator.  The format values are passed in a dictionary with the keys dragControl, dropControl, messages,
          x, y, type.  The dragControlvalue is a string and the other values are integers (eg the callback string could be print
          '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'
    
      - editable : ed                  (bool)          [create,query,edit]
          The edit state of the group.  By default, this flag is set to true and the check box values may be changed by clicking
          on them.  If false then the check boxes are 'read only' and can not be clicked on. The value of the check boxes can
          always be changed with the -v/valueflags regardless of the state of the -ed/editableflag.
    
      - enable : en                    (bool)          [create,query,edit]
          The enable state of the control.  By default, this flag is set to true and the control is enabled.  Specify false and
          the control will appear dimmed or greyed-out indicating it is disabled.
    
      - enable1 : en1                  (bool)          [create,query,edit]
    
      - enable2 : en2                  (bool)          [create,query,edit]
    
      - enable3 : en3                  (bool)          [create,query,edit]
    
      - enable4 : en4                  (bool)          [create,query,edit]
          Enable state of the individual check boxes.
    
      - enableBackground : ebg         (bool)          [create,query,edit]
          Enables the background color of the control.
    
      - exists : ex                    (bool)          [create]
          Returns whether the specified object exists or not. Other flags are ignored.
    
      - fullPathName : fpn             (bool)          [query]
          Return the full path name of the widget, which includes all the parents
    
      - height : h                     (int)           [create,query,edit]
          The height of the control.  The control will attempt to be this size if it is not overruled by parent layout conditions.
    
      - highlightColor : hlc           (float, float, float) [create,query,edit]
          The highlight color of the control. The arguments correspond to the red, green, and blue color components. Each
          component ranges in value from 0.0 to 1.0.
    
      - isObscured : io                (bool)          [query]
          Return whether the control can actually be seen by the user. The control will be obscured if its state is invisible, if
          it is blocked (entirely or partially) by some other control, if it or a parent layout is unmanaged, or if the control's
          window is invisible or iconified.
    
      - label : l                      (unicode)       [create,query,edit]
          When present on creation an optional text label will be built with the group.  The string specifes the label text.
    
      - label1 : l1                    (unicode)       [create,query,edit]
    
      - label2 : l2                    (unicode)       [create,query,edit]
    
      - label3 : l3                    (unicode)       [create,query,edit]
    
      - label4 : l4                    (unicode)       [create,query,edit]
          Specify label strings for the respective check boxes in the group.
    
      - labelArray2 : la2              (unicode, unicode) [create,query,edit]
    
      - labelArray3 : la3              (unicode, unicode, unicode) [create,query,edit]
    
      - labelArray4 : la4              (unicode, unicode, unicode, unicode) [create,query,edit]
          Specify multiple labels in a single flag.  These flags are ignored if the number of radio buttons doesn't match.
    
      - manage : m                     (bool)          [create,query,edit]
          Manage state of the control.  An unmanaged control is not visible, nor does it take up any screen real estate.  All
          controls are created managed by default.
    
      - noBackground : nbg             (bool)          [create,edit]
          Clear/reset the control's background. Passing true means the background should not be drawn at all, false means the
          background should be drawn.  The state of this flag is inherited by 