//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

//
// ShapeMonitor
//
// Author: Christian Laforte
//
// Data: March 2001
//

#ifndef _ShapeMonitor_
#define _ShapeMonitor_

#include <maya/MNodeMessage.h>
#include "AWarray.h"


// Structure used to track monitored Maya nodes.
class MonitoredObject
{
public:
	MString mayaNodeName;
	MonitoredObject() { renamedCallbackId = 0; dirtyCallbackId = 0; }

	virtual ~MonitoredObject() {}
	MCallbackId renamedCallbackId;
	MCallbackId dirtyCallbackId;
};


class ShapeMonitor
{
public:

	// Return a pointer to the singleton node. 
	// It is created automatically if it doesn't already exist.
	static ShapeMonitor* instance();

	// Initialize the ShapeMonitor singleton. 
	// This frees internal data structures and detach any callbacks left,
	// and returns a fresh and clean ShapeMonitor instance.
	static ShapeMonitor* initialize();

	// Destroy the internal content of the ShapeMonitor singleton. 
	// This also detaches any callbacks left.
	static void destroy();

	// Watch the given node. This function will add an element in the monitored objects array,
	// and set callbacks on the node in order to get notified when the node changes.
	void watch(MString mayaNodeName, MonitoredObject* pMon);

	// Stop watching all nodes that correspond to the given unique texture name.
	// This function can also be used to stop watching all elements, by setting that argument to true.
	void stopWatching(MString mayaNodeName);

	// Stop watching all nodes.
	void stopWatchingAll();

	void stopWatchingUnselectedDagObjects(MSelectionList& selectedObjects);

private:

	// The constructor and destructor are private, to guarantee that client-side code cannot instance
	// more than one at a time.
	ShapeMonitor();
	~ShapeMonitor();

	// Pointer to the singleton private instance.
	static ShapeMonitor* privateInstance;


	// The list of currently monitored objects.
	AWarray< MonitoredObject* > monitoredObjectsPtrArray;

	// Find a monitored object according to its node name.
	// This is used to ensure that we don't store duplicates in the list.
	MonitoredObject* retrieveMonitorObject(MString nodeName);

	// Callback functions. Those are called, respectively, when a node is dirty (has changed substantially),
	// or when a node is renamed.
	static void watchedObjectDirtyCallback( void* clientData );
	static void watchedObjectRenamedCallback( MObject & node, void* clientData );

	void removeCallbacks(MonitoredObject *mon);
};

#endif // _ShapeMonitor_
