//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

//
//	File Name: animImport.h
//	
//	Description:
//

#ifndef _AnimImport
#define _AnimImport

#include <maya/MPxFileTranslator.h>
#include "animFileUtils.h"


class animReader;

// The animImport command object
//
class animImport : public MPxFileTranslator {
public:
	animImport ();
	~animImport () override; 

	MStatus				doIt (const MArgList &argList);
	static void *		creator ();

	MStatus		reader(	const MFileObject& file,
						const MString& optionsString,
						FileAccessMode mode) override;

	bool		haveReadMethod() const override;
	bool		haveWriteMethod() const override;
	bool		canBeOpened() const override;
	MString 	defaultExtension() const override;
	MFileKind	identifyFile(	const MFileObject& fileName,
										const char* buffer,
										short size) const override;
private:
	MStatus				importAnim(ifstream&, const MString&);
	MStatus				exportSelected(ofstream&);

	animReader			fReader;
};
#endif
//
//	File Name:	animExport.h
//
//	Description:
//
//

#ifndef _AnimExport
#define _AnimExport

#include <maya/MPxFileTranslator.h>
#include "animFileUtils.h"


class animWriter;

// The animImport command object
//
class animExport : public MPxFileTranslator {
public:
	animExport ();
	~animExport () override; 

	static void *		creator ();

	MStatus 	writer(	const MFileObject& file,
						const MString& optionsString,
						FileAccessMode mode ) override;

	bool		haveReadMethod() const override;
	bool		haveWriteMethod() const override;
	MString 	defaultExtension() const override;
	MFileKind	identifyFile(	const MFileObject& fileName,
										const char* buffer,
										short size) const override;
private:
	MStatus				exportSelected(	ofstream&, MString &,
										bool = false, bool = false);

	animWriter			fWriter;
};
#endif
