#ifndef __NodeMonitor_h__
#define __NodeMonitor_h__

//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

// NodeMonitor.h

//
//
// DESCRIPTION:  This class monitors a given node.
//
// AUTHOR: Christian Laforte
//
//

#include <maya/MFnDagNode.h>
#include <maya/MFnDependencyNode.h>
#include <maya/MString.h>
#include <maya/MNodeMessage.h>
#include <maya/MObject.h>
#include <maya/MSelectionList.h>
#include <maya/MStatus.h>

MObject getObjFromName(MString name, MStatus& stat);

// If a problem occurs, this function returns an empty string.
MString getNameFromObj(MObject obj);

// Classes that implement the NodeMonitorManager interfaces
// can be called back when a node is renamed.
class NodeMonitorManager
{
public:
	virtual void onNodeRenamed(MObject& node, MString oldName, MString newName) = 0;
};

class NodeMonitor
{
public:
	NodeMonitor(NodeMonitorManager* manager = NULL);

	~NodeMonitor();

	bool watch(MString nodeName);
	bool watch(MObject nodeObj);

	void stopWatching();

	bool dirty();

	void cleanIt();

	void setManager(NodeMonitorManager* manager) { fManager = manager; }

private:
	bool attachCallbacks();

	void detachCallbacks();

	void callbackOccured();

	// Callback functions. Those are called, respectively, when a node is dirty (has changed substantially),
	// or when a node is renamed.
	static void watchedObjectDirtyCallback(void* clientData);

	static void watchedObjectRenamedCallback(MObject & node, void* clientData);


private:
	MString fNodeName;
	bool fIsDirty;

	MCallbackId fRenamedCallbackId;
	MCallbackId fDirtyCallbackId;

	NodeMonitorManager* fManager;
};


#endif // MAYA_ShadingConnection
