//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc. and/or its licensors.  All 
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors, which is protected by U.S. and Canadian federal copyright 
// law and by international treaties.
//
// The Data is provided for use exclusively by You. You have the right 
// to use, modify, and incorporate this Data into other products for 
// purposes authorized by the Autodesk software license agreement, 
// without fee.
//
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the 
// following disclaimer, must be included in all copies of the 
// Software, in whole or in part, and all derivative works of 
// the Software, unless such copies or derivative works are solely 
// in the form of machine-executable object code generated by a 
// source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
// PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE, OR 
// TRADE PRACTICE. IN NO EVENT WILL AUTODESK AND/OR ITS LICENSORS 
// BE LIABLE FOR ANY LOST REVENUES, DATA, OR PROFITS, OR SPECIAL, 
// DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK 
// AND/OR ITS LICENSORS HAS BEEN ADVISED OF THE POSSIBILITY 
// OR PROBABILITY OF SUCH DAMAGES.
//
// ==========================================================================
//+

#ifndef MAYA_ShadingConnection
#define MAYA_ShadingConnection

// ShadingConnection.h

///////////////////////////////////////////////////////////////////
// DESCRIPTION:  This class stores useful information about
//				 a shader's attribute, including what's connected upstream of it.
//				 It also automatically passes through shader switches.
//
// The ShadingConnection is a helper class that stores useful information 
// about a shader's attribute, including what's connected upstream of it.
//
// It can:
//		Traverse upstream until it finds if the connection is ultimately 
// on a constant color, or a shading object. This process goes through 
// shading switches if it encounters some. The object/color found is called
// the "target".
//
// At the end of this process, the following information is stored:
// 1. Target type: whether or not the connection ends up on a shading 
//				   object (for example: file texture), or a constant 
//				   color (ex: bright red).
// 2. Target identity: either the color, or the target object itself. Note
//					   that the caller is responsible to first check the type
//					   before calling color() or object().
// 3. Directness: Whether or not the connection was direct (ie: there was
//				  no shading switch in between the source and the target)
//			      or indirect (ie: there were shading switches in between.)
//
// In order to traverse the shading network, we need the name of the shape.
//
// AUTHOR: Christian Laforte
//
///////////////////////////////////////////////////////////////////

#include <maya/MColor.h>

class ShadingConnection
{
public:
	enum TYPE
	{
		CONSTANT_COLOR, 
		TEXTURE
	};

	ShadingConnection(MObject shaderObj, MString shapeName, MString attribute = "");

	TYPE traverseAttribute(MString attributeName);
	
	TYPE analyzePlug(MPlug plug);
	
	TYPE traverseTripleShadingSwitch(MObject connectedObject);

	TYPE type();

	MColor constantColor();

	MObject texture();

	MObject shaderObj();

	MString shaderName();

	MString attributeName();

	MString shapeName();

	TYPE setConstantColor(MColor col);
	TYPE setTexture(MObject texture);

	bool isDirectConnection();

	
private:
	// Input
	MObject m_shaderObj;
	MString m_attributeName;
	MString m_shapeName;

	// Output	
	TYPE m_type;
	MColor m_constantColor;
	MObject m_texture;
	bool m_directConnection;


};


#endif // MAYA_ShadingConnection
