#ifndef _MFnKeyframeDeltaTangent
#define _MFnKeyframeDeltaTangent
//-
// ===========================================================================
// Copyright 2017 Autodesk, Inc. All rights reserved.
//
// Use of this software is subject to the terms of the Autodesk license
// agreement provided at the time of installation or download, or which
// otherwise accompanies this software in either electronic or hard copy form.
// ===========================================================================
//+
// ****************************************************************************
//
// CLASS:    MFnKeyframeDeltaTangent
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnKeyframeDelta.h>
#include <maya/MFnAnimCurve.h>


OPENMAYA_MAJOR_NAMESPACE_OPEN

// ****************************************************************************
// CLASS DECLARATION (MFnKeyframeDeltaTangent)

//! \ingroup OpenMayaAnim MFn
//! \brief Function set for changes to a key's tangent. 
/*!
A MFnKeyframeDeltaTangent function allows API programmers to read
changes in keyframe tangent values. It captures changes in tangent
type, as well as, changes in tangent time/value pair.

MFnKeyframeDeltaTangents are generated by a
MAnimMessage::addAnimKeyframeEditedCallback. Because a key's tangent
may be unbroken. It is possible to receive to MFnKeyframeDeltaTangent
values per key -- one for the incoming tangent and one for the
outgoing tangent. The API programmer should use the isInTangent method
to determine if the tangent change affects the in-bound tangent or
out-bound tangent.
*/
class OPENMAYAANIM_EXPORT MFnKeyframeDeltaTangent : public MFnKeyframeDelta
{
	declareMFn(MFnKeyframeDeltaTangent, MFnKeyframeDelta);

public:

	MFnAnimCurve::TangentType	previousTangentType( MStatus *ReturnStatus = NULL ) const;
	MFnAnimCurve::TangentType	currentTangentType( MStatus *ReturnStatus = NULL ) const;

    MStatus		getPreviousPosition( MFnAnimCurve::TangentValue &x, MFnAnimCurve::TangentValue &y ) const;
	MStatus		getCurrentPosition( MFnAnimCurve::TangentValue &x, MFnAnimCurve::TangentValue &y ) const;
	bool		isInTangent( MStatus *ReturnStatus = NULL  ) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnKeyframeDeltaTangent, MFnKeyframeDelta );

END_NO_SCRIPT_SUPPORT:

protected:
	// No protected.

private:
	// No private.
};

OPENMAYA_NAMESPACE_CLOSE

#endif /* __cplusplus */
#endif /* _MFnKeyframeDeltaTangent */
